<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$thumb_size = 'finbuzz-size7';
$id = get_the_ID();

$position   	= get_post_meta( $id, 'finbuzz_team_position', true );
$socials       	= get_post_meta( $id, 'finbuzz_team_socials', true );
$social_fields 	= FinbuzzTheme_Helper::team_socials();
?>
<article id="post-<?php the_ID(); ?>">
	<div class="rtin-item" >
		<div class="rtin-content-wrap">		
			<div class="team-thumb">
				<figure>
					<a href="<?php the_permalink();?>">
						<?php
						if ( has_post_thumbnail() ){
							the_post_thumbnail( $thumb_size );
						}
						else {
							if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
								echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], $thumb_size );
							}
							else {
								echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_400X400.jpg' ) . '" alt="'. the_title_attribute( array( 'echo'=> false ) ) .'">';
							}
						}
						?>
					</a>
					<?php if ( FinbuzzTheme::$options['team_ar_social'] ) { ?>
						<ul class="rtin-social-icon">
							<?php foreach ( $socials as $key => $social ): ?>
								<?php if ( !empty( $social ) ): ?>
									<li><a target="_blank" href="<?php echo esc_url( $social );?>"><i class="fab <?php echo esc_attr( $social_fields[$key]['icon'] );?>" aria-hidden="true"></i></a>
									</li>
								<?php endif; ?>
							<?php endforeach; ?>
						</ul>
					<?php } ?>
				</figure>
			</div>
			<div class="rtin-content">
				<h3 class="rtin-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
				<?php if ( FinbuzzTheme::$options['team_ar_position'] ) { ?>
				<div class="rtin-designation"><?php echo esc_html( $position );?></div>
				<?php } ?>
			</div>
		</div>
	</div>
</article>