<?php
$finbuzz_footer_column = FinbuzzTheme::$options['footer_column_1'];
switch ( $finbuzz_footer_column ) {
	case '1':
	$finbuzz_footer_class = 'col-sm-12 col-12';
	break;
	case '2':
	$finbuzz_footer_class = 'col-sm-6 col-12';
	break;
	case '3':
	$finbuzz_footer_class = 'col-lg-4 col-md-6 col-12';
	break;		
	default:
	$finbuzz_footer_class = 'col-lg-3 col-md-6 col-12';
	break;
}
// Logo
$finbuzz_light_logo = empty( FinbuzzTheme::$options['footer_logo_light']['url'] ) ? FINBUZZ_IMG_URL . 'logo-light.svg' : FinbuzzTheme::$options['footer_logo_light']['url'];



$finbuzz_bg_class='';
if( !empty( FinbuzzTheme::$options['fbgimg'] ) ) {
	$f1_bg = wp_get_attachment_image_src( FinbuzzTheme::$options['fbgimg'], 'full', true );
	$footer_bg_img = $f1_bg[0];
}else {
	$footer_bg_img = FINBUZZ_IMG_URL . 'footer2_bg.jpg';
}

if ( FinbuzzTheme::$options['footer_bgtype'] == 'fbgcolor' ) {
	$finbuzz_bg = FinbuzzTheme::$options['fbgcolor'];
	$finbuzz_bg_class='no-footer-img';
} else {
	$finbuzz_bg = 'url(' . $footer_bg_img . ') no-repeat center bottom / cover';
	$finbuzz_bg_class='has-footer-img';
}

?>

<?php if ( FinbuzzTheme::$footer_area == 1 || FinbuzzTheme::$footer_area == 'on') { ?>
	<div class="footer-top-area <?php echo esc_attr( $finbuzz_bg_class ); ?>"  style="background:<?php echo esc_html( $finbuzz_bg ); ?>">
		<?php if ( FinbuzzTheme::$options['footer_shape'] ) { ?>
			<ul class="shape-holder">
				<li class="shape1 rt-animate wow fadeInLeft" data-wow-delay="0.6s" data-wow-duration="1.5s">
					<img width="309" height="235" loading='lazy' src="<?php echo FINBUZZ_ASSETS_URL . 'element/figure1.png'; ?>" alt="<?php echo esc_attr('figure1', 'finbuzz'); ?>">
				</li>
				<li class="shape2 wow rt-animate fadeInRight" data-wow-delay="0.6s" data-wow-duration="1.5s">
					<img width="309" height="235" loading='lazy' src="<?php echo FINBUZZ_ASSETS_URL . 'element/figure2.png'; ?>" alt="<?php echo esc_attr('figure2', 'finbuzz'); ?>">
				</li>
			</ul>
		<?php } ?>
		<div class="container">
			<?php if ( is_active_sidebar( 'footer-style-1-1' ) ) { ?>
				<div class="footer-top-widget">
					<div class="row">
						<?php
						for ( $i = 1; $i <= $finbuzz_footer_column; $i++ ) {
							if(is_active_sidebar( 'footer-style-1-'. $i )){
								echo '<div class="' . $finbuzz_footer_class . '">';
								dynamic_sidebar( 'footer-style-1-'. $i );
								echo '</div>';
							}
						}
						?>
					</div>
				</div>	
			<?php } ?>
			<div class="copyright_wrap">
				<span class="left-line"></span>
				<div class="copyright-img1">
                    <img src="<?php echo FINBUZZ_ASSETS_URL . 'element/figure4.png'; ?>" alt="<?php echo esc_attr('figure', 'finbuzz'); ?>" width="20" height="20">
                </div>
				<div class="copyright"><?php echo wp_kses( FinbuzzTheme::$options['copyright_text'] , 'allow_link' );?></div>
				<div class="copyright-img2">
                    <img src="<?php echo FINBUZZ_ASSETS_URL . 'element/figure4.png'; ?>" alt="<?php echo esc_attr('figure', 'finbuzz'); ?>" width="20" height="20">
                </div>
				<span class="right-line"></span>
			</div>
		</div>		
	</div>
<?php } ?>
