<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$image=wp_get_attachment_image(FinbuzzTheme::$options['fctabgimg'],'full');
$image_class=$image ? 'show-image':'no-image';
?>
<div class="container">
    <div class="cta-default cta-style1 footer-cta <?php echo esc_attr($image_class); ?>">
        <div class="action-box">
            <?php if($image): ?>
                <div class="action-box-img">
                    <?php echo wp_kses_post($image);?>
                </div>
            <?php endif; ?>
            <div class="cta-info">
                <div class="title">
                    <h2 class="cta-title"><?php echo wp_kses_post( FinbuzzTheme::$options['footer_cta_area_title'] );?></h2>
                </div>
                <?php if(FinbuzzTheme::$options['fctaphone_number'] || FinbuzzTheme::$options['fctaemail_address']){ ?>
                    <div class="cta-contact-box">
                        <?php if(FinbuzzTheme::$options['fctaphone_number']){ ?>
                            <div class="cta-contact cta-contact-1">
                                <div class="contact-icon"><i class="far fa-comments"></i></div>
                                <div class="contact-content">
                                    <?php if(FinbuzzTheme::$options['fctaphone_title']) { ?>
                                        <div class="contact-title"><?php echo wp_kses_post( FinbuzzTheme::$options['fctaphone_title'] );?></div>
                                    <?php } ?>
                                    <div class="contact-info"><a href="tel:<?php echo esc_attr( FinbuzzTheme::$options['fctaphone_number'] );?>"><?php echo wp_kses_post( FinbuzzTheme::$options['fctaphone_number'] );?></a></div>
                                </div>
                            </div>
                        <?php } ?>
                        <?php if(FinbuzzTheme::$options['fctaemail_address']){ ?>
                            <div class="cta-contact cta-contact-2">
                                <div class="contact-icon"><i class="far fa-envelope"></i></div>
                                <div class="contact-content">
                                    <?php if(FinbuzzTheme::$options['fctaemail_title']){ ?>
                                        <div class="contact-title"><?php echo wp_kses_post( FinbuzzTheme::$options['fctaemail_title'] );?></div>
                                    <?php } ?>
                                    <div class="contact-info"><a href="mailto:<?php echo esc_attr( FinbuzzTheme::$options['fctaemail_address'] );?>"><?php echo wp_kses_post(FinbuzzTheme::$options['fctaemail_address'] );?></a></div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>