<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$nav_menu_args = FinbuzzTheme_Helper::nav_menu_args();

// Logo

if( !empty( FinbuzzTheme::$options['logo'] ) ) {
	$logo_dark = wp_get_attachment_image( FinbuzzTheme::$options['logo'], 'full' );
	$finbuzz_dark_logo = $logo_dark;
}else {
	$finbuzz_dark_logo = "<img width='152' height='45' src='" . FINBUZZ_IMG_URL . 'logo-dark.svg' . "' alt='" . esc_attr( get_bloginfo('name') ) . "' loading='lazy'>"; 
}

if( !empty( FinbuzzTheme::$options['logo_light'] ) ) {
	$logo_lights = wp_get_attachment_image( FinbuzzTheme::$options['logo_light'], 'full' );
	$finbuzz_light_logo = $logo_lights;
}else {
	$finbuzz_light_logo = "<img width='152' height='45' src='" . FINBUZZ_IMG_URL . 'logo-light.svg' . "' alt='" . esc_attr( get_bloginfo('name') ) . "'>";
} ?>
<div id="rt-sticky-placeholder"></div>
<div class="header-menu mobile-menu menu-layout1 rt-header-12" id="header-menu">
	<div class="header-main style-4 d-flex align-items-center justify-content-between">
		<div class="site-branding">
			<a class="dark-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo wp_kses( $finbuzz_dark_logo, 'allow_link' ); ?></a>
			<a class="light-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo wp_kses( $finbuzz_light_logo, 'allow_link' ); ?></a>
		</div>
		<div id="site-navigation" class="main-navigation">
			<?php wp_nav_menu( $nav_menu_args );?>
		</div>
		<?php if ( FinbuzzTheme::$options['online_button'] == '1' && !empty(FinbuzzTheme::$options['online_button_text'])) { ?>	
		<ul class="header-action-items">
			<li class="header-button">
				<a href="<?php echo esc_url( FinbuzzTheme::$options['online_button_link']  );?>" class="style-2">
				<?php echo esc_html( FinbuzzTheme::$options['online_button_text'] );?> 
					<svg width="18" height="16" viewBox="0 0 18 16" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path fill-rule="evenodd" clip-rule="evenodd" d="M17.3623 6.17315C17.3623 4.01255 17.3623 2.93225 16.9418 2.10659C16.5719 1.38065 15.9817 0.790441 15.2557 0.420546C14.4301 -1.14984e-07 13.3498 0 11.1892 0H6.17347C4.01286 0 2.93256 -1.14984e-07 2.1069 0.420546C1.38096 0.790441 0.790754 1.38065 0.42086 2.10659C0.000314713 2.93225 0.000312805 4.01255 0.000312805 6.17315V7.33062C0.000312805 9.49122 0.000314713 10.5715 0.42086 11.3972C0.790754 12.1231 1.38096 12.7133 2.1069 13.0832C2.93256 13.5038 4.01286 13.5038 6.17347 13.5038H13.1048C13.3606 13.5038 13.6059 13.6055 13.7867 13.7864L15.7158 15.7155C16.3235 16.3232 17.3623 15.893 17.3623 15.0336V8.681V6.17315ZM11.575 3.85822C11.8308 3.85822 12.0761 3.95984 12.257 4.14073C12.4379 4.32162 12.5395 4.56696 12.5395 4.82278C12.5395 5.07859 12.4379 5.32393 12.257 5.50482C12.0761 5.68571 11.8308 5.78733 11.575 5.78733H5.78764C5.53183 5.78733 5.28649 5.68571 5.1056 5.50482C4.92471 5.32393 4.82309 5.07859 4.82309 4.82278C4.82309 4.56696 4.92471 4.32162 5.1056 4.14073C5.28649 3.95984 5.53183 3.85822 5.78764 3.85822H11.575ZM11.575 7.71644C11.8308 7.71644 12.0761 7.81806 12.257 7.99895C12.4379 8.17984 12.5395 8.42518 12.5395 8.681C12.5395 8.93681 12.4379 9.18215 12.257 9.36304C12.0761 9.54393 11.8308 9.64555 11.575 9.64555H8.68131C8.42549 9.64555 8.18015 9.54393 7.99927 9.36304C7.81838 9.18215 7.71675 8.93681 7.71675 8.681C7.71675 8.42518 7.81838 8.17984 7.99927 7.99895C8.18015 7.81806 8.42549 7.71644 8.68131 7.71644H11.575Z" fill="currentColor"/>
					</svg>
				</a>
			</li>
		</ul>
		<?php } ?>
	</div>
</div>	


