<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$finbuzz_socials = FinbuzzTheme_Helper::socials();
?>
<div id="tophead" class="header-top-bar align-items-center">
	<div class="container">
		<div class="top-bar-wrap">
			<div class="tophead-left">
				<?php if ( FinbuzzTheme::$options['address'] ) { ?>
					<div class="address">
						<svg width="18" height="21" viewBox="0 0 18 21" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path fill-rule="evenodd" clip-rule="evenodd" d="M11.4868 8.80639C11.4868 7.43255 10.3736 6.31934 9.00073 6.31934C7.62689 6.31934 6.51367 7.43255 6.51367 8.80639C6.51367 10.1792 7.62689 11.2924 9.00073 11.2924C10.3736 11.2924 11.4868 10.1792 11.4868 8.80639Z" stroke="#FF2500" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
						<path fill-rule="evenodd" clip-rule="evenodd" d="M8.99976 19.25C8.99976 19.25 1.72391 14.5108 1.54058 8.59729C1.41185 4.4451 4.87963 0.750081 8.99976 0.750081C13.1199 0.750081 16.5868 4.44504 16.4599 8.59729C16.2755 14.632 8.99976 19.25 8.99976 19.25Z" stroke="#FF2500" stroke-width="1.5" stroke-linecap="round"/>
						</svg>
						<?php echo wp_kses( FinbuzzTheme::$options['address'] , 'alltext_allow' );?>
					</div>
				<?php } ?>
				<?php if ( FinbuzzTheme::$options['opening_closing'] ) { ?>
					<div class="opening-closing">
						<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M13.4321 12.9422L9.66211 10.6932V5.84619M19.25 10C19.25 15.109 15.109 19.25 10 19.25C4.891 19.25 0.75 15.109 0.75 10C0.75 4.891 4.891 0.75 10 0.75C15.109 0.75 19.25 4.891 19.25 10Z" stroke="#FF2500" stroke-width="1.5" stroke-linecap="square"/>
						</svg>
						<?php echo wp_kses_post(FinbuzzTheme::$options['opening_closing']); ?>
					</div>
				<?php } ?>	
			</div>
			<div class="tophead-right">
				<?php if ( $finbuzz_socials ) { ?>
					<ul>
						<li class="topbar-social">
						<div class="social-icon">
						<?php foreach ( $finbuzz_socials as $finbuzz_social ): ?>
							<a target="_blank" href="<?php echo esc_url( $finbuzz_social['url'] );?>"><i class="fab <?php echo esc_attr( $finbuzz_social['icon'] );?>"></i></a>
						<?php endforeach; ?>
						</div>
						</li>
					</ul>
				<?php } ?>
			</div>
		</div>
	</div>
</div>