<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.6.0
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' );

if(FinbuzzTheme::$options['shop_sidebar']==1 && is_active_sidebar('shop-sidebar-1')){
	$content_layout_class='col-lg-9 col-md-12';
	$sidebar_class='col-lg-3 col-md-12';
	$fixedbar = 'fixed-bar-coloum';
}
else{
	$content_layout_class='col-lg-12';
	$sidebar_class='col-lg-12';
	$fixedbar = '';
}

?>

<div id="primary" class="content-area customize-content-selector finbuzz-products-page">
	<div class="container">
		<div class="row">
			<?php
			if ( woocommerce_product_loop() ) { ?>
				<div class="<?php echo esc_attr($content_layout_class); ?>">

					<?php echo '<div class="shop-page-top">';
					/**
					 * Hook: woocommerce_before_shop_loop.
					 *
					 * @hooked woocommerce_output_all_notices - 10
					 * @hooked woocommerce_result_count - 20
					 * @hooked woocommerce_catalog_ordering - 30
					 */
					do_action( 'woocommerce_before_shop_loop' );
					echo '</div>';
					woocommerce_product_loop_start();

					if ( wc_get_loop_prop( 'total' ) ) {
						while ( have_posts() ) {
							the_post();

							/**
							 * Hook: woocommerce_shop_loop.
							 */
							do_action( 'woocommerce_shop_loop' );

							wc_get_template_part( 'content', 'product' );
						}
					}

					woocommerce_product_loop_end(); ?>
				</div>
				<?php if(is_active_sidebar('shop-sidebar-1') && FinbuzzTheme::$options['shop_sidebar']==1){ ?>
					<div class="<?php echo esc_attr($sidebar_class); ?> <?php echo esc_attr($fixedbar); ?>">
						<aside class="sidebar-widget-area">
							<?php dynamic_sidebar('shop-sidebar-1'); ?>
						</aside>
					</div>
				<?php } ?>
				<?php
				/**
				 * Hook: woocommerce_after_shop_loop.
				 *
				 * @hooked woocommerce_pagination - 10
				 */
				do_action( 'woocommerce_after_shop_loop' );
			} else {
				/**
				 * Hook: woocommerce_no_products_found.
				 *
				 * @hooked wc_no_products_found - 10
				 */
				do_action( 'woocommerce_no_products_found' );
			}

			?>
		</div>
	</div>
</div>
<?php get_footer( 'shop' );
