<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     9.6.0
 */

$has_slider = apply_filters( 'rdtheme_has_slider_for_related_post_box', true );
$product_class = apply_filters( 'rdtheme_related_product_class', '', $has_slider );

$related_product_per_slide=esc_html( FinbuzzTheme::$options['related_product_per_page'] );
if( $has_slider ) {
	$swiper_data = array(
		'slidesPerView'       => 2,
		'centeredSlides'      => false,
		'loop'                => true,
		'spaceBetween'        => 20,
		'slideToClickedSlide' => true,
		'slidesPerGroup'      => 1,
		'autoplay'            => array(
			'delay' => 1000,
		),
		'speed'               => 500,
		'breakpoints'         => array(
			'0'    => array( 'slidesPerView' => 1 ),
			'576'  => array( 'slidesPerView' => 2 ),
			'768'  => array( 'slidesPerView' => 2 ),
			'992'  => array( 'slidesPerView' => 2 ),
			'1200' => array( 'slidesPerView' => 2 ),
			'1600' => array( 'slidesPerView' => $related_product_per_slide )
		),
		'auto'                => false,
		'show_arrow' => 1,
	);
	$swiper_data = apply_filters( 'finbuzz_related_products_carousel_options', $swiper_data );
	$swiper_json_data = json_encode( $swiper_data );
}
$pro_no =  count($related_products);
?>
<?php if( FinbuzzTheme::$options['related_woo_product'] && $pro_no > 1 ) { ?>
<div class="rt-related-post">
	<div class="rt-related-slider woo-related-product" data-xld = '<?php echo esc_attr( $has_slider ? $swiper_json_data : ''  ) ;?>'>
		<div class="section-title">
			<h3 class="related-title"><?php echo wp_kses( FinbuzzTheme::$options['related_product_title'] , 'alltext_allow' );?>
				<span class="titledot"></span>
				<span class="titleline"></span>
			</h3>
	    <?php if( $has_slider && ! empty( $swiper_data['show_arrow'] ) ){ ?>
			<div class="swiper-button">
	            <div class="swiper-button-prev"><i class="fas fa-chevron-left"></i></div>
	            <div class="swiper-button-next"><i class="fas fa-chevron-right"></i></div>
	        </div>
        <?php } ?>
	    </div>
		<ul class="swiper-wrapper <?php echo $has_slider ? 'swiper-wrapper': 'no-slider row' ;?>">

            <?php
			$product_class .= $has_slider ? ' swiper-slide' : ' col-md-3 col-sm-6 col-12 ';
            foreach ( $related_products as $related_product ) : ?>
			<div class="<?php echo esc_attr( $product_class ); ?>">
				<?php
				$post_object = get_post( $related_product->get_id() );

				setup_postdata( $GLOBALS['post'] =& $post_object ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited, Squiz.PHP.DisallowMultipleAssignments.Found

				wc_get_template_part( 'content', 'product' );
				?>
			</div>
			<?php endforeach; ?>
		</ul>
	</div>
</div>
<?php } ?>