<?php

/**
 *
 * @package WordPress
 * @subpackage goldsmith
 * @since Goldsmith 1.0
 *
**/

define('GOLDSMITH_DIRECTORY_URI', get_template_directory_uri());
define('GOLDSMITH_DIRECTORY', get_template_directory());

$ninethemeOpt = get_option('goldsmith',array());
/*************************************************
## GOOGLE FONTS
*************************************************/
if ( ! function_exists( 'goldsmith_fonts_url' ) ) {
    function goldsmith_fonts_url()
    {
        $fonts_url = '';
        $jost      = _x( 'on', 'Jost font: on or off', 'goldsmith' );
        $manrope   = _x( 'on', 'Manrope font: on or off', 'goldsmith' );

        if (  'off' !== $jost || 'off' !== $manrope ) {

            $font_families = array();

            if ( 'off' !== $jost ) {
                $font_families[] = 'Jost:300,400,500,600,700';
            }

            if ( 'off' !== $manrope ) {
                $font_families[] = 'Manrope:400,500,600,700,800';
            }

            $query_args = array(
                'family' => urlencode( implode( '|', $font_families ) ),
                'subset' => urlencode( 'latin,latin-ext' ),
                'display' => urlencode( 'swap' ),
            );

            $fonts_url = add_query_arg( $query_args, "//fonts.googleapis.com/css" );
        }

        return esc_url_raw( $fonts_url );
    }
}

/*************************************************
## STYLES AND SCRIPTS
*************************************************/

function goldsmith_theme_scripts()
{
    $rtl = is_rtl() ? 'rtl/' : '';
    // theme inner pages files

    wp_enqueue_style( 'goldsmith-fonts', goldsmith_fonts_url(), array(), null );

    if ( class_exists('Elementor\Plugin')) {

        $is_elementor = get_post_meta( get_the_ID(), '_elementor_edit_mode', true);

        $kit_id = \Elementor\Plugin::$instance->kits_manager->get_active_id();

        $kitcss_file = class_exists( '\Elementor\Core\Files\CSS\Post' )
        ? new \Elementor\Core\Files\CSS\Post( $kit_id )
        : ( class_exists( '\Elementor\Post_CSS_File' ) ? new \Elementor\Post_CSS_File( $kit_id ) : null );

        $kitcss_file->enqueue();

        $footerId   = apply_filters( 'goldsmith_elementor_footer_template', goldsmith_settings( 'footer_elementor_templates' ) );
        $footerId   = apply_filters( 'goldsmith_translated_template_id', $footerId );
        $shopTemp1  = goldsmith_settings( 'shop_before_loop_templates' );
        $shopTemp1  = apply_filters( 'goldsmith_translated_template_id', $shopTemp1 );
        $shopTemp2  = goldsmith_settings( 'shop_after_loop_templates' );
        $shopTemp2  = apply_filters( 'goldsmith_translated_template_id', $shopTemp2 );

        if ( $footerId || $shopTemp1 || $shopTemp2 ) {
            wp_enqueue_style( 'font-awesome-5-all' );
            wp_enqueue_style( 'widget-image' );
            wp_enqueue_style( 'widget-icon-list' );
            wp_enqueue_style( 'widget-social-icons' );
            wp_enqueue_style( 'widget-heading' );
            wp_enqueue_style( 'e-apple-webkit' );
        }

        if ( class_exists( 'WooCommerce' ) && is_woocommerce() ) {
            if ( $shopTemp1 ) {
                $shopTemp1css_file = class_exists( '\Elementor\Core\Files\CSS\Post' )
                ? new \Elementor\Core\Files\CSS\Post( $shopTemp1 )
                : ( class_exists( '\Elementor\Post_CSS_File' ) ? new \Elementor\Post_CSS_File( $shopTemp1 ) : null );

                $shopTemp1css_file->enqueue();
            }

            if ( $shopTemp2 ) {
                $shopTemp2css_file = class_exists( '\Elementor\Core\Files\CSS\Post' )
                ? new \Elementor\Core\Files\CSS\Post( $shopTemp2 )
                : ( class_exists( '\Elementor\Post_CSS_File' ) ? new \Elementor\Post_CSS_File( $shopTemp2 ) : null );

                $shopTemp2css_file->enqueue();
            }
        }

        if ( $footerId ) {
            $footercss_file = class_exists( '\Elementor\Core\Files\CSS\Post' )
            ? new \Elementor\Core\Files\CSS\Post( $footerId )
            : ( class_exists( '\Elementor\Post_CSS_File' ) ? new \Elementor\Post_CSS_File( $footerId ) : null );

            if ( $footercss_file ) {
                $footercss_file->enqueue();
            }
        }
    }

    if ( class_exists( 'WooCommerce' ) ) {
        wp_enqueue_style( 'goldsmith-wc-page-hero', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'woocommerce-page-hero.css',false, '1.0');
    }
    // bootstrap
    wp_enqueue_style( 'bootstrap-grid', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'bootstrap-light.min.css', false, '1.0' );
    wp_enqueue_style( 'goldsmith-default', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'default.css', false, '1.0' );
    // goldsmith-framework-style
    wp_enqueue_style( 'goldsmith-framework-style', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'framework-style.css', false, '1.0' );
    // goldsmith-main-style
    wp_enqueue_style( 'goldsmith-magnific', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'style-magnific.css', false, '1.0' );
    wp_register_style( 'goldsmith-nice-select', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'style-nice-select.css', false, '1.0' );
    wp_register_style( 'goldsmith-slick', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'style-slick.css', false, '1.0' );
    wp_enqueue_style( 'goldsmith-swiper', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'style-swiper.css', false, '1.0' );
    wp_register_style( 'goldsmith-blog-post', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'style-blog-post-item.css', false, '1.0' );
    wp_enqueue_style( 'goldsmith-side-panel-cart', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'style-side-panel-cart.css', false, '1.0' );
    wp_enqueue_style( 'goldsmith-side-panel-account', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'style-side-panel-account.css', false, '1.0' );
    wp_enqueue_style( 'goldsmith-side-panel', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'style-side-panel.css', false, '1.0' );
    wp_enqueue_style( 'goldsmith-style', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'style.css', false, '1.0' );
    wp_enqueue_style( 'goldsmith-main-style', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'style-main.css', false, '1.0' );

    wp_register_style( 'goldsmith-deals', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'product-deals.css', false, '1.0' );

    // lazy load
    wp_register_script( 'lazyload', GOLDSMITH_DIRECTORY_URI. '/js/lazy/lazyload.min.js', array( 'jquery' ), '1.0', false );
    // nice-select
    wp_register_script( 'jquery-nice-select', GOLDSMITH_DIRECTORY_URI . '/js/nice-select/jquery-nice-select.min.js', array( 'jquery' ), '1.0', true );
    // slick slider
    wp_register_script( 'slick', GOLDSMITH_DIRECTORY_URI. '/js/slick/slick.min.js', array( 'jquery' ), '1.0', true );
    // magnific
    wp_register_script( 'magnific', GOLDSMITH_DIRECTORY_URI. '/js/magnific/magnific-popup.min.js', array( 'jquery' ), '1.0', true );

    // swiper
    wp_register_script( 'goldsmith-swiper', GOLDSMITH_DIRECTORY_URI . '/js/swiper/swiper-bundle.min.js', array( 'jquery' ), '1.0', true );
    wp_enqueue_script( 'goldsmith-swiper' );
    // jquery-cookie
    wp_register_script( 'jquery-cookie', GOLDSMITH_DIRECTORY_URI . '/js/jquery/jquery-cookie.min.js', array( 'jquery' ), '1.0', true );
    // sliding-menu
    wp_register_script( 'sliding-menu', GOLDSMITH_DIRECTORY_URI . '/js/sliding-menu/sliding-menu.js', array( 'jquery' ), '1.0', true );
    // jquery-countdown
    wp_register_script( 'jquery-countdown', GOLDSMITH_DIRECTORY_URI. '/js/countdown/jquery.countdown.min.js', array( 'jquery' ), '1.0', true );
    wp_register_script( 'goldsmith-countdown', GOLDSMITH_DIRECTORY_URI. '/js/countdown/script.js', array( 'jquery' ), '1.0', true );

    wp_enqueue_script( 'goldsmith-main', GOLDSMITH_DIRECTORY_URI . '/js/scripts.js', array( 'jquery' ), '1.0', true );
    wp_localize_script( 'goldsmith-main', 'goldsmith_vars', goldsmith_theme_all_settings() );

    // select2-full
    wp_register_style( 'select2-full', GOLDSMITH_DIRECTORY_URI . '/js/select2/select2.min.css' );
    wp_register_script( 'select2-full', GOLDSMITH_DIRECTORY_URI . '/js/select2/select2.full.min.js', array( 'jquery' ), '1.0', true );

    if ( class_exists( 'WooCommerce' ) ) {
        $is_woo = is_woocommerce() || is_tax( 'goldsmith_product_brands' ) ? true : false;
        wp_enqueue_style( 'goldsmith-product-box-style', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'woocommerce-product-box-style.css',false, '1.0');

        if ( is_cart() ) {
            wp_enqueue_style( 'goldsmith-wc-cart-page', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'woocommerce-cart-page.css',false, '1.0');
        }
        if ( is_checkout() ) {
            wp_enqueue_style( 'goldsmith-wc-checkout-page', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'woocommerce-checkout-page.css',false, '1.0');

            $goldsmith_checkout_type = apply_filters( 'goldsmith_checkout_enable_multistep', goldsmith_settings( 'checkout_enable_multistep', 'default' ) );
            if ( 'multisteps' == $goldsmith_checkout_type ) {
                wp_enqueue_script( 'goldsmith-multi-step-checkout', GOLDSMITH_DIRECTORY_URI . '/woocommerce/assets/js/multi-step-checkout.js', array('jquery'), '1.0', true);
            }
        }

        wp_register_style( 'goldsmith-wc-account-page', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'woocommerce-account-page.css',false, '1.0');

        wp_enqueue_style( 'goldsmith-wc-popup-notices', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'woocommerce-popup-notices.css',false, '1.0');

        if ( '1' == goldsmith_settings( 'quick_view_visibility', '1' ) ) {
            wp_enqueue_style( 'goldsmith-wc-quick-view', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'woocommerce-quick-view.css',false, '1.0');
        }

        wp_enqueue_style( 'goldsmith-wc-ajax-search', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'woocommerce-ajax-search.css',false, '1.0');
        if ( '1' == goldsmith_settings( 'free_shipping_progressbar_visibility', '1' ) ) {
            wp_enqueue_style( 'goldsmith-wc-free-shipping-progressbar', GOLDSMITH_DIRECTORY_URI . '/css/woocommerce-free-shipping-progressbar.css',false, '1.0');
        }
        wp_enqueue_style( 'goldsmith-wc-quantity', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'woocommerce-quantity.css',false, '1.0');
        wp_enqueue_style( 'goldsmith-wc-stars', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'woocommerce-stars.css',false, '1.0');

        $layout = apply_filters('goldsmith_shop_layout', goldsmith_settings( 'shop_layout', 'left-sidebar' ) );
        $pagination = apply_filters('goldsmith_shop_pagination_type', goldsmith_settings('shop_paginate_type') );

        if ( $is_woo ) {

            if ( 'no-sidebar' != $layout ) {
                wp_enqueue_style( 'goldsmith-wc-sidebar', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'woocommerce-sidebar.css',false, '1.0');
            }
            if ( $pagination == 'pagination' || $pagination == 'ajax-pagination' ) {
                wp_enqueue_style( 'goldsmith-wc-pagination', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'woocommerce-pagination.css',false, '1.0');
            }
            if ( $pagination == 'infinite' ) {
                wp_enqueue_script( 'goldsmith-infinite-scroll', GOLDSMITH_DIRECTORY_URI. '/woocommerce/assets/js/infinite-scroll.js', array( 'jquery' ), false, '1.0' );
            }
            if ( $pagination == 'loadmore' ) {
                wp_enqueue_script( 'goldsmith-load-more', GOLDSMITH_DIRECTORY_URI. '/woocommerce/assets/js/load_more.js', array( 'jquery' ), false, '1.0' );
            }

            if ( !is_product() ) {
                wp_register_style( 'goldsmith-wc-masonry-layout', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'woocommerce-masonry-layout.css',false, '1.0');
                wp_enqueue_style( 'goldsmith-wc-filter-top', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'woocommerce-filter-top.css',false, '1.0');
            }
        }

        if ( '1' == goldsmith_settings('shop_fast_filter_visibility', '1' ) ) {
            wp_enqueue_style( 'goldsmith-wc-fast-filters', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'woocommerce-fast-filters.css',false, '1.0');
        }
        wp_enqueue_style( 'goldsmith-wc', GOLDSMITH_DIRECTORY_URI . '/woocommerce/assets/css/'.$rtl.'woocommerce-general.css',false, '1.0');

        wp_enqueue_script( 'goldsmith-wc', GOLDSMITH_DIRECTORY_URI . '/woocommerce/assets/js/woocommerce-general.js', array('jquery'), '1.0', true);

        if ( '1' == goldsmith_settings('shop_fast_filter_visibility', '1' ) ) {
            wp_enqueue_script( 'goldsmith-shop-cats-slider', GOLDSMITH_DIRECTORY_URI . '/woocommerce/assets/js/shop-cats-slider.js', array('jquery'), '1.0', true);
        }

        wp_enqueue_script( 'goldsmith-wc-ajax-addtocart', GOLDSMITH_DIRECTORY_URI . '/woocommerce/assets/js/ajax-addtocart.js', array('jquery'), '1.0', true);

        if ( '1' == goldsmith_settings('cart_limited_timer_visibility', '1' ) ) {
            wp_enqueue_script( 'goldsmith-sidepanel-timer', GOLDSMITH_DIRECTORY_URI . '/woocommerce/assets/js/sidepanel-timer.js', array('jquery'), '1.0', true);
        }

        if ( '1' == goldsmith_settings( 'quick_shop_visibility', '1' ) ) {
            wp_enqueue_script( 'wc-add-to-cart-variation' );
            wp_enqueue_style( 'goldsmith-wc-quick-shop', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'woocommerce-quick-shop.css',false, '1.0');
            wp_enqueue_script( 'goldsmith-wc-ajax-quick-shop', GOLDSMITH_DIRECTORY_URI . '/woocommerce/assets/js/quick-shop.js', array('jquery'), '1.0', true);
        }

        wp_register_style( 'goldsmith-wc-custom-reviews-slider', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'woocommerce-custom-reviews-slider.css',false, '1.0');

        wp_enqueue_style( 'goldsmith-wc-product-variatons', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'woocommerce-product-variatons.css',false, '1.0');
        wp_enqueue_style( 'goldsmith-wc-product-page', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'woocommerce-product-page.css',false, '1.0');

        if ( is_product() ) {
            // fancybox
            wp_enqueue_style( 'fancybox', GOLDSMITH_DIRECTORY_URI . '/js/fancybox/jquery.fancybox.css', false, '1.0' );
            wp_enqueue_script( 'fancybox', GOLDSMITH_DIRECTORY_URI . '/js/fancybox/jquery.fancybox.min.js', array(), '1.0', true );

            wp_enqueue_script( 'goldsmith-product-page', GOLDSMITH_DIRECTORY_URI . '/woocommerce/assets/js/product-page.js', array('jquery'), '1.0', true);
            wp_register_script( 'flex-thumbs', GOLDSMITH_DIRECTORY_URI . '/woocommerce/assets/js/product-page-flex-thumbs.js', array('jquery'), '1.0', true);

            if ( '1' == goldsmith_settings( 'goldsmith_product_bottom_popup_cart', '1' ) ) {
                wp_enqueue_script( 'goldsmith-product-bottom-popup-cart', GOLDSMITH_DIRECTORY_URI . '/woocommerce/assets/js/product-bottom-popup-cart.js', array('jquery'), '1.0', true);
            }

            wp_register_script( 'goldsmith-product-page-carousel', GOLDSMITH_DIRECTORY_URI . '/woocommerce/assets/js/product-page-gallery-carousel.js', array('jquery'), '1.0', true);
            wp_register_script( 'goldsmith-product-page-showcase-carousel', GOLDSMITH_DIRECTORY_URI . '/woocommerce/assets/js/product-page-showcase-carousel.js', array('jquery'), '1.0', true);
            wp_register_script( 'goldsmith-product-carousel-thumbs', GOLDSMITH_DIRECTORY_URI . '/woocommerce/assets/js/product-page-showcase-carousel-thumbs.js', array('jquery'), '1.0', true);

            if ( class_exists( 'Ivole' ) && comments_open() && '1' == goldsmith_settings('single_shop_review_visibility', '1' ) ) {
                wp_enqueue_style( 'goldsmith-wc-custom-reviews', GOLDSMITH_DIRECTORY_URI . '/css/'.$rtl.'woocommerce-custom-reviews.css',false, '1.0');
            }
        }

        if ( function_exists('goldsmith_pjax') && ( is_shop() || is_product_category() || is_product_tag() || is_tax( 'goldsmith_product_brands' ) ) ) {
            if ( '1' == goldsmith_settings('shop_ajax_filter', '1' ) ) {
                wp_enqueue_script( 'pjax', GOLDSMITH_DIRECTORY_URI . '/woocommerce/assets/js/pjax.min.js', array('jquery'), '1.0', true );
                wp_enqueue_script( 'shopAjaxFilter', GOLDSMITH_DIRECTORY_URI . '/woocommerce/assets/js/shopAjaxFilter.js', array('jquery', 'pjax'), '1.0', true );
            }
        }

        wp_register_script( 'goldsmith-quantity-button', GOLDSMITH_DIRECTORY_URI . '/woocommerce/assets/js/quantity_button.js', array('jquery'), '1.0.0', true );
    }

    if ( '1' == goldsmith_settings( 'theme_blocks_styles', '0' ) ) {
        wp_dequeue_style( 'cr-badges-css' );
        wp_deregister_style( 'cr-badges-css' );
        wp_dequeue_style( 'ivole-frontend-css' );
        wp_deregister_style( 'ivole-frontend-css' );
        wp_dequeue_style( 'wc-blocks-vendors-style' );
        wp_dequeue_style( 'wc-blocks-editor' );
        wp_dequeue_style( 'wp-block-library' );
        wp_dequeue_style( 'wp-block-library-theme' );
        wp_dequeue_style( 'wc-blocks-style' ); // Remove WooCommerce block CSS
        wp_deregister_style( 'wc-blocks-vendors-style' );
        wp_deregister_style( 'wc-blocks-editor' );
        wp_deregister_style( 'wp-block-library' );
        wp_deregister_style( 'wp-block-library-theme' );
        wp_deregister_style( 'wc-blocks-style' ); // Remove WooCommerce block CSS
    }
}
add_action( 'wp_enqueue_scripts', 'goldsmith_theme_scripts', 9999999 );

if ( isset($ninethemeOpt['theme_blocks_styles']) && '1' == $ninethemeOpt['theme_blocks_styles'] ) {
    remove_theme_support( 'widgets-block-editor' );
    add_filter( 'use_widgets_block_editor', '__return_false' );
    add_filter('use_block_editor_for_post', '__return_false', 10);
    add_filter('use_block_editor_for_page', '__return_false', 10);
}

/*************************************************
## THEME SETUP
*************************************************/

if ( ! isset( $content_width ) ) {
    $content_width = 960;
}

function goldsmith_theme_setup()
{
    /*
    * This theme styles the visual editor to resemble the theme style,
    * specifically font, colors, icons, and column width.
    */
    add_editor_style( 'custom-editor-style.css' );

    // Add default posts and comments RSS feed links to head.
    add_theme_support( 'automatic-feed-links' );
    add_image_size( 'goldsmith-quickview', 60, 60, true );
    add_image_size( 'goldsmith-panel', 80, 80, true );
    add_image_size( 'goldsmith-mini', 300, 300, true );
    add_image_size( 'goldsmith-medium', 370, 370, true );
    add_image_size( 'goldsmith-square', 500, 500, true );
    add_image_size( 'goldsmith-grid', 767, 767, true );
    /*
    * Enable support for Post Thumbnails on posts and pages.
    *
    * See: https://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
    */
    add_theme_support( 'post-thumbnails' );

    // theme supports
    add_theme_support( 'title-tag' );
    add_theme_support( 'custom-background' );
    add_theme_support( 'custom-header' );
    add_theme_support( 'html5', array( 'search-form' ) );
    add_theme_support( 'admin-bar', array( 'callback' => '__return_false' ) );

    // Make theme available for translation
    // Translations can be filed in the /languages/ directory
    load_theme_textdomain( 'goldsmith', GOLDSMITH_DIRECTORY . '/languages' );

    if ( is_admin() ) {
        include GOLDSMITH_DIRECTORY . '/inc/admin.php';
        // Theme admin menu
        require_once get_parent_theme_file_path( '/inc/core/merlin/admin-menu.php' );
        require_once get_parent_theme_file_path( '/inc/core/merlin/class-merlin.php' );
        require_once get_parent_theme_file_path( '/inc/core/demo-wizard-config.php' );
    }

    // Template-functions
    include get_template_directory() . '/inc/template-functions.php';

    // Theme parts
    include GOLDSMITH_DIRECTORY . '/inc/template-parts/menu.php';
    include GOLDSMITH_DIRECTORY . '/inc/template-parts/post-formats.php';
    include GOLDSMITH_DIRECTORY . '/inc/template-parts/single-post-formats.php';
    include GOLDSMITH_DIRECTORY . '/inc/template-parts/paginations.php';
    include GOLDSMITH_DIRECTORY . '/inc/template-parts/comment-parts.php';
    include GOLDSMITH_DIRECTORY . '/inc/template-parts/small-parts.php';
    include GOLDSMITH_DIRECTORY . '/inc/template-parts/header-parts.php';
    include GOLDSMITH_DIRECTORY . '/inc/template-parts/footer-parts.php';
    include GOLDSMITH_DIRECTORY . '/inc/template-parts/page-hero.php';
    include GOLDSMITH_DIRECTORY . '/inc/template-parts/breadcrumbs.php';
    include GOLDSMITH_DIRECTORY . '/inc/template-parts/custom-style.php';

    // WooCommerce init
    if ( class_exists( 'WooCommerce' ) ) {
        $ninethemeOpt = get_option('goldsmith',array());
        $single_image = isset($ninethemeOpt['product_gallery_imgsize']) ? $ninethemeOpt['product_gallery_imgsize'] : 980;
        $zoom = isset($ninethemeOpt['goldsmith_product_zoom']) ? $ninethemeOpt['goldsmith_product_zoom'] : 1;
        $thumbs_layout = isset($ninethemeOpt['product_thumbs_layout']) ? $ninethemeOpt['product_thumbs_layout'] : 'slider';
        add_theme_support( 'woocommerce', array(
            'thumbnail_image_width' => 450,
            'single_image_width'    => $single_image
        ));

        if ( '1' == $zoom ) {
            add_theme_support( 'wc-product-gallery-zoom' );
        }

        $thumbs_layout = apply_filters( 'goldsmith_product_thumbs_layout', $thumbs_layout );
        if ( $thumbs_layout == 'woo' ) {
            add_theme_support( 'wc-product-gallery-zoom' );
            add_theme_support( 'wc-product-gallery-lightbox' );
            add_theme_support( 'wc-product-gallery-slider' );
        }
        
        include GOLDSMITH_DIRECTORY . '/woocommerce/init.php';
    }

    // Redux theme options panel
    include GOLDSMITH_DIRECTORY . '/inc/core/theme-options/options.php';

    register_nav_menus(array(
        'header_menu' => esc_html__( 'Header Menu', 'goldsmith' ),
        'sidebar_menu' => esc_html__( 'Sidebar Menu', 'goldsmith' ),
        'sidebar_second_menu' => esc_html__( 'Sidebar Header Second Menu ( For Sidebar Header )', 'goldsmith' ),
        'left_menu' => esc_html__( 'Left Menu ( for logo center )', 'goldsmith' ),
        'rigt_menu' => esc_html__( 'Right Menu ( for logo center )', 'goldsmith' ),
        'header_mini_menu' => esc_html__( 'Secondary Mini Menu', 'goldsmith' ),
        'header_lang_menu' => esc_html__( 'Header Lang Menu', 'goldsmith' ),
        'mobile_bottom_menu' => esc_html__( 'Mobile Bottom Menu', 'goldsmith' ),
    ));
}
add_action( 'after_setup_theme', 'goldsmith_theme_setup' );


// disable srcset on frontend
if ( !function_exists('goldsmith_disable_wp_responsive_images') ){
    function goldsmith_disable_wp_responsive_images() {
        return 1;
    }
    add_filter('max_srcset_image_width', 'goldsmith_disable_wp_responsive_images');
}

add_filter('wpcf7_autop_or_not', '__return_false');

/*************************************************
## WIDGET COLUMNS
*************************************************/

function goldsmith_widgets_init()
{
    register_sidebar(array(
        'name' => esc_html__( 'Blog Sidebar', 'goldsmith' ),
        'id' => 'sidebar-1',
        'description' => esc_html__( 'These widgets for the Blog page.', 'goldsmith' ),
        'before_widget' => '<div class="nt-sidebar-inner-widget widget blog-sidebar-widget mb-40 %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<div class="nt-sidebar-inner-widget-title blog-sidebar-title"><h5>',
        'after_title' => '</h5></div>'
    ));
    if ( class_exists( 'Redux' ) ) {
        if ( 'full-width' != goldsmith_settings( 'goldsmith_page_layout' ) ) {
            register_sidebar(array(
                'name' => esc_html__( 'Default Page Sidebar', 'goldsmith' ),
                'id' => 'goldsmith-page-sidebar',
                'description' => esc_html__( 'These widgets for the Default Page pages.', 'goldsmith' ),
                'before_widget' => '<div class="nt-sidebar-inner-widget widget blog-sidebar-widget mb-40 %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<div class="nt-sidebar-inner-widget-title blog-sidebar-title"><h5>',
                'after_title' => '</h5></div>'
            ));
        }
        if ( 'full-width' != goldsmith_settings( 'archive_layout', 'full-width' ) ) {
            register_sidebar(array(
                'name' => esc_html__( 'Archive Sidebar', 'goldsmith' ),
                'id' => 'goldsmith-archive-sidebar',
                'description' => esc_html__( 'These widgets for the Archive pages.', 'goldsmith' ),
                'before_widget' => '<div class="nt-sidebar-inner-widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<div class="nt-sidebar-inner-widget-title blog-sidebar-title"><h5>',
                'after_title' => '</h5></div>'
            ));
        }
        if ( 'full-width' != goldsmith_settings( 'search_layout', 'full-width' ) ) {
            register_sidebar(array(
                'name' => esc_html__( 'Search Sidebar', 'goldsmith' ),
                'id' => 'goldsmith-search-sidebar',
                'description' => esc_html__( 'These widgets for the Search pages.', 'goldsmith' ),
                'before_widget' => '<div class="nt-sidebar-inner-widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<div class="nt-sidebar-inner-widget-title blog-sidebar-title"><h5>',
                'after_title' => '</h5></div>'
            ));
        }
        if ( 'full-width' != goldsmith_settings( 'single_layout', 'right-sidebar' ) ) {
            register_sidebar(array(
                'name' => esc_html__( 'Blog Single Sidebar', 'goldsmith' ),
                'id' => 'goldsmith-single-sidebar',
                'description' => esc_html__( 'These widgets for the Blog single page.', 'goldsmith' ),
                'before_widget' => '<div class="nt-sidebar-inner-widget widget blog-sidebar-widget mb-40 %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<div class="nt-sidebar-inner-widget-title blog-sidebar-title"><h5>',
                'after_title' => '</h5></div>'
            ));
        }
    } // end if redux exists
} // end goldsmith_widgets_init
add_action( 'widgets_init', 'goldsmith_widgets_init' );

function goldsmith_register_elementor_locations( $elementor_theme_manager )
{
    $elementor_theme_manager->register_location( 'header' );
    $elementor_theme_manager->register_location( 'footer' );
    $elementor_theme_manager->register_location( 'single' );
    $elementor_theme_manager->register_location( 'archive' );

}
add_action( 'elementor/theme/register_locations', 'goldsmith_register_elementor_locations' );
