<?php
/**
* Class for the CPTUI importer.
*
* @see https://wordpress.org/plugins/redux-framework/
*
* @package Merlin WP
*/

class Merlin_Ntcptui_Importer {
    /**
    * Import CPTUI data from a JSON file, generated by the CPTUI plugin.
    *
    * @param array $import_data Array of arrays. Child array contains 'cpt_file_url' and 'tax_file_url'.
    *
    * @return boolean
    */
    public static function import( $import_data ) {
        // CPTUI plugin is not active!
        if ( ! class_exists( 'cptui_admin_ui' ) || empty( $import_data ) ) {
            return false;
        }

        // CPTUI Post Types
        $cptui_raw_data = file_get_contents( $import_data[0]['cpt_file_url'] );
        $cptui_data= json_decode( $cptui_raw_data, true );
        $cptdata = maybe_unserialize( $cptui_data );
        update_option( 'cptui_post_types', $cptdata );

        // CPTUI Taxonomies
        $cptui_tax_data = file_get_contents( $import_data[0]['tax_file_url'] );
        $cptui_tax = json_decode( $cptui_tax_data, true );
        $taxdata = maybe_unserialize( $cptui_tax );
        update_option( 'cptui_taxonomies', $taxdata );

        return true;
    }
}
