<?php
/**
* Checkout coupon form
*
* This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-coupon.php.
*
* HOWEVER, on occasion WooCommerce will need to update template files and you
* (the theme developer) will need to copy the new files to your theme to
* maintain compatibility. We try to do this as little as possible, but it does
* happen. When this occurs the version of the template file will be bumped and
* the readme will list any important changes.
*
* @see https://docs.woocommerce.com/document/template-structure/
* @package WooCommerce\Templates
* @version 9.8.0
*/

defined( 'ABSPATH' ) || exit;

if ( ! wc_coupons_enabled() ) { // @codingStandardsIgnoreLine.
return;
}

?>
<div class="woocommerce-form-coupon-toggle">
<?php wc_print_notice( apply_filters( 'woocommerce_checkout_coupon_message', esc_html__( 'Have a coupon?', 'goldsmith' ) . ' <a href="#" class="showcoupon" aria-controls="woocommerce-checkout-form-coupon" aria-expanded="false" class="showcoupon">' . esc_html__( 'Click here to enter your code', 'goldsmith' ) . '</a>' ), 'notice' ); ?>
</div>

<form class="checkout_coupon woocommerce-form-coupon" method="post" style="display:none">

    <p class="form-row goldsmith-coupon-row">
        <label for="coupon_code" class="screen-reader-text"><?php esc_html_e( 'Coupon:', 'goldsmith' ); ?></label>
        <input type="text" name="coupon_code" class="input-text" id="coupon_code" value="" />
        <button type="submit" class="button goldsmith-btn-medium goldsmith-btn goldsmith-bg-black" name="apply_coupon" value="<?php esc_attr_e( 'Apply coupon', 'goldsmith' ); ?>"><?php esc_html_e( 'Apply coupon', 'goldsmith' ); ?><span class="loading-wrapper"><span class="ajax-loading"></span></span></button>
    </p>

    <div class="clear"></div>
</form>
