<?php
$leads_count = Houzez_Leads::get_leads_stats();

$lastday = $leads_count['leads_count']['lastday'];
$lasttwo = $leads_count['leads_count']['lasttwo'];
$lasttwo = $lasttwo - $lastday;

$lastweek = $leads_count['leads_count']['lastweek'];
$last2week = $leads_count['leads_count']['last2week'];
$last2week = $last2week - $lastweek;

$lastmonth = $leads_count['leads_count']['lastmonth'];
$last2month = $leads_count['leads_count']['last2month'];
$last2month = $last2month - $lastweek;

?>
<div class="property-stats">
	<div class="row">
		<div class="col-md-4 col-sm-6 col-12">
			<div class="stats-box">
				<div class="media">
					<p>
						<strong><?php esc_html_e('Last 24 Hours', 'houzez'); ?></strong>
					</p>
				</div>
				<div class="d-flex align-items-baseline gap-2">
					<h3><?php echo number_format_i18n($lastday); ?></h3>
					<?php houzez_views_percentage($lasttwo, $lastday); ?>
				</div>
			</div>
		</div>
		<div class="col-md-4 col-sm-6 col-12">
			<div class="stats-box">
				<div class="media">
					<p>
						<strong><?php esc_html_e('Last 7 Days', 'houzez'); ?></strong>
					</p>
				</div>
				<div class="d-flex align-items-baseline gap-2">
					<h3><?php echo number_format_i18n($leads_count['leads_count']['lastweek']); ?></h3>
					<?php houzez_views_percentage($last2week, $lastweek); ?>
				</div>
			</div>
		</div>
		<div class="col-md-4 col-sm-6 col-12">
			<div class="stats-box">
				<div class="media">
					<p>
						<strong><?php esc_html_e('Last 30 Days', 'houzez'); ?></strong>
					</p>
				</div>
				<div class="d-flex align-items-baseline gap-2">
					<h3><?php echo number_format_i18n($leads_count['leads_count']['lastmonth']); ?></h3>
					<?php houzez_views_percentage($last2month, $lastmonth); ?>
				</div>
			</div>
		</div>
	</div>
</div>
