<?php

// Block direct access to file
defined( 'ABSPATH' ) or die( 'Not Authorized!' );

class Kanews_Stories {

	public function __construct() {
		
		// Check if the theme is enabled
		if( ! class_exists( 'KANEWS_WEATHER' ) ){
			return;
		}

		// Plugin uninstall hook
		register_uninstall_hook( WPS_FILE, array('Kanews_Stories', 'plugin_uninstall') );

		// Plugin activation/deactivation hooks
		register_activation_hook( WPS_FILE, array($this, 'plugin_activate') );
		register_deactivation_hook( WPS_FILE, array($this, 'plugin_deactivate') );

		// Plugin Actions
		load_plugin_textDomain( WPS_TEXT_DOMAIN, false, dirname(WPS_DIRECTORY_BASENAME) . '/languages' );
		add_action( 'kanews_header_ad', array($this, 'html_output') );
		add_action( 'wp_enqueue_scripts', array($this, 'plugin_enqueue_scripts') );

	}

	public static function plugin_uninstall() { }

	/**
	 * Plugin activation function
	 * called when the plugin is activated
	 * @method plugin_activate
	 */
	public function plugin_activate() { }

	/**
	 * Plugin deactivate function
	 * is called during plugin deactivation
	 * @method plugin_deactivate
	 */
	public function plugin_deactivate() { }


	/**
	 * Enqueue the main Plugin user scripts and styles
	 * @method plugin_enqueue_scripts
	 */
	function plugin_enqueue_scripts() {
		wp_register_style( 'zuck', WPS_DIRECTORY_URL . '/assets/zuck.min.css', array(), null );
		wp_register_script( 'zuck', WPS_DIRECTORY_URL . '/assets/zuck.min.js', array(), null, true );
		wp_enqueue_script('jquery');
		wp_enqueue_style('zuck');
		wp_enqueue_script('zuck');
		$this->kanews_stories(); 
	}
	
	function html_output() {
		$options = get_option( 'kanews_stories' );
		$custom = $options['kanews_story_site'];
		$cats = $options['kanews_story_cats'];

		if( ! isset($options['kanews_stories']) )
		return;
	
		if( ! $options['kanews_stories'] )
		return;
	
		if( is_home() || is_front_page() ) {
			$style = isset($options['kanews_stories_style']) ? $options['kanews_stories_style'] : '1';
			$hide_title = isset($options['kanews_stories_hide_title']) && $options['kanews_stories_hide_title'] ? 'kanews_story_hide_title' : '';
			$out = '<div class="container"><div id="stories" class="kanews_stories_'.$style.' '.$hide_title.'"></div></div>';
		
			echo $out;
		}
	}
	
	function kanews_stories() {
		$options = get_option( 'kanews_stories' );
		$custom = $options['kanews_story_site'];
		$cats = $options['kanews_story_cats'];
		
		if( ! isset($options['kanews_stories']) )
		return;
	
		if( ! $options['kanews_stories'] )
		return;	
	
		$out = '';
		
		$dr = $options['kanews_stories_dr']; 
		
		$custom_title = !empty($options['kanews_story_site_title']) ? $options['kanews_story_site_title'] : get_bloginfo('name');
		
		if( is_home() || is_front_page() ) {
			ob_start(); ?>
				var stories  = function () {
					var stories = new Zuck('stories', {
						skin: 'snapgram',
						backNative: true,
						previousTap: true,
						autoFullScreen: true,
						avatars: true,
						list: false,
						cubeEffect: true,
						localStorage: false,
						stories: [
						// custom category
							<?php if ($custom): $_timezone = date_default_timezone_get(); date_default_timezone_set( 'Europe/Istanbul' ); ?>
								<?php $a=0;foreach($custom as $item ) : $a++; ?>
									{
										id: "kanews-story-site-<?php echo $a; ?>",
										photo: "<?php echo (!empty($item['image'])) ? $item['image']: WPS_DIRECTORY_URL.'/assets/kanthemes_favicon.png'; ?>",
										name: "<?php echo !empty($item['title']) ? $item['title'] : get_bloginfo('name'); ?>",
										link: "<?php echo get_home_url(); ?>",
										color: "<?php echo !empty($item['color']) ? $item['color'] : '#d7050f'; ?>",
										lastUpdated: "<?php echo strtotime($item['stories']['0']['date']); ?>",
										seen: false,
										items: [
											<?php $i=0;foreach($item['stories'] as $story ) : $i++; ?>
												Zuck.buildItem(
													"kanews-story-site-<?php echo $a; ?>-<?php echo $i; ?>",
													"photo",
													"<?php echo $dr; ?>",
													"<?php echo $story['image']; ?>",
													"data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs%3D",
													"<?php echo $story['link']; ?>",
													"<?php echo $story['title'] ?>",
													false,
													"<?php echo strtotime($story['date']); ?>",
												),
											<?php endforeach; ?>
										]
									},
								<?php endforeach; ?>
							
							<?php date_default_timezone_set( $_timezone ); endif;?>
						
						// blog categories 
							<?php if ($cats): ?> 
							<?php foreach($cats as $item):?>
								<?php $number_of_posts = !empty($options['kanews_stories_post']) ? $options['kanews_stories_post'] : '5'; 
								$orderby = !empty($options['kanews_stories_order']) ? $options['kanews_stories_order'] : ''; 
								if ($options['kanews_stories_time']):
									$query_st = new WP_Query(array( 'cat' => $item['id'], 'author' => $item['uid'], 'showposts' => $number_of_posts, 'orderby' => $orderby, 'date_query' => array(array('after' => '24 hours ago'))));
								else:
									$query_st = new WP_Query(array( 'cat' => $item['id'], 'author' => $item['uid'], 'showposts' => $number_of_posts, 'orderby' => $orderby));
								endif;?>
								<?php if ($query_st->have_posts()): $avatar = (!empty($item['image'])) ? $item['image']: WPS_DIRECTORY_URL.'/assets/kanthemes_favicon.png'; ?>
									{
							  id: "geoit-story-<?php echo $item['id'] != '' ? get_category($item['id'])->slug : get_the_author_meta( 'ID', $item['uid'] ); ?>",
										photo: "<?php echo $avatar; ?>",
										name: "<?php echo $item['title']; ?>",
							  link: "<?php echo $item['id'] != '' ? get_category_link($item['id']) : get_author_feed_link( $item['id'] ); ?>",
										color: "<?php echo !empty($item['color']) ? $item['color'] : '#d7050f'; ?>",
										seen: false,
										lastUpdated: "<?php echo get_post_modified_time('U', true); ?>",
										items: [
										<?php $i=0;while($query_st->have_posts()): $query_st->the_post(); global $post; $i++;?>
											Zuck.buildItem(
										"geoit-story-<?php echo ($item['id'] != '') ? get_category($item['id'])->slug : get_the_author_meta( 'ID', $item['uid'] ); ?>-<?php echo $i; ?>",
												"photo",
												"<?php echo $dr; ?>",
												"<?php echo get_the_post_thumbnail_url($post->ID,'full'); ?>",
												"data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs%3D",
												'<?php echo get_the_permalink(); ?>',
												'<?php echo get_the_title(); ?>',
												false,
												"<?php echo get_post_modified_time('U', true, $post->ID); ?>"
											),
										<?php endwhile; wp_reset_postdata() ?>
										]
									},
								<?php endif; ?>
							<?php endforeach; ?>
							<?php endif; ?>
						],
						'language': {
						'unmute': '<?php _e("Sesi açmak için dokunun", WPS_TEXT_DOMAIN); ?>',
						'keyboardTip': '<?php _e("Bir sonrakine geçmek için dokunun", WPS_TEXT_DOMAIN); ?>',
						'visitLink': '<?php _e("Hemen Okuyun", WPS_TEXT_DOMAIN); ?>',
						'time': {
							'ago':'<?php _e("önce", WPS_TEXT_DOMAIN); ?>', 
							'hour':'<?php _e("saat", WPS_TEXT_DOMAIN); ?>', 
							'hours':'<?php _e("saat", WPS_TEXT_DOMAIN); ?>', 
							'minute':'<?php _e("dakika", WPS_TEXT_DOMAIN); ?>', 
							'minutes':'<?php _e("dakika", WPS_TEXT_DOMAIN); ?>', 
							'fromnow': '<?php _e("şimdi", WPS_TEXT_DOMAIN); ?>', 
							'seconds':'<?php _e("saniye", WPS_TEXT_DOMAIN); ?>', 
							'yesterday': '<?php _e("dün", WPS_TEXT_DOMAIN); ?>', 
							'tomorrow': '<?php _e("bugün", WPS_TEXT_DOMAIN); ?>', 
							'days':'<?php _e("gün", WPS_TEXT_DOMAIN); ?>'
						}
						},
					});

				};
					stories();
			<?php $out = ob_get_clean();
			wp_add_inline_script('zuck', $out);
		}
	}

}

//
add_filter( 'init', 'Kanews_Stories_init' );
function Kanews_Stories_init(){
	if( ! class_exists( 'CSF' ) )
		return;
	new Kanews_Stories();

}

