<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Kanews
 */
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
wp_enqueue_style( 'kanews-theme-single');
get_header(); ?>
  <main id="main" class="site-main">
		<div class="container">
			<div class="kanews-error-page">
				<div class="row align-items-center">
					<div class="col-12 col-md-6">
						
						<h1>404</h1>
						<h2><?php echo kanews_translate('404-page-title', esc_html__( 'Aradığınız Sayfa Bulunamadı!', 'kanews' )); ?></h2>
						<p><?php echo kanews_translate('404-page-desc', esc_html__( 'Aradığınız sayfaya ulaşamadık silinmiş, geçici olarak kaldırılmış veya böyle bir sayfa hiç olmamış olabilir, lütfen daha sonra tekrar deneyiniz.', 'kanews' )); ?></p>
						<?php get_search_form(); ?>
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="kanews-btn kanews-btn-sm"> <?php _e('Anasayfa\'ya Dön', 'kanews'); ?></a>
					</div>
					<div class="col-12 col-md-6">
						<?php echo kanews_get_local_image(KAN_TEMPLATE_URL.'/assets/img/static/404.svg', array( 'width' => '570', 'height' =>'427', 'alt' => '404'	 )); ?>
						</div>
				</div>
			</div>
		</div>
  </main>
<?php get_footer();