<?php
add_filter( 'amp_customizer_is_enabled', '__return_false' );

/*-----------------------------------------------------------------------------------*/
# AMP Head Codes
/*-----------------------------------------------------------------------------------*/
function kanews_amp_wp_head() {
	$kod = kanews_get_amp_option('amp-wp-head');
	$out = '';
	if (!empty($kod))
		$out = $kod;
	echo $out;
}
add_action('amp_post_template_head', 'kanews_amp_wp_head');

/*-----------------------------------------------------------------------------------*/
# AMP Footer Codes
/*-----------------------------------------------------------------------------------*/
function kanews_amp_footer_codes() {
	$kod = kanews_get_amp_option('amp-wp-footer');
	$out = '';
	if (!empty($kod))
		$out = $kod;
	echo $out;
}
add_action('amp_post_template_footer', 'kanews_amp_footer_codes');

/*-----------------------------------------------------------------------------------*/
# AMP Custom css
/*-----------------------------------------------------------------------------------*/
add_action( 'amp_post_template_css', function() {
	if($css = kanews_get_amp_option('amp-custom-css'))
	echo $css;
} );

/*-----------------------------------------------------------------------------------*/
# Post Thumbnails
/*-----------------------------------------------------------------------------------*/
function kanews_amp_post_thumbnail() {
	$thumbnail_id = get_post_thumbnail_id();
	if ( $thumbnail_id ) {
		$url = wp_get_attachment_image_url( $thumbnail_id, 'kanews-post-3' );
		$alt_html = get_post_meta( $thumbnail_id, '_wp_attachment_image_alt', true ) ? get_post_meta( $thumbnail_id, '_wp_attachment_image_alt', true ) : 'image';
		echo '<a href="' . amp_get_permalink(get_the_ID()) . '" title="' . get_the_title() . '"><amp-img alt="'.esc_attr($alt_html).'" layout="responsive" src="' . $url . '" width="390" height="218"></amp-img></a>';
	}
}

/*-----------------------------------------------------------------------------------*/
# Force the reader mode
/*-----------------------------------------------------------------------------------*/
function kanews_set_amp_mode( $value, $old_value ){
	$value['theme_support'] = 'reader';
	// $value['mobile_redirect'] = '';
	return $value;
}
add_filter( 'pre_update_option_amp-options', 'kanews_set_amp_mode', 10, 2 );

/*-----------------------------------------------------------------------------------*/
# AMP Link
/*-----------------------------------------------------------------------------------*/
add_filter( 'nav_menu_link_attributes', 'kanews_nav_menu_link');
function kanews_nav_menu_link($atts = array()) {
	if( function_exists( 'is_amp_endpoint' ) && is_amp_endpoint() ){

		if( ! empty( $atts['href'] ) ){
			$atts['href'] = add_query_arg( 'amp', '1', $atts['href'] );
		}
	}

	return $atts;
}

/*-----------------------------------------------------------------------------------*/
# AMP Menu
/*-----------------------------------------------------------------------------------*/
class kanews_AMP_Menu_Walker extends Walker_Nav_Menu {

	protected $accordion_started = FALSE;
	protected $accordion_childs_started = FALSE;

	public function start_lvl( &$output, $depth = 0, $args = array() ) {
	}

	public function end_lvl( &$output, $depth = 0, $args = array() ) {

		if ( $this->accordion_childs_started && $depth == 0 ) {

			$this->end_accordion_child_wrapper( $output, $depth );
		}

		if ( $this->accordion_started && $depth == 0 ) {
			$this->end_accordion( $output, $depth );
		}

	}

	public function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {

		$args = apply_filters( 'nav_menu_item_args', $args, $item, $depth );

		// Remove menu-item-has-children class
		if ( $depth ) {
			$index = array_search( 'menu-item-has-children', $item->classes );
			if ( $index !== FALSE ) {
				unset( $item->classes[ $index ] );
			}
		}

		$classes   = empty( $item->classes ) ? array() : (array) $item->classes;
		$classes[] = 'menu-item-' . $item->ID;

		if ( $depth > 1 ) {
			$classes[] = 'menu-item-deep';
		}

		$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args, $depth ) );
		$class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';

		if ( $this->has_children && $depth == 0 ) {
			add_theme_support( 'better-amp-has-nav-child', TRUE );

			$this->start_accordion( $output, $depth );

			$output .= '<h6><span ' . $class_names . '>';
			$output .= $this->get_anchor_tag( $item, $depth, $args, $id );
			$output .= '</span></h6>';

			$this->start_accordion_child_wrapper( $output, $depth );

		} else {

			$output .= '<span ' . $class_names . '>';
			$output .= $this->get_anchor_tag( $item, $depth, $args, $id );
			$output .= '</span>';

		}

	} // start_el


	public function end_el( &$output, $item, $depth = 0, $args = array() ) {
	}

	public function start_accordion( &$output, $depth = 0 ) {

		$output .= "<amp-accordion><section>";

		$this->accordion_started = TRUE;
		$this->enqueue_accordion = TRUE;
	}

	public function end_accordion( &$output, $depth = 0 ) {

		$output .= "</section></amp-accordion>";

		$this->accordion_started = FALSE;
	}

	public function start_accordion_child_wrapper( &$output, $depth = 0 ) {

		$output .= "\n<div>\n";

		$this->accordion_childs_started = TRUE;
	}

	public function end_accordion_child_wrapper( &$output, $depth = 0 ) {

		$output .= "</div>\n";

		$this->accordion_childs_started = FALSE;
	}

	public function get_anchor_tag( $item, $depth, $args, $id ) {

		$current_el = '';

		parent::start_el( $current_el, $item, $depth, $args, $id );

		// Unwrap li tag
		if ( preg_match( '#<\s*li\s* [^>]* > (.+) #ix', $current_el, $matched ) ) {
			return $matched[1];
		}

		return $this->make_anchor_tag( $item, $args, $depth );
	}

	protected function make_anchor_tag( $item, $args, $depth ) {

		$atts           = array();
		$atts['title']  = ! empty( $item->attr_title ) ? $item->attr_title : '';
		$atts['target'] = ! empty( $item->target ) ? $item->target : '';
		$atts['rel']    = ! empty( $item->xfn ) ? $item->xfn : '';
		$atts['href']   = ! empty( $item->url ) ? $item->url : '';

		$atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args, $depth );

		$attributes = '';
		foreach ( $atts as $attr => $value ) {
			if ( ! empty( $value ) ) {
				$value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
				$attributes .= ' ' . $attr . '="' . $value . '"';
			}
		}

		/** This filter is documented in wp-includes/post-template.php */
		$title = apply_filters( 'the_title', $item->title, $item->ID );

		$title = apply_filters( 'nav_menu_item_title', $title, $item, $args, $depth );

		$item_output = $args->before;
		$item_output .= '<a' . $attributes . '>';
		$item_output .= $args->link_before . $title . $args->link_after;
		$item_output .= '</a>';
		$item_output .= $args->after;

		return $item_output;
	}
}