<?php
/**
 * Post author template part.
 *
 * 🚫🚫🚫
 * DO NOT EDIT THIS FILE WHILE INSIDE THE PLUGIN! Changes You make will be lost when a new version
 * of the AMP plugin is released. You need to copy this file out of the plugin and put it into your
 * custom theme, for example. To learn about how to customize these Reader-mode AMP templates, please
 * see: https://amp-wp.org/documentation/how-the-plugin-works/classic-templates/
 * 🚫🚫🚫
 *
 * @package AMP
 */

/**
 * Context.
 *
 * @var AMP_Post_Template $this
 */

$post_author = $this->get( 'post_author' );
?>

<div class="amp-wp-post-meta">
	<div class="amp-wp-post-meta-left">
		<?php if(kanews_get_amp_option('amp-post-author') == true): ?>
			<span class="amp-wp-author">
				<?php 
				$nick = get_the_author_meta('user_nicename', $post_author->ID);
				$avatar = get_user_meta( $post_author->ID, 'basic_user_avatar', true );
				$size = 128;
				if (empty($avatar)) {
					$avatar = get_avatar_url($post_author->ID, array("size" => $size));
				} else {
					if (!empty($avatar[$size])) {
						$avatar = $avatar[$size];
					} else {
						$avatar = $avatar['full'];
					}
				}
				if ( function_exists( 'get_avatar_url' ) ) : ?>
					<div class="amp-wp-author-avatar"><div class="author-avatar"><amp-img src="<?php echo esc_url( $avatar ); ?>" alt="<?php echo esc_attr( $post_author->display_name ); ?>" width="32" height="32" layout="fixed"></amp-img></div></div>
				<?php endif; ?>
				<span class="amp-wp-author author vcard"><?php echo esc_html( $post_author->display_name ); ?></span>	
			</span>
		<?php endif; ?>
		<?php if(kanews_get_amp_option('amp-post-published') == true): ?>
			<?php echo kanews_posted_on(); ?>
		<?php endif; ?>								
	</div>
	<?php if(kanews_get_amp_option('amp-post-updated') == true): ?>
		<div class="amp-wp-post-meta-right">
			<?php kanews_post_updated(); ?>
		</div>
	<?php endif; ?>
</div>