<?php
/**
* Style template.
*
* 🚫🚫🚫
* DO NOT EDIT THIS FILE WHILE INSIDE THE PLUGIN! Changes You make will be lost when a new version
* of the AMP plugin is released. You need to copy this file out of the plugin and put it into your
* custom theme, for example. To learn about how to customize these Reader-mode AMP templates, please
* see: https://amp-wp.org/documentation/how-the-plugin-works/classic-templates/
* 🚫🚫🚫
*
* @package AMP
*/

// phpcs:disable WordPress.Security.EscapeOutput.OutputNotEscaped

/**
* Context.
*
* @var AMP_Post_Template $this
*/
$primary = kanews_get_option('primary-amp-color') != '' ? kanews_get_option('primary-amp-color') : kanews_get_option('primary-color');
$customizer = [
'bg' => (!empty(get_theme_mod('kanews_bg_color'))) ? get_theme_mod('kanews_bg_color') : '#fff',
'primary' => $primary ? $primary : '#ef1d11',
];
global $post;
$cat = (int) Kanews\Helper_Wp::primary_category_id($post->ID);
$cat_color = get_term_meta( $cat, '_category_color', true );
if($cat_color && get_post_meta($post->ID, 'primary_cat_color', true) != 'off')
$customizer['primary'] = '#'.$cat_color;

$content_max_width       = absint( $this->get( 'content_max_width' ) );
$theme_color             = $customizer['bg'];
$text_color              = '#202228';
$muted_text_color        = '#444';
$border_color            = '#eee';
$border_color2            = '#d2d6dc';
$primary_color           = $customizer['primary'];
$link_color              = $customizer['primary'];
$header_background_color = $customizer['primary'];
$header_color            = '#fff';

$alignwide_max = $content_max_width > 0 ? $content_max_width * 2 : 1920;

?>
/* Generic WP styling */

.alignnone,
.aligncenter,
.alignleft,
.alignright,
.alignwide {
margin-top: 1em;
margin-right: auto;
margin-bottom: 1em;
margin-left: auto;
}

.alignright {
float: right;
}

.alignleft {
float: left;
}

.aligncenter {
display: block;
text-align: center;
margin-left: auto;
margin-right: auto;
}

.alignwide {
width: 100%;
}

@media (min-width: calc(840px - 48px)) {
.alignwide {
width: calc(100vw - 48px);
max-width: calc(100vw - 48px);
margin-left: calc(50% - 50vw + 24px);
margin-right: calc(50% - 50vw + 24px);
}
}

@media (min-width: calc(<?php echo sprintf( '%dpx', $alignwide_max ); ?>)) {
.alignwide {
width: calc(<?php echo sprintf( '%dpx', $alignwide_max ); ?> - 48px);
max-width: calc(<?php echo sprintf( '%dpx', $alignwide_max ); ?> - 48px);
margin-left: calc(calc(50% - <?php echo sprintf( '%dpx', $alignwide_max ); ?> / 2) + 24px);
margin-right: calc(calc(50% - <?php echo sprintf( '%dpx', $alignwide_max ); ?> / 2) + 24px);
}
}

.alignfull {
width: 100vw;
max-width: 100vw;
margin-left: calc(50% - 50vw);
margin-right: calc(50% - 50vw);
}

.amp-wp-enforced-sizes {
/** Our sizes fallback is 100vw, and we have a padding on the container; the max-width here prevents the element from overflowing. **/
max-width: 100%;
margin: 0 auto;
}

<?php echo file_get_contents( AMP__DIR__ . '/assets/css/amp-default.css' ); // phpcs:ignore WordPress.WP.AlternativeFunctions ?>

/* Template Styles */

.amp-wp-content,
.amp-wp-title-bar div {
<?php if ( $content_max_width > 0 ) : ?>
margin: 0 auto;
max-width: <?php echo sprintf( '%dpx', $content_max_width ); ?>;
<?php endif; ?>
}

body {
background: <?php echo sanitize_hex_color( $theme_color ); ?>;
color: <?php echo sanitize_hex_color( $text_color ); ?>;
font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", "Open Sans", sans-serif;
font-weight: 300;
font-size:14px;
line-height: 1;
}

a:not(:hover) {
color: <?php echo sanitize_hex_color( $text_color ); ?>;
}

p,
ol,
ul,
figure {
margin: 0 0 1em;
padding: 0;
}

/* Quotes */

blockquote {
font-size: 1.25rem;
border: 1px solid #d2d6dc;
line-height: 1.6;
margin: 0 0 15px;
padding: 30px 60px 30px;
position: relative;
display: block;
}

.kanews-banner {
text-align: center;
position: relative;
z-index: 1;
display: inline-block;
width: 100%;
margin: 15px 0;
}

blockquote p {
margin:0!important;
font-size:22px!important;
line-height:28px!important
}

blockquote p+p,blockquote .uckan-btn {
margin-top:15px!important
}

/* UI Fonts */

.amp-wp-meta,
.wp-caption-text,
.amp-wp-tax-category,
.amp-wp-tax-tag,
.amp-wp-comments-link,
.amp-wp-footer p,
.amp-wp-article-content p,
.amp-wp-article-content ul,
amp-wp-article-content ol,
.back-to-top,
.menu-item a {
font-family: -apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue","Open Sans",Arial,sans-serif;
}

/* Header */

.amp-wp-header {
background-color: <?php echo sanitize_hex_color( $header_background_color ); ?>;
position: fixed;
top: 0;
left: 0;
right: 0;
z-index:999;
}

.amp-wp-header .amp-wp-container, .amp-wp-header .amp-wp-container>div {
color: <?php echo sanitize_hex_color( $header_color ); ?>;
font-size: 1em;
font-weight: 400;
display: flex;
align-items: center;
height: 70px;
position: relative;
text-align:center;
}

.amp-wp-header-left {
text-align:right;
position: absolute !important;
left: 15px;
top: 0;
}

.amp-wp-header-right {
text-align:right;
position: absolute !important;
right: 15px;
top: 0;
}

.amp-wp-container {
max-width: 830px;
margin: 0 auto;
padding-left: 15px;
padding-right: 15px;
}

.amp-logo-link {
font-size: 28px;
color:#fff !important;
text-decoration:none;
}

.amp-logo {
max-height: 60px;
max-width: 225px;
}

.kanews-weather-widget-wrapper {
  display: none
}


/* Article */

.amp-wp-article {
color: <?php echo sanitize_hex_color( $text_color ); ?>;
font-weight: 400;
margin: 1.5em auto;
font-size: 16px;
line-height: 26px;
max-width: 840px;
overflow-wrap: break-word;
word-wrap: break-word;
}

/* Article Header */

.amp-wp-title {
color: <?php echo sanitize_hex_color( $text_color ); ?>;
display: block;
flex: 1 0 100%;
font-weight: 700;
font-size: 38px;
line-height: 1.25;
margin: 0 0 10px;
width: 100%;
}
.amp-wp-title+p {
  font-size: 20px;
    line-height: 1.35;
    color: #525659;
margin-top: 15px;
}

@media (max-width: 992px) {
  .amp-wp-title { 
  font-size: 26px;
  line-height: 1.25
  }
  .amp-wp-title+p {
    font-size: 15px;
  }
}

/* Article Meta */
.amp-wp-post-meta {
-ms-flex-pack: justify!important;
-webkit-box-pack: justify!important;
-webkit-justify-content: space-between!important;
justify-content: space-between!important;
-ms-flex-align: center!important;
-webkit-box-align: center!important;
-webkit-align-items: center!important;
align-items: center!important;
display: -webkit-box;
display: -webkit-flex;
display: -ms-flexbox;
display: flex;
font-size: 14px;
-webkit-flex-wrap: wrap;
-ms-flex-wrap: wrap;
flex-wrap: wrap;
}
.amp-wp-post-meta>* {
-ms-flex-preferred-size: 0;
-webkit-flex-basis: 0;
flex-basis: 0;
-ms-flex-positive: 1;
-webkit-box-flex: 1;
-webkit-flex-grow: 1;
flex-grow: 1;
max-width: 100%;
}
.amp-wp-author {
font-weight: 600;
}
.amp-wp-author-avatar {
position: relative;
float: left;
width: 32px;
height: 32px;
padding: 2px;
border: 1px solid <?php echo $primary_color; ?>;
border-radius: 100%;
top: 5px;
margin-right: 15px;
}
.amp-wp-author-avatar img {
border-radius: 100%;
width: 32px;
height: 32px;
}
.kanews-article-meta-label {
    display: block;
    margin-bottom: -5px;
    font-weight: 600;
}
.posted-on {
display: block;
margin-top: -5px;
color: #525659!important;
}

.amp-wp-article-header {
margin-bottom: 20px
}
/* Featured image */

.amp-wp-article-featured-image {
margin: 0;
}
.amp-wp-article-featured-image amp-img {
margin: 0 auto;
width: 100%;
}
.amp-wp-article-featured-image.wp-caption .wp-caption-text {
margin: 0 18px;
}
@media (min-width: 992px) {
.amp-wp-post-meta-right {
text-align: right
}
}
@media (max-width: 992px) {
.amp-wp-post-meta-right {
flex: 0 0 100%;
margin-top: 15px
}
}

/* Article Content */


.amp-wp-article-content ul,
.amp-wp-article-content ol {
margin-<?php echo is_rtl() ? 'right' : 'left'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>: 1em;
}

.amp-wp-article-content .wp-caption {
max-width: 100%;
}

.amp-wp-article-content amp-img {
margin: 0 auto;
}

.amp-wp-article-content amp-img.alignright,
.amp-wp-article-content .wp-block-cover.alignright {
margin: 0 0 1em 16px;
}

.amp-wp-article-content amp-img.alignleft,
.amp-wp-article-content .wp-block-cover.alignleft {
margin: 0 16px 1em 0;
}

/* Captions */

.wp-caption {
padding: 0;
}

.wp-caption.alignleft {
margin-right: 16px;
}

.wp-caption.alignright {
margin-left: 16px;
}

.wp-caption .wp-caption-text {
border-bottom: 1px solid <?php echo sanitize_hex_color( $border_color ); ?>;
color: <?php echo sanitize_hex_color( $muted_text_color ); ?>;
font-size: .875em;
line-height: 1.5em;
margin: 0;
padding: .66em 10px .75em;
}

/* AMP Media */

.alignwide,
.alignfull {
clear: both;
}

amp-carousel {
background: <?php echo sanitize_hex_color( $border_color ); ?>;
margin: 0 -16px 1.5em;
}
amp-iframe,
amp-youtube,
amp-instagram,
amp-vine {
background: <?php echo sanitize_hex_color( $border_color ); ?>;
margin: 0 -16px 1.5em;
}

.amp-wp-article-content amp-carousel amp-img {
border: none;
}

amp-carousel > amp-img > img {
object-fit: contain;
}

.amp-wp-iframe-placeholder {
background: <?php echo sanitize_hex_color( $border_color ); ?> url( <?php echo esc_url( $this->get( 'placeholder_image_url' ) ); ?> ) no-repeat center 40%;
background-size: 48px 48px;
min-height: 48px;
}

.amp-wp-article-content h1 {
font-size: 32px;
margin: 0 0 1em;
line-height: 1.4;
}

.amp-wp-article-content h2 {
font-size: 26px;
margin: 0 0 1em;
line-height: 1.4;
}

.amp-wp-article-content h3 {
font-size: 22px;
margin: 0 0 1em;
line-height: 1.4;
}

.amp-wp-article-content h4 {
font-size: 18px;
margin: 0 0 1em;
line-height: 1.4;
}

.amp-wp-article-content h5 {
font-size: 14px;
margin: 0 0 1em;
line-height: 1.4;
}

/* Article Footer Meta */

.amp-wp-article-footer .amp-wp-meta {
display: block;
margin: 0 0 1em
}

.amp-wp-article-footer .amp-wp-meta a, .back-to-top {
font-size: 12px!important;
color:#2d2d2d;
line-height: 35px;
height: 35px;
text-decoration:none;
display: inline-block;
letter-spacing: .05em;
text-transform: uppercase;
padding: 0 10px;
border-radius: 3px;
border: 1px #d2d6dc solid;
-webkit-transition: all .3s ease;
transition: all .3s ease;
}
.amp-wp-article-footer .amp-wp-meta a:hover, .back-to-top:hover, .view-full-version {
color: <?php echo $primary_color; ?>;
border-color: <?php echo $primary_color; ?>;
}
.amp-wp-article-footer .amp-wp-meta:after {
content: none;
}

.amp-wp-comments-link a {
padding: 0 15px !important;
background-color: <?php echo $primary_color; ?>;
color: #fff !important;
border: 0 !important;
text-align:center;
}

/* AMP Footer */

.amp-wp-footer {
border-top: 1px solid <?php echo sanitize_hex_color( $border_color ); ?>;
width: 100%;

}

.amp-wp-footer>div {
margin: 0 auto;
width: 100%;
padding: 2em 0;
position: relative;
display: -webkit-box;
display: -ms-flexbox;
display: flex;
-webkit-box-align:center;
-ms-flex-align:center;
align-items:center;
-webkit-box-pack:justify;
-ms-flex-pack:justify;
justify-content:space-between;
}

.amp-wp-footer h2 {
font-size: 1.75em;
font-weight: 600;
line-height: 1.375em;
margin: 0;
}

.amp-wp-footer p {
color: <?php echo sanitize_hex_color( $muted_text_color ); ?>;
line-height: 1.5em;
margin: 0 85px 0 0;
}

.amp-wp-footer a {
text-decoration: none;
font-weight: 400;
}


.amp-wp-header svg {
fill:#fff;
vertical-align:middle;
cursor:pointer;
width: 24px;
height:20px;
}
.hamburger {
margin-left: 0 !important;
}
.hamburger {
border-right: 1px solid rgba(255,255,255,.25) !important;
margin-right: 15px;
padding-right: 15px;
}
.amp-wp-header button {
background:transparent;
border:0;
margin-left: 10px;
}
#kanews-wp-amp-form {
position: absolute;
z-index: -1;
margin: 0;
top: 100%;
right: 15px;
width: 325px;
visibility: hidden;
opacity: 0;
background:#333;
padding: 1em;
transition: all .3s ease;
}
#kanews-wp-amp-form.active {
opacity: 1;
visibility: visible;
z-index:1;
}
#kanews-wp-amp-form input {
width: 100%;
height: 40px;
line-height: 40px;
position:relative;
border: 0;
display: block;
background:#fff;
padding: 15px;
margin: 0;
}
.amp-wp-search-submit {
position: absolute;
margin:0 !important;
padding:0 !important;
top:24px;
right: 25px;
}
.amp-wp-search-submit svg>path:first-child {
fill:#000
}
.amp-wp-search-btn {
background: rgba(255,255,255,.2) !important;
width: 35px;
height: 35px;
line-height: 35px;
font-size: 12px;
text-align: center;
border-radius: 100%;
}
amp-sidebar {
background: #fff;
width: 80vw;
max-width: 325px;
}

#amp-menu {
width: 300px;
color:#222;
background-color: #fff;
}
#amp-menu .menu-item a {
display: block;
color: #222;
border-bottom: 1px solid <?php echo $border_color; ?>;
text-decoration: none !important;
padding: 1em 2em;
font-size: 16px;
font-weight: 600;
width: 100%;
transition: all .3s ease;
}
#amp-menu .menu-item a:hover {
background: <?php echo $primary_color; ?>;
color: #fff;
border-color: <?php echo $primary_color; ?>
}
amp-accordion h6 {
background: transparent !important;
border:0 !important;
padding: 0 !important;
}
amp-accordion h6>svg {
position: absolute;
width: 12px;
height: 12px;
z-index: 2;
right: 20px;
top: 20px;
}
#amp-menu .menu-item a {
font-size: 14px;
font-weight: 400
}
.search-icon {
width: 20px !important;
height: 16px !important;
}
#amp-wp-search-btn.active svg.search-icon, #amp-wp-search-btn svg.close-icon {
display: none;
}
#amp-wp-search-btn.active svg.close-icon {
display: block
}
amp-social-share {
border-radius: 100%;
margin-right: 0;
background-size:18px!important
}
.amp-wp-article-social-share-default amp-social-share{
-ms-flex-preferred-size: 0;
display: block;
padding: 8px 10px;
flex-basis: 0;
border-radius: 4px;
-webkit-box-flex: 1;
-ms-flex-positive: 1;
flex-grow: 1;
list-style: none!important;
margin: -1em 5px 1em;
text-align: center;
}
.amp-wp-article-social-share-default {
display: -webkit-box!important;
margin-left: -5px;
margin-right: -5px;
display: -ms-flexbox!important;
display: flex!important;
}
.amp-wp-article-social-share-style-3 amp-social-share{
border-radius: 4px
}
.amp-wp-post-meta {
display: flex;
align-items:center;
width: 100%
}
amp-img.amp-wp-enforced-sizes[layout="intrinsic"] > img {
object-fit:cover
}

code {
padding:3px 10px;
font-size:90%;
color:#c7254e;
background-color:#eee;
border-radius:4px
}
code,kbd,pre,samp {
font-family:Menlo,Monaco,Consolas,"Courier New",monospace
}
pre code {
padding:0;
font-size:inherit;
color:inherit;
white-space:pre-wrap;
background-color:transparent;
border-radius:0
}
pre {
display:block;
overflow:auto;
padding:10px;
margin:0 0 20px;
font-size:13px;
line-height:1.42857143;
color:#333;
word-break:break-all;
-ms-word-wrap: break-word;
word-wrap: break-word;
background-color:#f5f5f5;
border:1px solid #ccc;
border-radius:4px
}
table {
border-width:1px;
width:100%;
margin:20px 0;
border-spacing:0;
overflow-x:auto;
display:inline-block;
border-color:#EAEAEA;
border-collapse:collapse;
background-color:#fff
}
table tbody {
display:inline-table;
width:100%
}
table th {
border-width:1px;
padding:1em;
border-style:inset;
vertical-align:middle;
font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue","Open Sans",sans-serif;
font-weight:600;
text-align:left;
float:none;
border-color:#EAEAEA;
background-color:#fff
}
table th[scope=row],table tr th {
background-color:#F5F5F5
}
table td {
border-width:1px;
padding:1em;
border-style:inset;
vertical-align:middle;
font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue","Open Sans",sans-serif;
border-color:#EAEAEA
}
.dark-mode table th[scope=row],.dark-mode table tr th {
background:#313131
}
.dark-mode table td,.dark-mode table th[scope=row],.dark-mode table tr th {
border-color:#5e5e5e
}
.wp-block-table td,.wp-block-table th {
border-color:#EAEAEA;
word-break:unset!important
}
@media screen and (max-width: 750px) {
table th,table td {
font-size:12px!important;
padding:6px!important
}
}
@media screen and (max-width: 550px) {
table th,table td {
font-size:10px!important;
padding:4px!important
}
}
iframe,object,embed {
max-width:100%
}
.wp-block-cover{
margin: 20px 0;
}
.wp-block-code {
margin: 20px 0;
overflow: auto;
}
.amp-wp-article-content h1, .amp-wp-article-content h2, .amp-wp-article-content h3, .amp-wp-article-content h4, .amp-wp-article-content h5, .amp-wp-article-content h6 {
margin-bottom: 20px
}

.kanews-private-post {
text-align: center;
position: relative;
margin: 30px 0;
border-radius: 20px;
background: #f8f8f8;
}
.kanews-private-post:before {
content: '';
position: absolute;
top: -110px;
background: -webkit-gradient(linear,left top, left bottom,from(rgba(255,255,255,0)),to(#fff));
background: -webkit-linear-gradient(top,rgba(255,255,255,0),#fff);
background: linear-gradient(to bottom,rgba(255,255,255,0),#fff);
height: 100px;
left: 0;
right: 0;
}
.kanews-private-post-inner {
max-width: 425px;
margin: 0 auto;
position: relative;
z-index: 2;
padding: 50px 0;
}
.kanews-private-post-inner .kanews-banner {
display: none
}
.kanews-btn-group {
display: -webkit-box;
display: -webkit-flex;
display: -ms-flexbox;
display: flex;
-webkit-flex-wrap: wrap;
-ms-flex-wrap: wrap;
flex-wrap: wrap;
}
.kanews-btn-group>* {
margin: 0 5px !important
}

.amp-wp-article-assets {
-ms-flex-pack: justify!important;
-webkit-box-pack: justify!important;
-webkit-justify-content: space-between!important;
justify-content: space-between!important;
display: -webkit-box;
display: -webkit-flex;
display: -ms-flexbox;
display: flex;
margin-bottom: 15px;
-webkit-flex-wrap: wrap;
-ms-flex-wrap: wrap;
flex-wrap: wrap;
-ms-flex-align: center!important;
-webkit-box-align: center!important;
-webkit-align-items: center!important;
align-items: center!important;
border-bottom: 1px solid <?php echo $border_color; ?>;
padding: 15px 0;
}

.google-news {
display: -webkit-box;
display: -webkit-flex;
display: -ms-flexbox;
display: flex;
-webkit-box-align: center;
-webkit-align-items: center;
-ms-flex-align: center;
align-items: center;
}
.google-news-link {
display: inline-block;
vertical-align: baseline;
height: 38px;
width: 140px;
margin: 0 5px;
border: 1px solid <?php echo $border_color2; ?>;
border-radius: 3px;
background-size: 100%;
}

.google-news span {
margin-right: 8px;
font-weight: 500;
color: #1d1f26;
}

.amp-wp-article .kanews-btn {
margin-top: 0;
}


.kanews-btn {
padding: 0 25px;
height: 54px;
line-height: 54px;
cursor: pointer;
margin: 15px 0;
background: <?php echo $primary_color; ?>;
border-radius: 3px;
display: inline-block;
-webkit-transition: all .3s ease;
transition: all .3s ease;
color: #fff;
text-decoration: none;
text-align: center;
border: 1px solid transparent;
}

.kanews-btn-sm {
height: 40px;
line-height: 40px;
padding: 0 15px;
}

.kanews-btn-block {
display: block;
}

.kanews-response {
padding: 15px 20px;
border-radius: 3px;
color: #fff;
line-height: 20px;
background: #202228;
}

.amp-wp-article .kanews-response {
margin-bottom: 15px;
}

.kanews-section-heading {
margin-bottom: 15px;
border: 0;
border-bottom: 2px solid <?php echo $border_color; ?>;
}

.kanews-section-heading .kanews-section-headline {
padding: 0 0 15px;
border: 0;
position: relative;
margin-bottom: 0;
}

.kanews-section-heading .kanews-section-headline>span {
font-weight: 600;
font-size: 16px;
}

.kanews-section-heading .kanews-section-headline:after {
content: "";
width: 40px;
height: 2px;
position: absolute;
background: <?php echo $primary_color; ?>;
bottom: -2px;
left: 0;
}

.kanews-text-dropcap {
display: block;
float: left;
font-size: 32px;
width: 50px;
height: 50px;
line-height: 50px;
margin: 0 10px 0 0;
text-align: center;
}

.kanews-label {
font-size: 11px!important;
line-height: 35px;
height: 35px;
cursor: pointer;
display: inline-block;
letter-spacing: .05em;
text-transform: uppercase;
padding: 0 10px;
border-radius: 3px;
border: 1px <?php echo $border_color2; ?> solid;
-webkit-transition: all .3s ease;
transition: all .3s ease;
}
.kanews-posts-shortcode .kanews-post-item {
border: 0;
box-shadow: none;
padding-right: 0;
padding-left: 0;
background: transparent; }

.kanews-posts-shortcode .kanews-post-content {
padding-left: 0;
padding-right: 0; }

.kanews-posts-shortcode .kanews-section-heading .kanews-section-headline {
padding-left: 0px; }

.kanews-posts-shortcode .kanews-section-heading span:before {
content: none !important; }

.kanews-posts-shortcode .kanews-section-heading span:after {
content: "";
position: absolute;
left: 0;
bottom: 0;
height: 2px;
width: 40px; }

.kanews-posts-shortcode .kanews-section-heading {
margin: 0 0 15px !important; }

.kanews-post-shortcode {
position: relative; }
.kanews-post-shortcode > .kanews-category {
left: 0px;
right: -1px;
top: -1px;
bottom: -1px; }
.kanews-post-shortcode .kanews-post-item {
display: inline-block;
margin-bottom: 0px;
width: 100%;
box-shadow: none !important;
border: 2px solid <?php echo $primary_color; ?> }
.kanews-post-shortcode .kanews-post-item .kanews-post-headline {
font-size: 18px; }
.kanews-post-shortcode .kanews-category {
display: inline-block; }
@media (min-width: 768px) {
.kanews-post-shortcode .kanews-post-content {
padding: 20px; }
.kanews-post-shortcode .kanews-post-thumb {
float: left;
margin-right: 30px; }
.kanews-post-shortcode .kanews-post-thumb img {
width: 215px; } }


.kanews-post-href {
position: absolute;
left: 0;
right: 0;
bottom: 0;
top: 0;
z-index: 5;
cursor: pointer;
}

@media (min-width: 768px) {
.kanews-post-shortcode .kanews-post-thumb {
float: left;
margin-right: 30px;
}
}

kanews-post-item {
background: #fff;
-webkit-box-shadow: 0 0 0 1px #eee;
box-shadow: 0 0 0 1px #eee;
margin-bottom: 15px;
}
.mb-1 {
margin-bottom: 1em!important;
}
.kanews-post-thumb {
z-index: 2;
overflow: hidden;
}

.kanews-post-shortcode .kanews-post-thumb img { 
height: 200px
}

@media (min-width: 768px) {
.kanews-post-shortcode .kanews-post-thumb img {
width: 215px;
height: 138px;
}
}

.kanews-post-thumb img {
width: 100%;
-webkit-transition: all .3s ease;
transition: all .3s ease;
}

@media (min-width: 768px) {
.kanews-post-shortcode .kanews-post-content {
padding: 20px;
}
}
.kanews-post-shortcode .kanews-post-item .kanews-post-headline {
font-size: 20px;
line-height: 1.3
}
.kanews-post-shortcode .kanews-post-item .kanews-label {
margin-bottom: 15px
}

.collapse-btn {
background: transparent;
border: 0;
padding: 0;
}
.collapse-btn h3 {
margin: 0
}
.kanews-box-shortcode {
display: none;
}
.col-6,.col-md,.col-12 {
position: relative;
width: 100%;
padding-right: 7.5px;
padding-left: 7.5px;
}
.mb-2 {
margin-bottom: 2em!important;
}
.row {
display: -webkit-box;
display: -webkit-flex;
display: -ms-flexbox;
display: flex;
-webkit-flex-wrap: wrap;
-ms-flex-wrap: wrap;
flex-wrap: wrap;
margin-right: -7.5px;
margin-left: -7.5px;
}
.col-6 {
-ms-flex: 0 0 calc(50% - 15px);
-webkit-box-flex: 0;
-webkit-flex: 0 0 calc(50% - 15px);
flex: 0 0 calc(50% - 15px);
max-width: calc(50% - 15px);
}
.col-12 {
-ms-flex: 0 0 100%;
-webkit-box-flex: 0;
-webkit-flex: 0 0 100%;
flex: 0 0 100%;
max-width: 100%;
}
@media (min-width: 768px) {
.col-md {
-ms-flex-preferred-size: 0;
-webkit-flex-basis: 0;
flex-basis: 0;
-ms-flex-positive: 1;
-webkit-box-flex: 1;
-webkit-flex-grow: 1;
flex-grow: 1;
max-width: 100%;
}
.col-md-6 {
-ms-flex: 0 0 calc(50% - 15px);
-webkit-box-flex: 0;
-webkit-flex: 0 0 calc(50% - 15px);
flex: 0 0 calc(50% - 15px);
max-width: calc(50% - 15px);
}
.col-md-4 {
-ms-flex: 0 0 calc(33.3333333% - 15px);
-webkit-box-flex: 0;
-webkit-flex: 0 0 calc(33.3333333% - 15px);
flex: 0 0 calc(33.3333333% - 15px);
max-width: calc(33.3333333% - 15px);
}
}




.kanews-post-item, .kanews-post-thumb {
position: relative
}
.kanews-post-item {
background: #fff;
-webkit-box-shadow: 0 0 0 1px #eee;
box-shadow: 0 0 0 1px #eee;
margin-bottom: 15px;
}
.kanews-post-small-item {
padding: 15px;
display: flex;
flex-wrap: wrap;
margin: 5px 0;
border: 0;
}
.kanews-posts-shortcode .kanews-post-item {
border: 0;
-webkit-box-shadow: none;
box-shadow: none;
padding-right: 0;
padding-left: 0;
background: 0 0;
}
.kanews-post-small-item .kanews-post-thumb {
width: 70px;
height: 70px;
-webkit-box-flex: 0;
-webkit-flex: 0 0 70px;
-ms-flex: 0 0 70px;
flex: 0 0 70px;
float: left;
margin-right: 15px;
}
.kanews-post-thumb {
z-index: 2;
overflow: hidden;
}
.kanews-post-content {
padding: 15px;
z-index: 3;
}
.kanews-posts-shortcode .kanews-post-content {
padding-left: 0;
padding-right: 0;
}
.kanews-post-small-item .kanews-post-content {
padding: 0!important;
}
.kanews-posts-shortcode .kanews-post-headline {
font-size: 15px;
}
.kanews-post-headline:first-child {
margin-top: 0;
}
.kanews-post-headline:last-child {
margin-bottom: 0;
}
.embed-container {
position: relative;
padding-bottom: 56.25%;
overflow: hidden;
max-width: 100%;
height: auto;
}
.embed-container embed, .embed-container iframe, .embed-container object {
position: absolute;
top: 0;
left: 0;
width: 100%;
height: 100%;
}
.kanews-post-headline {
font-size: 15px;
line-height: 22px;
text-decoration: none;
color: <?php echo $text_color; ?>;
margin: 0 !important;
font-weight: 600;
}
.kanews-post-small-item .kanews-post-thumb amg-img {
width: 70px;
-webkit-box-flex: 0;
-webkit-flex: 0 0 70px;
-ms-flex: 0 0 70px;
flex: 0 0 70px;
height: 70px;
-webkit-transform: scale(1)!important;
-ms-transform: scale(1)!important;
transform: scale(1)!important;
}
.truncate {
white-space: normal;
display: block;
display: -webkit-box;
-webkit-box-orient: vertical;
overflow: hidden;
text-overflow: ellipsis;
}
.truncate-3 {
-webkit-line-clamp: 3;
}
.truncate-2 {
-webkit-line-clamp: 2;
}
#toc_container {
border: 1px solid <?php echo sanitize_hex_color( $border_color ); ?>;
margin: 0 0 30px;
}
#toc_container a {
text-transform: none;
text-decoration: none;
}
#toc_container .toc_title {
padding: 15px;
display: flex;
margin: 0;
justify-content: space-between;
flex-wrap: wrap;
}
#toc_container ul {
padding: 0;
margin: 0;
}
#toc_container ul li {
list-style: none;
margin: 0;
}
#toc_container ul li span {
min-width: 25px;
height: 25px;
padding: 0 5px;
display: inline-block;
border: 1px solid <?php echo sanitize_hex_color( $border_color ); ?>;
line-height: 24px;
text-align: center;
border-radius: 25px;
font-size: 12px;
margin-right: 10px;
}
#toc_container ul li a {
display: block;
padding: 10px 15px;
border-top: 1px solid <?php echo sanitize_hex_color( $border_color ); ?>;
}
.col-auto {
-ms-flex: 0 0 auto;
flex: 0 0 auto;
width: auto;
max-width: 100%;
}
.col {
-ms-flex-preferred-size: 0;
flex-basis: 0;
-ms-flex-positive: 1;
flex-grow: 1;
max-width: 100%;
}
.kanews-inline-card {
display: flex;
margin: 1.5rem 0;
align-items: stretch;
overflow: auto;
flex-wrap: wrap;
overflow: hidden; }
.kanews-inline-card-item {
display: flex !important;
align-items: center;
padding: 15px !important;
flex: 1;
min-width: 200px;
border-right: 1px solid <?php echo sanitize_hex_color( $border_color ); ?>;
border-bottom: 1px solid <?php echo sanitize_hex_color( $border_color ); ?>;
margin-bottom: -1px;
margin-right: -2px; }
.kanews-inline-card-item:last-child {
border: 0; }
.kanews-inline-card-title {
font-weight: 500;
font-size: 12px; }
.kanews-inline-card-content {
margin-top: 5px;
font-size: 18px; }
.kanews-inline-card-icon {
margin-right: 15px;
flex: 0 0 25px;
position: relative;
width: 25px;
height: 25px; }
.kanews-inline-card-icon amp-img {
width: 18px;
height: 18px;
position: absolute;
border-radius: 50%;
background-color: #f0f3fa; }
.kanews-inline-card-icon amp-img:first-child {
bottom: 0;
right: 0; }
.kanews-inline-card-icon amp-img:last-child {
top: -1px;
left: -1px;
border: 1px solid #fff; }
.kanews-inline-card-icon amp-img:first-child:last-child {
border: 0;
top: 2px;
width: 22px;
height: 22px; }
.kanews-inline-card-icon i {
vertical-align: text-top; }
.kanews-inline-card-icon.border-danger .icon-arrow {
transform: rotate(180deg);
display: inline-block; }

.amp-wp-navigation .menu-item {
display: block
}
.amp-wp-navigation .menu-item-has-children>a {
position: relative;
z-index: -1
}
.amp-wp-navigation .menu-item-has-children:after {
content: "▾";
position: absolute;
padding: 10px 25px;
right: 0;
font-size: 18px;
top: 0;
z-index: 10000;
line-height: 1;
}
/**
* Simple HTML/CSS switch
*/
.switch {
display: inline-block;
position: relative;
width: 60px;
height: 35px;
border-radius: 20px;
background: rgba(255,255,255,.2);
transition: background 0.28s cubic-bezier(0.4, 0, 0.2, 1);
vertical-align: middle;
cursor: pointer;
}
.switch::before {
content: '';
position: absolute;
top: 6px;
left: 6px;
width: 24px;
height: 24px;
background: #fafafa;
border-radius: 50%;
transition: left 0.28s cubic-bezier(0.4, 0, 0.2, 1), background 0.28s cubic-bezier(0.4, 0, 0.2, 1), box-shadow 0.28s cubic-bezier(0.4, 0, 0.2, 1);
}
.switch:active::before {
box-shadow: 0 2px 8px rgba(0,0,0,0.28), 0 0 0 20px rgba(128,128,128,0.1);
}

#dark-mode-checkbox:checked  ~ .amp-wrapper .switch {
background: #444;
}
#dark-mode-checkbox:checked  ~ .amp-wrapper .switch::before {
left: 30px;
background: #c1c1c1;
}
#dark-mode-checkbox:checked  ~ .amp-wrapper .switch:active::before {
box-shadow: 0 2px 8px rgba(0,0,0,0.28), 0 0 0 20px rgba(0,150,136,0.2);
}

#dark-mode-checkbox:checked ~ .amp-wrapper
{
background:#1f1f1f;
color: rgba(255,255,255,.9)
}
#dark-mode-checkbox:checked ~ .amp-wrapper amp-social-share,
#dark-mode-checkbox:checked ~ .amp-wrapper .amp-wp-header,
#dark-mode-checkbox:checked ~ .amp-wrapper .kanews-response,
#dark-mode-checkbox:checked ~ .amp-wrapper .kanews-btn,
#dark-mode-checkbox:checked ~ .amp-wrapper .kanews-post-item

{
background-color:#333335 !important
}
#dark-mode-checkbox:checked ~ .amp-wrapper .amp-wp-title,
#dark-mode-checkbox:checked ~ .amp-wrapper .kanews-post-headline,
#dark-mode-checkbox:checked ~ .amp-wrapper .amp-wp-footer a,
#dark-mode-checkbox:checked ~ .amp-wrapper .amp-wp-comments-link a,
#dark-mode-checkbox:checked ~ .amp-wrapper .amp-wp-article

{
color: rgba(255,255,255,.75) !important
}

#dark-mode-checkbox:checked ~ .amp-wrapper .kanews-post-item 
{
-webkit-box-shadow: 0 0 0 1px #333335;
box-shadow: 0 0 0 1px #333335;
}
#dark-mode-checkbox:checked ~ .amp-wrapper .amp-wp-article-footer .amp-wp-meta a,
#dark-mode-checkbox:checked ~ .amp-wrapper .amp-wp-article-assets,
#dark-mode-checkbox:checked ~ .amp-wrapper .kanews-section-heading,
#dark-mode-checkbox:checked ~ .amp-wrapper .kanews-label,
#dark-mode-checkbox:checked ~ .amp-wrapper .amp-wp-footer,
#dark-mode-checkbox:checked ~ .amp-wrapper .amp-wp-footer a,
#dark-mode-checkbox:checked ~ .amp-wrapper .amp-wp-comments-link a,
#dark-mode-checkbox:checked ~ .amp-wrapper blockquote,
#dark-mode-checkbox:checked ~ .amp-wrapper .google-news-link
{
border-color: rgba(255,255,255,.1) !important
}
.size-post-thumbnail {
width: 100%
}