// Manşet önizleme fonksiyonları
(function($) {
  'use strict';

  function updateHeadlinePreview() {
    var style = $('.csf-field-image_select input[name="kanews_options[headline-style]"]:checked').val();
    var titlePosition = $('.csf-field-select select[name="kanews_options[headline-title-position]"]').val();
    var titleSize = $('.csf-field-slider input[name="kanews_options[headline-title-size]"]').val();
    var showMeta = $('.csf-field-switcher input[name="kanews_options[headline-meta]"]').is(':checked');
    
    var $preview = $('.kan-headline-preview-container');
    var $content = $('.kanews-slide-content');
    var $meta = $('.kan-headline-preview-meta');
    
    // Stil güncelleme
    $preview.removeClass('style-1 style-2 style-3 style-4').addClass('style-' + style);
    
    // Pozisyon güncelleme
    $content.addClass(titlePosition);
    
    // Başlık boyutu güncelleme
    $('.kanews-slide-headline').css('font-size', titleSize + 'px');
    
    // Tipografi ayarlarını güncelle
    var mansetTitleTypography = getMansetTitleTypography();
    $('.kanews-slide-headline').css({
      'font-size': mansetTitleTypography.font_size,
      'font-weight': mansetTitleTypography.font_weight,
      'line-height': mansetTitleTypography.line_height,
      'letter-spacing': mansetTitleTypography.letter_spacing,
      'text-transform': mansetTitleTypography.text_transform
    });

    // Meta gösterimi
    $meta.toggle(showMeta);

    // Manşet etiketi kontrolü
    var mansetTagTitle = $('[name="kanews_post_options[manset_tag_title]"]').val();
    if (mansetTagTitle) {
      $('.kanews-manset-tag').text(mansetTagTitle).show();
    } else {
      $('.kanews-manset-tag').hide();
    }
  }

  function getMansetTitleTypography() {
    return {
      font_size: $('[name="kanews_post_options[manset_title_typography][font-size]"]').val() + 'px' || '',
      font_weight: $('[name="kanews_post_options[manset_title_typography][font-weight]"]').val() || '',
      line_height: $('[name="kanews_post_options[manset_title_typography][line-height]"]').val() || '',
      letter_spacing: $('[name="kanews_post_options[manset_title_typography][letter-spacing]"]').val() + 'px' || '',
      text_transform: $('[name="kanews_post_options[manset_title_typography][text-transform]"]').val() || ''
    };
  }

  // Ayarlar değiştiğinde önizlemeyi güncelle
  $(document).on('change', '.csf-field input, .csf-field select', function() {
    updateHeadlinePreview();
  });

  // Sayfa yüklendiğinde önizlemeyi başlat
  $(document).ready(function() {
    updateHeadlinePreview();
  });

  // Initialize preview when document is ready
  $(document).ready(function() {
    initMansetPreview();
  });

  function initMansetPreview() {
    const preview = $('#kanews-manset-preview');
    if (!preview.length) return;

    // Watch for changes in relevant fields
    const fields = {
      title: $('[name="kanews_post_options[kanews_manset_title]"]'),
      excerpt: $('[name="kanews_post_options[kanews_manset_excerpt]"]'),
      tagTitle: $('[name="kanews_post_options[manset_tag_title]"]'),
      tagPosition: $('[name="kanews_post_options[manset_tag]"]'),
      tagStyle: $('[name="kanews_post_options[manset_tag_style]"]'),
      tagBg: $('[name="kanews_post_options[manset_tag_bg]"]'),
      tagColor: $('[name="kanews_post_options[manset_tag_color]"]'),
      detailPosition: $('[name="kanews_post_options[manset_detail_position]"]'),
      overlayColor: $('[name="kanews_post_options[manset_color]"]'),
      titleColor: $('[name="kanews_post_options[manset_title_color]"]'),
      descColor: $('[name="kanews_post_options[manset_desc_color]"]'),
      desktopImage: $('[name="kanews_post_options[manset_desktop][url]"]'),
      mobileImage: $('[name="kanews_post_options[manset_mobile][url]"]'),
      hideContent: $('[name="kanews_post_options[post_detail]"]')
    };

    // Get post title from WordPress editor
    const getPostTitle = () => {
      const gutenbergTitle = wp.data?.select('core/editor')?.getEditedPostAttribute('title');
      if (gutenbergTitle) return gutenbergTitle;
      return $('#title').val() || '';
    };

    // Get featured image URL
    const getFeaturedImageUrl = () => {
      // Try Gutenberg
      const featuredImage = wp.data?.select('core/editor')?.getEditedPostAttribute('featured_media');
      if (featuredImage) {
        const mediaObj = wp.data.select('core').getMedia(featuredImage);
        return mediaObj?.source_url;
      }
      // Try classic editor
      return $('#set-post-thumbnail img').attr('src') || '';
    };

    // Update preview when fields change
    Object.values(fields).forEach(field => {
      field.on('change keyup', updatePreview);
    });

    // Watch media uploads
    $('.csf-field-media').on('csf.change', updatePreview);

    // Watch featured image changes
if (wp.data && wp.data.subscribe) {
  wp.data.subscribe(() => {
    // Check if the editor store exists before accessing it
    const editor = wp.data.select('core/editor');
    if (editor) {
      const featuredImageId = editor.getEditedPostAttribute('featured_media');
      if (featuredImageId !== lastFeaturedImageId) {
        lastFeaturedImageId = featuredImageId;
        updatePreview();
      }
    }
  });
}
    $('#postimagediv').on('click', '#remove-post-thumbnail', updatePreview);
    $('#postimagediv').on('DOMSubtreeModified', '#set-post-thumbnail img', updatePreview);

    // Watch post title changes
    $('#title').on('change keyup', updatePreview);
    if (wp.data && wp.data.subscribe) {
      wp.data.subscribe(() => {
        const newTitle = wp.data.select('core/editor')?.getEditedPostAttribute('title');
        if (newTitle !== lastTitle) {
          lastTitle = newTitle;
          updatePreview();
        }
      });
    }

    let lastTitle = getPostTitle();
    let lastFeaturedImageId = wp.data?.select('core/editor')?.getEditedPostAttribute('featured_media');

    function updatePreview() {
      const previewWrapper = preview.find('.kanews-slide');
      const previewTag = preview.find('.kanews-manset-tag');
      const previewContent = preview.find('.kanews-slide-content');
      const previewOverlay = preview.find('.kanews-slide-overlay');
      const previewImage = preview.find('.kanews-slide-thumb');
      
      // Update text content
      const mansetTitle = fields.title.val();
      const postTitle = getPostTitle();
      const cleanTitle = (mansetTitle || postTitle).replace(/&quot;/g, '"').replace(/&#039;/g, "'");
      preview.find('.kanews-slide-headline').text(cleanTitle);
      preview.find('.kanews-slide-spot').text(fields.excerpt.val());
      
      // Update image - use manset image if available, otherwise use featured image
      const desktopImageUrl = fields.desktopImage.val();
      const mobileImageUrl = fields.mobileImage.val();
      const featuredImageUrl = getFeaturedImageUrl();
      
      if (window.innerWidth <= 768 && mobileImageUrl) {
        previewImage.attr('src', mobileImageUrl);
      } else if (desktopImageUrl) {
        previewImage.attr('src', desktopImageUrl);
      } else if (featuredImageUrl) {
        previewImage.attr('src', featuredImageUrl);
      }
      
      // Toggle content visibility based on post_detail checkbox
      const hideContentCheckbox = fields.hideContent;
      const hideContent = hideContentCheckbox.val() === '1';
      
      if (hideContent) {
        previewContent.css('display', 'none');
        previewOverlay.css('display', 'none');
      } else {
        previewContent.css('display', '');
        previewOverlay.css('display', '');
      }
      
      // Update tag
      const mansetTagTitle = fields.tagTitle.val();
      if (mansetTagTitle) {
        previewTag.html("<span></span><span></span><span></span>" + mansetTagTitle);
        previewTag.css({
          'background-color': fields.tagBg.val(),
          'color': fields.tagColor.val()
        }).show();
      } else {
        previewTag.hide();
      }

      // Update tag position and style with classes
      previewTag
        .removeClass('kanews-manset-tag-position-top-left kanews-manset-tag-position-top-right kanews-manset-tag-position-bottom-left kanews-manset-tag-position-bottom-right')
        .removeClass('kanews-manset-tag-style-1 kanews-manset-tag-style-2 kanews-manset-tag-style-3')
        .addClass('kanews-manset-tag-position-' + fields.tagPosition.val())
        .addClass('kanews-manset-tag-style-' + fields.tagStyle.val());

      // Update content position with classes
      previewWrapper
        .removeClass('kanews-mansetd-bottom kanews-mansetd-left kanews-mansetd-right')
        .addClass('kanews-mansetd-' + fields.detailPosition.val());

      // Update overlay position with classes
      previewOverlay
        .removeClass('overlay-bottom overlay-left overlay-right')
        .addClass('overlay-' + fields.detailPosition.val())
        .css('--gradient-start-color', fields.overlayColor.val());

      // Update colors
      preview.find('.kanews-slide-headline').css('color', fields.titleColor.val());
      preview.find('.kanews-slide-spot').css('color', fields.descColor.val());

      // Başlık için inline düzenleme
      preview.find('.kanews-slide-headline').on('click', function() {
        const currentText = $(this).text();
        const currentClasses = $(this).attr('class');
        const $editable = $('<div contenteditable="true" class="inline-edit"></div>').text(currentText);
        $(this).replaceWith($editable);
        $editable.focus();

        $editable.on('blur', function() {
          const newText = $(this).text();
          const $headline = $('<div>').addClass(currentClasses).text(newText);
          $(this).replaceWith($headline);
          fields.title.val(newText);
          updatePreview();
        });
      });

      // Açıklama için inline düzenleme
      preview.find('.kanews-slide-spot').on('click', function() {
        const currentText = $(this).text();
        const currentClasses = $(this).attr('class');
        const $editable = $('<div contenteditable="true" class="inline-edit"></div>').text(currentText);
        $(this).replaceWith($editable);
        $editable.focus();

        $editable.on('blur', function() {
          const newText = $(this).text();
          const $spot = $('<div>').addClass(currentClasses).text(newText);
          $(this).replaceWith($spot);
          fields.excerpt.val(newText);
          updatePreview();
        });
      });

      // Etiket için inline düzenleme
      previewTag.on('click', function() {
        const currentText = $(this).text();
        const currentClasses = $(this).attr('class');
        const $editable = $('<div contenteditable="true" class="inline-edit"></div>').text(currentText);
        $(this).replaceWith($editable);
        $editable.focus();

        $editable.on('blur', function() {
          const newText = $(this).text();
          const $tag = $('<div>').addClass(currentClasses).html("<span></span><span></span><span></span>" + newText);
          $(this).replaceWith($tag);
          fields.tagTitle.val(newText);
          updatePreview();
        });
      });

      // Açıklama için tipografi ayarlarını güncelle
      const mansetDescTypography = getMansetDescTypography();
      preview.find('.kanews-slide-spot').css({
        'font-size': mansetDescTypography.font_size,
        'font-weight': mansetDescTypography.font_weight,
        'line-height': mansetDescTypography.line_height,
        'letter-spacing': mansetDescTypography.letter_spacing,
        'text-transform': mansetDescTypography.text_transform
      });
    }

    // Watch checkbox changes specifically
    fields.hideContent.on('change', function() {
      updatePreview();
    });

    // Watch all CSF field changes
    $('.csf-field').on('change keyup', function() {
      updatePreview();
    });

    // Handle window resize for responsive preview
    $(window).on('resize', updatePreview);

    // Initial update
    updatePreview();
  }

  // Yeni tipografi ayarlarını almak için fonksiyon
  function getMansetDescTypography() {
    return {
      font_size: $('[name="kanews_post_options[manset_desc_typography][font-size]"]').val() + 'px' || '',
      font_weight: $('[name="kanews_post_options[manset_desc_typography][font-weight]"]').val() || '',
      line_height: $('[name="kanews_post_options[manset_desc_typography][line-height]"]').val() || '',
      letter_spacing: $('[name="kanews_post_options[manset_desc_typography][letter-spacing]"]').val() + 'px' || '',
      text_transform: $('[name="kanews_post_options[manset_desc_typography][text-transform]"]').val() || ''
    };
  }

})(jQuery);

