jQuery(document).ready(function($) {
    // Launch button handler
    $('#kanews-ai-launch').click(function() {
        $('#kanews-ai-popup').show();
    });
    
    // Close handlers
    $('.kanews-ai-popup-close').click(function() {
        $('#kanews-ai-popup').hide();
    });
    
    $(window).click(function(e) {
        if ($(e.target).is('.kanews-ai-popup')) {
            $('.kanews-ai-popup').hide();
        }
    });
    
    // Task selection handler
    $('#kanews-ai-selector').change(function() {
        const task = $(this).val();
        const inputsArea = $('#kanews-ai-task-inputs');
        inputsArea.empty();
        
        // Enable/disable execute button
        $('#kanews-ai-execute').prop('disabled', !task);
        
        // Generate task-specific inputs
        switch(task) {
            case 'tts':
                inputsArea.html(`
                    <div class='kanews-ai-input-group'>
                        <label>Seslendiren</label>
                        <select id='kanews-voice-selector' class='widefat'>
                            <option value='alloy'>Alloy</option>
                            <option value='echo'>Echo</option>
                            <option value='fable'>Fable</option>
                            <option value='onyx'>Onyx</option>
                            <option value='nova'>Nova</option>
                            <option value='shimmer'>Shimmer</option>
                            <option value='ash'>Ash</option>
                            <option value='coral'>Coral</option>
                            <option value='sage'>Sage</option>
                        </select>
                    </div>
                `);
                break;
                
            case 'excerpt':
                inputsArea.html(`
                    <div class='kanews-ai-info-message'>
                        Yazı içeriğinden otomatik olarak açıklama oluşturulacak.
                    </div>
                `);
                break;
                
            case 'summary':
                inputsArea.html(`
                    <div class='kanews-ai-info-message'>
                        Yazı içeriğinden otomatik olarak özet oluşturulacak.
                    </div>
                `);
                break;
                
            case 'seo-title':
                inputsArea.html(`
                    <div class='kanews-ai-info-message'>
                        Yazı içeriğinden SEO dostu başlık oluşturulacak.
                    </div>
                `);
                break;
                
            case 'article':
                inputsArea.html(`
                    <div class='kanews-ai-input-group'>
                        <label>Konu</label>
                        <input autocomplete="off" type='text' id='article-topic' class='widefat' placeholder='Makale konusunu girin'>
                    </div>
                    <div class='kanews-ai-input-group'>
                        <label>Makale hakkında şunları unutma</label>
                        <input autocomplete="off" type='text' id='article-notes' class='widefat' placeholder='Eklemek istedikleriniz'>
                    </div>
                    <div class='kanews-ai-input-group'>
                        <label>Yapay Zeka Modeli</label>
                        <select id='gpt-model' class='widefat'>
                            <option value='gpt-4o-mini'>GPT-4o Mini</option>
                            <option value='gpt-4o'>GPT-4o</option>
                            <option value='gpt-4-turbo'>GPT-4 Turbo</option>
                            <option value='gpt-3.5-turbo'>GPT-3.5 Turbo</option>
                        </select>
                    </div>
                    <div class='kanews-ai-input-group'>
                        <label>Dil</label>
                        <select id='article-language' class='widefat'>
                            <option value='tr'>Türkçe</option>
                            <option value='en'>İngilizce</option>
                            <option value='de'>Almanca</option>
                            <option value='fr'>Fransızca</option>
                            <option value='es'>İspanyolca</option>
                            <option value='it'>İtalyanca</option>
                            <option value='ru'>Rusça</option>
                            <option value='ar'>Arapça</option>
                        </select>
                    </div>
                    <div class='kanews-ai-input-group'>
                        <label>Anlatım Biçimi</label>
                        <select id='article-style' class='widefat'>
                            <option value='news'>Haber Yazısı</option>
                            <option value='analysis'>Analiz</option>
                            <option value='interview'>Röportaj</option>
                            <option value='opinion'>Köşe Yazısı</option>
                            <option value='custom-news'>Özel Haber</option>
                            <option value='guide'>Rehber</option>
                            <option value='review'>İnceleme</option>
                            <option value='list'>Liste</option>
                            <option value='clickbait'>Clickbait</option>
                        </select>
                    </div>
                    <div class='kanews-ai-checkbox-group'>
                        <label><input type='checkbox' id='use-5w1h'> 5N1K Formatı Kullan</label>
                        <label><input type='checkbox' id='add-faq' checked> SSS Bölümü Ekle</label>
                        <label><input type='checkbox' id='use-tables'> Karşılaştırma Tabloları Kullan</label>
                        <label><input type='checkbox' id='use-list'> Listeler Kullan</label>
                    </div>
                `);
                break;
                
            case 'paraphrase':
                inputsArea.html(`
                    <div class='kanews-ai-input-group'>
                        <label>Yapay Zeka Modeli</label>
                        <select id='paraphrase-model' class='widefat'>
                            <option value='gpt-4o-mini'>GPT-4o Mini</option>
                            <option value='gpt-4o'>GPT-4o</option>
                            <option value='gpt-4-turbo'>GPT-4 Turbo</option>
                            <option value='gpt-3.5-turbo'>GPT-3.5 Turbo</option>
                        </select>
                    </div>
                    <div class='kanews-ai-input-group'>
                        <label>Özgünleştirme Seviyesi</label>
                        <select id='paraphrase-level' class='widefat'>
                            <option value='light'>Hafif (Minimal değişiklik)</option>
                            <option value='medium' selected>Orta (Dengeli değişiklik)</option>
                            <option value='high'>Yüksek (Tamamen özgün)</option>
                        </select>
                    </div>
                    <div class='kanews-ai-checkbox-group'>
                        <label><input type='checkbox' id='preserve-keywords' checked> Anahtar Kelimeleri Koru</label>
                        <label><input type='checkbox' id='preserve-structure' checked> Yapıyı Koru</label>
                        <label><input type='checkbox' id='improve-seo'> SEO'yu İyileştir</label>
                    </div>
                    <div class='kanews-ai-info-message'>
                        Mevcut yazı içeriği otomatik olarak özgünleştirilecek.
                    </div>
                `);
                break;
                
            case 'featured-image':
                inputsArea.html(`
                    <div class='kanews-ai-input-group'>
                        <label>Görsel Konusu</label>
                        <input type='text' id='image-topic' class='widefat' placeholder='Görsel konusunu girin'>
                    </div>
                    <div id="kanews-ai-images-grid" class="kanews-ai-images-grid"></div>
                `);
                break;
            case 'comments':
                inputsArea.html(`
                    <div class='kanews-ai-input-group'>
                        <label>Yorum Sayısı</label>
                        <select id='comment-count' class='widefat'>
                            <option value='3'>3 Yorum</option>
                            <option value='5' selected>5 Yorum</option>
                            <option value='10'>10 Yorum</option>
                            <option value='15'>15 Yorum</option>
                            <option value='20'>20 Yorum</option>
                        </select>
                    </div>
                    <div class='kanews-ai-info-message'>
                        Yazı içeriğine uygun gerçekçi yorumlar otomatik olarak oluşturulacak.
                    </div>
                `);
                break;
            case 'faq':
                inputsArea.html(`
                    <div class='kanews-ai-input-group'>
                        <label>Soru Sayısı</label>
                        <select id='faq-count' class='widefat'>
                            <option value='3'>3 Soru</option>
                            <option value='5' selected>5 Soru</option>
                            <option value='7'>7 Soru</option>
                            <option value='10'>10 Soru</option>
                        </select>
                    </div>
                    <div class='kanews-ai-checkbox-group'>
                        <label><input type='checkbox' id='faq-detailed' checked> Detaylı Cevaplar</label>
                    </div>
                `);
                break;
        }
    });
    
    // Execute button handler
    $('#kanews-ai-execute').click(function() {
        let task = $('#kanews-ai-selector').val();
        const post_id = $('#post_ID').val();
        const nonce = $('#kanews_ai_nonce_name').val();

        task = task.replace(/-/g, "_");

        
        let taskData = {
            action: 'generate_'+task,
            post_id: post_id,
            type: 'POST',
            dataType: 'json',
            nonce: nonce
        };
        
        $('#kanews-ai-loading').html('<span class="spinner is-active"></span>');
        $('#kanews-ai-results').html();
        $(this).prop('disabled', true);
        
        // Add task-specific data
        switch(task) {
            case 'comments':
                taskData.count = $('#comment-count').val();
                break;
            case 'tts':
                taskData.voice = $('#kanews-voice-selector').val();
                break;
            case 'article':
                taskData.model = $('#gpt-model').val();
                taskData.topic = $('#article-topic').val();
                taskData.notes = $('#article-notes').val();
                taskData.notes = $('#article-notes').val();
                taskData.language = $('#article-language').val();
                taskData.style = $('#article-style').val();
                taskData.use_5w1h = $('#use-5w1h').is(':checked');
                taskData.use_list = $('#use-list').is(':checked');
                taskData.add_faq = $('#add-faq').is(':checked');
                taskData.use_tables = $('#use-tables').is(':checked');
                break;
            case 'paraphrase':
                taskData.model = $('#paraphrase-model').val();
                taskData.level = $('#paraphrase-level').val();
                taskData.preserve_keywords = $('#preserve-keywords').is(':checked');
                taskData.preserve_structure = $('#preserve-structure').is(':checked');
                taskData.improve_seo = $('#improve-seo').is(':checked');
                break;
            case 'featured_image':
                if($('#image-topic').val()) {
                    const selectedImage = $('.kanews-ai-image-item.selected').data('image');
                    if(selectedImage) {
                        taskData.selected_image = selectedImage;
                    }
                    taskData.topic = $('#image-topic').val();
                }
                break;
            case 'faq':
                // taskData.topic = $('#faq-topic').val();
                taskData.count = $('#faq-count').val();
                taskData.detailed = $('#faq-detailed').is(':checked');
                break;
        }
        
        // Send AJAX request
        $.post(ajaxurl, taskData, function(response) {
            if( task != 'featured_image' )
            var response = JSON.parse(response);

            if (response.success) {
                // Task-specific success handlers
                switch(task) {
                    case 'seo_title':
                        // WordPress editör başlığını güncelle
                        $('#title').val(response.message);
                        // Gutenberg editörü için
                        if (wp.data && wp.data.select('core/editor')) {
                            wp.data.dispatch('core/editor').editPost({ title: response.message });
                        }
                        break;
                    case 'article':
                        var content = response.message;
                        var lines = content.split('\n');
                        var title = lines[0].replace(/<[^>]*>/g, ''); // HTML etiketlerini temizle
                        var articleContent = lines.slice(1).join('\n'); // Geri kalan içerik
                        
    
                        // Gutenberg editörü kontrolü
                        if (wp.data && wp.data.select('core/editor')) {
                            // Önce içeriği temizle
                            wp.data.dispatch('core/editor').resetBlocks([]);
                            
                            // Başlığı ayarla
                            wp.data.dispatch('core/editor').editPost({
                                title: title.trim() // Başlıktaki fazla boşlukları temizle
                            });
                            
                            // İçeriği blok olarak ekle
                            wp.data.dispatch('core/editor').insertBlocks(
                                wp.blocks.parse(articleContent)
                            );
                        } else {
                            // Klasik editör için
                            // Başlığı ayarla
                            $('#title').val(title.trim());
                            
                            // İçeriği ayarla
                            if (typeof tinyMCE !== 'undefined' && tinyMCE.get('content')) {
                                tinyMCE.get('content').setContent(articleContent);
                            } else {
                                $('#content').val(articleContent);
                            }
                        }
                        response.message = 'Makale oluşturuldu.';
                        break;
                    case 'paraphrase':
                        var content = response.message;
                        
                        // Gutenberg editörü kontrolü
                        if (wp.data && wp.data.select('core/editor')) {
                            // İçeriği blok olarak ekle
                            wp.data.dispatch('core/editor').resetBlocks([]);
                            wp.data.dispatch('core/editor').insertBlocks(
                                wp.blocks.parse(content)
                            );
                        } else {
                            // Klasik editör için
                            if (typeof tinyMCE !== 'undefined' && tinyMCE.get('content')) {
                                tinyMCE.get('content').setContent(content);
                            } else {
                                $('#content').val(content);
                            }
                        }
                        response.message = 'Makale özgünleştirildi.';
                        break;
                    case 'excerpt':
                        $('textarea[data-depend-id="kanews_post_excerpt"]').val(response.message);
                        break;
                    case 'featured_image':
                        if(response.data.images) {
                            // Görselleri grid olarak göster
                            let imagesHtml = '';
                            response.data.images.forEach(image => {
                                imagesHtml += `
                                    <div class="kanews-ai-image-item" data-image='${JSON.stringify(image)}'>
                                        <img src="${image.thumbnail}" alt="Önizleme">
                                        <div class="image-overlay">
                                            Fotoğrafçı: ${image.photographer}
                                        </div>
                                    </div>
                                `;
                            });
                            $('#kanews-ai-images-grid').html(imagesHtml);

                            // Görsel seçim işleyicisi
                            $('.kanews-ai-image-item').click(function() {
                                $('.kanews-ai-image-item').removeClass('selected');
                                $(this).addClass('selected');
                                $('#kanews-ai-execute').text('Seçilen Görseli Uygula');
                            });

                            $('#kanews-ai-execute').text('Görsel Seç');
                        } else {
                            // Seçilen görsel uygulandı
                            if(wp.data && wp.data.select('core/editor')) {
                                wp.data.dispatch('core/editor').editPost({
                                    featured_media: response.data.image_id
                                });
                            }
                        }
                        break;
                    case 'tts':
                        $('input[data-depend-id="post_text_to_speech"]').val(response.file_url);
                        $('input[name="kanews_post_options[post_text_to_speech][id]"]').val(response.file_id);
      
                        break;
                    case 'faq':
                        if (wp.data && wp.data.select('core/editor')) {
                            // Gutenberg editör için
                            wp.data.dispatch('core/editor').insertBlocks(
                                wp.blocks.parse(response.message)
                            );
                        } else {
                            // Klasik editör için
                            if (typeof tinyMCE !== 'undefined' && tinyMCE.get('content')) {
                                tinyMCE.get('content').setContent(
                                    tinyMCE.get('content').getContent() + response.message
                                );
                            } else {
                                $('#content').val($('#content').val() + response.message);
                            }
                        }
                        break;
                }

                $('#kanews-ai-results').html('<div class="notice notice-success">' + response.message + '</div>');

            } else {
                $('#kanews-ai-results').html('<div class="notice notice-error">' + response.message + '</div>');
            }
            $('#kanews-ai-loading').html('');

            $('#kanews-ai-execute').prop('disabled', false);
        }).fail(function() {
            $('#kanews-ai-results').html('<div class="notice notice-error">İşlem sırasında bir hata oluştu.</div>');
            $('#kanews-ai-execute').prop('disabled', false);
            $('#kanews-ai-loading').html('');
        });
    });
});