<?php
/**
 * The main template file
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 * @package Kanews
 * @since 1.0.0
 */
defined( 'ABSPATH' ) || exit; // Exit if accessed directly

if( $ilan = get_term_meta( get_queried_object_id(  ), 'ilan-category', true ) ) {
  // Datapicker
  function wpse_enqueue_datepicker() {
    wp_enqueue_script( 'moment', 'https://cdn.jsdelivr.net/momentjs/latest/moment.min.js', array('jquery'), null, true );
    wp_enqueue_script( 'daterangepicker', 'https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js', array('jquery'), null, true );
    wp_enqueue_style( 'daterangepicker', 'https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css' );
    wp_add_inline_script( 'daterangepicker', "
    (function($) {
      'use strict';

        $('.datefilter' ).daterangepicker({
          'singleDatePicker': false,
          'showDropdowns': true,
          'autoApply': false,
          ranges: {
              'Bugün': [moment(), moment()],
              'Dün': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
              'Son 7 Gün': [moment().subtract(6, 'days'), moment()],
              'Son 30 Gün': [moment().subtract(29, 'days'), moment()],
              'Bu Ay': [moment().startOf('month'), moment().endOf('month')],
              'Geçen Ay': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
          },
          'alwaysShowCalendars': true,
          'opens': 'center',
          'drops': 'down',
          'autoUpdateInput': false,
          locale: {
              'cancelLabel': 'Temizle',
              'applyLabel': 'Uygula'
          },
      }, function(start, end, label) {
        console.log('New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') + ' (predefined range: ' + label + ')');
      });

      $('.datefilter').on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('MM/DD/YYYY') + ' - ' + picker.endDate.format('MM/DD/YYYY'));
        $(this).addClass('used')
    });

    $('.datefilter').on('cancel.daterangepicker', function(ev, picker) {
        $(this).val('');
        $(this).removeClass('used');
    });

  
    })(jQuery)" );
  }
  add_action( 'wp_enqueue_scripts', 'wpse_enqueue_datepicker' );
}
get_header(); 
kanews_navbar_sub_category(); ?>
  <?php do_action('kanews_header_ad'); ?>
  <main id="main" class="site-main">
    <div class="container">
      <div class="row">
        <div class="site-main-wrapper">
          <?php if( $ilan ) : ?>
            <?php get_template_part( 'template-parts/archives/category-ilan' ); ?>
          <?php else: ?>
          <?php do_action('kanews_page_builder_cat'); ?>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </main>
<?php get_footer();