<?php
namespace Kanews\Assets;

class FrontEndAsset {
  private static $instance;

  public static function getInstance() {
    if ( null === static::$instance ) {
      static::$instance = new static();
    }
    return static::$instance;
  }

  public function __construct() {
    add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
    // add_action( 'wp_default_scripts', array( $this, 'remove_jquery_migrate' ) );
		// add_filter( 'style_loader_tag', array( $this, 'add_style_attributes' ), 10, 4 );
		// add_filter( 'wp_resource_hints', array( $this, 'google_fonts_preconnect' ), 10, 2 );
	}

	public function enqueue_scripts() {
		// JS
		wp_enqueue_script('jquery');
		
		wp_register_style('kanews-theme-single', KAN_TEMPLATE_URL . '/assets/css/theme-single.min.css', array('kanews-theme'), KAN_THEME_VER);

		wp_register_script( 'kanews-infinite-scroll', KAN_TEMPLATE_URL . '/assets/js/infinite-scroll.min.js', array('jquery'), KAN_THEME_VER, true );
		wp_register_script( 'kanews-calculator', KAN_TEMPLATE_URL . '/assets/js/calculator.min.js', array('jquery'), KAN_THEME_VER, true );
		
		wp_register_script( 'kanews-sticky', KAN_TEMPLATE_URL . '/assets/js/sticky.min.js', array('kanews-theme'), KAN_THEME_VER, true );
		if( (kanews_get_option('sticky-sidebar', true) )  )
		wp_enqueue_script( 'kanews-sticky' );

		if( (is_singular() && kanews_get_option('infinite-post-scroll', false)) 
		|| (is_singular() && kanews_get_option('single-pagination', '') != 'number' ) 
		|| ((is_archive() || is_home() ||is_front_page(  )) && kanews_get_option('archives-pagination', '') != 'classic' && kanews_get_option('archives-pagination', '') != 'number') )
		wp_enqueue_script( 'kanews-infinite-scroll' );

		$localize = array(
			'nonce'  => wp_create_nonce( 'kanews-ajax-nonce' ),
			'isadmin'  => current_user_can('administrator') ? 1 : 0,
			'ajax'  => admin_url('admin-ajax.php'),
			'assets' => KAN_TEMPLATE_URL .'/assets/',
			'emptydata' => esc_html__( 'Veri alınamadı', 'kanews' ),
			'invalidapi' => esc_html__( 'API hatası', 'kanews' ),
			'infinite_scroll' => (kanews_get_option('infinite-post-scroll') == true) ? 1 : 0,

			'weather_api' => kanews_get_option('openweathermap-api'),
			'noresult' => esc_html__( 'Sonuç bulunamadı.', 'kanews' ),
			'new_tab' => (kanews_get_option('open-link-new-tab')) ? 1 : 0,
			'sticky_navbar' => (kanews_get_option('sticky-navbar')) ? 1 : 0,
			'text_share' => (kanews_get_option('post-text-share') == true) ? 1 : 0,
			'right_click' => (kanews_get_option('right-click') == true) ? 1 : 0,
			'copy_event' => (kanews_get_option('copy-event') == true) ? 1 : 0,
			'adblock' => (kanews_get_option('adblock-detected') == true) ? 1 : 0,
			'subscribe' => kanews_insights_control(get_current_user_id()) == true ? 1 : 0,
			'lazy' => kanews_get_option('lazy'),
			'mode' => kanews_get_option('default-mode', 'light'),
			'dark_mode' => kanews_get_option('mode') ? 1: 0,
			'dark_mode_system' => kanews_get_option('mode_system') ? 1: 0,
			'like' => kanews_translate('like-text', esc_html__( 'Beğen', 'kanews' )),
			'unlike' => kanews_translate('unlike-text', esc_html__( 'Vazgeç', 'kanews' )),
			'bookmark' => kanews_translate('bookmark-text', esc_html__( 'Favorilerime Ekle', 'kanews' )),
			'unbookmark' => kanews_translate('unbookmark-text', esc_html__( 'Favorilerimden Çıkar', 'kanews' )),
			'show_children' => kanews_translate('show-children', esc_html__( 'Yanıtları Göster', 'kanews' )),
			'hide_children' => kanews_translate('hide-children', esc_html__( 'Yanıtları Gizle', 'kanews' )),
			'pagination' => (!empty(kanews_get_option('archives-pagination'))) ? kanews_get_option('archives-pagination') : 'numbers',
			'insights' => kanews_insights_page_url(),
			'gotop' => kanews_get_option('back-to-top') == true ? 1: 0,
			'translate' => [
				'days'	   => esc_html__('Gün', 'kanews'),
				'showless' => esc_html__( 'Daha Az Göster', 'kanews' ),
				'showmore' => esc_html__( 'Daha Fazla Göster', 'kanews' ),
				'prev' => esc_html__( 'Önceki', 'kanews' ),
				'next' => esc_html__( 'Sonraki', 'kanews' ),
				'expand' => esc_html__( 'Daralt', 'kanews' ),
				'expand2' => esc_html__( 'Genişlet', 'kanews' ),
				'continue' => esc_html__( 'Devam Et', 'kanews' ),
				'copied' => esc_html__( 'Kopyalandı!', 'kanews' ),
				'insights' => esc_html__( 'Reklamsız Sürüm', 'kanews' ),
				'right_click' => esc_html__( 'Bu sayfada sağ tıklama işlemi yasaklanmıştır.', 'kanews' ),
				'copy_event' => esc_html__( 'Bu sayfada kopyalama işlemi yasaklanmıştır.', 'kanews' ),
				'adblock_text' => esc_html__( 'Sitemize katkıda bulunmak için lütfen reklam engelleyicinizi devredışı bırakın.', 'kanews' ),
				'adblock_title' => esc_html__( 'Reklam Engelleyicisi Tespit Edildi', 'kanews' ),
			],
		);

		wp_enqueue_script( 'kanews-theme', KAN_TEMPLATE_URL . '/assets/js/theme.min.js', array('jquery'), KAN_THEME_VER, true );
		
		wp_localize_script( 'kanews-theme', 'kan_vars', $localize);

		// Generate nonce
    $nonce = wp_create_nonce('kanews_chat_nonce');
    $free_limit = kanews_get_option('kai-chat-free-limit', 5);
    $premium_limit = kanews_get_option('kai-chat-premium-limit', 20);

    // Add nonce and subscription status to JavaScript
    wp_localize_script('kanews-theme', 'kanews_chat', array(
      'nonce' => $nonce,
      'insights' => kanews_get_option('kanews-insights', false),
      'subscription_url' => kanews_insights_page_url(),
      'free_limit' => $free_limit,
      'premium_limit' => $premium_limit
    ));

		if( kanews_get_option('pwa-status') &&  kanews_get_option('pwa-btn') ) 
		wp_enqueue_script( 'kanews-pwa', KAN_TEMPLATE_URL . '/assets/js/pwa.js', array('jquery'), KAN_THEME_VER, true );
		
		if(kanews_get_option('ajax-search', false))
		wp_enqueue_script( 'kanews-ajax-search', KAN_TEMPLATE_URL . '/assets/js/ajax-search.min.js', array('jquery'), KAN_THEME_VER, true );

		wp_register_script( 'kanews-ilan-search', KAN_TEMPLATE_URL . '/assets/js/ilan.js', array('jquery'), KAN_THEME_VER, true );

		

		if(function_exists("pvc_get_post_views"))
		wp_dequeue_style( 'post-views-counter-frontend' );

		if(class_exists('TOC_Plus')) {
			wp_dequeue_style( 'toc-screen' );
			wp_dequeue_script( 'toc-front' );
		}

		wp_dequeue_style('classic-theme-styles');

		if(!is_user_logged_in())
		wp_dequeue_style('dashicons');
		
		if( is_singular() ) {

			wp_enqueue_script( 'kanews-singular', KAN_TEMPLATE_URL . '/assets/js/theme-singular.min.js', array('kanews-theme'), KAN_THEME_VER, true );

			global $post;
			
			if( $post ) {
				if ( has_shortcode( $post->post_content, 'contact-form-7' ) && function_exists( 'wpcf7_enqueue_styles' ) ) {
					wpcf7_enqueue_styles();
				}
			}
			
			// Disable Gutenberg Css
			if( function_exists( 'has_blocks' ) && has_blocks( $post->ID ) ){
				$has_blocks = true;
			}
		
			if( empty( $has_blocks ) ){
				wp_dequeue_style('wp-block-library');
				wp_dequeue_style('wp-block-library-theme');
				wp_dequeue_style('wc-block-style');
			}

			// Comments
			if ( comments_open() && get_option('thread_comments') ){
				wp_enqueue_script('comment-reply');
			}

			// Gallery
			if($post && ( has_shortcode( $post->post_content, 'gallery' ) || is_singular('ilan') ) ) {
				wp_enqueue_style( 'mfp-popup', KAN_TEMPLATE_URL . '/assets/css/magnific-popup.css', array(), '1.1.0');
				wp_enqueue_script( 'mfp-popup', KAN_TEMPLATE_URL . '/assets/js/magnific-popup.min.js', array('kanews-theme'), '1.1.0', true );
				if( is_singular('ilan') ) {
					wp_add_inline_script( "mfp-popup", kan_minify_js("
					(function( $ ) {
						'use strict';
				$('.kanews-gallery-text').on('click', function () {
					$(this).closest('.kanews-gallery-lightbox').magnificPopup('open');
			});
				$('.kanews-gallery-lightbox').magnificPopup({
					delegate: 'figure', // child items selector, by clicking on it popup will open
					gallery: {
						enabled: true
					},
					type: 'image'
					// other options
				});
			})(jQuery);
				"));
				} else {
					wp_add_inline_script( "mfp-popup", kan_minify_js("
					(function( $ ) {
						'use strict';
						$('.kanews-gallery-lightbox').on('click', function() {
							$(this).magnificPopup('open');
						});
						jQuery('.kanews-gallery').each(function() {
							jQuery(this).magnificPopup({
								delegate: 'figure',
								type: 'image',
								mainClass: 'mfp-zoom-in kanews-post-gallery-lightbox',
								zoom: {
									enabled: true,
									duration: 300
								},
								cursor: 'mfp-zoom-out-cur',
								closeBtnInside: false,
								removalDelay: 400,
								overflowY: 'hidden',
								gallery: {
									enabled: true,
									arrowMarkup: '<button title=\"%title%\" type=\"button\" class=\"mfp-arrow mfp-arrow-%dir%\"></button>',
									tCounter: '<span class=\"mfp-counter\">%curr%/%total%</span>'
								},
								image: {
									titleSrc: false,
									markup: '<div class=\"mfp-figure d-flex flex-column\">' + '<div class=\"mfp-top-bar d-flex align-items-center justify-content-between\">' + '<div class=\"mfp-title\"></div>' + '<div class=\"mfp-counter\"></div>' + '</div>' + '<div class=\"mfp-inner row m-0\">' + '<div class=\"mfp-left-column col-12 col-md-7 col-lg-9\"><div class=\"mfp-img\"></div></div>' + '<div class=\"mfp-right-column col-12 col-md-5 col-lg-3\"><div class=\"mfp-inner-content\"></div></div>' + '</div>' + '</div>',
								},
								callbacks: {
									// this - is Magnific Popup object.
									change: function() {
										$(this.content).find('.mfp-inner-content').html('<h5>' + $(this.currItem.el).attr('title') + '</h5>' + $(this.currItem.el).attr('content'));
									}
								},
							});
						});
					})(jQuery);
					") );
				}
			}
		} else {
			wp_dequeue_style('wp-block-library');
			wp_dequeue_style('wp-block-library-theme');
			wp_dequeue_style('wc-block-style');
			wp_dequeue_style( 'global-styles' );
		}

		if ( class_exists( 'WooCommerce' ) ) {
			wp_dequeue_style( 'wc-blocks-style' );
			wp_dequeue_style(	'wc-block-style' );
			wp_dequeue_script(	'sourcebuster-js' );
		}
		


	}

  public function remove_jquery_migrate( $scripts ) {
		if ( ! is_admin() && isset( $scripts->registered['jquery'] ) ) {
			$script = $scripts->registered['jquery'];
			if ( $script->deps ) { 
				$script->deps = array_diff( $script->deps, array( 'jquery-migrate' ) );
			}
		}
	}

	public function google_fonts_preconnect( array $urls, string $relationship_type ): array {
		if ( 'preconnect' !== $relationship_type ) {
			return $urls;
		}
		$urls[] = array(
			'rel'  => 'preconnect',
			'href' => 'https://fonts.gstatic.com',
			'crossorigin',
		);
		return $urls;
	}

	public function add_style_attributes( string $html = '', string $handle = '', string $href = '', string $media = '' ): string {
		if ( $handle == 'kanews-google-font' || $handle == 'kanews-google-font-single' ) {
			// Revamp thanks to Harry: https://csswizardry.com/2020/05/the-fastest-google-fonts/.
			$href      = str_replace( array( '|', ' ' ), array( '%7C', '%20' ), urldecode( $href ) );
			$new_html  = '<link rel="preload" as="style" href="' . esc_attr( $href ) . '" />';
			$new_html .= '<link rel="stylesheet" href="' . esc_attr( $href ) . '" media="print" onload="this.media=\'all\'">';  // phpcs:ignore WordPress.WP.EnqueuedResources.NonEnqueuedStylesheet
			$new_html .= '<noscript><link rel="stylesheet" href="' . esc_attr( $href ) . '" /></noscript>'; // phpcs:ignore WordPress.WP.EnqueuedResources.NonEnqueuedStylesheet
			$html      = $new_html;
		}

		return $html;
	}

}