<?php
namespace Kanews\Builder;

class Modules {
  private static $instance;

  public static function getInstance() {
    if ( null === static::$instance ) {
      static::$instance = new static();
    }
    return static::$instance;
  }

  function __construct() {
    add_action( 'widgets_init', array($this, 'list_modules') );
    $this->get_files();
  }
  
  function get_files() {
    $theme_widgets = array(
      'manset-1',
      'manset-2',
      'manset-3',
      'slider-1',
      'slider-2',
      'slider-3',
      // 'slider-4',
      'slider-5',
      'posts-x',
      'posts-1',
      'posts-2',
      // 'posts-3',
      'posts-4',
      'posts-6',
      // 'posts-7',
      'posts-8',
      'posts-9',
      'posts-10',
      'posts-11',
      'carousel-1',
      'tab-menu',
      'currencies',
      'standings',
      'weather',
      'calculator',
      // 'emtia',
      'prayer',
      'video',
      'ticker',
      'authors',
      'newsletter',
      'ads',
      'tagcloud',
      'social',
      // 'categories',
      'iconbox',
      'columnist',
      'gamecenter',
      // 'manset-custom',
      // 'imagebox',
      'taxonomies',
      // 'ilan',
      // 'firma',
      // 'term-images',
      // 'services',
      // 'survey',
      // 'secim2023',
      'eczane',
      // 'example-widget',
    );
    $theme_widgets = apply_filters( 'kanews_default_widgets', $theme_widgets );
    
    if( ! empty( $theme_widgets ) && is_array( $theme_widgets ) ){
      foreach ( $theme_widgets as $widget ){
        locate_template( "framework/widgets/$widget.php", true, true );
      }
    }
  }

  function list_modules() {
    register_widget('kanews_widget_class_ads');
    register_widget('kanews_widget_class_authors');
    register_widget('kanews_widget_class_calculator');
    register_widget('kanews_widget_class_carousel_1');
    // register_widget('kanews_widget_class_categories' );
    register_widget('kanews_widget_class_columnist');
    register_widget('kanews_widget_class_currencies');
    // register_widget('kanews_widget_class_emtia');
    register_widget('kanews_widget_class_game_center');
    register_widget('kanews_widget_class_iconbox' );
    register_widget('kanews_widget_class_manset_1');
    register_widget('kanews_widget_class_manset_2');
    register_widget('kanews_widget_class_manset_3');
    register_widget('kanews_widget_class_newsletter');
    register_widget('kanews_widget_class_posts_1');
    register_widget('kanews_widget_class_posts_2');
    // register_widget('kanews_widget_class_posts_3');
    register_widget('kanews_widget_class_posts_4');
    register_widget('kanews_widget_class_posts_6');
    register_widget('kanews_widget_class_posts_8');
    register_widget('kanews_widget_class_posts_9');
    register_widget('kanews_widget_class_posts_10');
    register_widget('kanews_widget_class_posts_11');
    register_widget('kanews_widget_class_posts_x');
    register_widget('kanews_widget_class_prayer');
    register_widget('kanews_widget_class_slider_1');
    register_widget('kanews_widget_class_slider_2');
    register_widget('kanews_widget_class_slider_3');
    // register_widget('kanews_widget_class_slider_4');
    register_widget('kanews_widget_class_slider_5');
    register_widget('kanews_widget_class_social');
    register_widget('kanews_widget_class_standings');
    register_widget('kanews_widget_class_tab_menu');
    register_widget('kanews_widget_class_tagcloud' );
    register_widget('kanews_widget_class_ticker');
    register_widget('kanews_widget_class_video');
    register_widget('kanews_widget_class_weather');
    register_widget('kanews_widget_class_eczane');
    register_widget('kanews_widget_class_taxonomies');
    // register_widget('kanews_widget_class_imagebox');
  }

}