<?php
namespace Kanews\Builder;
use Kanews\Helper_Wp;

class PageBuilder {

  private static $instance;

  public static function getInstance() {
    if ( null === static::$instance ) {
      static::$instance = new static();
    }
    return static::$instance;
  }

  function __construct() {
    
    // Templates
    add_action('kanews_header', array( $this, 'get_header' ));
    add_action('kanews_footer', array( $this, 'get_footer' ));

    // Home Builder
    add_action( 'kanews_page_builder_home', 'kanews_home_page_top', 15 );
    add_action( 'kanews_page_builder_home', 'kanews_home_page_content_start', 20 );
    add_action( 'kanews_page_builder_home', 'kanews_home_page_content', 25 );
    add_action( 'kanews_page_builder_home', 'kanews_home_page_sidebar', 30 );
    add_action( 'kanews_page_builder_home', 'kanews_home_page_content_end', 35 );
    add_action( 'kanews_page_builder_home', 'kanews_home_page_bottom', 40 );

    // Page Builder
    add_action( 'widgets_init', array( $this, 'page_builder' ), 20 );
    add_action( 'kanews_page_builder_custom', 'kanews_custom_page_top', 15 );
    add_action( 'kanews_page_builder_custom', 'kanews_custom_page_content_start', 20 );
    add_action( 'kanews_page_builder_custom', 'kanews_custom_page_content', 25 );
    add_action( 'kanews_page_builder_custom', 'kanews_custom_page_sidebar', 30 );
    add_action( 'kanews_page_builder_custom', 'kanews_custom_page_content_end', 35 );
    add_action( 'kanews_page_builder_custom', 'kanews_custom_page_bottom', 40 );

    // Cat Builder
    add_action( 'kanews_page_builder_cat', 'kanews_cat_page_top', 15 );
    add_action( 'kanews_page_builder_cat', 'kanews_cat_page_content_start', 20 );
    add_action( 'kanews_page_builder_cat', 'kanews_cat_page_content', 25 );
    add_action( 'kanews_page_builder_cat', 'kanews_cat_page_sidebar', 30 );
    add_action( 'kanews_page_builder_cat', 'kanews_cat_page_content_end', 35 );
    add_action( 'kanews_page_builder_cat', 'kanews_cat_page_bottom', 40 );
    
  }

  function get_header() {
    $layout   = (!empty(kanews_get_option('header-layout'))) ? kanews_get_option('header-layout') : 'style-1';
    switch($layout) {
      case 'style-4':
        get_template_part('template-parts/header/header-4');
        break;
      case 'style-3':
        get_template_part('template-parts/header/header-3');
        break;
      case 'style-2':
        get_template_part('template-parts/header/header-2');
        break;
      default:
        get_template_part('template-parts/header/header-1');
    }
  }

  function get_footer() {
    $layout   = (!empty(kanews_get_option('footer-layout'))) ? kanews_get_option('footer-layout') : 'style-1';
    switch($layout) {
      case 'style-1':
        get_template_part('template-parts/footer/footer-1');
        break;
      case 'style-2':
        get_template_part('template-parts/footer/footer-2');
        break;
    }
  }

  function page_builder() {

    // Category Sidebars
    $categories = kanews_get_option('category-sidebar2');
    if($categories) {
      foreach($categories as $cat_id) {
        $cat = Helper_Wp::get_term_by( 'slug', $cat_id, 'category' );
        if( !is_wp_error( $cat ) && is_object($cat) ) {
          $cat_name = $cat->name;
          if($cat_name != '') {
            register_sidebar(
              array(
                'name'          => esc_html__( $cat_name.': Üst Tam Genişlik', 'kanews-admin' ),
                'id'            => 'home-top-full-'.$cat_id,
                'before_widget' => '<div class="col"><section id="%1$s" class="kanews-section widget %2$s">',
                'after_widget'  => '</section></div>',
                'before_title'  => '<div class="kanews-section-heading"><h4 class="kanews-section-headline"><span>',
                'after_title'   => '</span></h4></div>',
              )
            );
            register_sidebar(
              array(
                'name'          => esc_html__( $cat_name.': Sol Bölüm', 'kanews-admin' ),
                'id'            => 'home-content-'.$cat_id,
                'before_widget' => '<div class="col"><section id="%1$s" class="kanews-section widget %2$s">',
                'after_widget'  => '</section></div>',
                'before_title'  => '<div class="kanews-section-heading"><h4 class="kanews-section-headline"><span>',
                'after_title'   => '</span></h4></div>',
              )
        
            );
            register_sidebar(
              array(
                'name'          => esc_html__( $cat_name.': Sidebar', 'kanews-admin' ),
                'id'            => 'home-sidebar-'.$cat_id,
                'before_widget' => '<div class="col-12"><section id="%1$s" class="kanews-section widget %2$s">',
                'after_widget'  => '</section></div>',
                'before_title'  => '<div class="kanews-section-heading"><h4 class="kanews-section-headline"><span>',
                'after_title'   => '</span></h4></div>',
              )
            );
        
            register_sidebar(
              array(
                'name'          => esc_html__( $cat_name.': Alt Tam Genişlik', 'kanews-admin' ),
                'id'            => 'home-bottom-full-'.$cat_id,
                'before_widget' => '<div class="col"><section id="%1$s" class="kanews-section widget %2$s">',
                'after_widget'  => '</section></div>',
                'before_title'  => '<div class="kanews-section-heading"><h4 class="kanews-section-headline"><span>',
                'after_title'   => '</span></h4></div>',
              )
            );
          }
        }
      }
  
    }

    // Page Sidebars
    $custom_widgets = get_option( 'kanews_page_sidebars_widgets', array() );
    $get_custom_widgets = kanews_get_option( 'page-builder');
    if($get_custom_widgets) {
      foreach($get_custom_widgets as $page_id) {

        $name = get_the_title( $page_id );
        
        register_sidebar(
          array(
            'name'          => sprintf(esc_html__( '%s: Üst Tam Genişlik', 'kanews-admin' ), $name),
            'id'            => 'home-top-full-'.$page_id,
            'before_widget' => '<div class="col"><section id="%1$s" class="kanews-section widget %2$s">',
            'after_widget'  => '</section></div>',
            'before_title'  => '<div class="kanews-section-heading"><h4 class="kanews-section-headline"><span>',
            'after_title'   => '</span></h4></div>',
          )
        );
        register_sidebar(
          array(
            'name'          => sprintf(esc_html__( '%s: Sol Bölüm', 'kanews-admin' ), $name),
            'id'            => 'home-content-'.$page_id,
            'before_widget' => '<div class="col"><section id="%1$s" class="kanews-section widget %2$s">',
            'after_widget'  => '</section></div>',
            'before_title'  => '<div class="kanews-section-heading"><h4 class="kanews-section-headline"><span>',
            'after_title'   => '</span></h4></div>',
          )
    
        );
        register_sidebar(
          array(
            'name'          => sprintf(esc_html__( '%s: Sidebar', 'kanews-admin' ), $name),
            'id'            => 'home-sidebar-'.$page_id,
            'before_widget' => '<div class="col-12"><section id="%1$s" class="kanews-section widget %2$s">',
            'after_widget'  => '</section></div>',
            'before_title'  => '<div class="kanews-section-heading"><h4 class="kanews-section-headline"><span>',
            'after_title'   => '</span></h4></div>',
          )
        );
    
        register_sidebar(
          array(
            'name'          => sprintf(esc_html__( '%s: Alt Tam Genişlik', 'kanews-admin' ), $name),
            'id'            => 'home-bottom-full-'.$page_id,
            'before_widget' => '<div class="col col-lg"><section id="%1$s" class="kanews-section widget %2$s">',
            'after_widget'  => '</section></div>',
            'before_title'  => '<div class="kanews-section-heading"><h4 class="kanews-section-headline"><span>',
            'after_title'   => '</span></h4></div>',
          )
        );
      }
    } elseif( !empty($custom_widgets) ) {

      foreach ( $custom_widgets as $post_id => $type ) {
        $name = get_the_title( $post_id );

        if( ! empty( $type ) ){
          if($type == 'all') {
            register_sidebar(
              array(
                'name'          => sprintf(esc_html__( '%s: Üst Tam Genişlik', 'kanews-admin' ), $name),
                'id'            => 'home-top-full-'.$post_id,
                'before_widget' => '<div class="col"><section id="%1$s" class="kanews-section widget %2$s">',
                'after_widget'  => '</section></div>',
                'before_title'  => '<div class="kanews-section-heading"><h4 class="kanews-section-headline"><span>',
                'after_title'   => '</span></h4></div>',
              )
            );
            register_sidebar(
              array(
                'name'          => sprintf(esc_html__( '%s: Sol Bölüm', 'kanews-admin' ), $name),
                'id'            => 'home-content-'.$post_id,
                'before_widget' => '<div class="col"><section id="%1$s" class="kanews-section widget %2$s">',
                'after_widget'  => '</section></div>',
                'before_title'  => '<div class="kanews-section-heading"><h4 class="kanews-section-headline"><span>',
                'after_title'   => '</span></h4></div>',
              )
        
            );
            register_sidebar(
              array(
                'name'          => sprintf(esc_html__( '%s: Sidebar', 'kanews-admin' ), $name),
                'id'            => 'home-sidebar-'.$post_id,
                'before_widget' => '<div class="col-12"><section id="%1$s" class="kanews-section widget %2$s">',
                'after_widget'  => '</section></div>',
                'before_title'  => '<div class="kanews-section-heading"><h4 class="kanews-section-headline"><span>',
                'after_title'   => '</span></h4></div>',
              )
            );
        
            register_sidebar(
              array(
                'name'          => sprintf(esc_html__( '%s: Alt Tam Genişlik', 'kanews-admin' ), $name),
                'id'            => 'home-bottom-full-'.$post_id,
                'before_widget' => '<div class="col col-lg"><section id="%1$s" class="kanews-section widget %2$s">',
                'after_widget'  => '</section></div>',
                'before_title'  => '<div class="kanews-section-heading"><h4 class="kanews-section-headline"><span>',
                'after_title'   => '</span></h4></div>',
              )
            );
          } else {
            register_sidebar(
              array(
                'name'          => sprintf(esc_html__( '%s: Sidebar', 'kanews-admin' ), $name),
                'id'            => 'home-sidebar-'.$post_id,
                'before_widget' => '<div class="col-12"><section id="%1$s" class="kanews-section widget %2$s">',
                'after_widget'  => '</section></div>',
                'before_title'  => '<div class="kanews-section-heading"><h5 class="kanews-section-headline"><span>',
                'after_title'   => '</span></h5></div>',
              )
            );
          }
        }
      }
    }

    // Köşe Yazıları
    register_sidebar(
      array(
        'name'          => sprintf(esc_html__( '%s: Sidebar', 'kanews-admin' ), esc_html__('Köşe Yazıları', 'kanews-admin')),
        'id'            => 'columnist-sidebar',
        'before_widget' => '<div class="col-12"><section id="%1$s" class="kanews-section widget %2$s">',
        'after_widget'  => '</section></div>',
        'before_title'  => '<div class="kanews-section-heading"><h5 class="kanews-section-headline"><span>',
        'after_title'   => '</span></h5></div>',
      )
    );

    // Firma Rehberi
    if ( kanews_get_option('firma-rehberi') ) {
      register_sidebar(
        array(
          'name'          => sprintf(esc_html__( '%s: Üst Tam Genişlik', 'kanews-admin' ), esc_html__('Firma Rehberi', 'kanews-admin')),
          'id'            => 'firma-top-full',
          'before_widget' => '<div class="col"><section id="%1$s" class="kanews-section widget %2$s">',
          'after_widget'  => '</section></div>',
          'before_title'  => '<div class="kanews-section-heading"><h4 class="kanews-section-headline"><span>',
          'after_title'   => '</span></h4></div>',
        )
      );
      register_sidebar(
        array(
          'name'          => sprintf(esc_html__( '%s: Sol Bölüm', 'kanews-admin' ), esc_html__('Firma Rehberi', 'kanews-admin')),
          'id'            => 'firma-content',
          'before_widget' => '<div class="col"><section id="%1$s" class="kanews-section widget %2$s">',
          'after_widget'  => '</section></div>',
          'before_title'  => '<div class="kanews-section-heading"><h4 class="kanews-section-headline"><span>',
          'after_title'   => '</span></h4></div>',
        )
  
      );
      register_sidebar(
        array(
          'name'          => sprintf(esc_html__( '%s: Sidebar', 'kanews-admin' ), esc_html__('Firma Rehberi', 'kanews-admin')),
          'id'            => 'firma-sidebar',
          'before_widget' => '<div class="col-12"><section id="%1$s" class="kanews-section widget %2$s">',
          'after_widget'  => '</section></div>',
          'before_title'  => '<div class="kanews-section-heading"><h4 class="kanews-section-headline"><span>',
          'after_title'   => '</span></h4></div>',
        )
      );
    }

  }

}
