<?php
namespace Kanews\Builder;

Class Widget
{

  private static $instance;
  private $widget_location;

  public static function getInstance() {
    if (null === static::$instance)
    {
        static::$instance = new static();
    }
    return static::$instance;
  }

  private function __construct() {
    $this->widget_location = array(
      'home-top-full' => esc_html__('Anasayfa: Üst Tam Genişlik', 'kanews'),
      'home-bottom-full' => esc_html__('Anasayfa: Alt Tam Genişlik', 'kanews'),
      'home-content' => esc_html__('Anasayfa: Sol Bölüm', 'kanews'),
      'home-sidebar' => esc_html__('Anasayfa: Sidebar', 'kanews'),
      
      'home-sidebar-page' => esc_html__('Sayfa: Sidebar', 'kanews'),

      'category-top-full' => esc_html__('Kategori: Üst Tam Genişlik', 'kanews'),
      'category-bottom-full' => esc_html__('Kategori: Alt Tam Genişlik', 'kanews'),
      'category-content' => esc_html__('Kategori: Sol Bölüm', 'kanews'),

      'home-sidebar-cat' => esc_html__('Kategori: Sidebar', 'kanews'),
      'home-sidebar-archive' => esc_html__('Arşiv: Sidebar', 'kanews'),
      'home-sidebar-post' => esc_html__('Yazı: Sidebar', 'kanews'),
      'home-sidebar-video' => esc_html__('Video Yazı: Sidebar', 'kanews'),

      'footer' => esc_html__('Footer', 'kanews'),
      'popup' => esc_html__('Popup', 'kanews'),
    );
    $this->widget_location = apply_filters('kanews_widget_locations', $this->widget_location);

    if(!kanews_get_option('category-right-sidebar', true))
    unset($this->widget_location['home-sidebar-cat']);

    if( kanews_get_option('footer-layout') == 'style-2' || ! kanews_get_option('footer-widgets'))
    unset($this->widget_location['footer']);

    if( ! kanews_get_option('popup'))
    unset($this->widget_location['popup']);

    add_action('widgets_init', array(&$this, 'register_widget_module'), 10);
  }

  public function register_widget_module() {
    foreach($this->widget_location as $location => $widget) {
      if($location === 'footer') {
        register_sidebar(array(
            'id'                => $location,
            'name'              => $widget,
            'before_widget'     => '<div class="col-12 col-lg"><section id="%1$s" class="footer-widget %2$s">',
            'after_widget'      => '</section></div>',
            'before_title'      => '<div class="kanews-footer-heading"><div class="kanews-footer-headline"><span>',
            'after_title'       => '</span></div></div>',
        ));
      } elseif($location === 'popup') {
        register_sidebar(array(
          'id'                  => $location,
          'name'                => $widget,
          'before_widget'       => '<div class="popup-widget">',
          'after_widget'        => '</div>',
          'before_title'        => '<div class="widgettitle">',
          'after_title'         => '</div>',
        ));
      } elseif (strpos( $location, 'sidebar' )) {
        register_sidebar(array(
          'id'                  => $location,
          'name'                => $widget,
          'before_widget'       => '<div class="col-12"><section id="%1$s" class="kanews-section widget %2$s">',
          'after_widget'        => '</section></div>',
          'before_title'        => '<div class="kanews-section-heading"><h4 class="kanews-section-headline"><span>',
          'after_title'         => '</span></h4></div>',
        ));
      } else {
        register_sidebar(array(
          'id'                  => $location,
          'name'                => $widget,
          'before_widget'       => '<div class="col"><section id="%1$s" class="kanews-section widget %2$s">',
          'after_widget'        => '</section></div>',
          'before_title'        => '<div class="kanews-section-heading"><h4 class="kanews-section-headline"><span>',
          'after_title'         => '</span></h4></div>',
        ));
      }
    }
  }

}
