<?php
namespace Kanews;

class Currencies {

  private static $instance;

  public static function getInstance() {
    if ( null === static::$instance ) {
      static::$instance = new static();
    }
    return static::$instance;
  }

  var $option = 'Kanews\Currencies';

  public static function update() {
    $transient_name = 'kanews-currencies';
    if( ! $post_data = get_transient( $transient_name ) ){

      $response = get_local_file_contents(KAN_TEMPLATE_PATH."/inc/api/currencies/currencies.json");
      $currencies = json_decode($response, true);

      $response = get_local_file_contents(KAN_TEMPLATE_PATH."/inc/api/gold/gold.json");
      $gold = json_decode($response, true);
      
      $index = kanews_get_option('crypto-page-index', 'try');
      $crypto = wp_remote_get(KAN_API_URL2."/crypto/?currency=$index&api_key=kanews-theme");
      
      if (! is_wp_error($crypto)) {
        $crypto_data = json_decode(wp_remote_retrieve_body($crypto), true);
        if( isset($crypto_data['data']) )
        $crypto_data = $crypto_data['data'];
        if (json_last_error() !== JSON_ERROR_NONE) {
          $crypto_data = array();
        }
      }
      $post_data = array(
        'ukoil' => array(
          'name' => esc_html__( 'Petrol', 'kanews' ),
          'full' => 'Brent Petrol',
          'value' => isset($currencies['data']['BRENT']['Selling']) ? $currencies['data']['BRENT']['Selling'] : 0,
          'shutdown' => isset($currencies['data']['BRENT']['Buying']) ? $currencies['data']['BRENT']['Buying'] : 0,
          'change_percent' => isset($currencies['data']['BRENT']['Change']) ? $currencies['data']['BRENT']['Change'] : 0,
          'change_value' => 0,
        ),
        'ise-100' => array(
          'name' => 'BIST',
          'full' => 'Bist 100',
          'value' => isset($currencies['data']['BIST']['Selling']) ? $currencies['data']['BIST']['Selling'] : 0,
          'shutdown' => isset($currencies['data']['BIST']['Buying']) ? $currencies['data']['BIST']['Buying'] : 0,
          'change_percent' => isset($currencies['data']['BIST']['Change']) ? $currencies['data']['BIST']['Change'] : 0,
          'change_value' => 0,  
        ),
        'usd' => array(
          'name' => 'USD',
          'full' => 'Amerikan Doları',
          'value' => isset($currencies['data']['USD']['Selling']) ? $currencies['data']['USD']['Selling'] : 0,
          'shutdown' => isset($currencies['data']['USD']['Buying']) ? $currencies['data']['USD']['Buying'] : 0,
          'change_percent' => isset($currencies['data']['USD']['Change']) ? $currencies['data']['USD']['Change'] : 0,
          'change_value' => 0,  
        ),
        'euro' => array(
          'name' => 'EURO',
          'full' => 'Euro',
          'value' => isset($currencies['data']['EUR']['Selling']) ? $currencies['data']['EUR']['Selling'] : 0,
          'shutdown' => isset($currencies['data']['EUR']['Buying']) ? $currencies['data']['EUR']['Buying'] : 0,
          'change_percent' => isset($currencies['data']['EUR']['Change']) ? $currencies['data']['EUR']['Change'] : 0,
          'change_value' => 0,  
        ),
        'gbp' => array(
          'name' => 'GBP',
          'full' => 'İngiliz Sterlini',
          'value' => isset($currencies['data']['GBP']['Selling']) ? $currencies['data']['GBP']['Selling'] : 0,
          'shutdown' => isset($currencies['data']['GBP']['Buying']) ? $currencies['data']['GBP']['Buying'] : 0,
          'change_percent' => isset($currencies['data']['GBP']['Change']) ? $currencies['data']['GBP']['Change'] : 0,
          'change_value' => 0,
  
        ),
        'eur-usd' => array(
          'name' => 'EURO/USD',
          'full' => esc_html__( 'Euro Amerikan Doları', 'kanews' ),
          'value' => isset($currencies['data']['EURUSD']['Selling']) ? $currencies['data']['EURUSD']['Selling'] : 0,
          'shutdown' => isset($currencies['data']['EURUSD']['Buying']) ? $currencies['data']['EURUSD']['Buying'] : 0,
          'change_percent' => isset($currencies['data']['EURUSD']['Change']) ? $currencies['data']['EURUSD']['Change'] : 0,
          'change_value' => 0,
  
        ),
        'chf' => array(
          'name' => 'CHF',
          'full' => 'İsviçre Frangı',
          'value' => isset($currencies['data']['CHF']['Selling']) ? $currencies['data']['CHF']['Selling'] : 0,
          'change_percent' => isset($currencies['data']['CHF']['Change']) ? $currencies['data']['CHF']['Change'] : 0,
          'change_value' => 0,
     
        ),
        'cny' => array(
          'name' => 'CNY',
          'full' => 'Çin Yuanı',
          'value' => isset($currencies['data']['CNY']['Selling']) ? $currencies['data']['CNY']['Selling'] : 0,
          'change_percent' => isset($currencies['data']['CNY']['Change']) ? $currencies['data']['CNY']['Change'] : 0,
          'change_value' => 0,
        ),
        'jpy' => array(
            'name' => 'JPY',
            'full' => 'Japon Yeni',
            'value' => isset($currencies['data']['JPY']['Selling']) ? $currencies['data']['JPY']['Selling'] : 0,
            'change_percent' => isset($currencies['data']['JPY']['Change']) ? $currencies['data']['JPY']['Change'] : 0,
            'change_value' => 0,
        ),
        'rub' => array(
            'name' => 'RUB',
            'full' => 'Rus Rublesi',
            'value' => isset($currencies['data']['RUB']['Selling']) ? $currencies['data']['RUB']['Selling'] : 0,
            'change_percent' => isset($currencies['data']['RUB']['Change']) ? $currencies['data']['RUB']['Change'] : 0,
            'change_value' => 0,
        ),
        'gau' => array(
            'name' => 'GR. ALTIN',
            'full' => 'Gram Altın',
            'value' => isset($gold['data']['GRA']['Selling']) ? $gold['data']['GRA']['Selling'] : 0,
            'shutdown' => isset($gold['data']['GRA']['Buying']) ? $gold['data']['GRA']['Buying'] : 0,
            'change_percent' => isset($gold['data']['GRA']['Change']) ? $gold['data']['GRA']['Change'] : 0,
            'change_value' => 0,
        ),
        'btc' => array(
          'name' => 'BTC',
          'full' => 'Bitcoin',
          'value' => isset($crypto_data['BTC']['price']) ? $crypto_data['BTC']['price'] : 0,
          'shutdown' => isset($crypto_data['BTC']['high24h']) ? $crypto_data['BTC']['high24h'] : 0,
          'change_percent' => isset($crypto_data['BTC']['change24h']) ? $crypto_data['BTC']['change24h'] : 0,
          'change_value' => isset($crypto_data['BTC']['change_value']) ? $crypto_data['BTC']['change_value'] : 0,
          'market_cap' => isset($crypto_data['BTC']['market_cap']) ? $crypto_data['BTC']['market_cap'] : 0,
          'total_volume' => isset($crypto_data['BTC']['total_volume']) ? $crypto_data['BTC']['total_volume'] : 0,
          'low_24h' => isset($crypto_data['BTC']['low_24h']) ? $crypto_data['BTC']['low_24h'] : 0,
        ),
        'eth' => array(
          'name' => 'ETH',
          'full' => 'Ethereum',
          'value' => isset($crypto_data['ETH']['price']) ? $crypto_data['ETH']['price'] : 0,
          'shutdown' => isset($crypto_data['ETH']['high24h']) ? $crypto_data['ETH']['high24h'] : 0,
          'change_percent' => isset($crypto_data['ETH']['change24h']) ? $crypto_data['ETH']['change24h'] : 0,
          'change_value' => isset($crypto_data['ETH']['change_value']) ? $crypto_data['ETH']['change_value'] : 0,
          'market_cap' => isset($crypto_data['ETH']['market_cap']) ? $crypto_data['ETH']['market_cap'] : 0,
          'total_volume' => isset($crypto_data['ETH']['total_volume']) ? $crypto_data['ETH']['total_volume'] : 0,
          'low_24h' => isset($crypto_data['ETH']['low_24h']) ? $crypto_data['ETH']['low_24h'] : 0,
        ),
        'xrp' => array(
          'name' => 'XRP',
          'full' => 'Ripple',
          'value' => isset($crypto_data['XRP']['price']) ? $crypto_data['XRP']['price'] : 0,
          'shutdown' => isset($crypto_data['XRP']['high24h']) ? $crypto_data['XRP']['high24h'] : 0,
          'change_percent' => isset($crypto_data['XRP']['change24h']) ? $crypto_data['XRP']['change24h'] : 0,
          'change_value' => 0,
        ),
        'bch' => array(
          'name' => 'BCH',
          'full' => 'Bitcoin Cash',
          'value' => isset($crypto_data['BCH']['price']) ? $crypto_data['BCH']['price'] : 0,
          'shutdown' => isset($crypto_data['BCH']['high24h']) ? $crypto_data['BCH']['high24h'] : 0,
          'change_percent' => isset($crypto_data['BCH']['change24h']) ? $crypto_data['BCH']['change24h'] : 0,
          'change_value' => 0,
        ),
        'ltc' => array(
          'name' => 'LTC',
          'full' => 'Litecoin',
          'value' => isset($crypto_data['LTC']['price']) ? $crypto_data['LTC']['price'] : 0,
          'shutdown' => isset($crypto_data['LTC']['high24h']) ? $crypto_data['LTC']['high24h'] : 0,
          'change_percent' => isset($crypto_data['LTC']['change24h']) ? $crypto_data['LTC']['change24h'] : 0,
          'change_value' => 0,
        ),
        'bnb' => array(
          'name' => 'BNB',
          'full' => 'Binance Coin',
          'value' => isset($crypto_data['BNB']['price']) ? $crypto_data['BNB']['price'] : 0,
          'shutdown' => isset($crypto_data['BNB']['high24h']) ? $crypto_data['BNB']['high24h'] : 0,
          'change_percent' => isset($crypto_data['BNB']['change24h']) ? $crypto_data['BNB']['change24h'] : 0,
          'change_value' => 0,
        ),
        'sol' => array(
          'name' => 'SOL',
          'full' => 'Solana',
          'value' => isset($crypto_data['SOL']['price']) ? $crypto_data['SOL']['price'] : 0,
          'shutdown' => isset($crypto_data['SOL']['high24h']) ? $crypto_data['SOL']['high24h'] : 0,
          'change_percent' => isset($crypto_data['SOL']['change24h']) ? $crypto_data['SOL']['change24h'] : 0,
          'change_value' => 0,
        ),
        'avax' => array(
          'name' => 'AVAX',
          'full' => 'Avalanche',
          'value' => isset($crypto_data['AVAX']['price']) ? $crypto_data['AVAX']['price'] : 0,
          'shutdown' => isset($crypto_data['AVAX']['high24h']) ? $crypto_data['AVAX']['high24h'] : 0,
          'change_percent' => isset($crypto_data['AVAX']['change24h']) ? $crypto_data['AVAX']['change24h'] : 0,
          'change_value' => 0,
        ),
        'ada' => array(
          'name' => 'ADA',
          'full' => 'Cardano',
          'value' => isset($crypto_data['ADA']['price']) ? $crypto_data['ADA']['price'] : 0,
          'shutdown' => isset($crypto_data['ADA']['high24h']) ? $crypto_data['ADA']['high24h'] : 0,
          'change_percent' => isset($crypto_data['ADA']['change24h']) ? $crypto_data['ADA']['change24h'] : 0,
          'change_value' => 0,
        ),
        'dot' => array(
          'name' => 'DOT',
          'full' => 'Polkadot',
          'value' => isset($crypto_data['DOT']['price']) ? $crypto_data['DOT']['price'] : 0,
          'shutdown' => isset($crypto_data['DOT']['high24h']) ? $crypto_data['DOT']['high24h'] : 0,
          'change_percent' => isset($crypto_data['DOT']['change24h']) ? $crypto_data['DOT']['change24h'] : 0,
          'change_value' => 0,
        ),
        'doge' => array(
          'name' => 'DOGE',
          'full' => 'Dogecoin',
          'value' => isset($crypto_data['DOGE']['price']) ? $crypto_data['DOGE']['price'] : 0,
          'shutdown' => isset($crypto_data['DOGE']['high24h']) ? $crypto_data['DOGE']['high24h'] : 0,
          'change_percent' => isset($crypto_data['DOGE']['change24h']) ? $crypto_data['DOGE']['change24h'] : 0,
          'change_value' => 0,
        ),
        'shib' => array(
          'name' => 'SHIB',
          'full' => 'Shiba Inu',
          'value' => isset($crypto_data['SHIB']['price']) ? $crypto_data['SHIB']['price'] : 0,
          'shutdown' => isset($crypto_data['SHIB']['high24h']) ? $crypto_data['SHIB']['high24h'] : 0,
          'change_percent' => isset($crypto_data['SHIB']['change24h']) ? $crypto_data['SHIB']['change24h'] : 0,
          'change_value' => 0,
        ),
      );
      $post_data = json_encode($post_data);
      $post_data = json_decode($post_data);
      set_transient( $transient_name, $post_data, HOUR_IN_SECONDS );
    }

    return $post_data;
  }

  public static function get_currencies($s, $percent = true, $echo = true) {
    $option = self::update();
    $out = '';

    if($option) {
      if ($s == 'all') {
        foreach ($option as $currency) {
          // KAPANIS
          if($currency->value == 0)
          $currency->value = number_format((float)$currency->shutdown, 3,",",".");

          $name = '<span class="site-currencies-name">'.$currency->name.'</span>';
          $value = '<span class="site-currencies-value">'. currency_format_number((float)$currency->value) .'</span>';
          $change =  $currency->change_percent;
          if ($change < 0) {
            $class = 'site-currencies-down-item';
            $icon = '<svg class="icon-trending" xmlns="http://www.w3.org/2000/svg" height="16" width="18" fill="currentColor"><path d="M3.062 15 2 13.938l5.854-5.855 3.167 3.167 4.417-4.396H13v-1.5h5v5h-1.5V7.917l-5.479 5.458-3.167-3.167Z"/></svg>';
          } else {
            $class = 'site-currencies-up-item';
            $icon = '<svg class="icon-trending" xmlns="http://www.w3.org/2000/svg" height="16" width="18" fill="currentColor"><path d="M3.062 15 2 13.938l5.854-5.855 3.167 3.167 4.417-4.396H13v-1.5h5v5h-1.5V7.917l-5.479 5.458-3.167-3.167Z"/></svg>';
          }
          if ($percent == true)
          $change = '<span class="site-currencies-change">'.$icon.' %'.$change.'</span>';
          else
          $change = '<span class="site-currencies-change">'.$icon.'</i></span>';

          // Output
          $out .= '<div class="site-currencies-item '.$class.'">'.$name.$value.$change.'</div>';
        }
      } else {
        if(!$s)
        return;
        foreach($s as $currency) {
          
          // KAPANIS
          if($option->$currency->value == 0)
          $option->$currency->value = number_format((float)$option->$currency->shutdown, 3,",",".");

          $name = '<span class="site-currencies-name">'.$option->$currency->name.'</span>';
          $value = '<span class="site-currencies-value">'. currency_format_number((float)$option->$currency->value) .'</span>';
          $change =  $option->$currency->change_percent;
          if ($change < 0) {
            $class = 'site-currencies-down-item';
            $icon = '<i class="icon-caret"></i>';
          } else {
            $class = 'site-currencies-up-item';
            $icon = '<i class="icon-caret"></i>';
          }
   
          $change = '<span class="site-currencies-change"><div>'.$icon.'</div> <div>%'.$change.'</i></div></span>';

          if(kanews_get_option('header-layout') == 'style-3') {
            $out .= '<div class="site-currencies-item '.$class.'">'.$name.$value.$change.'</div>';
          } else {
            $out .= '<div class="site-currencies-item '.$class.'">'.$name.$value.$change.'</div>';
          }


        }
      }

      if(!$echo)
      return $out;

      echo $out;
    } else {
      if( $return_empty = get_option('_transient_kanews-currencies') ) {
        if(!$echo)
        return  $return_empty;
        echo  $return_empty;
      } else {
        if(!$echo)
        return esc_html__( 'Veri alınamadı', 'kanews' );
        echo esc_html__( 'Veri alınamadı', 'kanews' );
      }
    }

  }

}