<?php
namespace Kanews\Members;
use WP_User;

class Users {

  private static $instance;

  public static function getInstance() {
    if ( null === static::$instance ) {
      static::$instance = new static();
    }
    return static::$instance;
  }

	private $user_id_being_edited;
	private $author;
	private $a = '_kan_notifications_submited';
	private $b = 'kan_user_notifications';
	
	function __construct() {
		$this->possibly_redirect();
		
		// Filters
		add_filter( 'manage_users_columns', array( $this, 'admin_user_column' ), 1 );
		add_filter( 'manage_users_custom_column', array( $this, 'admin_user_column_content'), 10, 3);

		// Account
		add_filter( 'wp_ajax_nopriv_kanews_ajax_login', array( $this, 'kanews_ajax_login' ) );
		add_filter( 'wp_ajax_nopriv_kanews_ajax_register', array( $this, 'kanews_ajax_register' ) );
		add_filter( 'wp_ajax_kanews_ajax_profile', array( $this, 'kanews_ajax_profile' ) );
		add_filter( 'wp_ajax_kanews_ajax_subscribe_category', array( $this, 'kanews_ajax_subscribe_category' ) );
		add_filter( 'wp_ajax_kanews_ilan_ilan_update', array( $this, 'kanews_ilan_ilan_update' ) );

		// Archives
		add_filter( 'template_redirect', array( $this, 'disable_author_page' ) );
		add_filter( 'wp_ajax_nopriv_kanews_ajax_contact', array( $this, 'kanews_ajax_contact' ) );
		add_filter( 'wp_ajax_kanews_ajax_contact', array( $this, 'kanews_ajax_contact' ) );
		
		// Extra Fields
		add_action( 'show_user_profile', array( $this, 'add_user_profile_fields'  ) );
		add_action( 'edit_user_profile', array( $this, 'add_user_profile_fields'  ) );
		add_action( 'personal_options_update', array( $this, 'save_user_profile_fields'  ) );
		add_action( 'edit_user_profile_update', array( $this, 'save_user_profile_fields'  ) );

		add_action( 'transition_post_status',    array( $this, 'set_publish_date' ), 10, 3 );

	}

	/**
	 * Post publish date
	 */
	function set_publish_date( $new_status, $old_status, $post  ) {
		if ( ( $new_status == 'publish' ) && ( $old_status != 'publish' ) && ( $post->post_type == 'post' || $post->post_type == 'columist' ) ) {
			$this->author = get_userdata($post->post_author);

			if(!$this->author->ID)
			return;
			
			update_user_meta($this->author->ID, 'last_post_publish_date4', current_time( 'timestamp', 1 ));
		}
	}
	
	/**
	* User ID Column
	*
	* @since 1.0.0
	* */
	function admin_user_column($columns ) {
		$columns['user_id'] = 'ID';
		$columns['user_badge'] = esc_html__('Rozetler', 'kanews');
		return $columns;
	}		
	
	/**
	* User ID Column Content
	*
	* @since 1.0.0
	* */
	function admin_user_column_content($value, $column_name, $user_id) {
		if ( 'user_id' == $column_name )
		return $user_id;

		if ( 'user_badge' == $column_name ) {
			$user = new WP_User( $user_id );
			$role = $user->roles;
			$badges = kanews_get_option('user-badge');
			$out = '';
			if (!empty($badges)){
				foreach($badges as $badge) {
					if ( isset($badge['title']) && !empty($badge['title']) && !empty($badge['role']) && isset($badge['role'])) {
						if(isset($role[0]) && $role[0] == $badge['role']){
							$out .= '<button class="button" style="margin: 0 2px;border-color:'.$badge['color'].';background-color: '.$badge['color'].';color:#fff">'.$badge['title'].'</button>';
						}
					}
				}
				return $out;
			}
		}

		return $value;
	}
	
	/**
	* My Feed
	*
	* @since 1.0.0 
	**/
	function kanews_ajax_subscribe_category() {
		// Security
		$nonce = isset( $_REQUEST['nonce'] ) ? sanitize_text_field( $_REQUEST['nonce'] ) : 0;
		if ( !wp_verify_nonce( $nonce, 'kanews-ajax-nonce' ) ) {
			exit( __( 'İzin verilmedi!', 'kanews' ) );
		}
		
		$uid = get_current_user_id();

		if ( !is_user_logged_in() ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Giriş yapmalısınız!', 'kanews' ) ) );
			exit();
		}
		
		$cats = get_user_option( 'kanews_subscribe_category', $uid );
		$authors = get_user_option( 'kanews_subscribe_authors', $uid );
		$new_cat = (isset($_POST[ 'cat_id' ] ) && !empty($_POST[ 'cat_id' ] )) ? trim( sanitize_text_field( $_POST[ 'cat_id' ] ) ) : '';
		$new_author = (isset($_POST[ 'uid' ] ) && !empty($_POST[ 'uid' ] )) ? trim( sanitize_text_field( $_POST[ 'uid' ] ) ) : '';
		
		if( !empty($new_cat) ) {
			foreach ($cats as $key => $value) {
				if($value == $new_cat) {
					unset($cats[$key]);
					update_user_option($uid, 'kanews_subscribe_category', $cats);
					wp_send_json_success();
					exit();
				}
			}
	
			$cats[] = $new_cat;
			update_user_option($uid, 'kanews_subscribe_category', $cats);
		} elseif( !empty($new_author) ) {

			if( $uid == $new_author ) {
			wp_send_json_error( array( 'message' => esc_html__( 'İzin verilmedi!', 'kanews' ) ) );
			exit();
			}

			foreach ($authors as $key => $value) {
				if($value == $new_author) {
					unset($authors[$key]);
					update_user_option($uid, 'kanews_subscribe_authors', $authors);
					wp_send_json_success();
					exit();
				}
			}
	
			$authors[] = $new_author;
			update_user_option($uid, 'kanews_subscribe_authors', $authors);
		}

		wp_send_json_success();
		exit();
	}

	/**
	* İlanı Yukarı Taşı
	*
	* @since 1.0.0 
	**/
	function kanews_ilan_ilan_update() {
			
		// Security
		$nonce = isset( $_REQUEST['nonce'] ) ? sanitize_text_field( $_REQUEST['nonce'] ) : 0;
		if ( !wp_verify_nonce( $nonce, 'kanews-ajax-nonce' ) || ! is_numeric($_REQUEST['puid']) || ! is_numeric($_REQUEST['pid']) || !is_user_logged_in() ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Yukarı taşınamadı, tekrar deneyin.', 'kanews' ) ) );
			exit();
		}

		$insights = 24 * HOUR_IN_SECONDS;
		$user_id = get_current_user_id(); 
		$subscribed = true;

		if( class_exists( 'WooCommerce' ) && kanews_get_option('ilan-insights') && $user_id == $_REQUEST['puid'] ) {
			$insights  = get_user_meta($user_id, 'kanews_insights_ilan_update_loop', true) ? get_user_meta($user_id, 'kanews_insights_ilan_update_loop', true) : 24 * HOUR_IN_SECONDS;
			$subscribed = kanews_insights_control($user_id);
		} 

		$last_update_date = get_user_option( 'ilan-last-update-date', $user_id );
		$timediff = strtotime("now") - $last_update_date; 
		if ( class_exists('Simple_Review') && kanews_get_option('ilan-sistemi') && kanews_get_option('ilan-update') && $user_id == $_REQUEST['puid'] && $subscribed && $timediff > $insights ) {
			update_user_option($user_id, 'ilan-last-update-date', strtotime("now"));
			$my_post = array(
				'ID'           => $_REQUEST['pid'],
				'menu_order'   => 0
			);
		
			wp_update_post( $my_post );
		
			global $wpdb;
			$result = $wpdb->get_results(
				"
									SELECT count(*) as cnt, max(menu_order) as max, min(menu_order) as min
									FROM $wpdb->posts
									WHERE post_type = 'ilan' AND post_status IN ('publish', 'pending', 'draft', 'private', 'future')
							"
			);
		
			// Here's the optimization
			$wpdb->query( 'SET @row_number = 0;' );
			$wpdb->query(
				"UPDATE $wpdb->posts as pt JOIN (
		
								SELECT ID, (@row_number:=@row_number + 1) AS `rank`
								FROM $wpdb->posts
								WHERE post_type = 'ilan' AND post_status IN ( 'publish', 'pending', 'draft', 'private', 'future' )
								ORDER BY menu_order ASC
							) as pt2
							ON pt.id = pt2.id
							SET pt.menu_order = pt2.`rank`;"
			);
			
			
			wp_send_json_success(array( 'message' => esc_html__( 'İlan Yukarıya Taşındı', 'kanews' )));
			exit();
		}
		
		wp_send_json_error( array( 'message' => esc_html__( 'Yukarı taşınamadı, tekrar deneyin.', 'kanews' ) ) );
		exit();

	}
	

	/**
	* Ajax Register
	*
	* @since 1.0.0 
	**/
	function kanews_ajax_register() {
		check_ajax_referer( 'register_action', 'register_field' );

		if (isset($_POST['g-recaptcha-response']) && $_POST['g-recaptcha-response'] == 0) 
		wp_send_json_error( array( 'message' => esc_html__( 'Güvenlik doğrulamasını gerçekleştirin!', 'kanews' ) ) );

		if (isset($_POST['cf-turnstile-response']) && empty($_POST['cf-turnstile-response']))
		wp_send_json_error( array( 'message' => esc_html__( 'Güvenlik doğrulamasını gerçekleştirin!', 'kanews' ) ) );

		$username = trim( sanitize_text_field( $_POST[ 'username' ] ) );
		$email = trim( sanitize_email( $_POST[ 'email' ] ) );
		$password = trim( sanitize_text_field( $_POST[ 'password' ] ) );
		$password2 = trim( sanitize_text_field( $_POST[ 'password2' ] ) );

		if ( ! is_email( $email ) ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Lütfen doğru bir e-posta adresi girin!', 'kanews' ) ) );
			exit();
		}

		if ( $password != $password2 ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Girdiğiniz şifreler eşleşmiyor!', 'kanews' ) ) );
			exit();
		}

		$uppercase = preg_match('@[A-Z]@', $password);
		$number    = preg_match('@[0-9]@', $password);
		$specialChars = preg_match('@[^\w]@', $password);

		if(!$uppercase ||!$number || !$specialChars || strlen($password) < 8) {
			wp_send_json_error( array( 'message' => esc_html__( 'Şifreniz en az 8 karakter uzunluğunda olmalı ve en az bir büyük harf, bir rakam ve bir özel karakter içermelidir.', 'kanews' ) ) );
			exit();
		}

		$register_fields = array(
			'user_login' => $username,
			'user_email' => $email,
			'user_pass'  => $password,
			'show_admin_bar_front' => 'false',
			'role' => get_option('default_role', 'subscriber')
		);

		$register_status = wp_insert_user( $register_fields );

		if ( is_wp_error( $register_status ) ) {
			wp_send_json_error( array( 'message' => $register_status->get_error_message() ) );
			exit();
		}

		$user = get_user_by( 'ID', $register_status );
		wp_set_auth_cookie( $user->ID );
		wp_set_current_user( $user->ID );
		do_action( 'wp_login', $user->user_login, $user );

		wp_send_json_success( array( 'message' => esc_html__( 'Kaydınız tamamlanmıştır, yönlendiriliyorsunuz..', 'kanews' ) ) );
		exit();
	}

	/**
	* Ajax contact form
	*
	* @since 1.0.0 
	**/
	function kanews_ajax_contact() {
		check_ajax_referer( 'contact_action', 'contact_field' );

		if (isset($_POST['g-recaptcha-response']) && $_POST['g-recaptcha-response'] == 0) 
		wp_send_json_error( array( 'message' => esc_html__( 'Güvenlik doğrulamasını gerçekleştirin!', 'kanews' ) ) );

		if (isset($_POST['cf-turnstile-response']) && empty($_POST['cf-turnstile-response']))
		wp_send_json_error( array( 'message' => esc_html__( 'Güvenlik doğrulamasını gerçekleştirin!', 'kanews' ) ) );

		$pid = trim( sanitize_text_field( $_POST[ 'pid' ] ) );
		$to = trim( sanitize_text_field( $_POST[ 'to' ] ) );
		$name = trim( sanitize_text_field( $_POST[ 'name' ] ) );
		$surname = trim( sanitize_text_field( $_POST[ 'surname' ] ) );
		$phone = trim( sanitize_text_field( $_POST[ 'phone' ] ) );
		$subject = trim( sanitize_text_field( $_POST[ 'subject' ] ) );
		$email = trim( sanitize_email( $_POST[ 'email' ] ) );
		$comment = trim( sanitize_text_field( $_POST[ 'comment' ] ) );

		$qua = [
			'0' => [
				'question' => '3*3=?',
				'answer' => '9'
			],
			'1' => [
				'question' => '1*3=?',
				'answer' => '3'
			],
			'2' => [
				'question' => '2+2=?',
				'answer' => '4'
			],
			'3' => [
				'question' => '1+8=?',
				'answer' => '9'
			],
			'4' => [
				'question' => '5*0=?',
				'answer' => '0'
			],
			'5' => [
				'question' => '2+2=?',
				'answer' => '4'
			],
			'6' => [
				'question' => 'Türkiye\'nin Başkenti?',
				'answer' => 'Ankara'
			],
		];

		$answer = $_POST[ 'qua' ]; 
		$number_answer = $_POST[ 'qua1' ];

		if($qua[$number_answer]['answer'] != $answer) {
			wp_send_json_error( array( 'message' => esc_html__( 'Lütfen güvenlik sorusunu doğru yanıtlayın!', 'kanews' ) ) );
			exit();
		}
		$body = 'Kimden: '.$name.' '.$surname.' <a href="mailto:'.$email.'">'.$email.'</a><br>Konu: '.$subject.'<br>Telefon: '.$phone.'<br><br>İleti gövdesi:<br>'.$comment.'<br><br>Bu e-posta, '.get_bloginfo('name').' (<a rel="noreferrer" target="_blank" href="'.get_the_permalink($pid).'">'.get_the_permalink($pid).'</a>) adresindeki iletişim formundan gönderildi.<br><br></span>';
		$headers = array('Content-Type: text/html; charset=UTF-8', 'Reply-To: '.$name.' '.$surname.' <'.$email.'>');

		$mail = wp_mail( $to, $subject, $body, $headers );

		if ( is_wp_error( $mail ) ) {
			wp_send_json_error( array( 'message' => $mail->get_error_message() ) );
			exit();
		}

		wp_send_json_success( array( 'message' => esc_html__( 'Mesajınız iletilmiştir, yönlendiriliyorsunuz..', 'kanews' ) ) );
		exit();
	}

	/**
	* Ajax profile update
	*
	* @since 1.0.0 
	**/
	function kanews_ajax_profile(){
		check_ajax_referer( 'profile_action', 'profile_field' );

		if (isset($_POST['g-recaptcha-response']) && $_POST['g-recaptcha-response'] == 0)
		wp_send_json_error( array( 'message' => esc_html__( 'Güvenlik doğrulamasını gerçekleştirin!', 'kanews' ) ) );

		if (isset($_POST['cf-turnstile-response']) && empty($_POST['cf-turnstile-response']) ) 
		wp_send_json_error( array( 'message' => esc_html__( 'Güvenlik doğrulamasını gerçekleştirin!', 'kanews' ) ) );

		$user_id = get_current_user_id();

		if(!kanews_user_status($user_id)) {
			wp_send_json_error( array( 'message' => esc_html__( 'Değişiklikler kaydedilmemiştir lütfen e-posta adresinizi doğrulayın!', 'kanews' ) ) );
			exit();
		}

		$nickname = trim( sanitize_text_field( $_POST[ 'nickname' ] ) );
		$first_name = trim( sanitize_text_field( $_POST[ 'first-name' ] ) );
		$last_name = trim( sanitize_text_field( $_POST[ 'last-name' ] ) );
		$display_name = trim( sanitize_text_field( $_POST[ 'display_name' ] ) );
		$email = trim( sanitize_text_field( $_POST[ 'email' ] ) );
		$pass1 = trim( sanitize_text_field( $_POST[ 'pass1' ] ) );
		$pass2 = trim( sanitize_text_field( $_POST[ 'pass2' ] ) );

		if ( !empty( $email ) ){
			if (!is_email($email)) {
				wp_send_json_error( array( 'message' => esc_html__( 'Lütfen doğru bir e-posta adresi girin!', 'kanews' ) ) );
				exit();
			} elseif( email_exists($email ) && email_exists($email) != $user_id ) {
				wp_send_json_error( array( 'message' => esc_html__( 'Bu e-posta başka bir kullanıcı tarafından kullanılıyor. farklı bir e-posta adresi deneyin.', 'kanews' ) ) );
				exit();
			} else {
				
				$gsa = get_userdata( $user_id );
				$old_user_email = $gsa->user_email;
				if ( $_POST['email'] !== $old_user_email ) {
					wp_update_user( array ('ID' => $user_id, 'user_email' => esc_attr( $_POST['email'] )));
					delete_user_meta( $user_id, '_kanews_user_activation' );
					if(!kanews_user_status($user_id))
					kanews_send_user_activation_mail($user_id);
				}
				
			}
		}

		if ( !empty( $pass1 ) && !empty( $pass2 ) ) {
			if ( $pass1 != $pass2 ) {
				wp_send_json_error( array( 'message' => esc_html__( 'Girdiğiniz şifreler eşleşmiyor!', 'kanews' ) ) );
				exit();
			} else {
				wp_update_user( array( 'ID' => $user_id, 'user_pass' => $pass1 ) );
			}
		}

		$user_fields = array(
			'ID'           => $user_id,
			'nickname'     => $nickname,
			'first_name'   => $first_name,
			'last_name'    => $last_name,
			'display_name' => $display_name
		);

		$user_result = wp_update_user( $user_fields );
		
		update_user_meta( $user_id,'my_city', esc_attr( $_POST['my_city'] ) );
		update_user_meta( $user_id,'facebook_profile', esc_attr( $_POST['facebook_profile'] ) );
		update_user_meta( $user_id,'twitter_profile', esc_attr( $_POST['twitter_profile'] ) );
		update_user_meta( $user_id,'instagram_profile', esc_attr( $_POST['instagram_profile'] ) );
		update_user_meta( $user_id,'linkedin_profile', esc_attr( $_POST['linkedin_profile'] ) );
		update_user_meta( $user_id,'youtube_profile', esc_attr( $_POST['youtube_profile'] ) ); 
		update_user_meta( $user_id,'telegram_profile', esc_attr( $_POST['telegram_profile'] ) ); 
		update_user_meta( $user_id,'description', esc_html( $_POST['description'] ) ); 


		if ( get_the_author_meta('_kan_social_scored', $user_id) != '1' && kanews_get_option('scoring_system') && ( !empty($_POST['facebook_profile']) || !empty($_POST['twitter_profile']) || !empty($_POST['instagram_profile']) || !empty($_POST['linkedin_profile']) ||!empty($_POST['youtube_profile']) || !empty($_POST['youtube_profile']) ) ) {
			$points = get_user_meta( $user_id, 'kan_user_score', true );
			$points += kanews_get_option('social_score', 5);
			update_user_meta( $user_id, 'kan_user_score', $points );
			update_user_meta( $user_id, '_kan_social_scored', '1' );
			if( kanews_get_option('notifications') ) {
				date_default_timezone_set('Europe/Istanbul');
				Notifications::message( $user_id , array(
					'points'  => 'social',
					'date' => current_time( 'timestamp', 1 )
				) );
			}
		}
		

		if ( is_wp_error( $user_result ) ) {
			wp_send_json_error( array( 'message' => $user_result->get_error_message() ) );
			exit();
		}
		

		wp_send_json_success( array( 'message' => __( 'Profiliniz güncellenmiştir!', 'kanews' ) ) );
		exit();
	}

	/**
	* Ajax Login
	*
	* @since 1.0.0 
	**/
	function kanews_ajax_login(){

		if (isset($_POST['g-recaptcha-response']) && $_POST['g-recaptcha-response'] == 0 ) 
		wp_send_json_error( array( 'message' => esc_html__( 'Güvenlik doğrulamasını gerçekleştirin!', 'kanews' ) ) );

		if ( ! check_ajax_referer( 'login_action', 'login_field', false )) 
		wp_send_json_error( array( 'message' => esc_html__( 'Ön bellek sebebiyle doğrulama gerçekleştirilemedi, site yöneticisine başvurarak bu sayfanın ön bellekleğinin temizlenmesini veya ön belleklemeden muaf hale getirilmesini isteyiniz.', 'kanews' ) ) );

		$username = trim( sanitize_text_field( $_POST[ 'username' ] ) );
		$password = trim( sanitize_text_field( $_POST[ 'password' ] ) );
		$remember = isset($_POST[ 'rememberme' ]) ? trim( sanitize_text_field( $_POST[ 'rememberme' ] ) ) : false;

		$login_fields = array(
			'user_login'    => $username,
			'user_password' => $password,
			'remember'      => $remember
		);

		$login_status = wp_signon( $login_fields, is_ssl() );

		if ( is_wp_error( $login_status ) ) {
			wp_send_json_error( array( 'message' => $login_status->get_error_message() ) );
			exit();
		}

		wp_send_json_success( array( 'message' => esc_html__( 'Giriş başarılı, yönlendiriliyorsunuz..', 'kanews' ) ) );
		exit();
	}

	/**
	* Disable subscriber author archives
	*
	* @since 1.0.1
	**/
	function disable_author_page() {
		if(!is_author())
		return;

		global $wp_query;
		$user_info = get_userdata( $wp_query->query_vars['author'] );
		$user_roles = implode(', ', $user_info->roles);

		if ( $user_roles ==  "subscriber") {
			wp_redirect(get_option('home'), 301); 
			exit; 
		}
	}

	public function possibly_redirect(){
		$page = kanews_get_option('account-page') ? kanews_get_option('account-page') : '';
		if (kanews_get_option('wp-admin-redirect') == true && $page != '' && kanews__get__status() == true) {
			global $pagenow;
			if( 'wp-login.php' == $pagenow ) {
				if ( isset( $_POST['wp-submit'] ) ||   // in case of LOGIN
					( isset($_GET['action']) && $_GET['action']=='logout') ||   // in case of LOGOUT
					( isset($_GET['checkemail']) && $_GET['checkemail']=='confirm') ||   // in case of LOST PASSWORD
					( isset($_GET['checkemail']) && $_GET['checkemail']=='registered') ||    // in case of REGISTER
					( isset($_GET['action']) == 'rp') ||
					( isset($_GET['loginSocial'])) ||
					( isset($_GET['action']) == 'lostpassword') ) return;
				else wp_redirect(get_page_link($page));
				exit();
			}
		}
	}

	public function save_user_profile_fields( $user_id) {
		if(isset($_POST['facebook_profile']))
		update_user_meta( $user_id,'facebook_profile', sanitize_text_field( $_POST['facebook_profile'] ) );
		if(isset($_POST['twitter_profile']))
		update_user_meta( $user_id,'twitter_profile', sanitize_text_field( $_POST['twitter_profile'] ) );
		if(isset($_POST['instagram_profile']))
		update_user_meta( $user_id,'instagram_profile', sanitize_text_field( $_POST['instagram_profile'] ) );
		if(isset($_POST['linkedin_profile']))
		update_user_meta( $user_id,'linkedin_profile', sanitize_text_field( $_POST['linkedin_profile'] ) );
		if(isset($_POST['youtube_profile']))
		update_user_meta( $user_id,'youtube_profile', sanitize_text_field( $_POST['youtube_profile'] ) ); 
		if(isset($_POST['telegram_profile']))
		update_user_meta( $user_id,'telegram_profile', sanitize_text_field( $_POST['telegram_profile'] ) ); 
	}

	public function add_user_profile_fields( $user, $false = 'on' ) { if(is_admin()): ?>
		<table class="form-table">
			<tr>
				<th><label for="facebook_profile"><?php _e('Facebook Kullanıcı Adınız','kanews'); ?></label></th>
				<td>
					<input type="text" name="facebook_profile" value="<?php echo esc_attr(get_the_author_meta( 'facebook_profile', $user->ID )); ?>" class="regular-text" />
				</td>
			</tr>
			<tr>
				<th><label for="twitter_profile"><?php _e('Twitter Kullanıcı Adınız','kanews'); ?></label></th>
				<td>
					<input type="text" name="twitter_profile" value="<?php echo esc_attr(get_the_author_meta( 'twitter_profile', $user->ID )); ?>" class="regular-text" />
				</td>
			</tr>
			<tr>
				<th><label for="instagram_profile"><?php _e('Instagram Kullanıcı Adınız','kanews'); ?></label></th>
				<td>
					<input type="text" name="instagram_profile" value="<?php echo esc_attr(get_the_author_meta( 'instagram_profile', $user->ID )); ?>" class="regular-text" />
				</td>
			</tr>
			<tr>
				<th><label for="linkedin_profile"><?php _e('Linkedin Kullanıcı Adınız','kanews'); ?></label></th>
				<td>
					<input type="text" name="linkedin_profile" value="<?php echo esc_attr(get_the_author_meta( 'linkedin_profile', $user->ID )); ?>" class="regular-text" />
				</td>
			</tr>
			<tr>
				<th><label for="youtube_profile"><?php _e('Youtube Kanal idsi','kanews'); ?></label></th>
				<td>
					<input type="text" name="youtube_profile" value="<?php echo esc_attr(get_the_author_meta( 'youtube_profile', $user->ID )); ?>" class="regular-text" />
				</td>
			</tr>
			<tr>
				<th><label for="telegram_profile"><?php _e('Telegram Kullanıcı Adınız','kanews'); ?></label></th>
				<td>
					<input type="text" name="telegram_profile" value="<?php echo esc_attr(get_the_author_meta( 'telegram_profile', $user->ID )); ?>" class="regular-text" />
				</td>
			</tr>
		</table>
	<?php endif; }

}
