<?php
namespace Kanews;
use CSF;

Class Shortcode {
  private static $instance;
  public $prefix;
  public $lorem_ipsum;

  public static function getInstance() {
    if (class_exists( 'CSF') && is_admin() && null === static::$instance) {
      static::$instance = new static();
    }
    return static::$instance;
  }

  private function __construct() {
    $this->prefix = 'kanews_shortcodes';
    $this->lorem_ipsum = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.';
    $this->set_framework();
    $this->create_seciton();

    /* Add Next Page Button in First Row */
    add_filter( 'mce_buttons', array($this, 'page_break_button'), 1, 2 ); // 1st row
  }

  /**
   * Add Next Page/Page Break Button
   * in WordPress Visual Editor
   * 
   * @link https://shellcreeper.com/?p=889
   */
  function page_break_button( $buttons, $id ){
  
      /* only add this for content editor */
      if ( 'content' != $id )
          return $buttons;
  
      /* add next page after more tag button */
      array_splice( $buttons, 13, 0, 'wp_page' );
  
      return $buttons;
  }

  public function set_framework() {
    CSF::createShortcoder( $this->prefix, array(
      'button_title' => esc_html__('Kanews Kısakodları'),
      'gutenberg'    => array(
        'title' => esc_html__('Kanews Kısakodları'),
        'icon'  => 'superhero'
      )
    ) );
  }

  public function create_seciton() {

    $shortcodes = array(
      'title' => esc_html__('Başlık', 'kanews'),
      
      'btn' => esc_html__('Buton', 'kanews'),
      'alert' => esc_html__('Bilgi Kutusu', 'kanews'),
      'accordion' => esc_html__('Sıkça Sorular Sorular', 'kanews'),
      'sources' => esc_html__('Kaynak', 'kanews'),
      'dropcap' => esc_html__('Büyük Harf', 'kanews'),
      'highlight' => esc_html__('Vurgula', 'kanews'),
      'related-post' => esc_html__('İlişkili Yazı', 'kanews'),
      'related-posts' => esc_html__('Benzer Yazılar', 'kanews'),
      
      'read-more' => esc_html__('İçerik Gizle', 'kanews'),
      'prayer' => esc_html__('Namaz Vakitleri', 'kanews'),
      'currencies' => esc_html__('Piyasalar', 'kanews'),
      'exchange' => esc_html__('Borsa', 'kanews'),
      
      'calculator' => esc_html__('Çevirici', 'kanews'),
      'weather' => esc_html__('Hava Durumu', 'kanews'),

      'timeline' => esc_html__('Zaman Çizelgesi', 'kanews'),
    );

    foreach ( $shortcodes as $shortcode => $title ) {
      $function = str_replace( '-', '_', $shortcode ).'_fields';
      $section  = array(
        'title'     => $title,
        'view'      => 'normal', 
        'shortcode' => 'kanews-'.$shortcode, 
        'fields'    => $this->$function()
      );
      if( $shortcode == 'sources' || $shortcode == 'accordion' ) {
        $section['view'] = 'group';
        $section['fields'] = array();
        if( $shortcode == 'accordion' )
        $section['group_shortcode'] = 'kanews-collapse';
        else
        $section['group_shortcode'] = substr('kanews-'.$shortcode,0,-1);
        $section['group_fields'] = $this->$function();
      }
      CSF::createSection( $this->prefix, $section );

    }

  
  }


  public static function helpers($type) {
    if( $type == 'bgcolor' ) {
      return array(
        ''	=> esc_html__( 'Birincil Renk', 'kanews' ),
        'bg-info'	=> esc_html__( 'Mavi', 'kanews' ),
        'bg-danger'	=> esc_html__( 'Kırmızı', 'kanews' ),
        'bg-warning'	=> esc_html__( 'Turuncu', 'kanews' ),
        'bg-dark'	=> esc_html__( 'Siyah', 'kanews' ),
        'bg-success'	=> esc_html__( 'Yeşil', 'kanews' ),
      );
    }elseif( $type == 'color' ) {
      return array(
        ''	=> esc_html__( 'Birincil Renk', 'kanews' ),
        'color-info'	=> esc_html__( 'Mavi', 'kanews' ),
        'color-danger'	=> esc_html__( 'Kırmızı', 'kanews' ),
        'color-warning'	=> esc_html__( 'Turuncu', 'kanews' ),
        'color-dark'	=> esc_html__( 'Siyah', 'kanews' ),
        'color-success'	=> esc_html__( 'Yeşil', 'kanews' ),
      );
    }elseif( $type == 'html' ) {
      return array(
        'div'	=> 'div',
        'h1'	=> 'h1',
        'h2'	=> 'h2',
        'h3'	=> 'h3',
        'h4'	=> 'h4',
        'h5'	=> 'h5',
        'h6'	=> 'h6',
      );
    }
  }

  public function timeline_fields() {
    $setting = array();

    $setting[] = array(
      'id'      => 'date',
      'title'   => esc_html__( 'Saat', 'kanews' ),
      'type'    => 'text',
    );

    $setting[] = array(
      'id'      => 'content',
      'type'    => 'wp_editor',
      'title'   => esc_html__( 'İçerik', 'kanews' ),
      'default' => '<h2>'.$this->lorem_ipsum.'</h2><p>'.$this->lorem_ipsum.'</p>'
    );

 
    
    return $setting;
  }

  public function calculator_fields() {
    $setting = array();

    $setting[] = array(
      'id'      => 'tur',
      'type'    => 'select',
      'title'   => esc_html__( 'Araçlar', 'kanews' ),
      'options' => array(
        'doviz'	=> esc_html__( 'Döviz Çevirici', 'kanews' ),
        'emtia'	=> esc_html__( 'Altın Çevirici', 'kanews' ),
        'coin'	=> esc_html__( 'Kripto Para Çevirici', 'kanews' ),
        'burc'	=> esc_html__( 'Burç', 'kanews' ),
        'vki'	  => esc_html__( 'Vücut Kitle İndeksi', 'kanews' ),
        'kredi'	  => esc_html__( 'Kredi Hesaplayıcı', 'kanews' ),
        'birikim'	  => esc_html__( 'Bireysel Yatırım Hesaplayıcı', 'kanews' ),
      )
    );
    return $setting;
  }

  public function btn_fields() {
    $setting = array();

    $setting[] = array(
      'id'      => 'color',
      'type'    => 'select',
      'title'   => esc_html__( 'Renk', 'kanews' ),
      'options' => $this->helpers('bgcolor')
    );

    $setting[] = array(
      'id'      => 'size',
      'type'    => 'select',
      'title'   => esc_html__( 'Boyut', 'kanews' ),
      'options' => array(
        ''	=> esc_html__( 'Büyük', 'kanews' ),
        'kanews-btn-sm'	=> esc_html__( 'Küçük', 'kanews' ),
        'kanews-btn-block'	=> esc_html__( 'Blok', 'kanews' )
      )
    );

    $setting[] = array(
      'id'      => 'link',
      'title'   => esc_html__( 'Link', 'kanews' ),
      'type'    => 'text',
      'validate'=> 'csf_validate_url',
    );

    $setting[] = array(
      'id'      => 'target',
      'title'   => esc_html__( 'Yeni Sekmede Aç', 'kanews' ),
      'type'    => 'switcher',
    );

    $setting[] = array(
      'id'      => 'content',
      'title'   => esc_html__( 'Yazı', 'kanews' ),
      'type'    => 'text',
    );

    return $setting;
  }

  public function alert_fields() {
    $setting = array();

    $setting[] = array(
      'id'      => 'color',
      'type'    => 'select',
      'title'   => esc_html__( 'Renk', 'kanews' ),
      'options' => $this->helpers('bgcolor')
    );

    $setting[] = array(
      'id'      => 'content',
      'type'    => 'wp_editor',
      'title'   => esc_html__( 'İçerik', 'kanews' ),
      'default' => $this->lorem_ipsum
    );

    return $setting;
  }

  public function dropcap_fields() {
    $setting = array();

    $setting[] = array(
      'id'      => 'color',
      'type'    => 'select',
      'title'   => esc_html__( 'Renk', 'kanews' ),
      'options' => $this->helpers('color')
    );

    $setting[] = array(
      'id'      => 'content',
      'type'    => 'text',
      'title'   => esc_html__( 'İçerik', 'kanews' ),
      'default' => 'K'
    );

    return $setting;
  }

  public function highlight_fields() {
    $setting = array();

    $setting[] = array(
      'id'      => 'content',
      'type'    => 'text',
      'title'   => esc_html__( 'İçerik', 'kanews' ),
      'default' => $this->lorem_ipsum
    );

    return $setting;
  }

  public function related_posts_fields() {
    $setting = array();

    $setting[] = array(
      'id'      => 'title',
      'type'    => 'text',
      'title'   => esc_html__( 'Başlık', 'kanews' ),
    );

    $setting[] = array(
      'id'      => 'p',
      'type'    => 'select',
      'chosen'  => true,
      'sortable'=> true,
      'ajax'    => true,
      'multiple'=> true,
      'title'   => esc_html__( 'Gösterilecek Yazılar', 'kanews' ),
      'options' => 'posts'
    );

    $setting[] = array(
      'id'      => 'tag',
      'type'    => 'select',
      'title'   => esc_html__( 'HTML Tag', 'kanews' ),
      'options' => $this->helpers('html')
    );

    $setting[] = array(
      'id'      => 'style',
      'type'    => 'select',
      'title'   => esc_html__( 'Görünüm', 'kanews' ),
      'default' => '2',
      'options' => array(
        '1' => '1',
        '2' => '2'
      )
    );

    return $setting;
  }

  public function related_post_fields() {
    $setting = array();

    $setting[] = array(
      'id'      => 'title',
      'type'    => 'text',
      'title'   => esc_html__( 'Başlık', 'kanews' ),
    );

    $setting[] = array(
      'id'      => 'ids',
      'type'    => 'select',
      'chosen'  => true,
      'sortable'=> true,
      'ajax'    => true,
      'multiple'=> false,
      'title'   => esc_html__( 'Gösterilecek Yazılar', 'kanews' ),
      'options' => 'posts'
    );

    $setting[] = array(
      'id'      => 'tag',
      'type'    => 'select',
      'title'   => esc_html__( 'HTML Tag', 'kanews' ),
      'options' => $this->helpers('html')
    );

    return $setting;
  }

  public function title_fields() {
    $setting = array();

    $setting[] = array(
      'id'      => 'title',
      'type'    => 'text',
      'title'   => esc_html__( 'Başlık', 'kanews' ),
    );

    $setting[] = array(
      'id'      => 'tag',
      'type'    => 'select',
      'title'   => esc_html__( 'HTML Tag', 'kanews' ),
      'options' => $this->helpers('html')
    );

    return $setting;
  }

  public function read_more_fields() {
    $setting = array();

    $setting[] = array(
      'id'      => 'content',
      'type'    => 'wp_editor',
      'title'   => esc_html__( 'Gizlenecek İçerik', 'kanews' ),
    );

    return $setting;
  }

  public function prayer_fields() {
    $setting = array();

    foreach ( kanews_get_turkey_cities2() as $key => $value ) {
      $sehirler[$value] = $value;
    }

    $setting[] = array(
      'id'      => 'city',
      'type'    => 'select',
      'options' => array_slice($sehirler, 0, -6),
      'title'   => esc_html__( 'Şehir', 'kanews' ),
    );

    return $setting;
  }

  public function exchange_fields() {
    $setting = array();

    $setting[] = array(
      'id'      => 'hisse',
      'type'    => 'text',
      'title'   => esc_html__( 'Hisse Kısaltması', 'kanews' ),
    );

    return $setting;
  }

  public function currencies_fields() {
    $setting = array();

    $setting[] = array(
      'id'      => 'currencies',
      'type'    => 'button_set',
      'multiple' => true,
      'options' => array(
        'usd' => esc_html__('Dolar', 'kanews'),
        'euro' => esc_html__('Euro', 'kanews'),
        'chf' => esc_html__('İsviçre Frangı', 'kanews'),
        'jpy' => esc_html__('Japon Yeni', 'kanews'),
        'rub' => esc_html__('Rus Rublesi', 'kanews'),
        'rub' => esc_html__('Rus Rublesi', 'kanews'),
        'cny' => esc_html__('Çin Yuanı', 'kanews'),
        'gbp' => esc_html__('İngiliz Sterlini', 'kanews'),
        'eur-usd' => esc_html__('Euro/Dolar', 'kanews'),
        'ise-100' => esc_html__('Bist 100', 'kanews'),
        'ukoil' => esc_html__('Petrol', 'kanews'),
        'gau' => esc_html__('Gram Altın', 'kanews'),
        'btc' => esc_html__('Bitcoin', 'kanews'),
        'eth' => esc_html__('Ethereum', 'kanews'),
        'bch' => esc_html__('Bitcoin Cash', 'kanews'),
        'xrp' => esc_html__('XRP', 'kanews'),
        'ltc' => esc_html__('Litecoin', 'kanews'),
        'bnb' => esc_html__('Binance Coin', 'kanews'),
        'sol' => esc_html__('Solana', 'kanews'),
        'avax' => esc_html__('Avalanche', 'kanews'),
        'ada' => esc_html__('Cardano', 'kanews'),
        'dot' => esc_html__('Polkadot', 'kanews'),
        'doge' => esc_html__('Doge Coin', 'kanews'),
        'shib' => esc_html__('Shiba Inu', 'kanews')
      ),
      'title'   => esc_html__( 'Gözükecek Para Birimleri', 'kanews' ),
    );

    return $setting;
  }

  public function sources_fields() {
    $setting = array();

    $setting[] = array(
      'id'      => 'link',
      'type'    => 'text',
      'validate'=> 'csf_validate_url',
      'title'   => esc_html__( 'Link', 'kanews' ),
    );

    $setting[] = array(
      'id'      => 'content',
      'type'    => 'text',
      'title'   => esc_html__( 'Ad', 'kanews' ),
    );

    

    return $setting;
  }

  public function accordion_fields() {
    $setting = array();

    $setting[] = array(
      'id'      => 'active',
      'type'    => 'switcher',
      'title'   => esc_html__( 'Açık', 'kanews' ),
    );

    $setting[] = array(
      'id'      => 'title',
      'type'    => 'text',
      'title'   => esc_html__( 'Başlık', 'kanews' ),
    );

    $setting[] = array(
      'id'      => 'content',
      'type'    => 'wp_editor',
      'title'   => esc_html__( 'İçerik', 'kanews' ),
    );

    return $setting;
  }

  public function weather_fields() {
    $setting = array();

    $setting[] = array(
      'id'      => 'city',
      'type'    => 'text',
      'title'   => esc_html__( 'Şehir', 'kanews' ),
    );

    return $setting;
  }

}