<?php
namespace Kanews\Util;

class Speed {

  private static $instance;

  public static function getInstance() {
    if ( null === static::$instance ) {
      static::$instance = new static();
    }
    return static::$instance;
  }

	function __construct() {
		if( ! kanews_get_option('kanews-speed') )
		return;
	
		add_action( 'wp_resource_hints',             array( $this, 'resource_hints' ), 10, 2 );
		add_action( 'wp_head',             			 array( $this, 'preload_resources' ), 1 );
		add_filter( 'script_loader_tag',             array( $this, 'add_defer_attribute' ), 10, 2 );
		
		add_filter( 'xmlrpc_enabled',                '__return_false', 5 );
		remove_action( 'wp_head',                    'rsd_link' );
		remove_action( 'wp_head',                    'wlwmanifest_link' );
		
		remove_filter( 'the_title',                  'capital_P_dangit', 11 );
		remove_filter( 'the_content',                'capital_P_dangit', 11 );
		remove_filter( 'comment_text',               'capital_P_dangit', 31 );
		remove_filter( 'wp_title',              		 'capital_P_dangit', 31 );
		
		add_filter( 'wpcf7_load_js',                 '__return_false' );
		add_filter( 'wpcf7_load_css',                '__return_false' );


		remove_action( 'wp_print_styles',            'print_emoji_styles');
		remove_action( 'wp_head',                    'print_emoji_detection_script', 7);
		remove_filter( 'the_excerpt',                'convert_smilies' );
		remove_filter( 'the_post_thumbnail_caption', 'convert_smilies' );
		remove_filter( 'the_content',                'convert_smilies', 20 );
		remove_filter( 'comment_text',               'convert_smilies', 20 );
		remove_filter( 'widget_text_content',        'convert_smilies', 20 );
		
		add_filter( 'script_loader_src',  			 array( $this, 'remove_query_strings' ), 15, 2 );
		add_filter( 'style_loader_src',   			 array( $this, 'remove_query_strings' ), 15, 2 );
		
	}


	// Resource
	function resource_hints( $hints, $relation_type ) {

		if ( 'dns-prefetch' === $relation_type && kanews_get_option('kanews-dns-prefetch', true) ) {
			$hints[] = '//s.gravatar.com';
			$hints[] = '//fonts.googleapis.com';
			$hints[] = '//fonts.gstatic.com';
			$hints[] = '//cdnjs.cloudflare.com';
			$hints[] = '//www.google-analytics.com';
		}

		return $hints;
	
	}
	
	// Preload
	function preload_resources(){

		if(!kanews_get_option('kanews-preload', true))
		return false;
		
		// Styles
		if( wp_style_is( 'kanews-theme' ) ) 
		echo "<link rel='preload' as='style' href='".get_template_directory_uri()."/assets/css/theme.min.css' />\n";

		// Styles
		if( wp_style_is( 'kanews-theme-single' ) && is_singular() ) 
		echo "<link rel='preload' as='style' href='".get_template_directory_uri()."/assets/css/theme-single.min.css' />\n";

		// Fonts
		echo "<link rel='preload' as='font' href='".get_template_directory_uri()."/assets/fonts/icomoon.woff' type='font/woff' crossorigin='anonymous' />\n";

	}

	function remove_query_strings($src, $handle) {
		if($handle != 'child-style'){
			$src = remove_query_arg('ver', $src);
		}
		return $src;
	}
	
	// Add Defer
	function add_defer_attribute( $tag, $handle ) {

		if(!kanews_get_option('kanews-js-defer', true))
		return $tag;

		if ( ( strpos( $handle, 'kanews-') !== false || strpos( $handle, 'comment-reply') !== false ) && ! is_admin() ) {
			return str_replace( ' src', ' defer="defer" src', $tag );
		}

		return $tag;
	}

}
