<?php
/**
* The template for displaying comments
*
* This is the template that displays the area of the page that contains both the current comments
* and the comment form.
*
* @link https://developer.wordpress.org/themes/basics/template-hierarchy/
*
* @package Kanews
*/

defined( 'ABSPATH' ) || exit; // Exit if accessed directly

/*
* If the current post is protected by a password and
* the visitor has not yet entered the password we will
* return early without loading the comments.
*/
if ( post_password_required() ) {
return;
}
$login = '';
if(!is_user_logged_in() && kanews_get_option('login-system') == true) {
	$login = '<button class="kanews-btn kanews-btn-sm kanews-btn-o" data-toggle="kanews-modal-login">'.esc_html__( 'Giriş Yap', 'kanews' ).'</button>';
}
$commenter = wp_get_current_commenter();
$req = get_option( 'require_name_email' );
$aria_req = ( $req ? " aria-required='true'" : '' );
$fields = array (
	'author' => '<div class="kanews-form bgw"><input id="author" class="comment-input" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) .'" size="30"' . $aria_req . ' /><label for="author">' . __( 'Adınız', 'kanews' ) .( $req ? '<span class="required color-danger"> *</span>' : '' ) . '</label>' .'</div>',
	'email' => '<div class="kanews-form bgw"><input id="email" class="comment-input" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) .'" size="30"' . $aria_req . ' /><label for="email">' . __( 'E-Posta', 'kanews' ) . ( $req ? '<span class="required color-danger"> *</span>' : '' ) . '</label>' .'</div>',
	'cookies' => '<div class="d-flex mt-2"><div class="kanews-form"><input id="wp-comment-cookies-consent" name="wp-comment-cookies-consent" value="yes" type="checkbox" required></div> <label style="margin-top: 3px" for="wp-comment-cookies-consent">'.esc_html__('Bir dahaki sefere yorum yaptığımda kullanılmak üzere adımı, e-posta adresimi ve web site adresimi bu tarayıcıya kaydet.', 'kanews').'</label></div>',
);
$args = array(
	'id_form'           => 'commentform',
	'class_form'        => 'comment-form',
	'id_submit'         => 'submit',
	'class_submit'      => 'kanews-btn kanews-btn-sm',
	'submit_button'     => '<div class="kanews-btn-group"><button name="%1$s" type="submit" id="%2$s" class="%3$s">%4$s</button>'.$login.'</div>',
	'name_submit'       => 'submit',
	'title_reply'       => '<label>'.kanews_translate('write-a-comment-text', __( 'Bir Cevap Yaz', 'kanews' )).'</label>',
	'title_reply_to'    => __( 'Bir Cevap Yaz %s', 'kanews' ),
	'cancel_reply_link' => __( 'İptal', 'kanews' ),
	'label_submit'      => __( 'Yorum Gönder', 'kanews' ),
	'title_reply_before'=> '<div class="kanews-section-heading kanews-section-flat-heading"><h3 class="kanews-section-headline"><span>',
	'title_reply_after' => '</span></h3></div>',
	'format'            => 'xhtml',
	'comment_field'     =>  '<div class="kanews-form bgw"><textarea class="comment-input" id="comment" name="comment" cols="45" rows="4" aria-required="true" required>' .'</textarea><label for="comment">' . __( 'Yorumunuz', 'kanews' ) . ( $req ? '<span class="required color-danger"> *</span>' : '' ) .'</label></div>',
	'fields' 					  => apply_filters( 'comment_form_default_fields', $fields ),
);
?>
<div id="comments" class="comments-area kanews-section-box">

<?php if ( comments_open() && ! kanews_get_option('show-post-comments') ) :
	$count = get_comments_number( $post->ID ); 
	comment_form($args);
	if ( have_comments() ) : ?>

		<div class="comments-list">
			<div class="kanews-tab kanews-tab-4 mt-1">
			<?php if( kanews_get_option('show-popular-comments') ): ?>
				<ul class="nav nav-tabs d-flex flex-wrap" id="comment-tab" role="tablist">
					<li class="nav-item" role="presentation">
						<div class="nav-link active" id="comment-recent-tab" data-toggle="tab" href="#comment-recent" role="tab" data-controls="comment-recent" data-selected="true"><?php echo esc_html__( 'Tarihe Göre', 'kanews' ); ?></div>
					</li>
					<li class="nav-item" role="presentation">
						<div class="nav-link" id="comment-popular-tab" data-toggle="tab" href="#comment-popular" role="tab" data-controls="comment-popular" data-selected="false"><?php echo esc_html__( 'Beğeniye Göre', 'kanews' ); ?></div>
					</li>
				</ul>
				<?php endif; ?>

				<div class="tab-content" id="comment-tab-content">
					<div class="tab-pane fade show active" id="comment-recent" role="tabpanel" data-labelledby="comment-recent-tab">

						<?php $title = sprintf(esc_html__( ' %s Yorum', 'kanews' ), $count); ?>
						<div class="d-flex mt-1" style="position:relative">
							<h3 class="comments-title"><?php echo $title; ?></h3>
							<div class="kanews-dropdown">
								<div data-toggle="kanews-dropdown-comments-order-<?php echo $post->ID; ?>" class="kanews-dropdown-item"><i class="icon-menu2 icon-3x"></i></div>
								<div id="kanews-dropdown-comments-order-<?php echo $post->ID; ?>" class="kanews-dropdown-content">
									<ul>
										<li class="kanews-dropdown-title"><?php esc_html_e( 'Yorumların Sıralanışı', 'kanews' ); ?></li>
										<li><a href="<?php the_permalink( $post->ID ); ?>?comments_order=asc"><?php esc_html_e( 'Yeniden Eskiye', 'kanews' ); ?></a></li>
										<li><a href="<?php the_permalink( $post->ID ); ?>?comments_order=desc"><?php esc_html_e( 'Eskiden Yeniye', 'kanews' ); ?></a></li>
									</ul>
								</div>
							</div>
						</div>

						<ol class="comment-list">
							<?php wp_list_comments(array('callback' => 'kanews_list_comments')); ?>
						</ol>
						<?php
						the_comments_navigation(array('class' => 'kanews-comments-pag'));
						if ( ! comments_open() ) :
							?>
							<p class="no-comments"><?php esc_html_e( 'Yorumlar kapalı.', 'kanews' ); ?></p>
							<?php
						endif; ?>

					</div>
					<?php if( kanews_get_option('show-popular-comments') ): ?>
						<div class="tab-pane" id="comment-popular" role="tabpanel" data-labelledby="comment-popular-tab">

							<?php if(kanews_get_option('show-popular-comments') == true):
								$modify_args = array(
									'orderby'  => 'meta_value_num',
									'meta_key' => '_comment_like_count',
									'number'   => kanews_get_option('popular-comments-count', 10),
									'post_id'  => get_the_ID(),
									'order'    => 'DESC',
									'status'   => 'approve',
								);
								$popular_comments = get_comments( $modify_args );
								if ( $popular_comments && $count > 1): $args2['max_depth'] = '1'; ?>
									<ol class="comment-list mt-1">
										<?php foreach ( $popular_comments as $comment ) : 
											kanews_get_comment($comment, $args2, '1');
										endforeach; ?>
									</ol>
									<div class="empty-height" style="height: 50px"></div>
								<?php endif;
							endif; ?>

						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>


<?php endif;
else: ?>
	<p class="no-comments"><?php esc_html_e( 'Yorumlar kapalı.', 'kanews' ); ?></p>
<?php endif; ?>


</div><!-- #comments -->
