<?php

class SuperLigStandings
{
    /**
     * This function return Team Names
     * Returned values are name,middleName,ShortName
     * @param string $league League ID
     * @return array Team Array
     */
    public function getTeamNames($league){
        $teamNames = array();
        $data = $this->getData($league);
        
        if(!$data) return array();
        
        foreach ($data as $team) {
            $teamObj = new \stdClass();
            $teamObj->name = $team->name;
            $teamObj->middleName = $team->middleName;
            $teamObj->shortName = $team->shortName;
            array_push($teamNames, $teamObj);
        }
        return $teamNames;
    }

    /**
     * This function return Simple fixture data
     * Returned values are name,shortName,position,points
     * @param string $league League ID
     * @return array Team Array
     */
    public function getSimpleStandings($league){
        $standings = array();
        $data = $this->getData($league);
        
        if(!$data) return array();

        foreach ($data as $team) {
            $teamObj = new \stdClass();
            $teamObj->name = $team->name;
            $teamObj->played = $team->played;
            $teamObj->position = $team->position;
            $teamObj->points = $team->points;
            array_push($standings, $teamObj);
        }
        return $standings;
    }

    /**
     * This function return League Standings
     * Returned values include team details, statistics, form, next match
     * @param string $league League ID
     * @return array Team Array
     */
    public function getStandings($league){
        $standings = array();
		
        $ldata = $this->getData($league);

        if(!$ldata) {
            return false;
        }

        if($league == 'euroleague' || $league == 'erkek-basketbol' || $league == 'kadin-basketbol') {
            $sport_type = 'basketball';
            foreach ($ldata as $data) {
                $team = new \stdClass();
                $team->name = $data->name;
                $team->middleName = $data->middleName;
                $team->shortName = $data->shortName;
                $team->position = $data->position;
                $team->position_status = isset($data->positionStatus) ? $data->positionStatus->name : '';
                $team->points = $data->points;
                $team->against = $data->against;
                $team->scored = $data->scored;
                $team->average = $data->average;
                $team->lost = $data->lost;
                $team->played = $data->played;
                $team->won = $data->won;
                $team->delta = $data->delta;
                $team->formStatus = isset($data->formStatus) ? $data->formStatus : [
                    (object)[
                        'position' => 1,
                        'statusType' => -2
                    ],
                    (object)[
                        'position' => 2,
                        'statusType' => -2
                    ],
                    (object)[
                        'position' => 3,
                        'statusType' => -2
                    ],
                    (object)[
                        'position' => 4,
                        'statusType' => -2
                    ],
                    (object)[
                        'position' => 5,
                        'statusType' => -2
                    ],
                ];
                $team->nextMatch = isset($data->nextMatch) ? $data->nextMatch : null;
                $team->logo = $this->generateTeamLogo($data->id, $sport_type);
                array_push($standings, $team);
            }
        } elseif($league == 'sultanlar-ligi' || $league == 'efeler-ligi') {
            $sport_type = 'volleyball';
            foreach ($ldata as $data) {
                $team = new \stdClass();
                $team->name = $data->name;
                $team->middleName = $data->middleName;
                $team->shortName = $data->shortName;
                $team->position = $data->position;
                $team->position_status = isset($data->positionStatus) ? $data->positionStatus->name : '';
                $team->points = $data->points;
                $team->against = $data->against;
                $team->scored = $data->scored;
                $team->average = !empty($data->pointsQuotient) ? $data->pointsQuotient : '0';
                $team->lost = $data->lost;
                $team->played = $data->played;
                $team->won = $data->won;
                $team->formStatus = isset($data->formStatus) ? $data->formStatus : [
                    (object)[
                        'position' => 1,
                        'statusType' => -2
                    ],
                    (object)[
                        'position' => 2,
                        'statusType' => -2
                    ],
                    (object)[
                        'position' => 3,
                        'statusType' => -2
                    ],
                    (object)[
                        'position' => 4,
                        'statusType' => -2
                    ],
                    (object)[
                        'position' => 5,
                        'statusType' => -2
                    ],
                ];
                $team->nextMatch = isset($data->nextMatch) ? $data->nextMatch : null;
                $team->delta = $data->delta;
                $team->logo = $this->generateTeamLogo($data->id, $sport_type);
                array_push($standings, $team);
            }
        } else {
            $sport_type = 'soccer';
            foreach ($ldata as $data) {
                $team = new \stdClass();
                $team->name = $data->name;
                $team->middleName = $data->middleName;
                $team->shortName = $data->shortName;
                $team->position = $data->position;
                $team->position_status = isset($data->positionStatus) ? $data->positionStatus->name : '';
                $team->points = $data->points;
                $team->against = $data->against;
                $team->scored = $data->scored;
                $team->average = $data->average;
                $team->drawn = $data->drawn;
                $team->lost = $data->lost;
                $team->played = $data->played;
                $team->won = $data->won;
                $team->formStatus = isset($data->formStatus) ? $data->formStatus : [
                    (object)[
                        'position' => 1,
                        'statusType' => -2
                    ],
                    (object)[
                        'position' => 2,
                        'statusType' => -2
                    ],
                    (object)[
                        'position' => 3,
                        'statusType' => -2
                    ],
                    (object)[
                        'position' => 4,
                        'statusType' => -2
                    ],
                    (object)[
                        'position' => 5,
                        'statusType' => -2
                    ],
                ];
                $team->nextMatch = isset($data->nextMatch) ? $data->nextMatch : null;
                $team->delta = $data->delta;
                $team->logo = $this->generateTeamLogo($data->id, $sport_type);
                array_push($standings, $team);
            }
        }
        return $standings;
    }

    /**
     * Generate team logo url
     * @param int $teamId Team ID
     * @param string $sport_type Sport type (soccer, basketball, volleyball)
     * @return string Team logo url
     */
    private function generateTeamLogo($teamId, $sport_type){
        return "https://cdn.broadage.com/images-teams/{$sport_type}/18x18/{$teamId}.png";
    }

    /**
     * Get data from local JSON file
     * @param string $league League ID
     * @return array|false League data or false on failure
     */
    private function getData($league){
        $file_path = KAN_TEMPLATE_PATH."/inc/api/standings/".$league.".json";
        
        if (!file_exists($file_path)) {
            error_log("Standings file not found: " . $file_path);
            return false;
        }

        $response = get_local_file_contents($file_path);
        if (!$response) {
            error_log("Failed to read standings file: " . $file_path);
            return false;
        }

        $decoded = json_decode($response);
        if (!$decoded || !isset($decoded->initialData[0])) {
            error_log("Invalid JSON data in standings file: " . $file_path);
            return false;
        }

        if( is_array($decoded->initialData[0]) ) {
            return $decoded->initialData[0];
        } else {
            return $decoded->initialData;
        }
    }
}