<?php 
defined( 'ABSPATH' ) || exit; // Exit if accessed directly


/**
 * Site font
 */
function kanews_global_font($option) {
	$font = kanews_get_option($option);
	$first_big = ucwords(strtolower($font));
	$first_word2 = ucwords(strtolower($first_big), '_');
	$bul = '_';
	$degistir = ' ';
	$font_final = str_replace($bul, $degistir, $first_word2);
	return $font_final;
}

/**
 * Add color styling from theme
 */
function kanews_custom_css() {
	$styles = $single_styles = '';
	$terms = get_terms( 'category' );
	$font_final = kanews_global_font('site-font');

	wp_enqueue_style('kanews-theme', KAN_TEMPLATE_URL . '/assets/css/theme.min.css', array(), KAN_THEME_VER);

	if( is_singular() )
	wp_enqueue_style('kanews-theme-single');

	if( kanews_get_option('mode', true) || kanews_get_option('footer-skin', 'light') == 'dark' )
	wp_enqueue_style('kanews-dark-theme', KAN_TEMPLATE_URL . '/assets/css/dark.min.css', array(), KAN_THEME_VER);

	// Inline CSS
	if(is_page() && kanews_get_option('login-left-background')) {
		$styles .= '.kanews-lr-page-left {';
			foreach(kanews_get_option('login-left-background') as $key => $value) {
				if($key == 'background-image')
				$styles .= $key.': url('.$value['url'].');';
				else
				$styles .= $key.': '.$value.' !important;';
			}
		$styles .= '}';
	}
	
	// Lazy
	if(kanews_get_option('lazy') && kanews_get_option('lazy-logo') != '') {
		$styles .= '
			.kanews-post-thumb:before,
			.kanews-slider-wrapper:not(.slick-initialized):before,
			.kanews-slide-thumb:before 
			{
				background-image: url('.kanews_get_option('lazy-logo')['url'].');
			}
		';
	}

	// Fonts

	if ($font_final == 'System') {
		$styles .= 'body {font-family: -apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue","Open Sans",sans-serif !important; }';
	}elseif ($font_final != '') {
		$styles .= 'body {font-family: "'.$font_final.'", sans-serif !important;}'."\n";
	}

	// Single Fonts
	if(is_singular()) {
		$font_final2 = kanews_global_font('single-font');

		if ($font_final2 == 'System') {
			$single_styles .= '.entry-content-inner {font-family: -apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue","Open Sans",sans-serif !important; }';
		}elseif ($font_final2 != '') {
			$single_styles .= '.entry-content-inner {font-family: "'.$font_final2.'", sans-serif !important;}'."\n";
		}
	}

	// Dark Logo
	$dark_logo = (!empty(kanews_get_option('logo-dark'))) ? kanews_get_option('logo-dark') : array('url' => '');

	if( is_category() || is_singular() ) {
		$term_id = is_category() ? (int) get_category(get_query_var('cat'),false)->term_id : (int) Kanews\Helper_Wp::primary_category_id(get_the_ID());
		if( ($logo_category = get_term_meta( $term_id, 'kanews_logo_dark', true) ) && isset($logo_category['url']) && !empty($logo_category['url'])  ) {
			$dark_logo = $logo_category;
		}
	}
	
	if ($dark_logo['url'] != '') {
		$styles .= '.dark-mode .site-header-logo img{ 
			content: url('.$dark_logo['url'].');
			width: '.$dark_logo['width'].'px;
			/* height: '.$dark_logo['height'].'px; */
		}'."\n";
	}
	

	// All Settings
	$customizer = [
		'width' => kanews_get_option('site-container', ''),
		'bg' => kanews_get_option('site-background', ''),
		'primary' => kanews_get_option('primary-color'),
		
		'header-bg' => kanews_get_option('header-color'),
		'header-bg-gradient' => kanews_get_option('header-color-2'),
		'header-insights-btn-bg' => kanews_get_option('subscribe-btn-color'),
		'header-height' => kanews_get_option('height-height-tab'),
		'header-border' => kanews_get_option('header-border-color'),
		'header-btn-bg' => kanews_get_option('header-btn-bgcolor'),
		'header-btn-color' => kanews_get_option('header-btn-color'),
		
		'subheader-bg' => kanews_get_option('subheader-color'),
		'subheader-color' => kanews_get_option('subheader-link-color'),
		
		'footer-bg' => kanews_get_option('footer-color'),
		'footer-bg-gradient' => kanews_get_option('footer-color-2'),
		
		'navbar-bg' => kanews_get_option('navbar-color') ,
		'navbar-bg-gradient' => kanews_get_option('navbar-color-2'),
		'navbarlink-color' => kanews_get_option('navbarlink-color'),
		'navbarlinkhover-color' => kanews_get_option('navbarlinkhover-color'),
		'navbar-typography' =>  kanews_get_option('navbar-typography'),
		
		'mobilmenu-bg' => kanews_get_option('mobilmenu-color'),
		'mobilmenu-bg-gradient' => kanews_get_option('mobilmenu-color-2'),
		'mobilmenu-color' => kanews_get_option('mobilmenu-text-color'),
		'mobilmenulink-color' => kanews_get_option('mobilmenulink-color'),
		
		'pageheader-bg' => kanews_get_option('pageheader-color'),
		'pageheader-bg-gradient' => kanews_get_option('pageheader-color-2'),
		'pageheadertext-color' => kanews_get_option('pageheadertext-color'),
		
		'bigmenu-bg' => kanews_get_option('bigmenu-color'),
		'bigmenu-bg-gradient' => kanews_get_option('bigmenu-color-2'),
		'bigmenulink-color' => kanews_get_option('bigmenulink-color'),

		'backtotop-background' => kanews_get_option('backtotop-background'),
		'backtotop-color' => kanews_get_option('backtotop-color'),
		
		'single-postitle-color' => kanews_get_option('single-postitle-color'),
		'single-postitle-typography' => kanews_get_option('single-postitle-typography'),
		'single-postsubtitle-color' => kanews_get_option('single-postsubtitle-color'),
		'single-postsubtitle-typography' => kanews_get_option('single-postsubtitle-typography'),
		'single-postmeta-color' => kanews_get_option('single-postmeta-color'),
		'single-postmeta-typography' => kanews_get_option('single-postmeta-typography'),
		'single-postcontentlink-color' => kanews_get_option('single-postcontentlink-color'),
		'single-postcontentlinkhover-color' => kanews_get_option('single-postcontentlinkhover-color'),
		'single-postcontent-color' => kanews_get_option('single-postcontent-color'),
		'single-postcontent-typography' => kanews_get_option('single-postcontent-typography'),
		
		'postitle-typography' => kanews_get_option('postitle-typography'),

		'bn-left-background' => kanews_get_option('bn-left-background'),
		'bn-left-color' => kanews_get_option('bn-left-color'),				
		'bn-right-background' => kanews_get_option('bn-right-background'),
		'bn-right-color' => kanews_get_option('bn-right-color'),

		'tab-bar-bg' => kanews_get_option('tab-bar-bg'),
		'tab-bar-color' => kanews_get_option('tab-bar-color'),

		'block-border' => kanews_get_option('block-border', 'box_shadow'),
		'block-border-color' => kanews_get_option('block-border-color', ''),
		'block-border-radius' => kanews_get_option('block-border-radius', ''),
	];

	$root = '';

	/* Block Border Color */
	if( $customizer['block-border-color'] != '' ) {
		$root .= '--kan-border-color: '.$customizer['block-border-color'].';';
		$root .= '--kan-border-color2: '.$customizer['block-border-color'].';';
	}

	/* Block Border Radius */
	if( $customizer['block-border-radius'] != '' ) {
		$root .= '--kan-block-radius: '.$customizer['block-border-radius'].'px;';
		$styles .= '.kanews-section{overflow:hidden;}';
	}

	/* Block Border Type */
	if( $customizer['block-border'] == 'border' ) {
		$root .= '--kan-block-shadow: 0 0 0 1px var(--kan-border-color);';
	} elseif( $customizer['block-border'] == 'none' ) {
		$root .= '--kan-block-shadow: none';
	}

	/* Background */
	$bg_array = $customizer['bg'];

	if ( !empty($bg_array['background-color']) || !empty($bg_array['background-gradient-color']) || !empty($bg_array['background-image']['url']) ) {

		if($customizer['bg']['background-gradient-direction'] == '')
		$customizer['bg']['background-gradient-direction'] = 'to right';

		$styles .= '.site-wrapper {';
			foreach($customizer['bg'] as $key => $value) {
				if($key == 'background-image') {
					if($value['url'] != '')
					$styles .= $key.': url('.$value['url'].');';
				}
				elseif($key == 'background-color' || $key == 'background-gradient-color' || $key == 'background-gradient-direction') {
					if($customizer['bg']['background-color'] != '' && $customizer['bg']['background-gradient-color'] != '')
					$styles .= 'background: linear-gradient('.$customizer['bg']['background-gradient-direction'].', '.$customizer['bg']['background-color'].', '.$customizer['bg']['background-gradient-color'].' );';
					else {
						if($value != '')
						$styles .= 'background: '.$customizer['bg']['background-color'].';';
					}
					
				}
				else {
					if($value != '')
					$styles .= $key.': '.$value.';';
				}
				
			}
		$styles .= '}';
		
	}

	if( !empty($customizer['width']) && isset($customizer['width']['width']) && $customizer['width']['width'] != 1200 && is_numeric($customizer['width']['width'])) {
		$styles .= '
		@media (min-width: 992px) {
			.container {
				max-width: '.$customizer['width']['width'].$customizer['width']['unit'].'
			}
		}
		';
	}
	
	/* Primary Color */
	if (!empty($customizer['primary'])) {
		$root .= '
			--wp--preset--color--primary: '.$customizer['primary'].';
			--kan-theme-color: '.$customizer['primary'].';
		';
	}

	/* Sub Header*/
	if($customizer['subheader-bg'] != '') {
		$styles .= 'html:not(.dark-mode) .site-header-wrapper .site-subheader {background-color: '.$customizer['subheader-bg'].'}';
	}
	if($customizer['subheader-color'] != '') {
		$styles .= 'html:not(.dark-mode) .site-header-wrapper .site-subheader, html:not(.dark-mode) .site-header-wrapper .site-subheader * {color: '.$customizer['subheader-color'].' !important}';
	}

	/* Header*/
	if($customizer['header-bg-gradient'] != '' && $customizer['header-bg'] != '') {
		$styles .= '.site-header .site-header-wrapper {background: linear-gradient(to right, '.$customizer['header-bg'].', '.$customizer['header-bg-gradient'].')}';
	} elseif($customizer['header-bg'] != '') {
		$styles .= '.site-header .site-header-wrapper {background-color: '.$customizer['header-bg'].'}';
	}
	
	if($customizer['header-btn-bg'] != '') {
		$styles .= 'html:not(.dark-mode) .site-header .header-btn-icon, html:not(.dark-mode) .header-btn,  html:not(.dark-mode) .site-header button {background-color: '.$customizer['header-btn-bg'].'}';
	}
	if($customizer['header-btn-color'] != '') {
		$styles .= 'html:not(.dark-mode) .site-header .header-btn-icon, html:not(.dark-mode) .header-btn, html:not(.dark-mode) .site-header button {color: '.$customizer['header-btn-color'].'}';
	}
	
	if($customizer['header-border'] != '') {
		$styles .= 'html:not(.dark-mode) .site-header  {--kan-border-color: '.$customizer['header-border'].'}';
	}
	
	if( isset($customizer['header-height']['desktop']['height']) && !empty($customizer['header-height']['desktop']) && is_numeric($customizer['header-height']['desktop']['height'])) {
		$extra_height = 0;
		if(kanews_get_option('subheader-switch') && kanews_get_option('subnavbar-left-bn'))
		$extra_height = 80;
		elseif(kanews_get_option('subheader-switch') )
		$extra_height = 40;
		elseif(kanews_get_option('subnavbar-left-bn') )
		$extra_height = 40;

		$calculated_height = $customizer['header-height']['desktop']['height']+$extra_height;
		$styles .= '
		@media (min-width: 992px) {
		.site-header .site-header-top, .site-header .site-header-top .site-row {
			height: '.$customizer['header-height']['desktop']['height'].$customizer['header-height']['desktop']['unit'].' !important;
		}
		
		.site-head-2 {
			height: '.$calculated_height.$customizer['header-height']['desktop']['unit'].' !important;
		}
		}
		

		';
	}
	if( isset($customizer['header-height']['mobile']['height']) && !empty($customizer['header-height']['mobile']) && $customizer['header-height']['mobile']['height'] != 64 && is_numeric($customizer['header-height']['mobile']['height'])) {
		$styles .= '
		@media (max-width: 992px) {
			.site-header, .site-header .site-header-top, .site-header .site-header-top .site-row {
				height: '.$customizer['header-height']['mobile']['height'].$customizer['header-height']['mobile']['unit'].' !important;
			}
			.site-head-2 {
				height: '.$customizer['header-height']['mobile']['height'].$customizer['header-height']['mobile']['unit'].' !important;
			}
			.site-head-2 .site-navbar, .site-head-2 .site-navbar .navbar-row, .site-head-2 .site-navbar .site-navbar-nav>li {
				height: '.$customizer['header-height']['mobile']['height'].$customizer['header-height']['mobile']['unit'].' !important;
			}
			.site-head-2 .site-navbar .site-navbar-nav>li>a {
				line-height: '.$customizer['header-height']['mobile']['height'].$customizer['header-height']['mobile']['unit'].' !important;
			}
			
		}

		
		';
	}

	if($customizer['header-insights-btn-bg']) {
		$styles .= '.header-kanews-insights-btn {background-color: '.$customizer['header-insights-btn-bg'].'}';
	}

	/* Footer*/
	if($customizer['footer-bg-gradient'] != '' && $customizer['footer-bg'] != '') {
		$styles .= '#footer.dark-mode,.site-footer.light-mode {background: linear-gradient(to right, '.$customizer['footer-bg'].', '.$customizer['footer-bg-gradient'].')}';
	} elseif($customizer['footer-bg'] != '') {
		$styles .= '#footer.dark-mode,#footer.light-mode {background-color: '.$customizer['footer-bg'].'}';
	}

	/* Navbar*/
	if($customizer['navbar-bg-gradient'] != '' && $customizer['navbar-bg'] != '') {
		$styles .= '.site-navbar-wrapper, .site-navbar .site-navbar-nav li .sub-menu, .sie-head-3 .site-header .header-skin-light {background: linear-gradient(to right, '.$customizer['navbar-bg'].', '.$customizer['navbar-bg-gradient'].') !important}';
	} elseif($customizer['navbar-bg'] != '') {
		$styles .= '.site-navbar-wrapper, .site-navbar .site-navbar-nav li .sub-menu, .site-head-3 .site-header .header-skin-light {background-color: '.$customizer['navbar-bg'].' !important}';
	}
	if($customizer['navbarlink-color'] != '') {
		$styles .= '.site-navbar .site-navbar-nav li a {color: '.$customizer['navbarlink-color'].'}';
		$styles .= '.site-head-3 button {color: '.$customizer['navbarlink-color'].' !important}';
	}
	if($customizer['navbarlinkhover-color'] != '') {
		$styles .= '.site-navbar .site-navbar-nav li a:hover,.site-navbar .site-navbar-nav li .sub-menu li.current-category-ancestor>a, .site-navbar .site-navbar-nav li .sub-menu li.current-category-parent>a, .site-navbar .site-navbar-nav li .sub-menu li.current-menu-ancestor>a, .site-navbar .site-navbar-nav li .sub-menu li.current-menu-item>a, .site-navbar .site-navbar-nav li .sub-menu li.current-menu-parent>a, .site-navbar .site-navbar-nav>li.current-category-ancestor>a, .site-navbar .site-navbar-nav>li.current-category-parent>a, .site-navbar .site-navbar-nav>li.current-menu-ancestor>a, .site-navbar .site-navbar-nav>li.current-menu-item>a, .site-navbar .site-navbar-nav>li.current-menu-parent>a {color: '.$customizer['navbarlinkhover-color'].'}';
		$styles .= '.site-navbar .site-navbar-nav>li:after {background-color: '.$customizer['navbarlinkhover-color'].'}';
	}
	if( $customizer['navbar-typography'] != '' && ( $customizer['navbar-typography']['text-transform'] != '' || $customizer['navbar-typography']['font-size'] != '' || $customizer['navbar-typography']['font-weight'] != ''  || $customizer['navbar-typography']['type'] != '' ) ) {
		$styles .= '.site-navbar .site-navbar-nav li a {';
		foreach($customizer['navbar-typography'] as $key => $value) {
			if($value != '' && $key != 'unit') {
				if($key == 'text-transform' || $key == 'font-weight') {
					$styles .= $key.': '.$value.' !important;';
				} else {
					$styles .= $key.': '.$value.'px !important;';
				}
			}
		}
		$styles .= '}';
	}

	/* Breaking News Bar */
	if($customizer['bn-left-background'] != '') {
		$styles .= '.extra-sub .site-subheader {background-color: '.$customizer['bn-left-background'].'}';
		$styles .= '.extra-sub-action::after {background: linear-gradient(to right,transparent 0, '.$customizer['bn-left-background'].' 100%)}';
	}
	if($customizer['bn-left-color'] != '') {
		$styles .= '.extra-sub-action li a, .extra-sub-action .slick-arrow, .extra-sub .kanews-ticker-wrapper .kanews-ticker li>a, .extra-sub .kanews-ticker-wrapper .kanews-ticker-title, .extra-sub .kanews-ticker-wrapper .kanews-ticker-control>*{color: '.$customizer['bn-left-color'].' !important}';
	}
	
	/* Tab Bar */ 
	if($customizer['tab-bar-bg'] != '') {
		$styles .= '.kanews-tab-bar {background-color: '.$customizer['tab-bar-bg'].' !important}';
	}
	if($customizer['tab-bar-color'] != '') {
		$styles .= '.kanews-tab-bar li>a, .kanews-tab-bar li, .kanews-tab-bar-icon {color: '.$customizer['tab-bar-color'].' !important}';
	}

	/* Single Post */
	/* Single Post: Title */
	if($customizer['single-postitle-color'] != '') {
		$single_styles .= '.kanews-article-title {color: '.$customizer['single-postitle-color'].'}';
	}
	if($customizer['single-postitle-typography'] != '') {
		$single_styles .= '@media (min-width: 992px){.kanews-article-title {';
		foreach($customizer['single-postitle-typography'] as $key => $value) {
			if($value != '' && $key != 'unit') {
				if($key == 'text-transform' || $key == 'text-decoration' || $key == 'font-weight') {
					$single_styles .= $key.': '.$value.';';
				} else {
					$single_styles .= $key.': '.$value.'px !important;';
				}
			}
		}
		$single_styles .= '}}';
	}
	/* Single Post: Excerpt */
	if($customizer['single-postsubtitle-color'] != '') {
		$styles .= '.kanews-article-title+p {color: '.$customizer['single-postsubtitle-color'].'}';
	}
	if($customizer['single-postsubtitle-typography'] != '') {
		$single_styles .= '@media (min-width: 992px){.kanews-article-title+p {';
		foreach($customizer['single-postsubtitle-typography'] as $key => $value) {
			if($value != '' && $key != 'unit') {
				if($key == 'text-transform' || $key == 'text-decoration' || $key == 'font-weight') {
					$single_styles .= $key.': '.$value.';';
				} else {
					$single_styles .= $key.': '.$value.'px !important;';
				}
			}
		}
		$single_styles .= '}}';
	}
	/* Single Post: Meta */
	if($customizer['single-postmeta-color'] != '') {
		$single_styles .= '.kanews-article-meta {color: '.$customizer['single-postmeta-color'].'}';
	}
	if($customizer['single-postmeta-typography'] != '') {
		$single_styles .= '@media (min-width: 992px){.kanews-article-meta {';
		foreach($customizer['single-postmeta-typography'] as $key => $value) {
			if($value != '' && $key != 'unit') {
				if($key == 'text-transform' || $key == 'text-decoration' || $key == 'font-weight') {
					$single_styles .= $key.': '.$value.';';
				} else {
					$single_styles .= $key.': '.$value.'px !important;';
				}
			}
		}
		$single_styles .= '}}';
	}
	/* Single Post: Content */
	if($customizer['single-postcontent-color'] != '') {
		$single_styles .= '.kanews-article-content li, .kanews-article-content p, .kanews-article-content {color: '.$customizer['single-postcontent-color'].'}';
	}
	if($customizer['single-postcontentlink-color'] != '') {
		$single_styles .= '.entry-content-inner a {color: '.$customizer['single-postcontentlink-color'].'}';
	}
	if($customizer['single-postcontentlinkhover-color'] != '') {
		$single_styles .= '.entry-content-inner a:hover {color: '.$customizer['single-postcontentlinkhover-color'].'}';
	}
	if($customizer['single-postcontent-typography'] != '') {
		$single_styles .= '@media (min-width: 992px){.kanews-article-content li, .kanews-article-content p, .kanews-article-content {';
		foreach($customizer['single-postcontent-typography'] as $key => $value) {
			if($value != '' && $key != 'unit') {
				if($key == 'text-transform' || $key == 'font-weight') {
					$single_styles .= $key.': '.$value.';';
				} else {
					$single_styles .= $key.': '.$value.'px;';
				}
			}
		}
		$single_styles .= '}}';
	}
	if($customizer['postitle-typography'] != '') {
		$styles .= '@media (min-width: 992px){.kanews-post-headline {';
		foreach($customizer['postitle-typography'] as $key => $value) {
			if($value != '' && $key != 'unit') {
				if($key == 'text-transform' || $key == 'font-weight') {
					$styles .= $key.': '.$value.';';
				} else {
					$styles .= $key.': '.$value.'px !important;';
				}
			}
		}
		$styles .= '}}';
	}

	/* Page Header*/
	if($customizer['pageheader-bg-gradient'] != '' && $customizer['pageheader-bg'] != '') {
		$styles .= '#site-menu-block {background: linear-gradient(to right, '.$customizer['bigmenu-bg'].', '.$customizer['bigmenu-bg-gradient'].')}';
	} elseif($customizer['pageheader-bg'] != '') {
		$styles .= '.kanews-page-header {background-color: '.$customizer['pageheader-bg'].'}';
	}
	if($customizer['pageheadertext-color'] != '') {
		$styles .= '.kanews-page-header, .kanews-page-header .kanews-page-title {color: '.$customizer['pageheadertext-color'].'}';
	}

	/* Big Menu*/
	if($customizer['bigmenu-bg-gradient'] != '' && $customizer['bigmenu-bg'] != '') {
		$styles .= '#site-menu-block {background: linear-gradient(to right, '.$customizer['bigmenu-bg'].', '.$customizer['bigmenu-bg-gradient'].')}';
	} elseif($customizer['bigmenu-bg'] != '') {
		$styles .= '#site-menu-block {background-color: '.$customizer['bigmenu-bg'].'}';
	}
	if($customizer['bigmenulink-color'] != '') {
		$styles .= '#site-menu-block .site-menu-block>li a {color: '.$customizer['bigmenulink-color'].'}';
	}

	/* Mobil Menu*/
	if($customizer['mobilmenu-bg-gradient'] != '' && $customizer['mobilmenu-bg'] != '') {
		$styles .= '#site-mobile-menu .site-mobile-menu-wrapper{background: linear-gradient(to right, '.$customizer['mobilmenu-bg'].', '.$customizer['mobilmenu-bg-gradient'].')}';
	} elseif($customizer['mobilmenu-bg'] != '') {
		$styles .= '#site-mobile-menu .site-mobile-menu-wrapper {background-color: '.$customizer['mobilmenu-bg'].'}';
	}
	if($customizer['mobilmenulink-color'] != '') {
		$styles .= '#site-mobile-menu .site-mobile-menu-nav>ul>li>a, #site-mobile-menu .site-mobile-menu-footer {color: '.$customizer['mobilmenulink-color'].'}';
	}
	if($customizer['mobilmenu-color'] != '') {
		$styles .= '#site-mobile-menu,#site-mobile-menu .site-mobile-menu-footer p {color: '.$customizer['mobilmenu-color'].'}';
	}

	/* Back to top */
	if($customizer['backtotop-background'] != '') {
		$styles .= '.progress-wrap svg.progress-circle path {stroke: '.$customizer['backtotop-background'].'}';
	}
	if($customizer['backtotop-color'] != '') {
		$styles .= '.progress-wrap::after {color: '.$customizer['backtotop-color'].'}';
	}

	/* Main Cat Color */

	if(is_category()) {
		$cat = get_query_var('cat');
		$cat_color = get_term_meta( $cat, '_category_color', true );
		if($cat_color) {
			$root .= '
					--wp--preset--color--primary: #'.$cat_color.';
					--kan-theme-color: #'.$cat_color.';
			';
		}
	}elseif(is_single() && kanews_get_option('switch-primary-color', true)) {
		$cat = (int) Kanews\Helper_Wp::primary_category_id(get_the_ID());
		$cat_color = get_term_meta( $cat, '_category_color', true );
		if($cat_color && get_post_meta(get_the_ID(), 'primary_cat_color', true) != 'off') {
			$root .= '
				--wp--preset--color--primary: #'.$cat_color.';
				--kan-theme-color: #'.$cat_color.';
			';
		}
	} elseif(is_page()) {
		$page = get_queried_object_id();
		$page_color = get_post_meta( $page, '_page_color', true );
		if (!empty($page_color)) {
			$root .= '
				--wp--preset--color--primary: '.$page_color.';
				--kan-theme-color: '.$page_color.';
			';
		}
	}
	

	/* Button Cat Color */
	foreach ( $terms as $term ) {
		$control_term = get_term_meta( $term->term_id, '_category_color', true );
		if ($control_term != '') {
			$control_term_id = $term->term_id;
			$styles .= '
			.kanews-category-'.$control_term_id.'.kanews-category {--kan-theme-color:  #'.$control_term.' !important}
			';
		}
	}

	if( !empty($root) ) {
		$styles .= '
		:root { 
			'.$root.'
		}
		';
	}

	wp_add_inline_style( 'kanews-theme', kan_minify_css($styles) );
	wp_add_inline_style( 'kanews-theme-single', kan_minify_css($single_styles) );


}
add_action( 'wp_enqueue_scripts', 'kanews_custom_css', 9999 );	

/**
 * Dynamic
 */
add_action('wp_head', 'kanews_wp_head', 999);
if ( ! function_exists( 'kanews_wp_head' ) ) {
	function kanews_wp_head() {	

		$customizer = [
			'primary' => kanews_get_option('primary-color'),
		];


		if( kanews_get_option('switch-primary-color', true) ) {
			if(is_category()) {
				$cat = get_query_var('cat');
				$cat_color = get_term_meta( $cat, '_category_color', true );
				if($cat_color) {
					$customizer['primary'] = '#'.$cat_color;
				}
			}elseif(is_single()) {
				$cat = (int) Kanews\Helper_Wp::primary_category_id(get_the_ID());
				$cat_color = get_term_meta( $cat, '_category_color', true );
				if($cat_color && get_post_meta(get_the_ID(), 'primary_cat_color', true) != 'off') {
					$customizer['primary'] = '#'.$cat_color;
				}
			} elseif(is_page()) {
				$page = get_queried_object_id();
				$page_color = get_post_meta( $page, '_page_color', true );
				if (!empty($page_color)) {
					$customizer['primary'] = $page_color;
				}
			}
		}
		
		if ( $customizer['primary'] != '' ) {
			echo "<meta name=\"theme-color\" content=\"{$customizer['primary']}\" />
			<meta name=\"msapplication-navbutton-color\" content=\"{$customizer['primary']}\">
      <meta name=\"apple-mobile-web-app-status-bar-style\" content=\"{$customizer['primary']}\">";
		} else {
			echo '<meta name="theme-color" content="#e50914" />
			<meta name="msapplication-navbutton-color" content="#e50914" />
			<meta name="apple-mobile-web-app-status-bar-style" content="#e50914" />';
		}	
	}
}


/**
 * Include Site Font 
 */
add_action('wp_footer', 'dynamic_scripts');
if ( ! function_exists( 'dynamic_scripts' ) ) {
	function dynamic_scripts() {
		$font_final = kanews_global_font('site-font');
		$false = false;
		$font_single = '';
		if ($font_final == '') {
			$font_final = 'Inter';
		} elseif($font_final == 'System') {
			$false = true;
			if(!is_singular())
			return false;
		}
		$font_main = $font_final.':regular,500,600,700:latin&display=swap';
		
		if(is_singular() || is_admin()) {
			$font_final2 = kanews_global_font('single-font');
			if ($font_final2 == '') {
				$font_final2 = 'Inter';
			} elseif($font_final2 == 'System') {
				if($false)
				return false;
			}
			
			if(($font_final2 != $font_final) && $font_final2 != 'System') {
				$font_single = $font_final2.':regular,500,600,700:latin&display=swap';
			}
		}
		
		?>
		<script>
		var connection = navigator.connection || navigator.mozConnection || navigator.webkitConnection;
		if ( typeof connection != 'undefined' && (/\slow-2g|2g/.test(connection.effectiveType))) {
			console.warn( 'Slow Connection Google Fonts Disabled' );
		}
		else {
			WebFontConfig ={
				google:{
					families: ['<?php echo $font_main; ?>','<?php echo $font_single; ?>' ]
				}
			};

			(function(){
				var wf   = document.createElement('script');
				wf.src   = '//ajax.googleapis.com/ajax/libs/webfont/1.6.26/webfont.js';
				wf.type  = 'text/javascript';
				wf.defer = 'true';
				var s = document.getElementsByTagName('script')[0];
				s.parentNode.insertBefore(wf, s);
			})();
	
		}

		</script>
		<?php
	}
}