<?php

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

if ( (is_admin() || is_customize_preview())) {
	require_once dirname(__FILE__) . '/widget-framework.php';
}

// Widget Class
class kanews_widget_class_columnist extends WP_Widget {

  // Create
	public function __construct(){
		$widget_ops = array('classname' => 'kanews_widget_columnist kan-section-flat');
		$control_ops = array('id_base' => 'kanews_widget_columnist');
		parent::__construct('kanews_widget_columnist', ''.KAN_THEME_NAME .' - '.__( "Köşe Yazıları" , 'kanews' ), $widget_ops, $control_ops );
		add_action('admin_enqueue_scripts', array('Kanews_Form_Elements', 'enqueue_scripts'));

	}
  
  // Front-end
	public function widget($args, $instance)
	{
		$hide_mobile = isset($instance['hide_mobile']) ? 'on' : 'off';
		$hide_desktop = isset($instance['hide_desktop']) ? 'on' : 'off';

		if($hide_mobile == 'on') {
			if(kan_is_mobile())
			return;
		}

		if($hide_desktop == 'on') {
			if(!kan_is_mobile())
			return;
		}

		$title = apply_filters('widget_title', isset($instance['title']) ? $instance['title'] : '' );

		$grid = (!empty($instance['grid'])) ? $instance['grid'] : 'col-12';
		$col = (!empty($instance['col'])) ? $instance['col'] : 'col-12';

    $style = (isset($instance['style'])) ? $instance['style'] : '1';
    $posts = (isset($instance['posts'])) ? $instance['posts'] : '5';
    $offset = (isset($instance['offset'])) ? $instance['offset'] : '';
    $date_range = (isset($instance['date_range']) && $instance['date_range'] != '0') ? $instance['date_range'] : null;
    $sortby = (isset($instance['sortby'])) ? $instance['sortby'] : 'recent';
		$categories = !empty($instance['categories']) ? $instance['categories'] : '';
		$show_avatar = !isset($instance['show_avatar']) ? false : true;
		$show_post_date = !isset($instance['show_post_date']) ? false : true;
		$dark_mode = !isset($instance['dark_mode']) ? 'light-mode' : 'dark-mode';

		$query_args = array(
			'post_type'			=> 'columist',
			'id'				=> $categories,
			'number'				=> $posts,
			'sortby' 				=> $sortby,
			'offset' 				=> $offset,
			'range'				  => $date_range
		);


		$kanews_query = kan_query( $query_args );

		$row = '';
    $thumbnail = 'thumbnail';
    
    if(isset($args['id']))
		$sidebar = explode('-', $args['id']);
		else
		$sidebar = array('0' => 'home', '1' => 'content');
		
		if( $sidebar[1] == 'sidebar') {
      $col = 'col-12';
      $grid = 'col-12';
    }elseif($sidebar[1] == 'content') {
      if($col == 'col-12 col-lg-3 no-gutter') {
				$col = 'col-12 col-lg-4';  $grid = 'col-12';
			}
		}

    if($col != 'col-12') {
      $gutter = 'no-gutters';
      $row = 'm-0';
    }
		

    if ($kanews_query->have_posts()) : ?>
			<div class="<?php echo $grid; ?> <?php echo $dark_mode; ?>"> 
				<div class="kanews-section <?php echo $this->widget_options['classname']; ?>">
				<?php 
				if ( ! empty($instance['title']) ){
					echo ( $args['before_title'] . $title . $args['after_title'] );
				}
				?>
          <div class="row <?php echo $row; ?>">
            <?php 
            $displayed_authors = array(); // Eklendi: Gösterilen yazarlar dizisi
            while($kanews_query->have_posts()): $kanews_query->the_post(); global $post; 
              $author_id = get_the_author_meta('ID', $post->post_author); // Yazar ID'si alınıyor
              if (in_array($author_id, $displayed_authors)) continue; // Eğer yazar zaten gösterildiyse atla
              $displayed_authors[] = $author_id; // Yazarı diziye ekle
            ?>
            <div class="<?php echo $col; ?>">
              <?php if( $style == '2'): ?>
								<div class="kanews-post-quote">
									
									<div class="kanews-post-quote-info">
										
										<?php the_title( sprintf( '<h3 class="truncate truncate-2"><a href="%s" rel="bookmark">“ ', esc_url( get_permalink() ) ), ' “</a></h3>' ); ?>
	
										<span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID', $post->post_author ) ); ?>"><?php echo get_the_author_meta('display_name'); ?></a></span>
									</div>
									<?php if($show_avatar): ?>
										<div class="kanews-post-quote-img">
											<?php echo kanews_user_avatar(get_the_author_meta('ID', $post->post_author),'64'); ?>
										</div>
									<?php endif; ?>
								</div>
							<?php else: ?>
								<div class="kanews-post-item kanews-post-small-item kmfd2ag">
									<a href="<?php the_permalink(); ?>" class="kanews-post-href"></a>
									<?php do_action('kanews_post_hook'); ?>
									<?php if($show_avatar): ?>
											<div class="kanews-post-thumb">
											<a class="author-name" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID', $post->post_author ) ); ?>"><?php echo kanews_user_avatar(get_the_author_meta('ID', $post->post_author),'70'); ?></a>
										</div>
											<?php endif; ?>
									<div class="kanews-post-content">
										
										<?php the_title( sprintf( '<h3 class="kanews-post-headline truncate truncate-2"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
										<?php if($show_post_date): ?>
											<?php echo kanews_post_date(); ?>
										<?php endif; ?>
									</div>
								</div>
							<?php endif; ?>
            </div>
            <?php endwhile; wp_reset_postdata(); ?>
          </div>
        </div>
			</div>
		<?php endif; ?>
	<?php }
  
  // Update Form
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		
		$instance['grid'] = $new_instance['grid'];
		$instance['col'] = $new_instance['col'];
		$instance['style'] = $new_instance['style'];

		$instance['posts'] = $new_instance['posts'];
		$instance['offset'] = $new_instance['offset'];
		$instance['sortby'] = $new_instance['sortby'];
		$instance['date_range'] = $new_instance['date_range'];

		$instance['show_avatar'] = $new_instance['show_avatar'];
		$instance['show_post_date'] = $new_instance['show_post_date'];
		$instance['dark_mode'] = $new_instance['dark_mode'];
		$instance['hide_desktop'] = $new_instance['hide_desktop'];
		$instance['hide_mobile'] = $new_instance['hide_mobile'];
		$instance['categories'] = $new_instance['categories'];
		
		return $instance;
	}

  // Back-end
	public function form($instance)
	{
		$defaults = array( 
			'title' => esc_html__( 'Köşe Yazıları', 'kanews' ), 
			'grid' => 'col-12', 
			'col'  => 'col-12', 
			'style'  => '1', 
			'posts' => 5, 
			'sortby' => 'recent', 
			'date_range' => '0', 
			'offset' => '0',
			'show_avatar' => 'on',
			'show_post_date' => 'on',
			'dark_mode' => 'off',
			'hide_desktop' => 'off',
			'hide_mobile' => 'off',
			'categories' => ''
		);
		$instance = wp_parse_args((array) $instance, $defaults);

		// Genel Ayarlar
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Genel Ayarlar', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('title'),
					'name' => $this->get_field_name('title'),
					'label' => __('Başlık', 'kanews'),
					'value' => $instance['title']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('grid'),
					'name' => $this->get_field_name('grid'),
					'label' => __('Genişlik', 'kanews'),
					'value' => $instance['grid'],
					'options' => [
						'col-12' => '12/12',
						'col-12 col-lg-8' => '12/8',
						'col-12 col-lg-6' => '12/6',
						'col-12 col-lg-4' => '12/4'
					]
				],
				[
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('col'),
					'name' => $this->get_field_name('col'),
					'label' => __('Sütun Başına Yazı', 'kanews'),
					'value' => $instance['col'],
					'options' => [
						'col-12' => '1',
						'col-12 col-lg-6 no-gutter' => '2',
						'col-12 col-lg-4 no-gutter' => '3',
						'col-12 col-lg-3 no-gutter' => '4'
					]
				],
				[
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('style'),
					'name' => $this->get_field_name('style'),
					'label' => __('Görünüm', 'kanews'),
					'value' => $instance['style'],
					'options' => [
						'1' => '1',
						'2' => '2'
					]
				]
			]
		]);

		// Sıralama Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Sıralama Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_SELECT2_CATEGORIES,
					'id' => $this->get_field_id('categories'),
					'name' => $this->get_field_name('categories'),
					'label' => __('Kategori', 'kanews'),
					'value' => $instance['categories'],
					'multiple' => true,
					'placeholder' => __('Tüm Kategoriler', 'kanews')
				],
				[
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('sortby'),
					'name' => $this->get_field_name('sortby'),
					'label' => __('Göre Sırala', 'kanews'),
					'value' => $instance['sortby'],
					'options' => [
						'recent' => __('Yayınlanma Tarihine Göre', 'kanews'),
						'post-modified' => __('Düzenlenme Tarihine Göre', 'kanews'),
						'post-viewed' => __('En Çok Okunan Yazı - Tüm Zamanlar', 'kanews'),
						'commented' => __('En Çok Yorum Yapılan', 'kanews'),
						'random' => __('Rastgele', 'kanews')
					]
				],
				[
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('date_range'),
					'name' => $this->get_field_name('date_range'),
					'label' => __('Zaman Aralığı', 'kanews'),
					'value' => $instance['date_range'],
					'options' => [
						'0' => __('Zaman Aralığı Seçin', 'kanews'),
						'day' => __('Son 1 Gün', 'kanews'),
						'week' => __('Son 1 Hafta', 'kanews'),
						'month' => __('Son 1 Ay', 'kanews'),
						'year' => __('Son 1 Yıl', 'kanews')
					]
				],
				[
					'type' => Kanews_Form_Elements::TYPE_NUMBER,
					'id' => $this->get_field_id('offset'),
					'name' => $this->get_field_name('offset'),
					'label' => __('Offset', 'kanews'),
					'value' => $instance['offset'],
					'description' => __('Örneğin 1 girerseniz birinci yazıyı hariç tutar, ikinci yazıdan başlar.', 'kanews')
				],
				[
					'type' => Kanews_Form_Elements::TYPE_NUMBER,
					'id' => $this->get_field_id('posts'),
					'name' => $this->get_field_name('posts'),
					'label' => __('Yazı Sayısı', 'kanews'),
					'value' => $instance['posts']
				]
			]
		]);

		// İçerik Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('İçerik Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('show_avatar'),
					'name' => $this->get_field_name('show_avatar'),
					'label' => __('Yazar Fotoğrafını Göster', 'kanews'),
					'value' => $instance['show_avatar']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('show_post_date'),
					'name' => $this->get_field_name('show_post_date'),
					'label' => __('Yazı Tarihini Göster', 'kanews'),
					'value' => $instance['show_post_date']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('dark_mode'),
					'name' => $this->get_field_name('dark_mode'),
					'label' => __('Koyu Mod', 'kanews'),
					'value' => $instance['dark_mode']
				]
			]
		]);

		// Görünürlük Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Görünürlük Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_desktop'),
					'name' => $this->get_field_name('hide_desktop'),
					'label' => __('Masaüstünde Gizle', 'kanews'),
					'value' => $instance['hide_desktop']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_mobile'),
					'name' => $this->get_field_name('hide_mobile'),
					'label' => __('Mobilde Gizle', 'kanews'),
					'value' => $instance['hide_mobile']
				]
			]
		]);
	}
}