<?php 

if( class_exists( 'CSF' ) ) {

  CSF::createWidget( 'kanews_widget_firma', array(
    'title'       => KAN_THEME_NAME .' - '."Firma",
    'description' => "Firma rehberi ile alakalı tüm bileşenler.",
    'classname'   => 'kanews_widget_class_firma',
    'fields'      => array(

      array(
        'id'      => 'title',
        'type'    => 'text',
        'title'   => 'Title',
        'default'   => 'Firma',
      ),

      array(
        'id'      => 'widget',
        'type'    => 'select',
        'title'   => 'Kullanılacak Bileşen',
        'options' => array(
          'post' => 'Firma Listesi',
          'search' => 'Firma Ara',
          'insights' => 'Abone Firmalar',
        ),
        'default' => 'post'
      ),
      array(
        'id'      => 'grid',
        'type'    => 'select',
        'title'   => 'Genişlik',
        'options' => array(
          'col-12' => '12/12',
          'col-12 col-lg-8' => '12/8',
          'col-12 col-lg-6' => '12/6',
          'col-12 col-lg-4' => '12/4'
        ),
        'default' => 'col-12'
      ),

      // Posts
      array(
        'id'      => 'col',
        'type'    => 'select',
        'dependency' => array( 'widget', '!=', 'search' ),
        'title'   => 'Sütun Başına Yazı',
        'options' => array(
          'col-6 col-lg-12' => '1',
          'col-6 col-lg-6' => '2',
          'col-6 col-lg-4' => '3',
          'col-6 col-md-4 col-lg-3' => '4',
          'col-6 col-md-3 col-lg-2' => '6',
        ),
        'default' => 'col-6 col-md-4 col-lg-3'
      ),
      array(
        'id'      => 'variations',
        'type'    => 'select',
        'dependency' => array( 'widget', '!=', 'search' ),
        'title'   => 'Varyasyon',
        'options' => array('1' => '1', '2' => '2'),
        'default' => '1'
      ),
      array(
        'id'       => 'posts',
        'dependency' => array( 'widget', '!=', 'search' ),
        'type'     => 'slider',
        'title'    => 'Firma Sayısı',
        'min'      => 1,
        'step'     => 1,
        'default'  => 6,
      ),
      array(
        'id'      => 'sortby',
        'type'    => 'select',
        'title'   => 'Göre Sırala',
        'dependency' => array( 'widget', '==', 'post' ),
        'options' => array(
          'recent' => 'Yayınlanma Tarihine Göre',
          'post-modified' => 'Düzenlenme Tarihine Göre',
          'rating' => 'Ortalama Puana Göre',
          'commented' => 'En Çok Yorum Yapılan',
          'random' => 'Rastgele'
        ),
        'default' => 'recent'
      ),
      array(
        'id'      => 'date_range',
        'type'    => 'select',
        'dependency' => array( 'widget', '==', 'post' ),
        'title'   => 'Zaman Aralığı',
        'options' => array(
          '0' => 'Zaman Aralığı Seçin',
          'day' => 'Son 1 Gün',
          'week' => 'Son 1 Hafta',
          'month' => 'Son 1 Ay',
          'year' => 'Son 1 Yıl',
        ),
        'default' => '0'
      ),
      array(
        'id'      => 'categories',
        'type'    => 'select',
        'dependency' => array( 'widget', '!=', 'search' ),
        'title'   => 'Kategori',
        'options' => 'kanews_get_terms_firma_kategori',
        'multiple'=> true,
        'chosen'  => true,
        'default' => '0'
      ),
      array(
        'id'      => 'city',
        'type'    => 'text',
        'dependency' => array( 'widget', '==', 'post' ),
        'title'   => 'İl',
      ),
      array(
        'id'      => 'rating',
        'type'    => 'switcher',
        'dependency' => array( 'widget', '!=', 'search' ),
        'title'   => 'Ortalama Puan',
        'default' => false
      ),
      array(
        'id'      => 'postnotin',
        'type'    => 'text',
        'dependency' => array( 'widget', '==', 'post' ),
        'title'   => 'Hariç Tutulan Firmalar',
        'default' => ''
      ),

      array(
        'id'      => 'show_more_link',
        'type'    => 'text',
        'dependency' => array( 'widget', '==', 'post' ),

        'title'   => 'Daha Fazla Linki',
        'default' => ''
      ),

      array(
        'id'      => 'hide_desktop',
        'type'    => 'switcher',
        'title'   => 'Masaüstünde Gizle',
        'default' => false
      ),
      array(
        'id'      => 'hide_mobile',
        'type'    => 'switcher',
        'title'   => 'Mobilde Gizle',
        'default' => false
      ),
    
    )
  ) );
  
  if( ! function_exists( 'kanews_widget_firma' ) ) {
    function kanews_widget_firma( $widget_args, $instance ) {
      $hide_mobile = $instance['hide_mobile'] ? 'on' : 'off';
      $hide_desktop = $instance['hide_desktop']? 'on' : 'off';

      if( ! kanews_get_option('firma-rehberi') )
      return;

      if($hide_mobile == 'on') {
        if(kan_is_mobile())
        return;
      }

      if($hide_desktop == 'on') {
        if(!kan_is_mobile())
        return;
      }

      if( $instance['widget'] == 'search' ): 
        $args_defaults = array( 
          'title' => 'Firma Rehberi',
          'grid'  => 'col-12',
        );
        $args = wp_parse_args( $instance, $args_defaults );

        echo '<div class="'.$args['grid'].'"><div class="kanews-section kanews-widget-ilan-search">'; ?>
        
        <?php if ( ! empty($args['title']) ):
          echo ( $widget_args['before_title'] . $args['title'] . $widget_args['after_title'] );
        endif; ?>

        <form method="GET" action="<?php echo get_post_type_archive_link('firma'); ?> ">
          <div class="d-flex flex-wrap" style="padding: 1em 0">
            <div class="col-12 col-lg-6">
              <div class="kanews-form2">
                <input value="<?php echo isset($_GET['comp_name']) ? $_GET['comp_name'] : ''; ?>" type="text" name="comp_name" placeholder="Firma Adı">
              </div>
            </div>
            <div class="col-12 col-lg-6">
              <div class="kanews-form2">
                <input value="<?php echo isset($_GET['comp_city'])? $_POST['comp_city'] : ''; ?>" type="text" name="comp_city" placeholder="Şehir">
              </div>
            </div>
            <div class="col-12">
              <div class="kanews-form2">
                <?php $select_value = isset($_POST['comp_cat']) ? $_POST['comp_cat'] : ''; ?>
                <?php 
                if( $terms = get_terms( array(
                  'taxonomy' => 'kategori', // to make it simple I use default categories
                  'orderby' => 'name'
              ) ) ) : 
                // if categories exist, display the dropdown
                echo '<select value="'.$select_value.'" name="comp_cat"><option value="">Kategori</option>';
                foreach ( $terms as $term ) :
                  echo '<option value="' . $term->term_id . '">' . $term->name . '</option>'; // ID of the category as an option value
                endforeach;
                echo '</select>';
              endif;
              ?>
              </div>
            </div>
            <div class="col-12">
              <div class="kanews-form2">
                <select name="comp_rating_min">
                  <option value="">Minumum Puan</option>
                  <option <?php echo (isset($_GET['comp_rating_min']) && $_GET['comp_rating_min'] == '1') ? 'selected="select""': ''; ?> value="1">1</option>
                  <option <?php echo (isset($_GET['comp_rating_min']) && $_GET['comp_rating_min'] == '1') == '2' ? 'selected="select""': ''; ?>  value="2">2</option>
                  <option <?php echo (isset($_GET['comp_rating_min']) && $_GET['comp_rating_min'] == '1') == '3' ? 'selected="select""': ''; ?>  value="3">3</option>
                  <option <?php echo (isset($_GET['comp_rating_min']) && $_GET['comp_rating_min'] == '1') == '4' ? 'selected="select""': ''; ?>  value="4">4</option>
                  <option <?php echo (isset($_GET['comp_rating_min']) && $_GET['comp_rating_min'] == '1') == '5' ? 'selected="select"': ''; ?>  value="5">5</option>
                </select>
              </div>
            </div>
            <div class="col-12">
              <div class="kanews-form2 mb-0">
                <select name="comp_rating_max">
                  <option value="">Maksimum Puan</option>
                  <option <?php echo (isset($_GET['comp_rating_max']) && $_GET['comp_rating_max'] == '1') == '1' ? 'selected="select""': ''; ?> value="1">1</option>
                  <option <?php echo (isset($_GET['comp_rating_max']) && $_GET['comp_rating_max'] == '1') == '2' ? 'selected="select""': ''; ?>  value="2">2</option>
                  <option <?php echo (isset($_GET['comp_rating_max']) && $_GET['comp_rating_max'] == '1') == '3' ? 'selected="select""': ''; ?>  value="3">3</option>
                  <option <?php echo (isset($_GET['comp_rating_max']) && $_GET['comp_rating_max'] == '1') == '4' ? 'selected="select""': ''; ?>  value="4">4</option>
                  <option <?php echo (isset($_GET['comp_rating_max']) && $_GET['comp_rating_max'] == '1') == '5' ? 'selected="select"': ''; ?>  value="5">5</option>
                </select>
              </div>
            </div>
            <div class="col-12">
              <button type="submit" class="kanews-btn kanews-btn-block mb-0 kanews-btn-sm">Arama Yap</button>
            </div>
          </div>
        </form>
        <?php echo '</div></div>';
      elseif( $instance['widget'] == 'insights' ): 
        $args_defaults = array( 
          'grid'       => 'col-12',
          'col'        => 'col-6 col-md-4 col-lg-3',
          'title'      => 'Abone Firmalar',
          'categories' => '',
          'variations' => '1',
          'rating'     => false,
          'posts'      => 10,
        ); 
        $args = wp_parse_args( $instance, $args_defaults );
        extract($args);

        if(!empty($categories)) {
          $tax_query = array(
            array(
              'taxonomy' => 'kategori',
              'field' => 'id',
              'terms' => $categories,
            ) 
            );
        } else {
          $tax_query = '';
        }
    
        $all_user_ids = Kanews\Util\Cache::get_users([
          'fields' => 'id',
          'meta_key' => 'kanews_insights_purchase_date',
          'meta_compare' => '!==',
          'meta_value' => ''
        ]);
        
        $kanews_query = new WP_Query(
          array( 
            'showposts'    => $posts,
            'post_type'    => 'firma',
            'author__in'   => $all_user_ids,
            'tax_query'    => $tax_query
          )
        );
        ?>
        <?php if ($kanews_query->have_posts()) :?>
          <div class="<?php echo $grid; ?>"> 
            <div class="kanews-section kanews_widget_comp_2 kanews_widget_comp">
              <?php if ( ! empty($title) ):
                echo ( $widget_args['before_title'] . $title . $widget_args['after_title'] );
              endif; ?>
      
              <div class="row <?php echo $variations == 1 ? 'no-gutters' : ''; ?> p-1">
                <?php $counter = 0; while($kanews_query->have_posts()): $kanews_query->the_post(); global $post;  ?>
                  <?php if(kanews_insights_control($post->post_author) == true): $counter++; ?>
                    <?php if($variations == 2): ?>
                      <?php 
                      $comp = [
                        'name' => get_post_meta($post->ID, "comp_name", true ) ? get_post_meta($post->ID, "comp_name", true ) : get_the_title(),
                        'auth' => get_post_meta($post->ID, "comp_auth", true ) ? get_post_meta($post->ID, "comp_auth", true ) : 'Belirtilmemiş',
                        'city' => get_post_meta($post->ID, "comp_city", true ) ? get_post_meta($post->ID, "comp_city", true ) : 'Belirtilmemiş',
                        'address' => get_post_meta($post->ID, "comp_adress", true ) ? get_post_meta($post->ID, "comp_adress", true ) : 'Belirtilmemiş',
                        'phone' => get_post_meta($post->ID, "comp_tel", true ) ? get_post_meta($post->ID, "comp_tel", true ) : 'Belirtilmemiş',
                        'fax' => get_post_meta($post->ID, "comp_fax", true ) ? get_post_meta($post->ID, "comp_fax", true ) : 'Belirtilmemiş',
                        'site' => get_post_meta($post->ID, "comp_site", true ) ? get_post_meta($post->ID, "comp_site", true ) : 'Belirtilmemiş',
                        'map' => get_post_meta($post->ID, "comp_map", true )
                      ];
                      ?>
                      <div class="<?php echo $col; ?>">
                        <div class="kanews-post-item kanews-post-special-item kanews-post-comp">
                        <?php
                          if( empty( $GLOBALS['timeline_time'] ) || $GLOBALS['timeline_time'] != get_the_time('D M Y') ){
                            echo '<div class="kanews-post-special-item-date"><span>'. get_the_time('j') .'</span><div>'. get_the_time('F') .'</div></div>';
                          }
                          $GLOBALS['timeline_time'] = get_the_time('D M Y');
                          ?>	
                          <div class="kanews-post-special-item-time"><span><?php the_time( 'G:i');  ?></span></div>
                          <div class="row align-items-center">
                            <a href="<?php the_permalink(); ?>" class="kanews-post-href"></a>
                            <?php $content_class = 'col-12 col-md-4'; 
                            $content_class2 = 'col-12 col-md-8';  if(has_post_thumbnail()) :  $content_class = $content_class2 = 'col-12 col-md-4';  ?>
                              <div class="col-12 col-md-4">
                                <?php kanews_post_thumbnail('full', 'kanews-post-comp-thumb'); ?>
                              </div>
                            <?php endif; ?>
              
                            <div class="<?php echo $content_class; ?>">
                              <div class="kanews-post-content">

                                <?php the_title( sprintf( '<h3 class="kanews-post-headline truncate truncate-3"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
                                <?php if($rating): ?>
                                <div class="d-flex">
                                  <div><i class="icon-location"></i> <?php echo $comp['city']; ?></div>
                                  <div style="margin-left: 1em"><i class="icon-star"></i> <?php echo ci_comment_rating_get_average_ratings($post->ID); ?></div>
                                </div>
                                <?php endif; ?>
                              </div>
                            </div>
                            <?php if($sidebar[1] != 'sidebar'): ?>
                            <div class="<?php echo $content_class2; ?>">
                              <?php if (kanews_get_option('excerpt-length') != ''): ?>
                                <?php the_excerpt(); ?>
                              <?php endif; ?>
                            </div>
                            <?php endif; ?>
                            
                          </div>
                        </div>
                      </div>
                    <?php else: ?>
                      <div class="<?php echo $col; ?> ">
                        <div class="kanews-post-item kanews-post-grid-item">
                          <a href="<?php the_permalink(); ?>" class="kanews-post-href"></a>
                          <?php kanews_post_thumbnail('full', 'kanews-post-comp-thumb'); ?>
                          <div class="kanews-post-content">
                            <?php the_title( sprintf( '<h3 class="kanews-post-headline truncate truncate-2"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
                            <?php if($rating): ?>
                            <div><i class="icon-star"></i> <?php echo ci_comment_rating_get_average_ratings($post->ID); ?></div>
                            <?php endif; ?>
                          </div>
                        </div>
                      </div>
                    <?php endif; ?>
                  <?php endif; ?>
          
                <?php endwhile; wp_reset_postdata(); ?>
                <?php if($counter == 0): ?>
                  <p style="margin: 15px">Abone firma bulunamadı</p>
                <?php endif; ?>
            </div>
            </div>
            
          </div>
        <?php endif; ?>
      <?php else: 
        $args_defaults = array( 
          'grid'       => 'col-12',
          'col'        => 'col-6 col-md-4 col-lg-3',
          'title'      => '',
          'city'       => '',
          'postnotin'  => '',
          'show_more_link'  => '',
          'sortby'     => 'recent',
          'categories' => '',
          'variations' => '1',
          'rating'     => false,
          'posts'      => 6,
        ); 
        $args = wp_parse_args( $instance, $args_defaults );
        extract($args); 

        $postnotin = !empty($instance['postnotin']) ? $instance['postnotin'] : '';
        $excludeposts = explode(",", $postnotin);

        if(!empty($categories)) {
          $tax_query = array(
            array(
              'taxonomy' => 'kategori',
              'field' => 'id',
              'terms' => $categories,
            ) 
            );
        } else {
          $tax_query = '';
        }

        if(!empty($city)) {
          $meta_query = array( 'meta_query' => array(array('key' => 'comp_city', 'value' => $city, 'compare' => '=' )));
        } else {
          $meta_query = '';
        }

        if($sortby == 'commented') {
          $kanews_query = new WP_Query(
            array( 
              'post_type' => 'firma',
              'showposts' => $posts, 
              'orderby' => 'comment_count',
              'post__not_in' => $excludeposts,
              'tax_query' => $tax_query,
              'meta_query' => $meta_query
            )
          );
        }elseif($sortby == 'rating') {
          $kanews_query = new WP_Query(
            array( 
              'post_type'    => 'firma',
              'showposts'    => $posts,
              'post__not_in' => $excludeposts,
              'meta_key' => '_kanews_post_rating_overall',
              'type' => 'numeric',
              'orderby' => 'meta_value_num',
              'tax_query' => $tax_query,
              'meta_query' => $meta_query
            )
          );
        }elseif($sortby == 'random') {
          $kanews_query = new WP_Query(
            array( 
              'post_type'    => 'firma',
              'showposts'    => $posts,
              'post__not_in' => $excludeposts,
              'orderby' => 'rand',
              'tax_query' => $tax_query,
              'meta_query' => $meta_query
            )
          );
        }
        else {
          $kanews_query = new WP_Query(
            array( 
              'post_type'    => 'firma',
              'showposts'    => $posts,
              'post__not_in' => $excludeposts,
              'tax_query' => $tax_query,
              'meta_query' => $meta_query
            )
          );
        }
        ?>

        <?php if ($kanews_query->have_posts()) :?>
          <div class="<?php echo $grid; ?>"> 
            <div class="kanews-section kanews_widget_comp_1 kanews_widget_comp">
              <?php 
              if ( ! empty($title) ){
                echo ( $widget_args['before_title'] . $title . $widget_args['after_title'] );
              }
              ?>
      
              <div class="row <?php echo $variations == 1 ? 'no-gutters p-1' : ''; ?> ">
                <?php while($kanews_query->have_posts()): $kanews_query->the_post(); global $post;  ?>

                    <?php if($variations == 2): ?>
                      <?php 
                      $comp = [
                        'name' => get_post_meta($post->ID, "comp_name", true ) ? get_post_meta($post->ID, "comp_name", true ) : get_the_title(),
                        'auth' => get_post_meta($post->ID, "comp_auth", true ) ? get_post_meta($post->ID, "comp_auth", true ) : 'Belirtilmemiş',
                        'city' => get_post_meta($post->ID, "comp_city", true ) ? get_post_meta($post->ID, "comp_city", true ) : 'Belirtilmemiş',
                        'address' => get_post_meta($post->ID, "comp_adress", true ) ? get_post_meta($post->ID, "comp_adress", true ) : 'Belirtilmemiş',
                        'phone' => get_post_meta($post->ID, "comp_tel", true ) ? get_post_meta($post->ID, "comp_tel", true ) : 'Belirtilmemiş',
                        'fax' => get_post_meta($post->ID, "comp_fax", true ) ? get_post_meta($post->ID, "comp_fax", true ) : 'Belirtilmemiş',
                        'site' => get_post_meta($post->ID, "comp_site", true ) ? get_post_meta($post->ID, "comp_site", true ) : 'Belirtilmemiş',
                        'map' => get_post_meta($post->ID, "comp_map", true )
                      ];
                      ?>
                      <div class="<?php echo $col; ?>">
                        <div class="kanews-post-item kanews-post-special-item kanews-post-comp">
                        <?php
                          if( empty( $GLOBALS['timeline_time'] ) || $GLOBALS['timeline_time'] != get_the_time('D M Y') ){
                            echo '<div class="kanews-post-special-item-date"><span>'. get_the_time('j') .'</span><div>'. get_the_time('F') .'</div></div>';
                          }
                          $GLOBALS['timeline_time'] = get_the_time('D M Y');
                          ?>	
                          <div class="kanews-post-special-item-time"><span><?php the_time( 'G:i');  ?></span></div>
                          <div class="row align-items-center">
                            <a href="<?php the_permalink(); ?>" class="kanews-post-href"></a>
                            <?php $content_class = 'col-12 col-md-4'; 
                            $content_class2 = 'col-12 col-md-8';  if(has_post_thumbnail()) :  $content_class = $content_class2 = 'col-12 col-md-4';  ?>
                              <div class="col-12 col-md-4">
                                <?php kanews_post_thumbnail('full', 'kanews-post-comp-thumb'); ?>
                              </div>
                            <?php endif; ?>
      
                            <div class="<?php echo $content_class; ?>">
                              <div class="kanews-post-content">

                                <?php the_title( sprintf( '<h3 class="kanews-post-headline truncate truncate-3"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
                                <div class="d-flex">
                                  <div><i class="icon-location"></i> <?php echo $comp['city']; ?></div>
                                  <?php if($rating): ?>
                                  <div style="margin-left: 1em"><i class="icon-star"></i> <?php echo ci_comment_rating_get_average_ratings($post->ID); ?></div>
                                  <?php endif; ?>
                                </div>
                              </div>
                            </div>

                            
                          </div>
                        </div>
                      </div>
                    <?php else: ?>
                      <div class="<?php echo $col; ?> ">
                        <div class="kanews-post-item kanews-post-grid-item">
                          <a href="<?php the_permalink(); ?>" class="kanews-post-href"></a>
                          <?php kanews_post_thumbnail('full', 'kanews-post-comp-thumb'); ?>
                          <div class="kanews-post-content">
                            <?php the_title( sprintf( '<h3 class="kanews-post-headline truncate truncate-2"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
                            <?php if($rating): ?>
                            <div><i class="icon-star color-warning"></i> <?php echo ci_comment_rating_get_average_ratings($post->ID); ?></div>
                            <?php endif; ?>
                          </div>
                        </div>
                      </div>
                    <?php endif; ?>
                <?php endwhile; wp_reset_postdata(); ?>

                <?php if ( isset($instance['show_more_link']) && !empty($instance['show_more_link']) ): ?>
							<div class="col-12">
								<div class="col-12 col-md-8 mt-0 m-auto"><a href="<?php echo esc_url($instance['show_more_link']); ?>" class="kanews-btn kanews-btn-block kanews-btn-sm kanews-btn-o">Daha Fazla</a></div>
							</div>
						<?php endif; ?>
              </div>

            </div>
          </div>
        <?php endif; ?>
      <?php endif;
    }
  }
}