<?php

if (!defined('ABSPATH')) {
	die();
}

if(is_admin() || is_customize_preview(  )) {
	require_once dirname(__FILE__) . '/widget-framework.php';
}

class kanews_widget_class_iconbox extends WP_Widget {
    public function __construct() {
        $widget_ops = array('description' => __('İkon ve açıklama ile özelleştirilebilir kutu', 'kanews'), 'classname' => 'widget-iconbox');
        $control_ops = array('width' => 250, 'height' => 350, 'id_base' => 'kanews_widget_iconbox');
        parent::__construct('kanews_widget_iconbox', KAN_THEME_NAME . ' : ' . __('İkon Kutusu', 'kanews'), $widget_ops, $control_ops);
        add_action('admin_enqueue_scripts', array('Kanews_Form_Elements', 'enqueue_scripts'));
    }

    public function widget($args, $instance) {
        // Görünürlük kontrolü
        if ((isset($instance['hide_mobile']) && $instance['hide_mobile'] === 'on' && kan_is_mobile()) ||
            (isset($instance['hide_desktop']) && $instance['hide_desktop'] === 'on' && !kan_is_mobile())) {
			return;
		}

        $title = apply_filters('widget_title', isset($instance['title']) ? $instance['title'] : '');
        $btn_title = (!empty($instance['btn_text'])) ? $instance['btn_text'] : esc_html__('Gönder', 'kanews');
    $desc = (!empty($instance['desc'])) ? $instance['desc'] : '';
    $pages = (!empty($instance['pages'])) ? $instance['pages'] : '';
    $custompage = (!empty($instance['custompage'])) ? $instance['custompage'] : '';
				$bg_color = (!empty($instance['bg-color'])) ? 'background-color: ' . $instance['bg-color'] . ';' : '';
        $icon_type = (!empty($instance['icon_type'])) ? $instance['icon_type'] : 'icon';
        $icon = (!empty($instance['icon'])) ? $instance['icon'] : 'icon-star';
        $image = (!empty($instance['image'])) ? $instance['image'] : '';
        $grid = (!empty($instance['grid'])) ? $instance['grid'] : 'col-12';
		
        ?>
				<div class="<?php echo esc_attr($grid); ?>">
				<div class="kanews-section">
      <div class="kanews-icon-box">
            <div class="kanews-icon-box-header" style="<?php echo esc_attr($bg_color); ?>">
                <?php if ($icon_type === 'icon'): ?>
                    <i class="<?php echo esc_attr($icon); ?>"></i>
                <?php else: ?>
                    <?php if (!empty($image)): ?>
                        <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr($title); ?>">
                    <?php endif; ?>
                <?php endif; ?>
        </div>
				
            <?php if (!empty($title)) : ?>
                <h4><?php echo esc_html($title); ?></h4>
				<?php endif; ?>

            <?php if (!empty($desc)) : ?>
                <p class="kanews-icon-box-content"><?php echo wp_kses_post($desc); ?></p>
				<?php endif; ?>

            <?php if ($custompage != '') : ?>
                <a href="<?php echo esc_url($custompage) ?>" style="<?php echo esc_attr($bg_color); ?>" class="kanews-btn kanews-btn-sm mt-0"><?php echo esc_html($btn_title); ?></a>
            <?php elseif ($pages != '' && $pages != 'all') : ?>
                <a href="<?php echo esc_url(get_page_link($pages)); ?>" style="<?php echo esc_attr($bg_color); ?>" class="kanews-btn kanews-btn-sm mt-0"><?php echo esc_html($btn_title); ?></a>
        <?php endif; ?>
      </div>
		</div>
      </div>
    <?php 
    }

    public function update($new_instance, $old_instance) {
		$instance = $old_instance;
        $instance['icon_type'] = strip_tags($new_instance['icon_type']);
        $instance['icon'] = strip_tags($new_instance['icon']);
        $instance['image'] = esc_url_raw($new_instance['image']);
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['desc'] = wp_kses_post($new_instance['desc']);
        $instance['btn_text'] = strip_tags($new_instance['btn_text']);
        $instance['custompage'] = esc_url_raw($new_instance['custompage']);
        $instance['pages'] = strip_tags($new_instance['pages']);
        $instance['bg-color'] = sanitize_hex_color($new_instance['bg-color']);
        $instance['grid'] = strip_tags($new_instance['grid']);
		$instance['hide_desktop'] = $new_instance['hide_desktop'];
		$instance['hide_mobile'] = $new_instance['hide_mobile'];
		return $instance;
	}

    public function form($instance) {
        $defaults = array(
            'title' => __('Kanews Modül', 'kanews'),
            'icon_type' => 'icon',
            'icon' => 'icon-star',
            'image' => '',
            'hide_desktop' => 'off',
            'hide_mobile' => 'off',
            'custompage' => '',
            'pages' => '',
            'desc' => '',
            'bg-color' => '',
            'grid' => 'col-12',
            'btn_text' => esc_html__('Gönder', 'kanews')
        );
        $instance = wp_parse_args((array) $instance, $defaults);

        // Genel Ayarlar
        Kanews_Form_Elements::render_accordion_field([
            'title' => __('Genel Ayarlar', 'kanews'),
            'content' => [
								[
									'type' => Kanews_Form_Elements::TYPE_SELECT,
									'id' => $this->get_field_id('grid'),
									'name' => $this->get_field_name('grid'),
									'label' => __('Genişlik', 'kanews'),
									'value' => $instance['grid'],
									'options' => array(
										'col' => __('Sığdır', 'kanews'),
										'col-12' => '12/12',
										'col-12 col-lg-8' => '12/8',
										'col-12 col-lg-6' => '12/6',
										'col-12 col-lg-4' => '12/4'
									)
								],
                [
                    'type' => Kanews_Form_Elements::TYPE_RADIO,
                    'id' => $this->get_field_id('icon_type'),
                    'name' => $this->get_field_name('icon_type'),
                    'label' => __('Görsel Tipi', 'kanews'),
                    'value' => $instance['icon_type'],
                    'options' => [
                        'icon' => __('İkon', 'kanews'),
                        'image' => __('Görsel', 'kanews')
                    ]
                ],
                [
                    'type' => Kanews_Form_Elements::TYPE_ICON_PICKER,
                    'id' => $this->get_field_id('icon'),
                    'name' => $this->get_field_name('icon'),
                    'label' => __('İkon', 'kanews'),
                    'value' => $instance['icon'],
                    'condition' => [
                        'icon_type' => 'icon'
                    ]
                ],
                [
                    'type' => Kanews_Form_Elements::TYPE_MEDIA,
                    'id' => $this->get_field_id('image'),
                    'name' => $this->get_field_name('image'),
                    'label' => __('Görsel', 'kanews'),
                    'value' => $instance['image'],
                    'preview' => true,
                    'condition' => [
                        'icon_type' => 'image'
                    ]
                ],
                [
                    'type' => Kanews_Form_Elements::TYPE_TEXT,
                    'id' => $this->get_field_id('title'),
                    'name' => $this->get_field_name('title'),
                    'label' => __('Başlık', 'kanews'),
                    'value' => $instance['title']
                ],
                [
                    'type' => Kanews_Form_Elements::TYPE_TEXTAREA,
                    'id' => $this->get_field_id('desc'),
                    'name' => $this->get_field_name('desc'),
                    'label' => __('Açıklama', 'kanews'),
                    'value' => $instance['desc']
                ]
            ]
        ]);

        // Buton Ayarları
        Kanews_Form_Elements::render_accordion_field([
            'title' => __('Buton Ayarları', 'kanews'),
            'content' => [
                [
                    'type' => Kanews_Form_Elements::TYPE_SELECT,
                    'id' => $this->get_field_id('pages'),
                    'name' => $this->get_field_name('pages'),
                    'label' => __('Sayfa', 'kanews'),
                    'value' => $instance['pages'],
                    'options' => Kanews_Form_Elements::get_pages_options()
                ],
                [
                    'type' => Kanews_Form_Elements::TYPE_TEXT,
                    'id' => $this->get_field_id('custompage'),
                    'name' => $this->get_field_name('custompage'),
                    'label' => __('Veya Özel Link', 'kanews'),
                    'value' => $instance['custompage']
                ],
                [
                    'type' => Kanews_Form_Elements::TYPE_TEXT,
                    'id' => $this->get_field_id('btn_text'),
                    'name' => $this->get_field_name('btn_text'),
                    'label' => __('Buton Yazısı', 'kanews'),
                    'value' => $instance['btn_text']
                ]
            ]
        ]);

        // Görünüm Ayarları
        Kanews_Form_Elements::render_accordion_field([
            'title' => __('Görünüm Ayarları', 'kanews'),
            'content' => [
                [
                    'type' => Kanews_Form_Elements::TYPE_COLOR,
                    'id' => $this->get_field_id('bg-color'),
                    'name' => $this->get_field_name('bg-color'),
                    'label' => __('Header Rengi', 'kanews'),
                    'value' => $instance['bg-color']
                ]
            ]
        ]);

        // Görünürlük Ayarları
        Kanews_Form_Elements::render_accordion_field([
            'title' => __('Görünürlük Ayarları', 'kanews'),
            'content' => [
                [
                    'type' => Kanews_Form_Elements::TYPE_TOGGLE,
                    'id' => $this->get_field_id('hide_desktop'),
                    'name' => $this->get_field_name('hide_desktop'),
                    'label' => __('Masaüstünde Gizle', 'kanews'),
                    'value' => $instance['hide_desktop']
                ],
                [
                    'type' => Kanews_Form_Elements::TYPE_TOGGLE,
                    'id' => $this->get_field_id('hide_mobile'),
                    'name' => $this->get_field_name('hide_mobile'),
                    'label' => __('Mobilde Gizle', 'kanews'),
                    'value' => $instance['hide_mobile']
                ]
            ]
        ]);
	}
}
?>