<?php 

if( class_exists( 'CSF' ) ) {

  CSF::createWidget( 'kanews_widget_ilan', array(
    'title'       => KAN_THEME_NAME .' - '."İlan",
    'description' => "İlan sistemi ile alakalı tüm bileşenler.",
    'classname'   => 'kanews_widget_class_ilan',
    'fields'      => array(

      array(
        'id'      => 'title',
        'type'    => 'text',
        'title'   => 'Title',
        'default' => 'İlanlar'
      ),

      array(
        'id'      => 'widget',
        'type'    => 'select',
        'title'   => 'Kullanılacak Bileşen',
        'options' => array(
          'post' => 'İlanlar',
          'search' => 'İlan Ara',
        ),
        'default' => 'post'
      ),
      array(
        'id'      => 'grid',
        'type'    => 'select',
        'title'   => 'Genişlik',
        'options' => array(
          'col-12' => '12/12',
          'col-12 col-lg-8' => '12/8',
          'col-12 col-lg-6' => '12/6',
          'col-12 col-lg-4' => '12/4'
        ),
        'default' => 'col-12'
      ),

      // Search
      array(
        'id'      => 'city',
        'type'    => 'switcher',
        'dependency' => array( 'widget', '==', 'search' ),
        'title'   => 'İl',
        'default' => true
      ),
      array(
        'id'      => 'town',
        'type'    => 'switcher',
        'dependency' => array( 'widget', '==', 'search' ),
        'title'   => 'İlçe',
        'default' => true
      ),
      array(
        'id'      => 'tags_form',
        'dependency' => array( 'widget', '==', 'search' ),
        'type'    => 'switcher',
        'title'   => 'Etiket',
        'default' => true
      ),
      array(
        'id'      => 'search',
        'type'    => 'switcher',
        'dependency' => array( 'widget', '==', 'search' ),
        'title'   => 'Kelime ile',
        'default' => true
      ),

      // Posts
      array(
        'id'      => 'col',
        'type'    => 'select',
        'dependency' => array( 'widget', '==', 'post' ),
        'title'   => 'Sütun Başına Yazı',
        'options' => array(
          'col-6 col-lg-12' => '1',
          'col-6 col-lg-6' => '2',
          'col-6 col-lg-4' => '3',
          'col-6 col-md-4 col-lg-3' => '4',
          'col-6 col-md-3 col-lg-2' => '6',
        ),
        'default' => 'col-6 col-md-4 col-lg-3'
      ),
      array(
        'id'       => 'posts',
        'dependency' => array( 'widget', '==', 'post' ),
        'type'     => 'slider',
        'title'    => 'İlan Sayısı',
        'min'      => 1,
        'step'     => 1,
        'default'  => 6,
      ),
      array(
        'id'      => 'sortby',
        'type'    => 'select',
        'title'   => 'Göre Sırala',
        'dependency' => array( 'widget', '==', 'post' ),
        'options' => array(
          'recent-s' => 'Yayınlanma Tarihine Göre (Yukarı Taşıma Dahil)',
          'recent' => 'Yayınlanma Tarihine Göre',
          'post-modified' => 'Düzenlenme Tarihine Göre',
          'commented' => 'En Çok Yorum Yapılan',
          'random' => 'Rastgele'
        ),
        'default' => 'recent-s'
      ),
      array(
        'id'      => 'date_range',
        'type'    => 'select',
        'dependency' => array( 'widget', '==', 'post' ),
        'title'   => 'Zaman Aralığı',
        'options' => array(
          '0' => 'Zaman Aralığı Seçin',
          'day' => 'Son 1 Gün',
          'week' => 'Son 1 Hafta',
          'month' => 'Son 1 Ay',
          'year' => 'Son 1 Yıl',
        ),
        'default' => '0'
      ),
      array(
        'id'      => 'categories',
        'type'    => 'select',
        'dependency' => array( 'widget', '==', 'post' ),
        'title'   => 'Kategori',
        'options' => 'kanews_get_terms_ilan_kategori',
        'multiple'=> true,
        'chosen'  => true,
        'default' => '0'
      ),
      array(
        'id'      => 'tags',
        'type'    => 'select',
        'dependency' => array( 'widget', '==', 'post' ),
        'title'   => 'Etiket',
        'options' => 'kanews_get_terms_ilan_tag',
        'multiple'=> true,
        'chosen'  => true,
        'default' => '0'
      ),
      array(
        'id'      => 'city_query',
        'type'    => 'text',
        'dependency' => array( 'widget', '==', 'post' ),
        'title'   => 'İl',
      ),
      array(
        'id'      => 'town_query',
        'type'    => 'text',
        'dependency' => array( 'widget', '==', 'post' ),
        'title'   => 'İlçe',
      ),

      array(
        'id'      => 'show_more_link',
        'type'    => 'text',
        'dependency' => array( 'widget', '==', 'post' ),

        'title'   => 'Daha Fazla Linki',
        'default' => ''
      ),

      array(
        'id'      => 'hide_desktop',
        'type'    => 'switcher',
        'title'   => 'Masaüstünde Gizle',
        'default' => false
      ),
      array(
        'id'      => 'hide_mobile',
        'type'    => 'switcher',
        'title'   => 'Mobilde Gizle',
        'default' => false
      ),
    
    )
  ) );
  
  if( ! function_exists( 'kanews_widget_ilan' ) ) {
    function kanews_widget_ilan( $widgets, $instance ) {
      $hide_mobile = $instance['hide_mobile'] ? 'on' : 'off';
      $hide_desktop = $instance['hide_desktop']? 'on' : 'off';

      if( ! kanews_get_option('ilan-sistemi') )
      return;

      if($hide_mobile == 'on') {
        if(kan_is_mobile())
        return;
      }

      if($hide_desktop == 'on') {
        if(!kan_is_mobile())
        return;
      }

      if( $instance['widget'] == 'search' ) {
        wp_enqueue_script('kanews-ilan-search');
        $args_defaults = array( 
          'grid'     => 'col-12',
          'title'    => '',
          'city'     => true,
          'town'     => true,
          'search'   => true,
          'tags_form'     => true,
        ); 
        $args = wp_parse_args( $instance, $args_defaults );
        
        echo '<div class="'.$args['grid'].'"><div class="kanews-section kanews-widget-ilan-search">'; ?>
        
        <?php if ( ! empty($args['title']) ):
          echo ( $widgets['before_title'] . $args['title'] . $widgets['after_title'] );
        endif; ?>
  
        <form class="p-1 kanews-form-filter" action="<?php echo get_post_type_archive_link('ilan'); ?>">
          <div class="empty" style="display: block;height: 10px"></div>
          <div class="row no-gutters">
            <?php if( $args['city'] ): ?>
              <div class="col-12">
                <div class="kanews-form2 bgw">
                  <select name="il" id="ilan-il">
                    <option value="-1">İl</option>
                  </select>
                </div>
              </div>
            <?php endif; ?>
            <?php if( $args['city'] &&  $args['town'] ): ?>
              <div class="col-12">
                <div class="kanews-form2 bgw">
                  <select name="ilce" id="ilan-ilce" disabled="disabled">
                    <option value="-1">İlçe</option>
                  </select>
                </div>
              </div>
            <?php endif; ?>
          </div>
          
          <?php 
            if( $args['tags_form'] ) {
              $taxonomies = get_terms( array(
                  'taxonomy' => 'ilan-etiket',
                  'hide_empty' => false
              ) );
              if ( !empty($taxonomies) ) :
                $output = '<div class="empty" style="display: block;height: 10px"></div><div class="row flex-column">';
                foreach( $taxonomies as $category ) {
                  $output .= '<div class="col d-flex"><div class="kanews-form"><input type="checkbox" name="labels[]" value="'.esc_attr( $category->term_id ).'" id="ilan-etiket-'.$category->slug.'" />
                  </div><label for="ilan-etiket-'.$category->slug.'">'.esc_html( $category->name ).'</label></div>';
                }
                $output.='</div>';
                echo $output;
              endif;
            }
          ?>
          <?php if( $args['search'] ): ?>
            <div class="kanews-form2 bgw">
              <input class="mb-0" type="text" name="search" placeholder="Kelime Ara" />
            </div>
          <?php endif; ?>
          <button type="submit" class="kanews-btn kanews-btn-block kanews-btn-sm mb-0">Filtrele</button>
        </form>
  
        <?php echo '</div></div>';
      } else {
        $args_defaults = array( 
          'grid'       => 'col-12',
          'col'        => 'col-6 col-md-4 col-lg-3',
          'sortby'     => 'recent-s',
          'title'      => '',
          'categories' => '',
          'tags'       => '',
          'city_query' => '',
          'town_query' => '',
          'show_more_link' => '',
          'date_range' => '0',
          'posts'      => 10,
          'post_type'  => 'ilan',
        ); 
        $args = wp_parse_args( $instance, $args_defaults );
        extract($args);


        $query_args = array(
          'number'				=> $posts,
          'sortby' 				=> $sortby,
          'range'				  => $date_range,
          'icat'    			=> $categories,
          'itags'    			=> $tags,
          'city_query'    => $city_query,
          'town_query'    => $town_query,
          'post_type'		  => 'ilan'
        );

        // print_r($query_args);

        $kanews_query = kan_query( $query_args );
        if ($kanews_query->have_posts()) : 
          echo '<div class="'.$args['grid'].'"><div class="kanews-section kanews_widget_ilan">'; ?>
            <?php if ( ! empty($title) ):
              echo ( $widgets['before_title'] . $title . $widgets['after_title'] );
            endif; ?>
            <div class="row p-1">
              <?php while($kanews_query->have_posts()): $kanews_query->the_post(); 
                get_template_part('template-parts/archives/article', 'ilan', array('col'=> $col));
              endwhile; wp_reset_postdata();  ?>

<?php if ( isset($instance['show_more_link']) && !empty($instance['show_more_link']) ): ?>
							<div class="col-12">
								<div class="col-12 col-md-8 mt-0 m-auto"><a href="<?php echo esc_url($instance['show_more_link']); ?>" class="kanews-btn kanews-btn-block kanews-btn-sm kanews-btn-o">Daha Fazla</a></div>
							</div>
						<?php endif; ?>

            </div>
            
          <?php echo '</div></div>';
        endif;
      }
    }
  }
}