<?php 

// Control core classes for avoid errors
if( class_exists( 'CSF' ) ) {

  CSF::createWidget( 'kanews_widget_class_imagebox', array(
    'title'       => KAN_THEME_NAME .' - Resim Kutusu',
    'classname'   => 'kanews_widget_class_imagebox kanews-section-flat',
    'fields'      => array(

      array(
        'id'      => 'title',
        'type'    => 'text',
        'title'   => 'Title',
      ),
      array(
        'id'      => 'style',
        'type'    => 'select',
        'title'   =>'Görünüm',
        'options' => array(
          '1' => sprintf('Görünüm %s', '#1'),
          '2' => sprintf('Görünüm %s', '#2'),
        ),
        'default' => '1'
      ),
      array(
        'id'      => 'grid',
        'type'    => 'select',
        'title'   =>'Genişlik',
        'options' => array(
          'col-12' => '12/12',
          'col-12 col-lg-8' => '12/8',
          'col-12 col-lg-6' => '12/4',
          'col-12 col-lg-4' => '12/4',
        ),
        'default' => 'col-12'
      ),
      array(
        'id'      => 'column',
        'type'    => 'select',
        'title'   =>'Sütun Başına',
        'options' => array(
          'col-12' => '1',
          'col-12 col-lg-6' => '2',
          'col-12 col-lg-4' => '3',
          'col-12 col-lg-3' => '4',
          'col-12 col-lg-2' => '6',
        ),
        'default' => 'col-12 col-lg-3'
      ),

      array(
        'id'       => 'image-height',
        'type'     => 'dimensions',
        'width'   => false,
        'title'    =>'Görsel Yüksekliği',
        'default'  => array(
          'height'  => '375',
          'unit'   => 'px',
        ),
      ),

      array(
        'id'     => 'imagebox',
        'type'   => 'group',
        'title'  =>'Gösterilecekler',
        'button_title'  =>'Yeni Ekle',
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => 'Başlık'
          ),
          array(
            'id'    => 'subtitle',
            'type'  => 'text',
            'title' => 'Alt Başlık'
          ),
          array(
            'id'    => 'thumb',
            'type'  => 'media',
            'title' => 'Görsel'
          ),
          array(
            'id'    => 'link',
            'type'  => 'text',
            'title' => 'Link'
          ),
          array(
            'id'    => 'color',
            'type'  => 'color',
            'title' =>'Vurgulanan Renk'
          ),
        ),
      ),

      array(
        'id'      => 'hide_desktop',
        'type'    => 'switcher',
        'title'   => 'Masaüstünde Gizle',
      ),

      array(
        'id'      => 'hide_mobile',
        'type'    => 'switcher',
        'title'   => 'Mobilde Gizle',
      ),

      array(
        'id'      => 'open_in_new_tab',
        'type'    => 'switcher',
        'title'   => 'Linkleri Yeni Sekmede Aç',
        'default' => false,
      ),

    )
  ) );

  if( ! function_exists( 'kanews_widget_class_imagebox' ) ) {
    function kanews_widget_class_imagebox( $widget, $instance ) {

      $args_defaults = array( 
        'grid'     => 'col-12',
        'column'   => 'col-12 col-lg-3',
        'style'    => '1',
        'imagebox' => '',
        'title'    => '',
        'hide_desktop' => false,
        'hide_mobile'  => false,
        'open_in_new_tab' => false,
        'image-height' => array(
          'height' => '375',
          'unit'   => 'px'
        ),
      ); 
      $args = wp_parse_args( $instance, $args_defaults );

      if($args['hide_mobile']) {
        if(kan_is_mobile())
        return;
      }
  
      if($args['hide_desktop']) {
        if(!kan_is_mobile())
        return;
      }

      if(empty($args['imagebox']))
      return;

      ?>

      <div class="<?php echo $args['grid']; ?>"> 
        <div id="<?php echo $widget['widget_id']; ?>" class="kanews-section kanews-section-flat kanews-section-gutter <?php echo $widget['class'] ?>">
          <div class="row">
            <?php foreach($args['imagebox'] as $item): ?>
              <div class="kanews-image-box-item <?php echo $args['column']; ?>">
                <div class="kanews-image-box">
                  <?php if($item['thumb'] != ''): ?>
                    <?php echo wp_get_attachment_image($item['thumb']['id'], 'full'); ?>
                  <?php endif; ?>
                  <?php if($item['link'] != ''): ?>
                    <a class="kanews-image-box-url" href="<?php echo esc_url($item['link']); ?>" title="<?php echo esc_attr( $item['title'] ); ?>" <?php echo $args['open_in_new_tab'] ? 'target="_blank" rel="noopener noreferrer"' : ''; ?>></a>
                  <?php endif; ?>
                  <?php if($item['title'] != '' || $item['subtitle'] != ''): ?>
                    <div class="kanews-image-box-content" <?php echo ( isset($item['color']) && $item['color'] != '' ) ? 'style="--gradient-start-color: '.$item['color'].'"' : ''; ?>>
                      <?php if($item['title'] != ''): ?>
                        <h3 class="kanews-image-box-title"><?php echo $item['title']; ?></h3>
                      <?php endif; ?>
                      <?php if($item['subtitle'] != ''): ?>
                        <div class="kanews-image-box-subtitle"><?php echo $item['subtitle']; ?></div>
                      <?php endif; ?>
                    </div>
                  <?php endif; ?>
                </div>
              </div>
            <?php endforeach; ?>
          </div>
        </div>
      </div>
    <?php 

      $widget_id = '#'. $widget['widget_id'];

      if ( isset( $args['image-height']['unit'] ) && isset( $args['image-height']['height'] ) && $args['image-height']['height'] != '375' ) {

        $out = "<style id='kanews-theme-inline-$widget_id' scoped type=\"text/css\">";

          $out .= "
            $widget_id .kanews-image-box {
              height: ".$args['image-height']['height']."".$args['image-height']['unit'].";
            }
          ";

        echo ( $out ) ."</style>";
      }

    }
  }

}