<?php

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

if(is_admin() || is_customize_preview(  )) {
	require_once dirname(__FILE__) . '/widget-framework.php';
}
// Widget Class
class kanews_widget_class_posts_6 extends WP_Widget {

  // Create
	public function __construct(){
		$widget_ops = array('classname' => 'kanews_widget_posts_6');
		$control_ops = array('id_base' => 'kanews_widget_posts_6');
		parent::__construct('kanews_widget_posts_6', ''.KAN_THEME_NAME .' - '.__( "Yazılar" , 'kanews' ).' #6' , $widget_ops, $control_ops );
		add_action('admin_enqueue_scripts', array('Kanews_Form_Elements', 'enqueue_scripts'));

	}
  
  // Front-end
	public function widget($args, $instance)
	{
    $hide_mobile = isset($instance['hide_mobile']) ? 'on' : 'off';
		$hide_desktop = isset($instance['hide_desktop']) ? 'on' : 'off';

		if($hide_mobile == 'on') {
			if(kan_is_mobile())
			return;
		}

		if($hide_desktop == 'on') {
			if(!kan_is_mobile())
			return;
		}

		$grid = (!empty($instance['grid'])) ? $instance['grid'] : 'col-12';
		$col = (!empty($instance['col'])) ? $instance['col'] : 'col-12 col-md-6 col-lg-4';
		$title = apply_filters('widget_title', isset($instance['title']) ? $instance['title'] : '' );
    $html = !empty($instance['html']) ? $instance['html'] : 'h2';

		$categories = (isset($instance['categories'])) ? $instance['categories'] : '';
		$categories2 = (isset($instance['categories2'])) ? $instance['categories2'] : '';
		$categories3 = (isset($instance['categories3'])) ? $instance['categories3'] : '';
		$categories4 = (isset($instance['categories4'])) ? $instance['categories4'] : '';
		$categories5 = (isset($instance['categories5'])) ? $instance['categories5'] : '';
    $posts = (isset($instance['posts'])) ? $instance['posts'] : '5';
    // $tags = (isset($instance['tags'])) ? $instance['tags'] : '';
    $style = ($instance['posts']) ? $instance['style'] : '1';
    $offset = (isset($instance['offset'])) ? $instance['offset'] : '';
    $date_range = (isset($instance['date_range']) && $instance['date_range'] != '0') ? $instance['date_range'] : null;
    $sortby = (isset($instance['sortby'])) ? $instance['sortby'] : 'recent';
		$is_do_not_dublicate = $instance['postnotin'] == 'on' ? true : false;

		$format = !empty($instance['format']) ? $instance['format'] : '';

    $show_post_date = isset($instance['show_post_date']) ? 'on' : 'off';
    $show_post_cat = isset($instance['show_post_cat']) ? 'on' : 'off';
    $dark_mode = !isset($instance['dark_mode']) ? '' : 'dark-mode';

    $bg_color = !empty($instance['bg-color']) ? $instance['bg-color'] : '';
		$bg_color2 = !empty($instance['bg-color2']) ? $instance['bg-color2'] : '';
		$accent_color = !empty($instance['accent-color']) ? $instance['accent-color'] : '';


    $number = $this->number;

    $cat_style = '';
    switch($style) {
      case 1:
        $class = 'kanews-post-item kanews-post-grid-item kanews-post-grid-item-flat';
        $thumbnail = 'kanews-post-1';
        $cat_style = 'style-2';
        if(isset($args['id']))
        $sidebar = explode('-', $args['id']);
        else
        $sidebar = array('0' => 'home', '1' => 'content');
		
        if(isset($sidebar[2]) && $sidebar[2] == 'full') {
          if($col == 'col-12') {
            $thumbnail = 'kanews-manset-2'; 
            if( $grid == 'col-12' )
            $class .= ' kanews-post-big';
          } elseif($col == 'col-12')
            $thumbnail = 'kanews-manset-2';
          elseif($col == 'col-6 col-md-6 col-lg-4')
            $thumbnail = 'kanews-post-3';
          elseif($col == 'col-6 col-lg-3')
            $thumbnail = 'kanews-post-1';
        }elseif($sidebar[1] == 'content') {
          $grid = 'col-12';
          if($col == 'col-12')
            $thumbnail = 'kanews-manset-3';
            elseif($col == 'col-6')
            $thumbnail = 'kanews-post-3';
        }elseif($sidebar[1] == 'sidebar') {
          $grid = 'col-12';
          $col = 'col-12';
          $thumbnail = 'kanews-post-3';
        }
      break;
      case 2:
        $class = 'kanews-post-item kanews-post-grid-item kanews-post-small-item';
        $thumbnail = 'thumbnail';
        if(isset($args['id']))
        $sidebar = explode('-', $args['id']);
        else
        $sidebar = array('0' => 'home', '1' => 'content');
		
        if($sidebar[1] == 'sidebar') {
          $col = 'col-12';
          $grid = 'col-12';
        }elseif($sidebar[1] == 'content') {
          $col = 'col-12 col-md-6';
          $grid = 'col-12';
        }

        if($col != 'col-12') {
          $gutter = 'no-gutters';
        }
      break;
      case 3:
        $class = 'kanews-post-overlay';
        if($col == 'col-12')
        $thumbnail = 'kanews-manset-3';
        elseif($col == 'col-12 col-md-6')
        $thumbnail = 'kanews-post-3';
        elseif($col == 'col-12 col-md-6 col-lg-4')
        $thumbnail = 'kanews-post-1';
        elseif($col == 'col-12 col-md-6 col-lg-3')
        $thumbnail = 'kanews-post-2';

        if(isset($args['id']))
        $sidebar = explode('-', $args['id']);
        else
        $sidebar = array('0' => 'home', '1' => 'content');
		
        if(isset($sidebar[2]) && $sidebar[2] == 'full') {
          switch($grid) {
            case 'col-12':
              if($col == 'col-12')
                $thumbnail = 'kanews-manset-2';
              elseif($col == 'col-12 col-md-6')
                $thumbnail = 'kanews-post-2';
              elseif($col == 'col-12 col-md-6 col-lg-4')
                $thumbnail = 'kanews-post-3';
              elseif($col == 'col-12 col-md-6 col-lg-3')
                $thumbnail = 'kanews-post-1';
            break;
          }
        }elseif($sidebar[1] == 'content') {
          $grid = 'col-12';
          if($col == 'col-12 col-md-6 col-lg-3') {
            $col = 'col-12 col-md-6 col-lg-4'; $thumbnail = 'kanews-post-1';
          }
        }elseif($sidebar[1] == 'sidebar') {
          $grid = 'col-12';
          $col = 'col-12';
          $thumbnail = 'kanews-post-3';	
        }
      break;
    }

    $widget_id = '#'. $args['widget_id'];
			$output_css = '';
			if( $bg_color != '' && $bg_color2 != '') {
				$output_css .= "
				.light-mode $widget_id.kanews-section {
					background: linear-gradient(135deg,  $bg_color, $bg_color2 ) !important;
				}
        $widget_id.kanews-section .kanews-post-item {
          background: transparent !important
        }
				";
			}

			if( $accent_color != '') {
				$output_css .= "
				$widget_id {
					--kan-theme-color: $accent_color
				}
				";
			}

			if( !empty($output_css) ) {
				echo "<style id='kanews-theme-inline-$widget_id' scoped type=\"text/css\">".( kan_minify_css($output_css) ) ."</style>";
			}

		?>

		
    <div class="<?php echo $grid; ?> <?php echo $dark_mode; ?>"> 
      <div id="<?php echo $this->id; ?>" class="kanews-section kanews-posts-3 <?php echo $this->widget_options['classname']; ?>">

        <div class="kanews-tab">
          <!-- Tab Panel -->
          <ul class="nav nav-tabs d-flex flex-wrap" id="kanewsTab-<?php echo $number; ?>" role="tablist">
            <li class="nav-item" role="presentation">
              <div class="nav-link active" id="category-tab-<?php echo $number; ?>-<?php echo $categories; ?>" data-toggle="tab" href="#category-<?php echo $number; ?>-<?php echo $categories; ?>" role="tab" data-controls="category-<?php echo $number; ?>-<?php echo $categories2; ?>" data-selected="true"><?php echo $title ?></div>
            </li>
            <?php if($categories2 != 'no' && $categories2 != ''): ?>
              <li class="nav-item" role="presentation">
                <div class="nav-link" id="category-tab-<?php echo $number; ?>-<?php echo $categories2; ?>" data-toggle="tab" href="#category-<?php echo $number; ?>-<?php echo $categories2; ?>" role="tab" data-controls="category-<?php echo $number; ?>-<?php echo $categories2; ?>" data-selected="false">
                <?php echo get_cat_name($categories2); ?></div>
              </li>
            <?php endif; ?>
            <?php if($categories3 != 'no' && $categories3 != ''): ?>
              <li class="nav-item" role="presentation">
                <div class="nav-link" id="category-tab-<?php echo $number; ?>-<?php echo $categories3; ?>" data-toggle="tab" href="#category-<?php echo $number; ?>-<?php echo $categories3; ?>" role="tab" data-controls="category-<?php echo $number; ?>-<?php echo $categories3; ?>" data-selected="false">
                <?php echo get_cat_name($categories3); ?></div>
              </li>
            <?php endif; ?>
            <?php if($categories4 != 'no' && $categories4 != ''): ?>
              <li class="nav-item" role="presentation">
                <div class="nav-link" id="category-tab-<?php echo $number; ?>-<?php echo $categories4; ?>" data-toggle="tab" href="#category-<?php echo $number; ?>-<?php echo $categories4; ?>" role="tab" data-controls="category-<?php echo $number; ?>-<?php echo $categories4; ?>" data-selected="false">
                <?php echo get_cat_name($categories4); ?></div>
              </li>
            <?php endif; ?>
            <?php if($categories5 != 'no' && $categories5 != ''): ?>
              <li class="nav-item" role="presentation">
                <div class="nav-link" id="category-tab-<?php echo $number; ?>-<?php echo $categories5; ?>" data-toggle="tab" href="#category-<?php echo $number; ?>-<?php echo $categories5; ?>" role="tab" data-controls="category-<?php echo $number; ?>-<?php echo $categories5; ?>" data-selected="false">
                <?php echo get_cat_name($categories5); ?></div>
              </li>
            <?php endif; ?>
          </ul>
          
          <div class="tab-content" id="kanewsTabContent-<?php echo $number; ?>">
          
            <?php $categories_array = array(
                !empty($categories) ? $categories : null,
                !empty($categories2) ? $categories2 : null,
                !empty($categories3) ? $categories3 : null,
                !empty($categories4) ? $categories4 : null,
                !empty($categories5) ? $categories5 : null
            );

            // Boş değerleri temizle
            $categories_array = array_filter($categories_array);
						$counter=0; 
            foreach($categories_array as $category): $counter++;
              $query_args = array(
                    'number'        => $posts,
                    'id'           => $category,
                    'sortby'       => $sortby,
                    'offset'       => $offset,
                    'range'        => $date_range,
                    'format'       => $format 
                );
                $kanews_query = kan_query($query_args);
              ?>
              <?php if ($kanews_query->have_posts()) : ?>
                <div class="tab-pane fade <?php if($counter == 1) echo 'show active'; ?>" id="category-<?php echo $number; ?>-<?php echo $category; ?>" role="tabpanel" data-labelledby="category-tab-<?php echo $number; ?>-<?php echo $category; ?>">
                  <div class="d-flex flex-wrap" >
                    <?php while($kanews_query->have_posts()): $kanews_query->the_post(); global $post; ?>
                      <div class="<?php echo $col; ?>">
                        <div class="<?php echo $class; ?>">
                          <a href="<?php the_permalink(); ?>" class="kanews-post-href" aria-label="<?php the_title(); ?>"></a>	
                          <?php do_action('kanews_post_hook'); ?>
                          <?php kanews_post_thumbnail($thumbnail, 'kanews-post-thumb'); ?>
                          <div class="kanews-post-content">
													
														<?php if($show_post_cat != 'off'): ?>
															<?php echo kanews_primary_category($post->ID, 'style-2'); ?>
														<?php endif; ?>
														<?php if($show_post_date != 'off'): ?>
															<?php echo kanews_post_date('post', 'span'); ?>
														<?php endif; ?>
                            <?php the_title( sprintf( '<'.$html.' class="kanews-post-headline truncate truncate-2"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></'.$html.'>' ); ?>
						
                          </div>
                        </div>
                      </div>
                      <?php 
                      if( $is_do_not_dublicate ){
                        Kanews\Helper::do_not_dublicate( $post->ID );
                      }
                      ?>
                    <?php endwhile; wp_reset_postdata(); ?>
                  </div>
                </div>
                
              <?php endif; ?>
            <?php endforeach; ?>
          </div>

        </div>

      </div>
    </div>
	<?php }
  
  // Update Form
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = $new_instance['title'];
		$instance['style'] = $new_instance['style'];
		$instance['grid'] = $new_instance['grid'];
		$instance['col'] = $new_instance['col'];
    $instance['html'] = $new_instance['html'];

		$instance['tags'] = $new_instance['tags'];
		$instance['categories'] = $new_instance['categories'];
		$instance['categories2'] = $new_instance['categories2'];
		$instance['categories3'] = $new_instance['categories3'];
		$instance['categories4'] = $new_instance['categories4'];
		$instance['categories5'] = $new_instance['categories5'];
		$instance['posts'] = $new_instance['posts'];
		$instance['offset'] = $new_instance['offset'];
		$instance['sortby'] = $new_instance['sortby'];
    $instance['postnotin'] = $new_instance['postnotin'];
		$instance['date_range'] = $new_instance['date_range'];
		$instance['format'] = $new_instance['format'];

    $instance['show_post_date'] = $new_instance['show_post_date'];
    $instance['show_post_cat'] = $new_instance['show_post_cat'];
    $instance['dark_mode'] = $new_instance['dark_mode'];

    $instance['hide_desktop'] = $new_instance['hide_desktop'];
		$instance['hide_mobile'] = $new_instance['hide_mobile'];
    $instance['bg-color'] = $new_instance['bg-color'];
		$instance['bg-color2'] = $new_instance['bg-color2'];
		$instance['accent-color'] = $new_instance['accent-color'];
		
		return $instance;
	}

  // Back-end
	public function form($instance)
	{
		$defaults = array( 
			// Genel Ayarlar
			'title' => esc_html__('Modül', 'kanews'),

			'grid' => 'col-12', 
			'col' => 'col-12 col-md-6 col-lg-4', 
			'html' => 'h3',
			'style' => '1', 

			// Sıralama Ayarları
			'postnotin' => '',
			'tags' => '',
			'categories' => array(),
			'categories2' => array(),
			'categories3' => array(),
			'categories4' => array(),
			'categories5' => array(),
			'posts' => 5,
			'sortby' => 'recent',
			'date_range' => '0', 
			'format' => '0',
			'offset' => '0',
			'include_columist' => 'off',

			// İçerik Ayarları
			'show_post_cat' => 'on',
			'show_post_date' => 'on',
			'dark_mode' => 'off',

			// Görünüm Ayarları
			'accent-color' => '',
			'bg-color' => '',
			'bg-color2' => '',
			'hide_desktop' => 'off',
			'hide_mobile' => 'off',
		);

		$instance = wp_parse_args((array) $instance, $defaults); 


		// Genel Ayarlar Accordion
		Kanews_Form_Elements::render_accordion_field(array(
			'title' => __('Genel Ayarlar', 'kanews'),
			'content' => array(
				array(
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('title'),
					'name' => $this->get_field_name('title'),
					'label' => __('Başlık', 'kanews'),
					'value' => $instance['title']
				),

				array(
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('grid'),
					'name' => $this->get_field_name('grid'),
					'label' => __('Genişlik', 'kanews'),
					'value' => $instance['grid'],
					'options' => array(
						'col-12' => '12/12',
						'col-12 col-lg-8' => '12/8',
						'col-12 col-lg-6' => '12/6',
						'col-12 col-lg-4' => '12/4'
					)
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('html'),
					'name' => $this->get_field_name('html'),
					'label' => __('Yazı Başlığı HTML Tag', 'kanews'),
					'value' => $instance['html'],
					'options' => array(
						'div' => 'Div',
						'h1' => 'H1',
						'h2' => 'H2',
						'h3' => 'H3',
						'h4' => 'H4',
						'h5' => 'H5',
						'h6' => 'H6'
					)
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('style'),
					'name' => $this->get_field_name('style'),
					'label' => __('Görünüm', 'kanews'),
					'value' => $instance['style'],
					'options' => array(
						'1' => '1',
						'2' => '2',
						'3' => '3'
					)
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('col'),
					'name' => $this->get_field_name('col'),
					'label' => __('Sütun Başına Yazı', 'kanews'),
					'value' => $instance['col'],
					'options' => array(
						'col-12' => '1',
						'col-12 col-md-6' => '2',
						'col-12 col-md-6 col-lg-4' => '3',
						'col-12 col-lg-3' => '4'
					)
				)
			)
		));

		// Sıralama Ayarları Accordion
		Kanews_Form_Elements::render_accordion_field(array(
			'title' => __('Sıralama Ayarları', 'kanews'),
			'content' => array(
				array(
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('sortby'),
					'name' => $this->get_field_name('sortby'),
					'label' => __('Göre Sırala', 'kanews'),
					'value' => $instance['sortby'],
					'options' => array(
						'recent' => __('Yayınlanma Tarihine Göre', 'kanews'),
						'post-modified' => __('Düzenlenme Tarihine Göre', 'kanews'),
						'post-viewed' => __('En Çok Okunan Yazı - Tüm Zamanlar', 'kanews'),
						'commented' => __('En Çok Yorum Yapılan', 'kanews'),
						'random' => __('Rastgele', 'kanews')
					)
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('date_range'),
					'name' => $this->get_field_name('date_range'),
					'label' => __('Zaman Aralığı', 'kanews'),
					'value' => $instance['date_range'],
					'options' => array(
						'0' => __('Zaman Aralığı Seçin', 'kanews'),
						'day' => __('Son 1 Gün', 'kanews'),
						'week' => __('Son 1 Hafta', 'kanews'),
						'month' => __('Son 1 Ay', 'kanews'),
						'year' => __('Son 1 Yıl', 'kanews')
					)
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SELECT2_CATEGORIES,
					'id' => $this->get_field_id('categories'),
					'name' => $this->get_field_name('categories'),
					'label' => __('Kategori 1', 'kanews'),
					'value' => $instance['categories'],
					'multiple' => false,
					'placeholder' => __('Kategori Seçin', 'kanews')
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SELECT2_CATEGORIES,
					'id' => $this->get_field_id('categories2'),
					'name' => $this->get_field_name('categories2'),
					'label' => __('Kategori 2', 'kanews'),
					'value' => $instance['categories2'],
					'multiple' => false,
					'placeholder' => __('Kategori Seçin', 'kanews')
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SELECT2_CATEGORIES,
					'id' => $this->get_field_id('categories3'),
					'name' => $this->get_field_name('categories3'),
					'label' => __('Kategori 3', 'kanews'),
					'value' => $instance['categories3'],
					'multiple' => false,
					'placeholder' => __('Kategori Seçin', 'kanews')
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SELECT2_CATEGORIES,
					'id' => $this->get_field_id('categories4'),
					'name' => $this->get_field_name('categories4'),
					'label' => __('Kategori 4', 'kanews'),
					'value' => $instance['categories4'],
					'multiple' => false,
					'placeholder' => __('Kategori Seçin', 'kanews')
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SELECT2_CATEGORIES,
					'id' => $this->get_field_id('categories5'),
					'name' => $this->get_field_name('categories5'),
					'label' => __('Kategori 5', 'kanews'),
					'value' => $instance['categories5'],
					'multiple' => false,
					'placeholder' => __('Kategori Seçin', 'kanews')
				),

				array(
					'type' => Kanews_Form_Elements::TYPE_SLIDER,
					'id' => $this->get_field_id('offset'),
					'name' => $this->get_field_name('offset'),
					'label' => __('Offset', 'kanews'),
					'value' => $instance['offset'],
					'min' => 0,
					'max' => 50,
					'step' => 1,
					'description' => __('Örneğin 1 girerseniz birinci yazıyı hariç tutar, ikinci yazıdan başlar.', 'kanews')
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SLIDER,
					'id' => $this->get_field_id('posts'),
					'name' => $this->get_field_name('posts'),
					'label' => __('Yazı Sayısı', 'kanews'),
					'value' => $instance['posts'],
					'min' => 1,
					'max' => 20,
					'step' => 1
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('postnotin'),
					'name' => $this->get_field_name('postnotin'),
					'label' => __('Bu yazıları başka bileşende gösterme', 'kanews'),
					'value' => $instance['postnotin']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('include_columist'),
					'name' => $this->get_field_name('include_columist'),
					'label' => __('Köşe yazılarını dahil et', 'kanews'),
					'value' => $instance['include_columist']
				)
			)
		));

		// İçerik Ayarları Accordion
		Kanews_Form_Elements::render_accordion_field(array(
			'title' => __('İçerik Ayarları', 'kanews'),
			'content' => array(

				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('show_post_cat'),
					'name' => $this->get_field_name('show_post_cat'),
					'label' => __('Yazı Kategorisini Göster', 'kanews'),
					'value' => $instance['show_post_cat']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('show_post_date'),
					'name' => $this->get_field_name('show_post_date'),
					'label' => __('Yazı Tarihini Göster', 'kanews'),
					'value' => $instance['show_post_date']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('dark_mode'),
					'name' => $this->get_field_name('dark_mode'),
					'label' => __('Koyu Mod', 'kanews'),
					'value' => $instance['dark_mode']
				),

			)
		));

		// Görünüm Ayarları Accordion
		Kanews_Form_Elements::render_accordion_field(array(
			'title' => __('Görünüm Ayarları', 'kanews'),
			'content' => array(
				array(
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('accent-color'),
					'name' => $this->get_field_name('accent-color'),
					'label' => __('Birincil Renk', 'kanews'),
					'value' => $instance['accent-color']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('bg-color'),
					'name' => $this->get_field_name('bg-color'),
					'label' => __('Arkaplan Rengi', 'kanews'),
					'value' => $instance['bg-color']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('bg-color2'),
					'name' => $this->get_field_name('bg-color2'),
					'label' => __('Arkaplan Rengi 2', 'kanews'),
					'value' => $instance['bg-color2']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_desktop'),
					'name' => $this->get_field_name('hide_desktop'),
					'label' => __('Masaüstünde Gizle', 'kanews'),
					'value' => $instance['hide_desktop']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_mobile'),
					'name' => $this->get_field_name('hide_mobile'),
					'label' => __('Mobilde Gizle', 'kanews'),
					'value' => $instance['hide_mobile']
				)
			)
		));
	}
}
?>