<?php

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

if(is_admin() || is_customize_preview(  )) {
	require_once dirname(__FILE__) . '/widget-framework.php';
}

// Widget Class
class kanews_widget_class_prayer extends WP_Widget {

  // Create
	public function __construct(){
		$widget_ops = array('classname' => 'kanews_widget_prayer');
		$control_ops = array('id_base' => 'kanews_widget_prayer');
		parent::__construct('kanews_widget_prayer', ''.KAN_THEME_NAME .' - '.__( "Namaz Vakitleri" , 'kanews' ), $widget_ops, $control_ops );
		add_action('admin_enqueue_scripts', array('Kanews_Form_Elements', 'enqueue_scripts'));
	}
  
  // Front-end
	public function widget($args, $instance)
	{
		$hide_mobile = isset($instance['hide_mobile']) ? 'on' : 'off';
		$hide_desktop = isset($instance['hide_desktop']) ? 'on' : 'off';

		if($hide_mobile == 'on') {
			if(kan_is_mobile())
			return;
		}

		if($hide_desktop == 'on') {
			if(!kan_is_mobile())
			return;
		}

    $title = apply_filters('widget_title', isset($instance['title']) ? $instance['title'] : '' );
    $grid = (!empty($instance['grid'])) ? $instance['grid'] : 'col-12';
    $region = isset($instance['region']) && $instance['region'] != '' ? $instance['region'] : 'Ankara';
    $city = $instance['city'] != '' ? $instance['city'] : $region;
    $pages = (!empty($instance['pages'])) ? $instance['pages'] : '';

    if(isset($args['id']))
		$sidebar = explode('-', $args['id']);
		else
		$sidebar = array('0' => 'home', '1' => 'content');
		
		if($sidebar[1] == 'sidebar') {
      $grid = 'col-12';
    }

		$date = date('Y-m-d');
		$data = kanews_prayer_times_api( 'Turkey', $region, $city, $date, 30);

		if( empty($data) || !isset( $data['times'] ) || !isset($data['times'][$date]) )
		return;

    $bg_color = !empty($instance['bg-color']) ? $instance['bg-color'] : '';
    $bg_color2 = !empty($instance['bg-color2']) ? $instance['bg-color2'] : '';

    // CSS çıktısı için
    $widget_id = '#'. $args['widget_id'];
    $output_css = '';
    
    if($bg_color != '' && $bg_color2 != '') {
        $output_css .= "
        $widget_id .prayer-header {
            background: linear-gradient(135deg, $bg_color, $bg_color2) !important;
        }
        ";
    }

    if(!empty($output_css)) {
        echo "<style id='kanews-prayer-inline-$widget_id' scoped type=\"text/css\">".($output_css)."</style>";
    }

    ?>

    <div class="<?php echo $grid; ?>">
			<div id="<?php echo $args['widget_id']; ?>" class="kanews-section kanews-section-flat kanews_widget_prayer">

				<section class="prayer-times prayer-header ">
				<?php if( $pages != 'all' && $pages != ''):  ?>
					<div class="kanews-form2 mb-0 p-1">
						<select id="redirectSelect" class="mb-0" onchange="redirectToSelected()">
							<option option option value="<?php echo esc_attr($region); ?>"><?php echo $region; ?></option>

	
								<?php $sehirler = kanews_get_sehir(); unset($sehirler[0]); foreach( $sehirler as $sehir ): ?>
									<?php if( $region != $sehir ) : ?>
									<option value="<?php echo esc_url( add_query_arg( 'sehir', $sehir, esc_url(get_page_link($pages)) ) ); ?>"><?php echo $sehir; ?></option>
									<?php endif; ?>

								<?php endforeach; ?>
		
						</select>
					</div>

					
						<a class="prayer-more2" href="<?php echo esc_url(get_page_link($pages)); ?>" target="_blank">
						<i class="icon-arrow icon-90deg icon-3x"></i>
						</a>
					<?php endif; ?>


					<div class="prayer-title p-1">
						<span><?php echo $title; ?></span>
					</div>

					<ul class="d-flex flex-wrap">
						<li class="time">
							<div class="progress"></div>
							<span class="prayer-name"><?php esc_html_e( 'İmsak', 'kanews' ); ?></span>
							<span class="prayer-time"><?php echo $data['times'][$date][0]; ?></span>
						</li>
						<li class="time">
							<div class="progress"></div>
							<span class="prayer-name"><?php esc_html_e( 'Güneş', 'kanews' ); ?></span>
							<span class="prayer-time"><?php echo $data['times'][$date][1]; ?></span>
						</li>
						<li class="time">
							<div class="progress"></div>
							<span class="prayer-name"><?php esc_html_e( 'Öğle', 'kanews' ); ?></span>
							<span class="prayer-time"><?php echo $data['times'][$date][2]; ?></span>
						</li>
						<li class="time">
							<div class="progress"></div>
							<span class="prayer-name"><?php esc_html_e( 'İkindi', 'kanews' ); ?></span>
							<span class="prayer-time"><?php echo $data['times'][$date][3]; ?></span>
						</li>
						<li class="time">
							<div class="progress"></div>
							<span class="prayer-name"><?php esc_html_e( 'Akşam', 'kanews' ); ?></span>
							<span class="prayer-time"><?php echo $data['times'][$date][4]; ?></span>
						</li>
						<li class="time">
							<div class="progress"></div>
							<span class="prayer-name"><?php esc_html_e( 'Yatsı', 'kanews' ); ?></span>
							<span class="prayer-time"><?php echo $data['times'][$date][5]; ?></span>
						</li>
					</ul>
					
				</section>
				</div>
    </div>
		<script>
		function redirectToSelected() {
			var selectElement = document.getElementById("redirectSelect");
			var selectedValue = selectElement.value;
			if (selectedValue !== "") {
				window.location.href = selectedValue;
			}
		}
		</script>
  <?php
	}
  
  // Update Form
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = $new_instance['title'];
		$instance['pages'] = $new_instance['pages'];
		$instance['grid'] = $new_instance['grid'];
		$instance['city'] = $new_instance['city'];
		$instance['region'] = $new_instance['region'];

		$instance['hide_desktop'] = $new_instance['hide_desktop'];
		$instance['hide_mobile'] = $new_instance['hide_mobile'];
		$instance['bg-color'] = sanitize_hex_color($new_instance['bg-color']);
		$instance['bg-color2'] = sanitize_hex_color($new_instance['bg-color2']);
		
		return $instance;
	}

  // Back-end
	public function form($instance)
	{
		$defaults = array( 
      'title' => esc_html__( 'Namaz Vakitleri', 'kanews' ), 
			'grid' => 'col-12', 
      'pages' => 'all', 
			'city' => '',
			'region' => '',
			'hide_desktop' 	 => 'off',
			'hide_mobile' 	 => 'off',
			'bg-color' => '',
			'bg-color2' => ''
    );
		$instance = wp_parse_args((array) $instance, $defaults);

		// Genel Ayarlar
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Genel Ayarlar', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('title'),
					'name' => $this->get_field_name('title'),
					'label' => __('Başlık', 'kanews'),
					'value' => $instance['title']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('grid'),
					'name' => $this->get_field_name('grid'),
					'label' => __('Genişlik', 'kanews'),
					'value' => $instance['grid'],
					'options' => [
						'col' => __('Sığdır', 'kanews'),
						'col-12' => '12/12',
						'col-12 col-lg-8' => '12/8',
						'col-12 col-lg-6' => '12/6',
						'col-12 col-lg-4' => '12/4'
					]
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('region'),
					'name' => $this->get_field_name('region'),
					'label' => __('İl', 'kanews'),
					'value' => $instance['region']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('city'),
					'name' => $this->get_field_name('city'),
					'label' => __('İlçe', 'kanews'),
					'value' => $instance['city']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('pages'),
					'name' => $this->get_field_name('pages'),
					'label' => __('Sayfa', 'kanews'),
					'value' => $instance['pages'],
					'options' => Kanews_Form_Elements::get_pages_options()
				]
			]
		]);

		// Görünürlük Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Görünürlük Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_desktop'),
					'name' => $this->get_field_name('hide_desktop'),
					'label' => __('Masaüstünde Gizle', 'kanews'),
					'value' => $instance['hide_desktop']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_mobile'),
					'name' => $this->get_field_name('hide_mobile'),
					'label' => __('Mobilde Gizle', 'kanews'),
					'value' => $instance['hide_mobile']
				]
			]
		]);

		// Görünüm Ayarları ekle
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Görünüm Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('bg-color'),
					'name' => $this->get_field_name('bg-color'),
					'label' => __('Arkaplan Rengi 1', 'kanews'),
					'value' => $instance['bg-color']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('bg-color2'),
					'name' => $this->get_field_name('bg-color2'),
					'label' => __('Arkaplan Rengi 2', 'kanews'),
					'value' => $instance['bg-color2']
				]
			]
		]);
	}
}
?>