<?php

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

if(is_admin() || is_customize_preview(  )) {
	require_once dirname(__FILE__) . '/widget-framework.php';
}

// Widget Class
class kanews_widget_class_social extends WP_Widget {

  // Create
	public function __construct(){
		$widget_ops = array('classname' => 'kanews_widget_social');
		$control_ops = array('id_base' => 'kanews_widget_social');
		parent::__construct('kanews_widget_social', ''.KAN_THEME_NAME .' - '.__( "Sosyal Medya" , 'kanews' ), $widget_ops, $control_ops );
		add_action('admin_enqueue_scripts', array('Kanews_Form_Elements', 'enqueue_scripts'));
	}
  
  // Front-end
	public function widget($args, $instance)
	{
		$hide_mobile = isset($instance['hide_mobile']) ? 'on' : 'off';
		$hide_desktop = isset($instance['hide_desktop']) ? 'on' : 'off';

		if($hide_mobile == 'on') {
			if(kan_is_mobile())
			return;
		}

		if($hide_desktop == 'on') {
			if(!kan_is_mobile())
			return;
		}

    $title = apply_filters('widget_title', isset($instance['title']) ? $instance['title'] : '');
    $grid = (!empty($instance['grid'])) ? $instance['grid'] : 'col-12';
    $facebook = (!empty($instance['facebook'])) ? $instance['facebook'] : '';
    $twitter = (!empty($instance['twitter'])) ? $instance['twitter'] : '';
    $linkedin = (!empty($instance['linkedin'])) ? $instance['linkedin'] : '';
    $pinterest = (!empty($instance['pinterest'])) ? $instance['pinterest'] : '';
    $youtube = (!empty($instance['youtube'])) ? $instance['youtube'] : '';
    $whatsapp = (!empty($instance['whatsapp'])) ? $instance['whatsapp'] : '';
    $instagram = (!empty($instance['instagram'])) ? $instance['instagram'] : '';
    $telegram = (!empty($instance['telegram'])) ? $instance['telegram'] : '';
		$facebook_bg = (!empty($instance['facebook_bg'])) ? $instance['facebook_bg'] : '#1877f2';	
		$twitter_bg = (!empty($instance['twitter_bg'])) ? $instance['twitter_bg'] : '#1da1f2';	
		$instagram_bg = (!empty($instance['instagram_bg'])) ? $instance['instagram_bg'] : '#c32aa3';	
		$youtube_bg = (!empty($instance['youtube_bg'])) ? $instance['youtube_bg'] : '#ff0000';	
		$pinterest_bg = (!empty($instance['pinterest_bg'])) ? $instance['pinterest_bg'] : '#bd081c';	
		$linkedin_bg = (!empty($instance['linkedin_bg'])) ? $instance['linkedin_bg'] : '#0a66c2';	
		$whatsapp_bg = (!empty($instance['whatsapp_bg'])) ? $instance['whatsapp_bg'] : '#25d366';	
		$telegram_bg = (!empty($instance['telegram_bg'])) ? $instance['telegram_bg'] : '#0088cc';	

    ?>

    <div class="<?php echo $grid; ?>">
      <div class="kanews-section">
        <?php if ( ! empty($instance['title']) ):
					echo ( $args['before_title'] . $title . $args['after_title'] );
				endif; ?>
        <div class="kanews-social-accounts">
          <?php if ( $facebook ) : ?>
            <a rel="nofollow noopener" target="_blank" 
               style="background-color: <?php echo esc_attr($facebook_bg); ?>"
               class="social-link" 
               aria-label="<?php esc_html_e('Facebook\'da Beğen', 'kanews'); ?>"
               href="<?php echo esc_url($facebook); ?>">
              <span class="w-icon"><i class="icon-facebook"></i></span>
                <span class="text">
                    <span class="social-name"><?php _e('Facebook', 'kanews'); ?></span>
                    <?php if (!empty($instance['facebook_followers'])): ?>
                        <span class="social-count"><?php echo esc_html($instance['facebook_followers']); ?></span>
                    <?php endif; ?>
                </span>
            </a>
          <?php endif; ?>
          <?php if ( $twitter ) : ?>
            <a rel="nofollow noopener" target="_blank" 
               style="background-color: <?php echo esc_attr($twitter_bg); ?>"
               class="social-link" 
               aria-label="<?php esc_html_e('Twitter\'da Takip Et', 'kanews'); ?>"
               href="<?php echo esc_url($twitter); ?>">
              <span class="w-icon"><i class="icon-twitter"></i></span>
                <span class="text">
                    <span class="social-name"><?php _e('Twitter', 'kanews'); ?></span>
                    <?php if (!empty($instance['twitter_followers'])): ?>
                        <span class="social-count"><?php echo esc_html($instance['twitter_followers']); ?></span>
                    <?php endif; ?>
                </span>
            </a>
          <?php endif; ?>
          <?php if ( $linkedin ) : ?>
            <a rel="nofollow noopener" target="_blank" class="bg-linkedin"aria-label="<?php esc_html_e( 'Linkedin\'de Bağlantı Kur', 'kanews' ); ?>"   href="<?php echo esc_url($linkedin); ?>">
              <span class="w-icon"><i class="icon-linkedin"></i></span>
              <span class="text"><?php _e('Linkedin','kanews'); ?></span>
            </a>
          <?php endif; ?>
          <?php if ( $pinterest ) : ?>
            <a rel="nofollow noopener" target="_blank" class="bg-pinterest" aria-label="<?php esc_html_e( 'Pinterest\'te Takip Et', 'kanews' ); ?>"  href="<?php echo esc_url($pinterest); ?>">
              <span class="w-icon"><i class="icon-pinterest"></i></span>
              <span class="text"><?php _e('Pinterest','kanews'); ?></span>
            </a>
          <?php endif; ?>
          <?php if ( $youtube ) : ?>
            <a rel="nofollow noopener" target="_blank" 
               style="background-color: <?php echo esc_attr($youtube_bg); ?>"
               class="social-link" 
               aria-label="<?php esc_html_e('Youtube\'da Abone Ol', 'kanews'); ?>"
               href="<?php echo esc_url($youtube); ?>">
              <span class="w-icon"><i class="icon-video"></i></span>
                <span class="text">
                    <span class="social-name"><?php _e('Youtube', 'kanews'); ?></span>
                    <?php if (!empty($instance['youtube_followers'])): ?>
                        <span class="social-count"><?php echo esc_html($instance['youtube_followers']); ?></span>
                    <?php endif; ?>
                </span>
            </a>
          <?php endif; ?>
          <?php if ( $instagram ) : ?>
            <a rel="nofollow noopener" target="_blank" 
               style="background-color: <?php echo esc_attr($instagram_bg); ?>"
               class="social-link" 
               aria-label="<?php esc_html_e('Instagram\'da Takip Et', 'kanews'); ?>"
               href="<?php echo esc_url($instagram); ?>">
              <span class="w-icon"><i class="icon-instagram"></i></span>
                <span class="text">
                    <span class="social-name"><?php _e('Instagram', 'kanews'); ?></span>
                    <?php if (!empty($instance['instagram_followers'])): ?>
                        <span class="social-count"><?php echo esc_html($instance['instagram_followers']); ?></span>
                    <?php endif; ?>
                </span>
            </a>
          <?php endif; ?>
          <?php if ( $whatsapp ) : ?>
            <a rel="nofollow noopener" target="_blank" class="bg-whatsapp" aria-label="<?php esc_html_e( 'Whatsapp\'tan Yaz', 'kanews' ); ?>" href="<?php echo esc_url($whatsapp); ?>">
              <span class="w-icon"><i class="icon-whatsapp"></i></span>
              <span class="text"><?php _e('Whatsapp','kanews'); ?></span>
            </a>
          <?php endif; ?>
          <?php if ( $telegram ) : ?>
            <a rel="nofollow noopener" target="_blank" class="bg-telegram" aria-label="<?php esc_html_e( 'Telegram\'tan Yaz', 'kanews' ); ?>" href="<?php echo esc_url($telegram); ?>">
              <span class="w-icon"><i class="icon-telegram"></i></span>
              <span class="text"><?php _e('Telegram','kanews'); ?></span>
            </a>
          <?php endif; ?>
        </div>
      </div>
    </div>
  <?php
	}
  
  // Update Form
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		// Genel ayarlar
		$instance['title'] = $new_instance['title'];
		$instance['grid'] = $new_instance['grid'];

		// Facebook
		$instance['facebook'] = $new_instance['facebook'];
		$instance['facebook_followers'] = $new_instance['facebook_followers'];
		$instance['facebook_bg'] = $new_instance['facebook_bg'];

		// Twitter
		$instance['twitter'] = $new_instance['twitter'];
		$instance['twitter_followers'] = $new_instance['twitter_followers'];
		$instance['twitter_bg'] = $new_instance['twitter_bg'];

		// Instagram
		$instance['instagram'] = $new_instance['instagram'];
		$instance['instagram_followers'] = $new_instance['instagram_followers'];
		$instance['instagram_bg'] = $new_instance['instagram_bg'];

		// Youtube
		$instance['youtube'] = $new_instance['youtube'];
		$instance['youtube_followers'] = $new_instance['youtube_followers'];
		$instance['youtube_bg'] = $new_instance['youtube_bg'];

		// Pinterest
		$instance['pinterest'] = $new_instance['pinterest'];
		$instance['pinterest_followers'] = $new_instance['pinterest_followers'];
		$instance['pinterest_bg'] = $new_instance['pinterest_bg'];

		// LinkedIn
		$instance['linkedin'] = $new_instance['linkedin'];
		$instance['linkedin_followers'] = $new_instance['linkedin_followers'];
		$instance['linkedin_bg'] = $new_instance['linkedin_bg'];

		// WhatsApp
		$instance['whatsapp'] = $new_instance['whatsapp'];
		$instance['whatsapp_followers'] = $new_instance['whatsapp_followers'];
		$instance['whatsapp_bg'] = $new_instance['whatsapp_bg'];

		// Telegram
		$instance['telegram'] = $new_instance['telegram'];
		$instance['telegram_followers'] = $new_instance['telegram_followers'];
		$instance['telegram_bg'] = $new_instance['telegram_bg'];

		// Görünürlük
		$instance['hide_desktop'] = $new_instance['hide_desktop'];
		$instance['hide_mobile'] = $new_instance['hide_mobile'];
		
		return $instance;
	}

  // Back-end
	public function form($instance) {
		$defaults = array( 
			'title' => esc_html__('Bize Katılın', 'kanews'), 
			'grid' => 'col-12', 
			'facebook' => '', 
			'facebook_followers' => '',
			'facebook_bg' => '#1877f2',
			'twitter' => '', 
			'twitter_followers' => '',
			'twitter_bg' => '#1da1f2',
			'instagram' => '', 
			'instagram_followers' => '',
			'instagram_bg' => '#c32aa3',
			'youtube' => '', 
			'youtube_followers' => '',
			'youtube_bg' => '#ff0000',
			'pinterest' => '', 
			'pinterest_followers' => '',
			'pinterest_bg' => '#bd081c',
			'linkedin' => '', 
			'linkedin_followers' => '',
			'linkedin_bg' => '#0a66c2',
			'whatsapp' => '', 
			'whatsapp_followers' => '',
			'whatsapp_bg' => '#25d366',
			'telegram' => '', 
			'telegram_followers' => '',
			'telegram_bg' => '#0088cc',
			'hide_desktop' => 'off',
			'hide_mobile' => 'off'
		);
		$instance = wp_parse_args((array) $instance, $defaults);

		// Genel Ayarlar
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Genel Ayarlar', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('title'),
					'name' => $this->get_field_name('title'),
					'label' => __('Başlık', 'kanews'),
					'value' => $instance['title']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('grid'),
					'name' => $this->get_field_name('grid'),
					'label' => __('Genişlik', 'kanews'),
					'value' => $instance['grid'],
					'options' => [
						'col' => __('Sığdır', 'kanews'),
						'col-12' => '12/12',
						'col-12 col-lg-8' => '12/8',
						'col-12 col-lg-6' => '12/6',
						'col-12 col-lg-4' => '12/4'
					]
				]
			]
		]);

		// Facebook Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Facebook Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_URL,
					'id' => $this->get_field_id('facebook'),
					'name' => $this->get_field_name('facebook'),
					'label' => __('Facebook Profil URL', 'kanews'),
					'value' => $instance['facebook']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('facebook_followers'),
					'name' => $this->get_field_name('facebook_followers'),
					'label' => __('Takipçi Sayısı', 'kanews'),
					'value' => $instance['facebook_followers']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('facebook_bg'),
					'name' => $this->get_field_name('facebook_bg'),
					'label' => __('Arkaplan Rengi', 'kanews'),
					'value' => $instance['facebook_bg']
				]
			]
		]);

		// Twitter Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Twitter Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_URL,
					'id' => $this->get_field_id('twitter'),
					'name' => $this->get_field_name('twitter'),
					'label' => __('Twitter Profil URL', 'kanews'),
					'value' => $instance['twitter']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('twitter_followers'),
					'name' => $this->get_field_name('twitter_followers'),
					'label' => __('Takipçi Sayısı', 'kanews'),
					'value' => $instance['twitter_followers']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('twitter_bg'),
					'name' => $this->get_field_name('twitter_bg'),
					'label' => __('Arkaplan Rengi', 'kanews'),
					'value' => $instance['twitter_bg']
				]
			]
		]);

		// Instagram Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Instagram Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_URL,
					'id' => $this->get_field_id('instagram'),
					'name' => $this->get_field_name('instagram'),
					'label' => __('Instagram Profil URL', 'kanews'),
					'value' => $instance['instagram']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('instagram_followers'),
					'name' => $this->get_field_name('instagram_followers'),
					'label' => __('Takipçi Sayısı', 'kanews'),
					'value' => $instance['instagram_followers']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('instagram_bg'),
					'name' => $this->get_field_name('instagram_bg'),
					'label' => __('Arkaplan Rengi', 'kanews'),
					'value' => $instance['instagram_bg']
				]
			]
		]);

		// Youtube Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Youtube Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_URL,
					'id' => $this->get_field_id('youtube'),
					'name' => $this->get_field_name('youtube'),
					'label' => __('Youtube Profil URL', 'kanews'),
					'value' => $instance['youtube']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('youtube_followers'),
					'name' => $this->get_field_name('youtube_followers'),
					'label' => __('Abone Sayısı', 'kanews'),
					'value' => $instance['youtube_followers']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('youtube_bg'),
					'name' => $this->get_field_name('youtube_bg'),
					'label' => __('Arkaplan Rengi', 'kanews'),
					'value' => $instance['youtube_bg']
				]
			]
		]);

		// Pinterest Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Pinterest Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_URL,
					'id' => $this->get_field_id('pinterest'),
					'name' => $this->get_field_name('pinterest'),
					'label' => __('Pinterest Profil URL', 'kanews'),
					'value' => $instance['pinterest']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('pinterest_followers'),
					'name' => $this->get_field_name('pinterest_followers'),
					'label' => __('Takipçi Sayısı', 'kanews'),
					'value' => $instance['pinterest_followers']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('pinterest_bg'),
					'name' => $this->get_field_name('pinterest_bg'),
					'label' => __('Arkaplan Rengi', 'kanews'),
					'value' => $instance['pinterest_bg']
				]
			]
		]);

		// LinkedIn Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Linkedin Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_URL,
					'id' => $this->get_field_id('linkedin'),
					'name' => $this->get_field_name('linkedin'),
					'label' => __('Linkedin Profil URL', 'kanews'),
					'value' => $instance['linkedin']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('linkedin_followers'),
					'name' => $this->get_field_name('linkedin_followers'),
					'label' => __('Takipçi Sayısı', 'kanews'),
					'value' => $instance['linkedin_followers']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('linkedin_bg'),
					'name' => $this->get_field_name('linkedin_bg'),
					'label' => __('Arkaplan Rengi', 'kanews'),
					'value' => $instance['linkedin_bg']
				]
			]
		]);

		// WhatsApp Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('WhatsApp Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_URL,
					'id' => $this->get_field_id('whatsapp'),
					'name' => $this->get_field_name('whatsapp'),
					'label' => __('WhatsApp Profil URL', 'kanews'),
					'value' => $instance['whatsapp']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('whatsapp_followers'),
					'name' => $this->get_field_name('whatsapp_followers'),
					'label' => __('Takipçi Sayısı', 'kanews'),
					'value' => $instance['whatsapp_followers']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('whatsapp_bg'),
					'name' => $this->get_field_name('whatsapp_bg'),
					'label' => __('Arkaplan Rengi', 'kanews'),
					'value' => $instance['whatsapp_bg']
				]
			]
		]);

		// Telegram Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Telegram Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_URL,
					'id' => $this->get_field_id('telegram'),
					'name' => $this->get_field_name('telegram'),
					'label' => __('Telegram Profil URL', 'kanews'),
					'value' => $instance['telegram']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('telegram_followers'),
					'name' => $this->get_field_name('telegram_followers'),
					'label' => __('Takipçi Sayısı', 'kanews'),
					'value' => $instance['telegram_followers']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('telegram_bg'),
					'name' => $this->get_field_name('telegram_bg'),
					'label' => __('Arkaplan Rengi', 'kanews'),
					'value' => $instance['telegram_bg']
				]
			]
		]);

		// Görünürlük Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Görünürlük Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_desktop'),
					'name' => $this->get_field_name('hide_desktop'),
					'label' => __('Masaüstünde Gizle', 'kanews'),
					'value' => $instance['hide_desktop']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_mobile'),
					'name' => $this->get_field_name('hide_mobile'),
					'label' => __('Mobilde Gizle', 'kanews'),
					'value' => $instance['hide_mobile']
				]
			]
		]);

	}
}
?>