<?php 

if( class_exists( 'CSF' ) ) {

  CSF::createWidget( 'kanews_widget_survey', array(
    'title'       => KAN_THEME_NAME .' - '."Anket",
    'classname'   => 'kanews_widget_class_survey',
    'fields'      => array(

      array(
        'id'      => 'title',
        'type'    => 'text',
        'title'   => 'Title',
      ),

      array(
        'id'      => 'grid',
        'type'    => 'select',
        'title'   => 'Genişlik',
        'options' => array(
          'col-12' => '12/12',
          'col-12 col-lg-8' => '12/8',
          'col-12 col-lg-6' => '12/6',
          'col-12 col-lg-4' => '12/4'
        ),
        'default' => 'col-12'
      ),

      array(
        'id'     => 'options',
        'type'   => 'group',
        'title'  => 'Seçenekler',
        'button_title'  => 'Yeni Ekle',
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => 'Seçenek',
          ),
          array(
            'id'    => 'img',
            'type'  => 'media',
            'title' => 'Görsel',
          ),
          array(
            'id'    => 'color',
            'type'  => 'color',
            'title' => 'Renk',
          ),
        ),
      ),

      array(
        'id'      => 'date',
        'type'    => 'text',
        'title' => 'Tarih',
        'desc' => 'Ay/Gün/Yıl şeklinde örneğin 29/03/2023',
        'default' => false
      ),

      array(
        'id'      => 'hide_desktop',
        'type'    => 'switcher',
        'title'   => 'Masaüstünde Gizle',
        'default' => false
      ),
      array(
        'id'      => 'hide_mobile',
        'type'    => 'switcher',
        'title'   => 'Mobilde Gizle',
        'default' => false
      ),
    
    )
  ) );
  
  if( ! function_exists( 'kanews_widget_survey' ) ) {
    function kanews_widget_survey( $widgets, $instance ) {
      $hide_mobile = $instance['hide_mobile'] ? 'on' : 'off';
      $hide_desktop = $instance['hide_desktop']? 'on' : 'off';

      if($hide_mobile == 'on') {
        if(kan_is_mobile())
        return;
      }

      if($hide_desktop == 'on') {
        if(!kan_is_mobile())
        return;
      }

      $args_defaults = array( 
        'grid'     => 'col-12',
        'title'    => '',
        'date'     => date('d/m/Y', strtotime('+1 day')),
        'options'  => array(),
      ); 
      $args = wp_parse_args( $instance, $args_defaults );
      
      echo '<div class="'.$args['grid'].'"><div class="kanews-section kanews-survey-widget">';
      
      if ( ! empty($args['title']) ) {
        echo ( $widgets['before_title'] . $args['title'] . $widgets['after_title'] );
      }
	  
	  if( empty($args['date']) ) {
		echo '<div class="kanews-response">Anketiniz için bir bitiş tarihi ayarlayın.</div>';
	  } else {
      
		  $args['date'] = empty($args['date']) ? date('d/m/Y', strtotime('+1 day')) : $args['date'];

		  $date = str_replace('/', '-', $args['date']);
		  $date = date('Y-m-d', strtotime($date));
		  $widgets['widget_id'] = 'kanews-survey-'.md5( serialize( array( $args['options'], $args['date'] ) ) );
		  
		  $form  = '';
		  $counter = $total_vote = 0;
		  $option_name = $widgets['widget_id'].'-results';
		  $survey_data = get_option($option_name, array('options' => array(), 'totalUsers' => 0));

		  $cookie_name = $widgets['widget_id'].'-voted';

		  $timediff = strtotime("now") - strtotime($date);
		

		  $form .= '<form id="kanews-survey-submit" class="p-1 '.( isset($_COOKIE[$cookie_name] ) ? 'kanews-survey-voted-x': '' ).'" method="post" data-expired="'.esc_attr($date).'" data-widget-name="'.$widgets['widget_id'].'" data-widget="'. str_replace( '"', '\'', wp_json_encode( $args['options'] )) .'">';
		  if( is_array($args['options']) && !empty($args['options']) ) {
			foreach($args['options'] as $option){
			  if( $option['title'] != '' ) {
				$counter++;

				$vote_count = isset($survey_data['options'][sanitize_title($option['title'])]) ? $survey_data['options'][sanitize_title($option['title'])] : 0;
				$total_vote = array_sum($survey_data['options']);

				if ($total_vote != 0) {
				  $vote_per = round(( $vote_count / $total_vote  ) * 100, 2); 
				} else {
				  $vote_per = 0;
				}
        $vote_color = (isset($option['color']) && !empty($option['color'])) ? 'style="--kan-theme-color: '.$option['color'].'"' : '';
				$voted = (isset($_COOKIE[$cookie_name]) && $_COOKIE[$cookie_name] == sanitize_title( $option['title'])) ? 'kanews-survey-voted' : '';
        $votes_count_label = sprintf('%s oy', $vote_count);
        $vote_img = (isset($option['img']['thumbnail']) && !empty($option['img']['thumbnail'])) ? '<img loading="lazy" src="'.$option['img']['thumbnail'].'" width="28" height="28" alt="'.sanitize_title($option['title']).'">' : '';
				$form .= '<div class="kanews-survey-item no-gutters '.$voted.'" '.$vote_color.'>

            <div class="d-flex justify-content-between align-items-center">
              <div>
                  '.($timediff < 0 ? '<input required="required" type="radio" id="'.sanitize_title($option['title']).'" name="'.$widgets['widget_id'].'-vote" value="'.sanitize_title( $option['title']).'">' : '').'
                  <label class="mb-0" for="'.sanitize_title($option['title']).'">'.$vote_img.' ' . $option['title'] . '</label>
              </div>
              <div class="kanews-survey-item-result">%'.$vote_per.' ('.$votes_count_label.')</div>
            </div>
            <div class="kanews-survey-bar">
              <div class="kanews-survey-bar-current" style="width: '.$vote_per.'%"></div>
            </div>
      
        </div>';
			  }
			}

      

		  }
		  if( $timediff < 0 ) 
		  $form .= '<button type="submit" name="kanews-survey-submit" class="kanews-btn kanews-btn-sm">Oy Kullan<div id="kanews-loader"></div></button>';
		  $form .= '</form>';

		  echo $form;

		  if( $timediff > 0 ) 
		  echo '<p class="p-1 mb-0">Bu anket sonlanmıştır.</p>';
		  else
		  echo '<p class="p-1 mb-0">Bu anket '.$args['date'].' tarihinde sonlanacaktır.</p>';
	  }

      echo '</div></div>';
      
    
    }
  }
}

/*-----------------------------------------------------------------------------------*/
add_action( 'wp_ajax_nopriv_kanews_survey_ajax_callback', 'kanews_survey_ajax_callback' );
add_action( 'wp_ajax_kanews_survey_ajax_callback', 'kanews_survey_ajax_callback' );
function kanews_survey_ajax_callback(){
  $nonce = isset( $_REQUEST['nonce'] ) ? sanitize_text_field( $_REQUEST['nonce'] ) : 0;
  if ( ! wp_verify_nonce( $nonce, 'kanews-ajax-nonce' ) ) {
    wp_send_json_error( array( 'message' => 'İzin verilmedi!' ) );
  }
  
  $widget_name = $_REQUEST['widget_name'];
  $data_name   = $widget_name.'-results';
  $vote_now    = $_POST[$widget_name.'-vote'];

  // expired
  $timediff = strtotime("now") - strtotime($_REQUEST['expired']);
  if( $timediff > 0 ) {
    wp_send_json_error( array( 'message' => 'Anket tamamlandı, oyun geçersiz!' ) );
    exit();
  }

  // cookie
  $cookie_name = $widget_name.'-voted';

  if (isset($_COOKIE[$cookie_name]) && $_COOKIE[$cookie_name] != "") {
    wp_send_json_error( array( 'message' => 'Zaten oy kullandın!' ) );
    exit();
  } else {
    setcookie($cookie_name, $vote_now, strtotime($_REQUEST['expired']), '/', $_SERVER['HTTP_HOST']);
    $_COOKIE[$cookie_name] = $vote_now;
  }


  // data
  $survey_data = get_option( $data_name, array('options' => array(), 'totalUser' => 0) );
  if( isset($survey_data['options'][$vote_now]) )
  $survey_data['options'][$vote_now]++;
  else
  $survey_data['options'][$vote_now] = 1;
  $survey_data['totalUser']++;

  update_option($data_name, $survey_data);  

  // form
  $args['options'] = json_decode( str_replace( '\'', '"', stripslashes($_REQUEST['widget_data'] )), true );
  $form = '';
  $form .= '<form id="kanews-survey-submit" class="p-1 '.( isset($_COOKIE[$cookie_name] ) ? 'kanews-survey-voted-x': '' ).'" method="post">';
  if( is_array($args['options']) && !empty($args['options']) ) {
    foreach($args['options'] as $option){
      if( $option['title'] != '' ) {

        $vote_count = isset($survey_data['options'][sanitize_title($option['title'])]) ? $survey_data['options'][sanitize_title($option['title'])] : 0;
        $total_vote = array_sum($survey_data['options']);

        if ($total_vote != 0) {
          $vote_per = round(( $vote_count / $total_vote  ) * 100, 2); 
        } else {
          $vote_per = 0;
        }
        $votes_count_label = sprintf('%s oy', $vote_count);
        $vote_color = (isset($option['color']) && !empty($option['color'])) ? 'style="--kan-theme-color: '.$option['color'].'"' : '';
        $voted = (isset($_COOKIE[$cookie_name]) && $_COOKIE[$cookie_name] == sanitize_title( $option['title'])) ? 'kanews-survey-voted' : '';
        $vote_img = (isset($option['img']['thumbnail']) && !empty($option['img']['thumbnail'])) ? '<img loading="lazy" src="'.$option['img']['thumbnail'].'" width="28" height="28" alt="'.sanitize_title($option['title']).'">' : '';
				
				$form .= '<div class="kanews-survey-item no-gutters '.$voted.'" '.$vote_color.'>

            <div class="d-flex justify-content-between align-items-center">
              <div>
                  <label class="mb-0" for="'.sanitize_title($option['title']).'">'.$vote_img.' ' . $option['title'] . '</label>
              </div>
              <div class="kanews-survey-item-result">%'.$vote_per.' ('.$votes_count_label.')</div>
            </div>
            <div class="kanews-survey-bar">
              <div class="kanews-survey-bar-current" style="width: '.$vote_per.'%"></div>
            </div>
      
        </div>';
      }
      
    }
  } else {
    $form .= 'Yüklenmedi';
  }
  $form .= '</form>';

  wp_send_json_success( array( 'message' => 'Oy kullanıldı!', 'content' => $form ) );
  exit();
}