<?php

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

if(is_admin() || is_customize_preview(  )) {
	require_once dirname(__FILE__) . '/widget-framework.php';
}

class kanews_widget_class_tagcloud extends WP_Widget {
	public function __construct(){
		$widget_ops = array( 'classname' => 'kanews_widget_tagcloud' );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'kanews_widget_tagcloud' );
		parent::__construct( 'kanews_widget_tagcloud', ''.KAN_THEME_NAME .' - '.__( "Popüler Etiketler" , 'kanews' ), $widget_ops, $control_ops );
		add_action('admin_enqueue_scripts', array('Kanews_Form_Elements', 'enqueue_scripts'));
	}
	
	public function widget( $args, $instance ) {
		$hide_mobile = isset($instance['hide_mobile']) ? 'on' : 'off';
		$hide_desktop = isset($instance['hide_desktop']) ? 'on' : 'off';

		if($hide_mobile == 'on') {
			if(kan_is_mobile())
			return;
		}

		if($hide_desktop == 'on') {
			if(!kan_is_mobile())
			return;
		}


		$title = apply_filters('widget_title', isset($instance['title']) ? $instance['title'] : '' );
		$no_of_posts = $instance['no_of_posts'];
		$sortby = $instance['sortby'];
		$show_count = isset($instance['show_count']) ? true : false;

		echo ( $args['before_widget'] );
		
			if ( ! empty($instance['title']) ):
				echo ( $args['before_title'] . $title . $args['after_title'] );
			endif; 

			$tags = get_tags(array(
				'orderby' => 'count',
				'order' => $sortby
			));
			 
	
			$count = '';
			$counter = 0;
			echo '<div class="tagcloud">';
				if($tags) {
					foreach ($tags as $tag) {$counter++;
						if($counter <= $no_of_posts) {
							if($show_count == true)
							$count = '('.$tag->count.')';
							echo '<a class="kanews-label kanews-label-sm" href="'. Kanews\Helper_Wp::get_term_link( $tag, 'tag' ).'">'. $tag->name .' '.$count.'</a>  ';
						} else {
							break;
						}
					}
				} else {
					_e('Etiket bulunamadı!', 'kanews');
				}
			echo '</div>';
      

			echo ( $args['after_widget'] );
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['no_of_posts'] = $new_instance['no_of_posts'];
		$instance['sortby'] = $new_instance['sortby'];
		$instance['show_count'] = $new_instance['show_count'];

		$instance['hide_desktop'] = $new_instance['hide_desktop'];
		$instance['hide_mobile'] = $new_instance['hide_mobile'];

		return $instance;
	}

	public function form($instance) {
		$defaults = array(
			'title' => '',
			'no_of_posts' => '10',
			'sortby' => 'DESC',
			'show_count' => 'off',
			'hide_desktop' => 'off',
			'hide_mobile' => 'off'
		);
		$instance = wp_parse_args((array) $instance, $defaults);

		// Genel Ayarlar
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Genel Ayarlar', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('title'),
					'name' => $this->get_field_name('title'),
					'label' => __('Başlık', 'kanews'),
					'value' => $instance['title']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_NUMBER,
					'id' => $this->get_field_id('no_of_posts'),
					'name' => $this->get_field_name('no_of_posts'),
					'label' => __('Etiket Sayısı', 'kanews'),
					'value' => $instance['no_of_posts']
				]
			]
		]);

		// Sıralama Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Sıralama Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('sortby'),
					'name' => $this->get_field_name('sortby'),
					'label' => __('Göre Sırala', 'kanews'),
					'value' => $instance['sortby'],
					'options' => [
						'ASC' => __('Artan', 'kanews'),
						'DESC' => __('Azalan', 'kanews'),
						'RAND' => __('Rastgele', 'kanews')
					]
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('show_count'),
					'name' => $this->get_field_name('show_count'),
					'label' => __('Yazı Sayısını Göster', 'kanews'),
					'value' => $instance['show_count']
				]
			]
		]);

		// Görünürlük Ayarları
		Kanews_Form_Elements::render_accordion_field([
			'title' => __('Görünürlük Ayarları', 'kanews'),
			'content' => [
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_desktop'),
					'name' => $this->get_field_name('hide_desktop'),
					'label' => __('Masaüstünde Gizle', 'kanews'),
					'value' => $instance['hide_desktop']
				],
				[
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_mobile'),
					'name' => $this->get_field_name('hide_mobile'),
					'label' => __('Mobilde Gizle', 'kanews'),
					'value' => $instance['hide_mobile']
				]
			]
		]);

		?>
		<script type="text/javascript">
			<?php if($instance['hide_mobile'] == 'on' && $instance['hide_desktop'] != 'on'): ?>
				jQuery('div[id*="<?php echo $this->id; ?>"').addClass('kan-widget-visible-desktop');
			<?php elseif($instance['hide_desktop'] == 'on' && $instance['hide_mobile'] != 'on'): ?>
				jQuery('div[id*="<?php echo $this->id; ?>"').addClass('kan-widget-visible-mobile');
			<?php else: ?>
				jQuery('div[id*="<?php echo $this->id; ?>"').addClass('kan-widget-visible-all');
			<?php endif; ?>
		</script>
		<?php
	}
}
?>