<?php 

if( class_exists( 'CSF' ) ) {

  CSF::createWidget( 'kanews_widget_term_images', array(
    'title'       => KAN_THEME_NAME .' - '."Resimli Terimler",
    'description' => "Kategori, etiket veya sayfalarınızı görsel olarak listelemeye yarar.",
    'classname'   => 'kanews_widget_class_term_images',
    'fields'      => array(

      array(
        'id'      => 'title',
        'type'    => 'text',
        'title'   => 'Title',
      ),
      array(
        'id'      => 'grid',
        'type'    => 'select',
        'title'   => 'Genişlik',
        'options' => array(
          'col-12' => '12/12',
          'col-12 col-lg-8' => '12/8',
          'col-12 col-lg-6' => '12/6',
          'col-12 col-lg-4' => '12/4'
        ),
        'default' => 'col-12'
      ),

      array(
        'id'      => 'style',
        'type'    => 'select',
        'title'   => 'Görünüm',
        'options' => array(
          '1' => '1',
          '2' => '2',
        ),
        'default' => '1'
      ),
      array(
        'id'     => 'terms',
        'type'   => 'group',
        'title'  => 'Terim'.' #1',
        'button_title'  => 'Yeni Ekle',
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => 'Başlık'
          ),
          array(
            'id'    => 'thumb',
            'type'  => 'media',
            'title' => 'Görsel'
          ),
          array(
            'id'    => 'link',
            'type'  => 'text',
            'title' => 'Link'
          ),
          array(
            'id'    => 'color',
            'type'  => 'color',
            'title' => 'Vurgulanan Renk'
          ),
        ),
      ),
      array(
        'id'      => 'hide_desktop',
        'type'    => 'switcher',
        'title'   => 'Masaüstünde Gizle',
        'default' => false
      ),
      array(
        'id'      => 'hide_mobile',
        'type'    => 'switcher',
        'title'   => 'Mobilde Gizle',
        'default' => false
      )
    
    )
  ) );
  
  if( ! function_exists( 'kanews_widget_term_images' ) ) {
    function kanews_widget_term_images( $widget, $instance ) {
      $hide_mobile = $instance['hide_mobile'] ? 'on' : 'off';
      $hide_desktop = $instance['hide_desktop']? 'on' : 'off';

      if($hide_mobile == 'on') {
        if(kan_is_mobile())
        return;
      }

      if($hide_desktop == 'on') {
        if(!kan_is_mobile())
        return;
      }

      $args_defaults = array( 
        'grid'        => 'col-12',
        'title'       => '',
        'terms'       => '',
        'style'       => '1',
        'hide_mobile' => false,
        'hide_desktop' => false,
      ); 
      $args = wp_parse_args( $instance, $args_defaults );

      if(empty($args['terms']))
      return;


      $show = 7;
      if(isset($widget['id']))
      $sidebar = explode('-', $widget['id']);
      else
      $sidebar = array('0' => 'home', '1' => 'content');
      
      if($sidebar[1] == 'sidebar') {
        $show = 2;
      }elseif($sidebar[1] == 'content') {
        $show = 4;
      }

      $slick_options = [
        'slidesToShow' 		=> $show,
        'infinite' 		=> true,
        'responsive' 			=> [
          [
            'breakpoint' 	 => 992,
            'settings'		 => [
              'slidesToShow' => 3
            ]
          ],
          [
            'breakpoint' 	 => 525,
            'settings'		 => [
              'slidesToShow' => 2
            ]
          ],
        ]
      ];

      $slick_options2 = [
        'infinite' 		=> false,
        'slidesToScroll' 		=> 2,
        'variableWidth' => true
      ];

      ?>
      <div class="<?php echo $args['grid']; ?>"> 
        <div class="kanews-section kanews_widget_term_images kanews-section-flat kanews-section-gutter">
          <?php 
          if ( ! empty($args['title']) ){
            echo ( $widget['before_title'] . $args['title'] . $widget['after_title'] );
          }
          ?>
          <?php if($args['style'] == '1'): ?>
            <div class="kanews-slider-5 kanews-slider-global">
              <div class="col-12 no-gutter">
                <div class="kanews-slider-wrapper kanews-slider-grid" data-slick='<?php echo wp_json_encode( $slick_options ); ?>'>
                <?php foreach($args['terms'] as $term) {
                      $image_size = 'kanews-post-6';
                      $image_data = wp_get_attachment_image_src( $term['thumb']['id'], $image_size );
                      $image = $image_data[0];
                      $tag_color = isset($term['color']) ? 'style="background: linear-gradient(0deg,'.$term['color'].',rgba(0,0,0,.2) 50%) !important"' : '';
                      if ( ! empty( $image ) ) { ?>
                        <div class="kanews-slider-col col-6 col-md-4 col-lg-<?php $col = 12 / $show; echo round($col); ?>">
                        <div class="kanews-slide-item">
                          <div class="kanews-slide-thumb"><img class="kanews-lazy"  <?php if( isset($term['title'])): ?> alt="<?php echo esc_attr($term['title']); ?>"<?php endif; ?> src="<?php echo kanews_lazy_link(); ?>" data-src="<?php echo esc_url( $image ); ?>" /></div>
                          <?php if( !empty($term['link']) ): ?>
                          <a href="<?php echo esc_url($term['link']); ?>" class="kanews-slide-href"></a>
                          <?php endif; ?>
                          <?php if( !empty($term['title']) ): ?>
                            <div class="kanews-slide-overlay" <?php echo $tag_color; ?>></div>
                            <div class="kanews-slide-content">
                              <h5 class="kanews-slide-headline"><?php echo $term['title']?></h5>
                            </div>
                          <?php endif; ?>
                    
                        </div>
                        </div>
                      <?php 
                      }
                  
                  } ?>
                </div>
              </div>
            </div>
          <?php else: ?>
            <div class="kanews-slider-cats kanews-slider-global">
              <div class="kanews-slider-wrapper" data-slick='<?php echo wp_json_encode( $slick_options2); ?>'>
                <?php foreach($args['terms'] as $term): ?>
                  <?php if(isset($term['thumb']['id'])): ?>
                    <a href="<?php echo esc_url($term['link']); ?>" class="kanews-slider-cat d-flex align-items-center justify-content-center">
                      <?php echo wp_get_attachment_image($term['thumb']['id'], 'full', '', array('title' => esc_attr($term['title']), 'alt' => sanitize_title($term['title']))); ?>
                    </a>
                  <?php endif; ?>
                <?php endforeach; ?>
              </div>
            </div>
          <?php endif; ?>
        </div>
      </div>
      <?php

    }
  }
}