<?php
// WordPress'i yükle (direkt erişim için)
$wp_load_path = '../../../../../wp-load.php';
if (file_exists($wp_load_path)) {
    require_once($wp_load_path);
} else {
    // Dinamik olarak WordPress kök dizinini bulmaya çalış
    $dir = dirname(__FILE__);
    do {
        if (file_exists($dir . '/wp-load.php')) {
            require_once($dir . '/wp-load.php');
            break;
        }
    } while ($dir = dirname($dir));
}

// WordPress yüklü değilse çık
if (!defined('ABSPATH')) {
    die('WordPress yüklenemedi. Bu dosyaya direkt erişim yasak.');
}

// API sabitleri tanımlı değilse hata ver
if (!defined('KAN_API_URL') || !defined('KAN_API_KEY')) {
    error_log('Kanews API: API URL veya KEY tanımlı değil');
    return;
}

function is_valid_json($raw_json) {
    return (json_decode($raw_json, true) == NULL) ? false : true;
}

try {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, KAN_API_URL."/currency");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_REFERER, 'http://www.google.com.tr'); 
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.1) Gecko/20061204 Firefox/2.0.0.1'); 

    $headers = array(
        'Content-Type: application/json',
        'X-API-Key: '.KAN_API_KEY
    );
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);
    
    if (!curl_errno($ch) && is_valid_json($result)) {
        // Doğrudan tema klasörüne yazalım, uploads yerine
        $theme_dir = get_template_directory();
        $json_file = $theme_dir . '/inc/api/currencies/currencies.json';

        // Dosyaya yazma
        $write_result = file_put_contents($json_file, $result);
        
        if ($write_result === false) {
            // Daha ayrıntılı hata kontrolü
            $error = error_get_last();
            throw new Exception('Dosya yazılamadı: ' . json_encode([
                'path' => $json_file,
                'error' => $error,
                'writable' => is_writable(dirname($json_file))
            ]));
        } else {
            // Başarıyla yazılırsa
            if (defined('DOING_AJAX') && DOING_AJAX) {
                wp_send_json_success(array(
                    'message' => 'Döviz verileri güncellendi',
                    'bytes_written' => $write_result,
                    'file_path' => $json_file,
                    'timestamp' => current_time('mysql')
                ));
            } else {
                echo "Döviz verileri güncellendi. Zaman: " . current_time('mysql');
            }
        }
    } else {
        throw new Exception(curl_error($ch) ?: 'Geçersiz JSON yanıtı');
    }
} catch (Exception $e) {
    error_log('Kanews Currency API Error: ' . $e->getMessage());
    if (defined('DOING_AJAX') && DOING_AJAX) {
        wp_send_json_error(array(
            'message' => 'Döviz verileri güncellenemedi',
            'error' => $e->getMessage()
        ));
    } else {
        echo "Hata: " . $e->getMessage();
    }
} finally {
    if (isset($ch) && is_resource($ch)) {
        curl_close($ch);
    }
}
