<?php
/**
 * Template Name: İletişim
 * @theme kanews
 * @developer kanthemes.com
 */
__( 'İletişim', 'kanews' );
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
function g12wp_enqueue_scripts() {
  if(function_exists( 'wpcf7_enqueue_styles' ) )
  wpcf7_enqueue_styles();
}
add_action('wp_enqueue_scripts', 'g12wp_enqueue_scripts');
$qua = [
  '0' => [
    'question' => '3x3=?',
    'answer' => '9'
  ],
  '1' => [
    'question' => '1x3=?',
    'answer' => '3'
  ],
  '2' => [
    'question' => '2+2=?',
    'answer' => '4'
  ],
  '3' => [
    'question' => '1+8=?',
    'answer' => '9'
  ],
  '4' => [
    'question' => '5x0=?',
    'answer' => '0'
  ],
  '5' => [
    'question' => '2+2=?',
    'answer' => '4'
  ],
];
$qua_rand = array_rand($qua);
get_header(); ?>
<?php while ( have_posts() ) : the_post(); ?>
<?php endwhile; ?>
  <?php do_action('kanews_header_ad'); ?>
  <main id="main" class="site-main bg-dark m-0">

    <?php $insights = get_post_meta( get_the_ID(), 'post_insight', true ) == 1 ? 1 : 0; if(kanews_insights_control() == true || $insights == 0 ): ?>

      <div class="container" style="padding: 0 7.5px;">
        <div class="row">
          <div class="col-12 mobile-col">
            <div class="kanews-lr-page kanews-contact-page d-flex flex-wrap">
              <div class="kanews-lr-page-left col-12 col-lg-4">
                <div class="kanews-contact-header">
                  <?php while ( have_posts() ) : the_post(); ?>
                  
                  <h1><?php the_title(); ?></h1>
                  <?php endwhile; ?>
                  <?php if(kanews_get_option('contact-page-description')): ?>
                    <p><?php echo kanews_get_option('contact-page-description'); ?></p>
                  <?php endif; ?>
                </div>
                <div class="kanews-contact-meta">
                  <ul>
                    <?php if(kanews_get_option('contact-page-email')): ?>
                      <li>
                        <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><g><g><g><path d="M10.688,95.156C80.958,154.667,204.26,259.365,240.5,292.01c4.865,4.406,10.083,6.646,15.5,6.646c5.406,0,10.615-2.219,15.469-6.604c36.271-32.677,159.573-137.385,229.844-196.896c4.375-3.698,5.042-10.198,1.5-14.719C494.625,69.99,482.417,64,469.333,64H42.667c-13.083,0-25.292,5.99-33.479,16.438C5.646,84.958,6.313,91.458,10.688,95.156z"/><path d="M505.813,127.406c-3.781-1.76-8.229-1.146-11.375,1.542C416.51,195.01,317.052,279.688,285.76,307.885c-17.563,15.854-41.938,15.854-59.542-0.021c-33.354-30.052-145.042-125-208.656-178.917c-3.167-2.688-7.625-3.281-11.375-1.542C2.417,129.156,0,132.927,0,137.083v268.25C0,428.865,19.135,448,42.667,448h426.667C492.865,448,512,428.865,512,405.333v-268.25C512,132.927,509.583,129.146,505.813,127.406z"/></g></g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg>
                        <span><?php echo kanews_get_option('contact-page-email'); ?></span>
                      </li>
                    <?php endif; ?>
                    <?php if(kanews_get_option('contact-page-phone')): ?>
                      <li>
                        <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 384 384" style="enable-background:new 0 0 384 384;" xml:space="preserve"><g><g><path d="M353.188,252.052c-23.51,0-46.594-3.677-68.469-10.906c-10.719-3.656-23.896-0.302-30.438,6.417l-43.177,32.594c-50.073-26.729-80.917-57.563-107.281-107.26l31.635-42.052c8.219-8.208,11.167-20.198,7.635-31.448c-7.26-21.99-10.948-45.063-10.948-68.583C132.146,13.823,118.323,0,101.333,0H30.813C13.823,0,0,13.823,0,30.813C0,225.563,158.438,384,353.188,384c16.99,0,30.813-13.823,30.813-30.813v-70.323C384,265.875,370.177,252.052,353.188,252.052z"/></g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg> 
                        <span><?php echo kanews_get_option('contact-page-phone'); ?></span>
                      </li>
                    <?php endif; ?>
                    <?php if(kanews_get_option('contact-page-address')): ?>
                      <li>
                        <svg enable-background="new 0 0 24 24" height="512" viewBox="0 0 24 24" width="512" xmlns="http://www.w3.org/2000/svg"><path d="m12 0c-4.962 0-9 4.066-9 9.065 0 7.103 8.154 14.437 8.501 14.745.143.127.321.19.499.19s.356-.063.499-.189c.347-.309 8.501-7.643 8.501-14.746 0-4.999-4.038-9.065-9-9.065zm0 14c-2.757 0-5-2.243-5-5s2.243-5 5-5 5 2.243 5 5-2.243 5-5 5z"/></svg>
                        <span><?php echo kanews_get_option('contact-page-address'); ?></span>
                      </li>
                    <?php endif; ?>
                  </ul>
                </div>
              </div>
              <div class="kanews-lr-page-right col-12 col-lg-8">
                <div class="kanews-lr-page-inner d-flex flex-column">
                  <?php if(kanews_get_option('contact-page-form') != ''): ?>
                    <?php echo do_shortcode('[contact-form-7 id="'.kanews_get_option('contact-page-form').'"]'); ?>
                  <?php else: ?>
                    <form id="kanews-contact-form" method="post" style="margin-top: 1em" action="<?php the_permalink(); ?>">
                      <div class="row">
                        <div class="col-12 col-lg-6">
                          <div class="kanews-form bgw">
                            <input id="name" name="name"  required />
                            <label for="name"><?php esc_html_e( 'Adınız', 'kanews' ); ?> *</label>
                          </div>
                        </div>
                        <div class="col-12 col-lg-6">
                          <div class="kanews-form bgw">
                            <input id="surname" name="surname"  type="text" required />
                            <label for="surname"><?php esc_html_e( 'Soyadınız', 'kanews' ); ?> *</label>
                          </div>
                        </div>
                        <div class="col-12">
                          <div class="kanews-form bgw">
                            <input id="subject" name="subject" type="text" required />
                            <label for="subject"><?php esc_html_e( 'Konu', 'kanews' ); ?> *</label>
                          </div>
                        </div>
                        <div class="col-12 col-lg-6">
                          <div class="kanews-form bgw">
                            <input id="pid" name="pid" type="pid" value="<?php echo $post->ID; ?>" hidden />
                            <input id="to" name="to" type="to" value="<?php echo kanews_get_option('contact-page-email'); ?>" hidden />
                            <input id="email" name="email" type="email"  required />
                            <label for="email"><?php esc_html_e( 'E-Posta', 'kanews' ); ?> *</label>
                          </div>
                        </div>
                        <div class="col-12 col-lg-6">
                          <div class="kanews-form bgw">
                            <input id="phone" name="phone" type="phone"  />
                            <label for="phone"><?php esc_html_e( 'Telefon Numaranız', 'kanews' ); ?></label>
                          </div>
                        </div>
                        <div class="col-12">
                        <div class="kanews-form bgw">
                            <input id="qua1" name="qua1" type="qua1" value="<?php echo $qua_rand; ?>" hidden />
                            <input id="qua" name="qua" type="qua"  required />
                            <label for="qua"><?php esc_html_e( 'Güvelik Sorusu', 'kanews' ); ?> (<?php echo $qua[$qua_rand]['question']; ?>) *</label>
                          </div>
                        </div>
                        <div class="col-12">
                          <div class="kanews-form bgw">
                            <textarea id="comment" name="comment" cols="45" rows="4" aria-required="true" required=""></textarea>
                            <label for="comment"><?php esc_html_e( 'Mesajınız', 'kanews' ); ?> *</label>
                          </div>
                        </div>
                        <?php echo kanews_get_recaptcha('registration_form'); ?>
                        <div class="col-12">
                          <button  class="kanews-btn kanews-btn-block" type="submit"><?php esc_html_e( 'Gönder', 'kanews' ); ?><div id="kanews-loader"></div></button>
                          <?php wp_nonce_field( 'contact_action', 'contact_field' ); ?>
                        </div>
                      </div>
                    </form>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

    <?php else: ?>
      <div class="col-12"><?php echo kanews_private_content('a'); ?></div>
    <?php endif; ?>

  </main>
<?php get_footer();