<?php 
/**
 * Dashboard Bookmarks Template
 * 
 * Displays user's bookmarked posts in the dashboard
 */

// Check if bookmarks feature is enabled
if ( kanews_get_option('post-bookmark') == true ): 
?>
  <h2 class="kanews-custom-page-title mb-1"><?php esc_html_e( 'Favorilerim', 'kanews' ); ?></h2>
  <?php
  // Get current page number
  $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
  
  // Get current user ID
  $current_user_id = get_current_user_id();
  
  // Query arguments for bookmarked posts
  $args = array(
    'posts_per_page' => 9,
    'paged'          => $paged,
    'meta_query'     => array(
      array(
        'key'     => '_user_bookmarked',
        'value'   => $current_user_id,
        'compare' => 'LIKE'
      )
    )
  );
  
  // Run the query
  $bookmark_query = new WP_Query( $args );
  $post_count = 0;
  
  if ( $bookmark_query->have_posts() ) : 
  ?>
    <div class="kanews-section kanews-section-flat">
      <div class="row">
        <?php 
        while ( $bookmark_query->have_posts() ) : 
          $bookmark_query->the_post(); 
          global $post;
          
          // Double check if user has bookmarked this post
          $bookmarked_users = get_post_meta($post->ID, '_user_bookmarked', true);
          if ( is_array($bookmarked_users) && in_array($current_user_id, $bookmarked_users) ) :
            $post_count++;
            get_template_part('template-parts/archives/article-3');
          endif;
        endwhile; 
        ?>
      </div>
    </div>
    
    <?php if ( $post_count === 0 ) : ?>
      <p><?php esc_html_e( 'Henüz herhangi bir şeyi favorilerine eklememişsin.', 'kanews' ); ?></p>
    <?php endif; ?>
    
  <?php 
  else: 
  ?>
    <p><?php esc_html_e( 'Henüz herhangi bir şeyi favorilerine eklememişsin.', 'kanews' ); ?></p>
  <?php 
  endif; 
  
  // Reset post data
  wp_reset_postdata(); 
  
  // Show pagination if there are more than 9 posts
  if ( $bookmark_query->max_num_pages > 1 ) : 
  ?>
    <div class="navigation pagination">
      <div class="nav-links">
        <?php 
        echo paginate_links( array(
          'base'         => str_replace( 999999999, '%#%', esc_url( get_pagenum_link( 999999999 ) ) ),
          'total'        => $bookmark_query->max_num_pages,
          'current'      => max( 1, get_query_var( 'paged' ) ),
          'format'       => '?paged=%#%',
          'show_all'     => false,
          'type'         => 'plain',
          'end_size'     => 2,
          'mid_size'     => 1,
          'prev_next'    => true,
          'prev_text'    => '<i class="icon-arrow icon-90degg"></i>',
          'next_text'    => '<i class="icon-arrow icon-90deg"></i>',
          'add_args'     => false,
          'add_fragment' => '',
        ) );
        ?>
      </div>
    </div>
  <?php endif; ?>
<?php else: ?>
  <p><?php esc_html_e( 'Bu özellik geçici olarak devre dışıdır.', 'kanews' ); ?></p>
<?php endif; ?>