<?php
/**
 * Template Name: Son Depremler
 * @theme kanews
 * @developer kanthemes.com
 */
__( 'Son Depremler', 'kanews' );
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
get_header(); ?>
  <?php while ( have_posts() ) : the_post(); ?>
    <?php kanews_page_header($post->ID); ?>
  <?php endwhile; ?>
  <?php do_action('kanews_header_ad'); ?>
  <main id="main" class="site-main">
    <div class="container">
      <div class="row">
        <?php $insights = get_post_meta( get_the_ID(), 'post_insight', true ) == 1 ? 1 : 0; if(kanews_insights_control() == true || $insights == 0 ): ?>
          <?php 

          $earthquakes = array();
          $transient_name = 'kanews-earthquake';
          $transient_time = 30 * MINUTE_IN_SECONDS;

          if ( false === ( $earthquakes = get_transient( $transient_name ) ) ) {
            require_once KAN_TEMPLATE_PATH.'/framework/class/Earthquake.php';
            $earthquakes = new earthquake();
            $earthquakes = json_encode($earthquakes->Earth());
            set_transient( $transient_name, $earthquakes, $transient_time);
          }

          $earthquakes = json_decode($earthquakes);

          ?>
          <div class="col-12">
            <div class="kanews-section">
              <?php echo kanews_widget_title(esc_html__( 'Son Depremler', 'kanews' ), 'h2'); ?>
            <input placeholder="<?php _e('Hangi Şehirdeki Depremleri Görmek İstiyorsun?', 'kanews'); ?>" id="kanews-currencies-search">
            <div style="max-height: 768px;overflow: auto">
              <table class="kanews-table table-search table-currencies table-auto table-earthquake">
                <thead>
                  <tr>
                    <th><span class="nobr"><?php esc_html_e( 'Tarih', 'kanews' ); ?></span></th>
                    <th><span class="nobr"><?php esc_html_e( 'Yer', 'kanews' ); ?></span></th>
                    <th><span class="nobr"><?php esc_html_e( 'Tip', 'kanews' ); ?></span></th>
                    <th><span class="nobr"><?php esc_html_e( 'Büyüklük', 'kanews' ); ?></span></th>
                    <th class="hidden-mobile"><span class="nobr"><?php esc_html_e( 'Derinlik', 'kanews' ); ?></span></th>
                    
                    
                    <th><span class="nobr"><?php esc_html_e( 'Harita', 'kanews' ); ?></span></th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  if( !empty($earthquakes) ) {
                    foreach ($earthquakes as $Earth) {
                      if( $Earth->Ml > "3.5" )
                      $class = 'bg-warning color-white';
                      elseif( $Earth->Ml > "5.0" )
                      $class = 'bg-danger color-white';
                      else
                      $class = '';

                      echo '<tr class="'.$class.'">';
                        echo '<td>'.$Earth->Date.' '.$Earth->Time.'</td>';
                        echo '<td>'.$Earth->Location.'</td>';
                        echo '<td>ML</td>';
                        echo '<td>'.$Earth->Ml.'</td>';
                        echo '<td>'.$Earth->Depth.'km</td>';
                        
                       
                        echo '<td><a class="kanews-btn kanews-btn-sm m-0 color-white" href="https://maps.google.com/maps?q='.$Earth->Latitude.','.$Earth->Longitude.'" target="_blank">'.esc_html__( 'Haritada Göster', 'kanews' ).'</a></td>';
          
                      echo '</tr>';
                    }
                  } else {
                    echo '<tr><td>'.esc_html__( ('Veri alınamadı'), 'kanews' ).'</td></tr>';
                  }
                  ?>
                </tbody>
              </table>
            </div>
          </div>
          </div>
          <?php get_template_part('template-parts/content/components/related', 'page'); ?>
        
          <?php while ( have_posts() ) : the_post(); 
            if ($post->post_content): ?>
              <div class="col-12">
                <div class="kanews-article kanews-section-box kanews-article-1">
                  <div class="kanews-article-content entry-content">
                    <?php the_content(); ?>
                  </div>
                </div>
              </div>
            <?php endif; ?>
            <?php if ( comments_open() || get_comments_number() ) : ?>
              
              <div class="col-12">
                <?php comments_template(); ?>
              </div>
            <?php endif;?> 
          <?php endwhile; ?>
        <?php else: ?>
          <div class="col-12"><?php echo kanews_private_content('a'); ?></div>
        <?php endif; ?>

      </div>
    </div>
  </main>
<?php get_footer();
