<?php

function calculate_credits_by_post_length($post_content) {
    // Yazı içeriğindeki kelime sayısını hesapla
    $word_count = str_word_count(strip_tags($post_content));
    // Her 100 kelime için 1 kredi harca
    $credits_needed = ceil($word_count / 100);
    return $credits_needed;
  }

add_action('wp_ajax_generate_tts', 'generate_tts');
function generate_tts() {
    check_ajax_referer('kanews_ai_nonce_action', 'nonce');

    $post_id = intval($_POST['post_id']);
    $voice = $_POST['voice'];
    $post_content = get_post_field('post_content', $post_id);

    if( ! Kanews\Util\Kai::reduce_site_credits(calculate_credits_by_post_length($post_content)) ) {
    echo json_encode(['error' => false, 'message' => 'Krediniz yetmedi, kendi api keyinizi kullanın.']);
    wp_die();
    }

    $audioContent = kanews_ai_connect('tts', wp_strip_all_tags( strip_shortcodes($post_content) ), $voice );

    if ($audioContent) {
        require_once(ABSPATH . 'wp-admin/includes/image.php');
        require_once(ABSPATH . 'wp-admin/includes/file.php');
        require_once(ABSPATH . 'wp-admin/includes/media.php');

        // Yükleme dizinini al
        $upload_dir = wp_upload_dir();
        $file_path = $upload_dir['path'] . "/post-$post_id.mp3";
        file_put_contents($file_path, $audioContent);

        // Dosya bilgilerini oluştur
        $filetype = wp_check_filetype(basename($file_path), null);
        $wp_upload_dir = wp_upload_dir();

        $attachment = array(
            'guid'           => $wp_upload_dir['url'] . '/' . basename($file_path),
            'post_mime_type' => $filetype['type'],
            'post_title'     => preg_replace('/\.[^.]+$/', '', basename($file_path)),
            'post_content'   => '',
            'post_status'    => 'inherit'
        );
        
        // Attachment'ı ekle
        $attach_id = wp_insert_attachment($attachment, $file_path, $post_id);
        
        // Attachment meta datasını oluştur
        $attach_data = wp_generate_attachment_metadata($attach_id, $file_path);
        wp_update_attachment_metadata($attach_id, $attach_data);
        
        // Dosya URL'sini oluştur
        $file_url = $wp_upload_dir['url'] . "/post-$post_id.mp3";
        
        // Sonucu JSON formatında döndür
        echo json_encode(['success' => true, 'message' => 'Ses dosyası oluşturuldu.', 'file_url' => $file_url, 'file_id' => $attach_id]);

        update_post_meta( $post_id, 'post_text_to_speech', array('url' => $file_url, 'id' => $attach_id) );
    } else {
        echo json_encode(['success' => false, 'message' => 'Ses dosyası oluşturulamadı.']);
    }
    wp_die();
}

add_action('wp_ajax_generate_comments', 'generate_comments');
function generate_comments() {
    check_ajax_referer('kanews_ai_nonce_action', 'nonce');

    $post_id = intval($_POST['post_id']);
    $count = intval($_POST['count']);
    $post_content = get_post_field('post_content', $post_id);
    $post_title = get_post_field('post_title', $post_id);

    if(empty($post_content)) {
        echo json_encode(['success' => false, 'message' => 'Yazı içeriği boş olamaz.']);
        wp_die();
    }

    // Limit comment count for credit calculation
    $count = min($count, 20); // Maximum 20 comments allowed

    // Kredi kontrolü - her yorum 1 kredi olarak hesaplanabilir
    if(!Kanews\Util\Kai::reduce_site_credits($count)) {
        echo json_encode(['error' => false, 'message' => 'Krediniz yetmedi, kendi api keyinizi kullanın.']);
        wp_die();
    }

    // Comment content generation
    $comments = kanews_ai_connect('comments', wp_strip_all_tags(strip_shortcodes($post_content)), [
        'title' => $post_title,
        'count' => $count
    ]);

    if ($comments) {
        // Extract the actual JSON content from the response
        $raw_content = $comments['choices'][0]['message']['content'];
        
        // Remove code fence markers if present
        $cleaned_content = preg_replace('/```json\s*|\s*```/', '', $raw_content);
        
        // Now decode the cleaned content
        $comment_data = json_decode($cleaned_content, true);
        $added_count = 0;

        if (is_array($comment_data)) {
            foreach ($comment_data as $comment) {
                $comment_args = array(
                    'comment_post_ID' => $post_id,
                    'comment_author' => $comment['name'],
                    'comment_author_email' => $comment['email'],
                    'comment_content' => $comment['comment'],
                    'comment_date' => date('Y-m-d H:i:s', strtotime('-' . rand(1, 30) . ' days')),
                    'comment_approved' => 1
                );
                
                $comment_id = wp_insert_comment($comment_args);
                if ($comment_id) {
                    $added_count++;
                }
            }
        }

        echo json_encode([
            'success' => true, 
            'message' => sprintf('%d yorum başarıyla eklendi.', $added_count)
        ]);
    } else {
        echo json_encode([
            'success' => false, 
            'message' => 'Yorumlar oluşturulamadı.'
        ]);
    }
    wp_die();
}

add_action('wp_ajax_generate_excerpt', 'generate_excerpt');
function generate_excerpt() {
    check_ajax_referer('kanews_ai_nonce_action', 'nonce');

    $post_id = intval($_POST['post_id']);
    $post_content = get_post_field('post_content', $post_id);

    if( ! Kanews\Util\Kai::reduce_site_credits(calculate_credits_by_post_length($post_content)) ) {
        echo json_encode(['error' => false, 'message' => 'Krediniz yetmedi, kendi api keyinizi kullanın.']);
        wp_die();
    }

    $postExcerpt = kanews_ai_connect('excerpt', wp_strip_all_tags( strip_shortcodes($post_content) ));

    if ($postExcerpt) {
        // Sonucu JSON formatında döndür
        echo json_encode(['success' => true, 'message' => esc_html($postExcerpt['choices'][0]['message']['content']) ]);
        update_post_meta( $post_id, 'kanews_post_excerpt', esc_html($postExcerpt['choices'][0]['message']['content']) );
    } else {
        echo json_encode(['success' => false, 'message' => 'Açıklama oluşturulamadı.']);
    }
    wp_die();
}

add_action('wp_ajax_generate_summary', 'generate_summary');
function generate_summary() {
    check_ajax_referer('kanews_ai_nonce_action', 'nonce');


    $post_id = intval($_POST['post_id']);
    $post_content = get_post_field('post_content', $post_id);

    if( ! Kanews\Util\Kai::reduce_site_credits(calculate_credits_by_post_length($post_content)) ) {
        echo json_encode(['error' => false, 'message' => 'Krediniz yetmedi, kendi api keyinizi kullanın.']);
        wp_die();
    }

    $postSummary = kanews_ai_connect('summary', wp_strip_all_tags( strip_shortcodes($post_content) ));

    if ($postSummary) {
        // Sonucu JSON formatında döndür
        echo json_encode(['success' => true, 'message' => 'Özet oluşturuldu.' ]);
        update_post_meta( $post_id, 'kanews_post_summary', esc_html($postSummary['choices'][0]['message']['content']) );
    } else {
        echo json_encode(['success' => false, 'message' => 'Özet oluşturulamadı.']);
    }
    wp_die();
}

add_action('wp_ajax_generate_seo_title', 'generate_seo_title');
function generate_seo_title() {
    check_ajax_referer('kanews_ai_nonce_action', 'nonce');

    $post_id = intval($_POST['post_id']);
    $post_content = get_post_field('post_content', $post_id);

    if( ! Kanews\Util\Kai::reduce_site_credits(calculate_credits_by_post_length($post_content)) ) {
        echo json_encode(['error' => false, 'message' => 'Krediniz yetmedi, kendi api keyinizi kullanın.']);
        wp_die();
    }

    $seoTitle = kanews_ai_connect('seo-title', wp_strip_all_tags( strip_shortcodes($post_content) ));

    if ($seoTitle) {
        $title = esc_html($seoTitle['choices'][0]['message']['content']);
        
        // Post başlığını güncelle
        wp_update_post(array(
            'ID' => $post_id,
            'post_title' => $title
        ));
        
        echo json_encode(['success' => true, 'message' => $title]);
    } else {
        echo json_encode(['success' => false, 'message' => 'SEO başlığı oluşturulamadı.']);
    }
    wp_die();
}

add_action('wp_ajax_generate_article', 'generate_article');
function generate_article() {
    check_ajax_referer('kanews_ai_nonce_action', 'nonce');

    $topic = sanitize_text_field($_POST['topic']);
    $length = 0;
    $notes = sanitize_textarea_field($_POST['notes'] ?? '');
    
    if(empty($topic) ) {
        echo json_encode(['success' => false, 'message' => 'Konu ve kelime sayısı gereklidir.']);
        wp_die();
    }

    if(!Kanews\Util\Kai::reduce_site_credits(ceil($length/100))) {
        echo json_encode(['error' => false, 'message' => 'Krediniz yetmedi, kendi api keyinizi kullanın.']);
        wp_die();
    }

    
    $article = kanews_ai_connect('article', $topic, null);

    if ($article) {
        $content = $article['choices'][0]['message']['content'];
        echo json_encode(['success' => true, 'message' => $content]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Makale oluşturulamadı.']);
    }
    wp_die();
}

add_action('wp_ajax_generate_faq', 'generate_faq');
function generate_faq() {
    check_ajax_referer('kanews_ai_nonce_action', 'nonce');

    $post_id = intval($_POST['post_id']);
    $post_content = get_post_field('post_content', $post_id);
    $count = intval($_POST['count']);
    $detailed = filter_var($_POST['detailed'], FILTER_VALIDATE_BOOLEAN);

    if(empty($post_content)) {
        echo json_encode(['success' => false, 'message' => 'Yazı içeriği boş olamaz.']);
        wp_die();
    }

    // Kredi kontrolü
    if(!Kanews\Util\Kai::reduce_site_credits(calculate_credits_by_post_length($post_content))) {
        echo json_encode(['error' => false, 'message' => 'Krediniz yetmedi, kendi api keyinizi kullanın.']);
        wp_die();
    }

    $faq = kanews_ai_connect('faq', wp_strip_all_tags(strip_shortcodes($post_content)), [
        'count' => $count,
        'detailed' => $detailed
    ]);

    if ($faq) {
        echo json_encode([
            'success' => true, 
            'message' => $faq['choices'][0]['message']['content']
        ]);
    } else {
        echo json_encode([
            'success' => false, 
            'message' => 'SSS oluşturulamadı.'
        ]);
    }
    wp_die();
}

add_action('wp_ajax_generate_paraphrase', 'generate_paraphrase');
function generate_paraphrase() {
    check_ajax_referer('kanews_ai_nonce_action', 'nonce');

    $post_id = intval($_POST['post_id']);
    $model = sanitize_text_field($_POST['model']);
    $level = sanitize_text_field($_POST['level']);
    $preserve_keywords = filter_var($_POST['preserve_keywords'], FILTER_VALIDATE_BOOLEAN);
    $preserve_structure = filter_var($_POST['preserve_structure'], FILTER_VALIDATE_BOOLEAN);
    $improve_seo = filter_var($_POST['improve_seo'], FILTER_VALIDATE_BOOLEAN);
    
    $post_content = get_post_field('post_content', $post_id);
    $post_title = get_post_field('post_title', $post_id);

    if(empty($post_content)) {
        echo json_encode(['success' => false, 'message' => 'Yazı içeriği boş olamaz.']);
        wp_die();
    }

    // Kredi kontrolü
    if(!Kanews\Util\Kai::reduce_site_credits(calculate_credits_by_post_length($post_content))) {
        echo json_encode(['error' => false, 'message' => 'Krediniz yetmedi, kendi api keyinizi kullanın.']);
        wp_die();
    }

    // Paraphrase content generation
    $paraphrased_content = kanews_ai_connect('paraphrase', wp_strip_all_tags(strip_shortcodes($post_content)), [
        'title' => $post_title,
        'model' => $model,
        'level' => $level,
        'preserve_keywords' => $preserve_keywords,
        'preserve_structure' => $preserve_structure,
        'improve_seo' => $improve_seo
    ]);

    if ($paraphrased_content) {
        // Başlığı değiştirmeden sadece içeriği güncelle
        $paraphrased_text = $paraphrased_content['choices'][0]['message']['content'];
        
        // Başlık etiketlerini koru
        $paraphrased_text = preg_replace('/<h1[^>]*>.*?<\/h1>/i', '', $paraphrased_text);
        
        echo json_encode([
            'success' => true, 
            'message' => $paraphrased_text
        ]);
    } else {
        echo json_encode([
            'success' => false, 
            'message' => 'Makale özgünleştirilemedi.'
        ]);
    }
    wp_die();
}

function get_pexels_image($query) {
    if (empty(Kanews\Util\Kai::get_api_key('pexels'))) {
        return false;
    }

    $ch = curl_init();
    $url = "https://api.pexels.com/v1/search?" . http_build_query([
        'query' => $query,
        'per_page' => 9, // 9 görsel getir
        'locale' => 'tr-TR',
        'orientation' => 'landscape'
    ]);

    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => [
            "Authorization: " . Kanews\Util\Kai::get_api_key('pexels')
        ],
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false
    ]);

    $response = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);

    if ($err) {
        error_log("Pexels API Error: " . $err);
        return false;
    }

    $data = json_decode($response, true);
    
    if (isset($data['photos']) && !empty($data['photos'])) {
        $images = [];
        foreach($data['photos'] as $photo) {
            $images[] = [
                'url' => $photo['src']['large'],
                'thumbnail' => $photo['src']['medium'],
                'photographer' => $photo['photographer'],
                'photographer_url' => $photo['photographer_url']
            ];
        }
        return $images;
    }
    
    return false;
}

function generate_featured_image() {
    if (!check_ajax_referer('kanews_ai_nonce_action', 'nonce', false)) {
        wp_send_json_error(['message' => 'Güvenlik doğrulaması başarısız.']);
    }

    $topic = sanitize_text_field($_POST['topic'] ?? '');
    $post_id = intval($_POST['post_id'] ?? 0);
    $selected_image = isset($_POST['selected_image']) ? $_POST['selected_image'] : null;
    
    if (empty($topic) || empty($post_id)) {
        wp_send_json_error(['message' => 'Konu ve yazı ID\'si gereklidir.']);
    }

    if (empty(Kanews\Util\Kai::get_api_key('pexels'))) {
        wp_send_json_error(['message' => 'Pexels API anahtarı ayarlanmamış.']);
    }

    if ($selected_image) {
        // Seçilen görseli yükle
        $image_data = [
            'url' => $selected_image['url'],
            'photographer' => $selected_image['photographer'],
            'photographer_url' => $selected_image['photographer_url']
        ];
        
        $image_id = upload_featured_image($image_data, $post_id);
        
        if (!$image_id) {
            wp_send_json_error(['message' => 'Görsel yüklenirken bir hata oluştu.']);
        }

        wp_send_json_success([
            'message' => 'Görsel başarıyla eklendi. Fotoğrafçı: ' . esc_html($image_data['photographer']),
            'image_id' => $image_id,
            'image_url' => wp_get_attachment_url($image_id)
        ]);
    } else {
        // Görselleri getir
        $images = get_pexels_image($topic);
        
        if (!$images) {
            wp_send_json_error(['message' => 'Görsel bulunamadı. Lütfen farklı bir arama terimi deneyin.']);
        }

        wp_send_json_success([
            'message' => 'Görseller başarıyla getirildi.',
            'images' => $images
        ]);
    }
}

function kanews_ai_connect($type = 'e', $text = 'deneme', $voice = 'alloy') {

    $ch = curl_init();
    
    if( $type == 'tts') {
        $data = array(
            'model' => 'tts-1',
            'input' => substr($text, 0, 4090),
            'voice' => $voice
        );
        
        curl_setopt($ch, CURLOPT_URL, 'https://api.openai.com/v1/audio/speech');
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . Kanews\Util\Kai::get_api_key('openai')
        ));
  
    } elseif( $type == 'excerpt' ) {
        $data = array(
            'model' => 'gpt-4o-mini',
            "messages" => [
              [
                "role" => "system",
                "content" => "You are a professional news editor. Create a compelling news excerpt by following these steps:

                1. First, analyze the content and detect its language
                2. Then, create a journalistic lead paragraph that:
                   - Captures the most newsworthy aspects
                   - Answers the key questions (Who, What, Where, When, Why)
                   - Is between 100-150 characters
                   - Uses the same language as the content
                   - Follows news writing best practices
                
                Rules:
                - Write in clear, concise journalistic style
                - Focus on facts and key information
                - Use active voice and strong verbs
                - Maintain the original language of the content
                - Avoid sensationalism while keeping reader interest
                - Include the most relevant keywords naturally
                - Return only the excerpt text without formatting"
              ],
              [
                "role" => "user",
                "content" => $text
              ]
            ]
        );
        curl_setopt($ch, CURLOPT_URL, 'https://api.openai.com/v1/chat/completions');
    } elseif($type == 'comments') {
        $title = $voice['title'] ?? '';
        $count = $voice['count'] ?? 5;
        
        $data = array(
            'model' => 'gpt-4o-mini',
            "messages" => [
                [
                    "role" => "system",
                    "content" => "Generate {$count} realistic comments for a blog post. Detect the language of the content and create comments in the SAME language. Each comment should include:
                    
                    1. A realistic name (appropriate to the content language) - use a mix of full names and nicknames/usernames
                    2. A valid email format (example@domain.com)
                    3. Comment text that is 1-3 sentences long and relates directly to the content
                    
                    Make comments diverse in opinion, some positive, some neutral, some questioning.
                    Format as JSON array. Example:
                    [
                    {\"name\":\"Ali Yılmaz\",\"email\":\"ali@example.com\",\"comment\":\"Bu makale gerçekten bilgilendirici olmuş.\"},
                    {\"name\":\"TechGuru\",\"email\":\"techguru@example.com\",\"comment\":\"Harika bir yazı, özellikle ikinci bölüm çok faydalı.\"},
                    {\"name\":\"John Smith\",\"email\":\"john@example.com\",\"comment\":\"Great article! I wonder if you could expand on the second point?\"},
                    {\"name\":\"CryptoFan\",\"email\":\"cryptofan@example.com\",\"comment\":\"Bu konuda daha fazla bilgi paylaşabilir misiniz?\"}
                    ]"
                ],
                [
                    "role" => "user",
                    "content" => "Title: {$title}\n\nContent: {$text}"
                ]
            ]
        );
        curl_setopt($ch, CURLOPT_URL, "https://api.openai.com/v1/chat/completions");
    } elseif( $type == 'seo-title' ) {
        $data = array(
            'model' => 'gpt-4o-mini',
            "messages" => [
              [
                "role" => "system",
                "content" => "You are a professional news headline generator for a news website. Follow these steps:

                1. First, analyze the content and detect its language
                2. Then, identify the key newsworthy elements:
                   - Who is involved?
                   - What happened?
                   - Where did it happen?
                   - When did it happen?
                   - Why is it important?
                
                3. Create a news headline in the SAME LANGUAGE as the content that:
                   - Leads with the most important/impactful information
                   - Captures the essence of the news story
                   - Is under 70 characters
                   - Uses active voice and strong verbs
                   - Includes relevant keywords for SEO
                   - Follows news writing best practices
                   - Maintains journalistic integrity
                   - Creates urgency and interest
                
                Rules:
                - Write in the exact same language as the content
                - Focus on facts, not speculation
                - Use news style appropriate for the detected language
                - Avoid clickbait tactics while maintaining interest
                - Never use quotes unless directly quoting a key figure
                - Use minimal punctuation, only when necessary
                - Return only the headline text
                - No explanations or additional formatting"
              ],
              [
                "role" => "user",
                "content" => $text
              ]
            ]
        );
        curl_setopt($ch, CURLOPT_URL, "https://api.openai.com/v1/chat/completions");
    } elseif($type == 'article') {
        $topic = $_POST['topic'] ?? '';
        $style = $_POST['style'] ?? 'news';
        $model = $_POST['model'] ?? 'gpt-4o-mini';
        $use_list = filter_var($_POST['use_list'] ?? false, FILTER_VALIDATE_BOOLEAN);
        $use_5w1h = filter_var($_POST['use_5w1h'] ?? false, FILTER_VALIDATE_BOOLEAN);
        $add_faq = filter_var($_POST['add_faq'] ?? false, FILTER_VALIDATE_BOOLEAN);
        $language = $_POST['language'] ?? 'auto';
        $use_tables = filter_var($_POST['use_tables'] ?? false, FILTER_VALIDATE_BOOLEAN);
        $notes = $_POST['notes'] ?? '';

        // Stil tanımlamaları
        switch($style) {
            case 'news':
                $style_guide = "Write a news article focusing on facts and current events. Use journalistic style.";
                break;
            case 'analysis':
                $style_guide = "Create an analytical piece with data-driven insights and expert perspectives.";
                break;
            case 'interview':
                $style_guide = "Format as an interview with expert Q&A structure.";
                break;
            case 'opinion':
                $style_guide = "Write an opinion piece with clear arguments and supporting evidence.";
                break;
            case 'custom-news':
                $style_guide = "Create a unique custom news.";
                break;
            case 'guide':
                $style_guide = "Create a practical guide with clear steps and actionable advice.";
                break;
            case 'review':
                $style_guide = "Write a balanced review covering pros, cons and detailed evaluation.";
                break;
            case 'list':
                $style_guide = "Using a numbered list and heading structure, informal, fluent and plain language provides informative and guiding lists.";
                break;
            case 'clickbait':
                $style_guide = "Write in clickbait news style with these characteristics:
                    - Use attention-grabbing, dramatic titles with questions
                    - Repeat the title content in the first paragraph
                    - Use phrases like 'İşte', 'Peki', 'merak ediliyor'
                    - Create suspense by teasing information throughout the article
                    - Repeat key terms and questions multiple times
                    - Break content into very short paragraphs
                    - Use question-based subheadings
                    - IMPORTANT: Always provide the actual, complete answer in the final section
                    - The final section heading should be the main question in ALL CAPS
                    - Example: If the article is about 'X maçı hangi kanalda?', use that as the final heading
                    - Make sure the reader gets the real information they came for at the end
                    - Use a conclusive tone in the final section with phrases like 'işte detaylar', 'resmi açıklama', 'kesin sonuç'";
                break;
            default:
                $style_guide = "Write in standard article format.";
        }

        $data = array(
            'model' => $model,
            "messages" => [
                [
                    "role" => "system",
                    "content" => "You are writing a {$style} article. {$style_guide}

                    ARTICLE CREATION PROCESS:

                    1. TITLE
                    - First line must be the article title
                    - Create an SEO-friendly, engaging title
                    - Title should be clear and descriptive

                    2. INTRODUCTION
                    <p class=\"has-medium-font-size\">Engaging introduction with naturally emphasized key terms</p>

                    3. MAIN CONTENT
                    - Use HTML tags in an SEO friendly manner. For example, <strong>, <em> etc.
                    - Space out emphasis naturally through paragraphs
                    - Ensure emphasized terms are relevant and contextual

                    " . ($use_5w1h === true ? "
                    Create hierarchical subheadings using the 5W1H method with HTML heading tags.
                    " : "Create hierarchical subheadings with HTML heading tags.") . "

                    " . ($use_tables === true ? "
                    Include a relevant comparison table where appropriate:
                    <table class=\"wp-table is-style-stripes\">
                        <thead><tr><th>Compare</th></tr></thead>
                        <tbody><tr><td>Data</td></tr></tbody>
                    </table>
                    " : "") . "

                    " . ($use_list === true ? "
                    Include relevant lists where appropriate:
                    <ul>
                    <li>List 1</li>
                    <li>List 2</li>
                    </ul>
                    " : "") . "

                    4. CONCLUSION
                    <h2>Conclusion heading in article language</h2>
                    - Summarize key points
                    - Include one final term emphasis if natural
                    - Reinforce main arguments
                    - Provide final thoughts

                    " . ($add_faq === true ? "
                    5. FAQ SECTION
                    <h2>FAQ heading in article language</h2>
                    [kanews-accordion]
                    - Create 4-6 relevant questions and answers
                    - Include key terms naturally in questions
                    [kanews-collapse title=\"Question?\"]Answer[/kanews-collapse]
                    [/kanews-accordion]
                    " : "") . "

                    CONTENT GUIDELINES:
                    - Write everything in " . ($language == 'auto' ? "the language matching the topic" : $language) . "
                    - Use html tags use, do not different structure
                    - Never mix languages
                    - Use <h1><h2><h3><h4> tags for heading tags.
                    - Be careful to write a long answer.
                    - Adapt length to topic complexity
                    - Do not list keywords at the beginning
                    - Highlight SEO friendly words or phrases
                    - Space out emphasis throughout content
                    - Create natural, language-appropriate headings
                    - Include relevant examples and evidence
                    - Use clear paragraphs and transitions
                    - Maintain {$style} writing style
                    // - When talking about WordPress News Themes, include the Kanews.
                    " . (!empty($notes) ? "
                    
                    ADDITIONAL INSTRUCTIONS:
                    {$notes}
                    " : "")
                ],
                [
                    "role" => "user", 
                    "content" => "Create a {$style} about: {$topic}"
                ]
            ]
        );
        curl_setopt($ch, CURLOPT_URL, "https://api.openai.com/v1/chat/completions");
    } elseif($type == 'faq') {
        $data = array(
            'model' => 'gpt-4o-mini',
            "messages" => [
                [
                    "role" => "system",
                    "content" => "Create a FAQ section about the given topic. Follow these rules:
                    1. Detect the language of the topic and write in that language
                    2. Create " . $voice['count'] . " questions and answers
                    3. Use WordPress shortcodes for accordion structure
                    4. " . ($voice['detailed'] ? "Provide detailed answers" : "Keep answers concise") . "
                    5. Format output as:
                    [kanews-accordion]
                    [kanews-collapse title=\"Question 1?\"]Answer 1[/kanews-collapse]
                    [/kanews-accordion]"
                ],
                [
                    "role" => "user",
                    "content" => $text
                ]
            ]
        );
        curl_setopt($ch, CURLOPT_URL, "https://api.openai.com/v1/chat/completions");
    } elseif($type == 'paraphrase') {
        $title = $voice['title'] ?? '';
        $model = $voice['model'] ?? 'gpt-4o-mini';
        $level = $voice['level'] ?? 'medium';
        $preserve_keywords = $voice['preserve_keywords'] ?? true;
        $preserve_structure = $voice['preserve_structure'] ?? true;
        $improve_seo = $voice['improve_seo'] ?? false;
        
        // Özgünleştirme seviyesine göre talimatları ayarla
        $paraphrase_instructions = "";
        switch($level) {
            case 'light':
                $paraphrase_instructions = "Make minimal changes to the text while maintaining its original meaning. 
                - Keep most of the original sentence structure
                - Replace some words with synonyms
                - Maintain the same tone and style
                - Keep all key information intact";
                break;
            case 'medium':
                $paraphrase_instructions = "Make moderate changes to the text while preserving its core message.
                - Rewrite sentences with different structures
                - Use synonyms for most words
                - Maintain the same tone but with some variation
                - Keep all key information but present it differently";
                break;
            case 'high':
                $paraphrase_instructions = "Completely rewrite the text while preserving its core message.
                - Create entirely new sentence structures
                - Use different vocabulary throughout
                - Vary the tone and style while keeping it professional
                - Present the information in a fresh way";
                break;
        }
        
        // Anahtar kelimeleri koruma talimatı
        $keywords_instruction = $preserve_keywords ? 
            "IMPORTANT: Identify and preserve all SEO keywords from the original text. These keywords should appear in the paraphrased content with similar frequency." : 
            "You can freely change all words, including keywords.";
            
        // Yapıyı koruma talimatı
        $structure_instruction = $preserve_structure ? 
            "Maintain the same overall structure, headings, and paragraph organization as the original text." : 
            "You can reorganize the content structure as needed.";
            
        // SEO iyileştirme talimatı
        $seo_instruction = $improve_seo ? 
            "Additionally, optimize the content for SEO by:
            - Ensuring proper keyword placement (title, headings, first paragraph)
            - Improving readability with shorter paragraphs and sentences
            - Adding relevant internal linking suggestions where appropriate
            - Enhancing meta description quality" : 
            "";
        
        $data = array(
            'model' => $model,
            "messages" => [
                [
                    "role" => "system",
                    "content" => "You are a professional content rewriter. Your task is to paraphrase the given content while maintaining its original meaning and value.

                    PARAPHRASING INSTRUCTIONS:
                    {$paraphrase_instructions}
                    
                    {$keywords_instruction}
                    
                    {$structure_instruction}
                    
                    {$seo_instruction}
                    
                    HTML AND MEDIA PRESERVATION RULES:
                    - CRITICAL: Preserve ALL HTML tags exactly as they are (<p>, <h1>, <h2>, <h3>, <h4>, <strong>, <em>, etc.)
                    - CRITICAL: Do NOT modify or change any image tags (<img>) or their attributes
                    - CRITICAL: Keep all shortcodes intact (e.g., [kanews-accordion], [kanews-collapse])
                    - CRITICAL: Preserve all CSS classes and inline styles
                    - CRITICAL: Maintain all HTML formatting and structure
                    - CRITICAL: Do not add any new HTML tags or modify existing ones
                    - CRITICAL: Keep all links (<a> tags) exactly as they are
                    
                    ADDITIONAL RULES:
                    - Detect the language of the content and maintain the same language
                    - Maintain the same level of detail and information
                    - Ensure the paraphrased content is grammatically correct
                    - Make sure the content flows naturally and is easy to read
                    - Return the complete paraphrased content with all original formatting"
                ],
                [
                    "role" => "user",
                    "content" => "Title: {$title}\n\nContent to paraphrase:\n{$text}"
                ]
            ]
        );
        curl_setopt($ch, CURLOPT_URL, "https://api.openai.com/v1/chat/completions");
    } else {
        $data = array(
            'model' => 'gpt-4o-mini',
            "messages" => [
              [
                "role" => "system",
                "content" => "You are a professional news summarizer. Follow these steps strictly:

                1. IMPORTANT - LANGUAGE RULE:
                   - First, detect the language of the provided content
                   - You MUST write the summary in EXACTLY THE SAME LANGUAGE as the source content
                   - Do NOT translate to any other language
                   - If content is in Turkish, write in Turkish
                   - If content is in English, write in English
                   - Match the language style and tone of the original

                2. Then, create a three-paragraph news summary that:

                   Introduction (in the same language as source):
                   - Starts with a strong lead paragraph
                   - Presents the most important facts
                   - Captures reader attention immediately

                   Development (in the same language as source):
                   - Provides essential context and background
                   - Includes relevant quotes or data
                   - Expands on the key points

                   Conclusion (in the same language as source):
                   - Wraps up with impact or significance
                   - Provides broader context if relevant
                   - Ends with a strong closing point

                Rules:
                - CRITICAL: Keep the EXACT SAME LANGUAGE as the source content
                - Write in professional journalistic style
                - Use clear, factual language
                - Include relevant statistics and quotes when available
                - Follow inverted pyramid structure
                - Focus on accuracy and objectivity
                - Avoid editorializing or speculation
                - Keep paragraphs concise and well-structured
                - Never translate to another language"
              ],
              [
                "role" => "user",
                "content" => $text
              ]
            ]
        );
        curl_setopt($ch, CURLOPT_URL, "https://api.openai.com/v1/chat/completions");
    }

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Authorization: Bearer ' . Kanews\Util\Kai::get_api_key('openai'),
        'Content-Type: application/json'
    ));
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

    $result = curl_exec($ch);

    if (curl_errno($ch) || isset(json_decode($result, true)['error']) ) {
        return false;
    } else {
        if( $type == 'tts')
        return $result;
        else {
        return json_decode($result, true);
    }
    }

    curl_close($ch);
}

function upload_featured_image($image_data, $post_id) {
    require_once(ABSPATH . 'wp-admin/includes/media.php');
    require_once(ABSPATH . 'wp-admin/includes/file.php');
    require_once(ABSPATH . 'wp-admin/includes/image.php');

    $tmp = download_url($image_data['url']);
    
    if (is_wp_error($tmp)) {
        error_log("Image download error: " . $tmp->get_error_message());
        return false;
    }

    $file_array = array(
        'name' => sanitize_file_name(get_the_title($post_id) . '-featured.jpg'),
        'tmp_name' => $tmp
    );

    $image_id = media_handle_sideload($file_array, $post_id);

    @unlink($tmp);

    if (is_wp_error($image_id)) {
        error_log("Media upload error: " . $image_id->get_error_message());
        return false;
    }

    update_post_meta($image_id, 'photographer_name', $image_data['photographer']);
    update_post_meta($image_id, 'photographer_url', $image_data['photographer_url']);
    
    set_post_thumbnail($post_id, $image_id);
    
    return $image_id;
}
add_action('wp_ajax_generate_featured_image', 'generate_featured_image');
?>
