<?php
/**
 * Template Name: Gazete Manşetleri
 * @theme kanews
 * @developer kanthemes.com
 */
defined( 'ABSPATH' ) || exit; // Exit if accessed directly

// Set timezone
date_default_timezone_set('Europe/Istanbul');

// Get current date
$day = date("n");
if($day < 10)
$day = '0'.$day;
$gazetetarih = date("d".$day."y");

// Format date for display
if (class_exists('IntlDateFormatter')) {
  $formatter = new IntlDateFormatter('tr_TR', IntlDateFormatter::LONG, IntlDateFormatter::NONE);
  $today = $formatter->format(time());
} else {
  setlocale(LC_TIME, 'tr_TR.UTF-8');
  $today = strftime('%e %B %Y, %A');
}

// Get custom newspapers from options
$custom_news = kanews_get_option('newspapers', array());

$transient_name = 'kanews_np_data';
// Check if we need to update the newspaper data
$last_update = get_transient($transient_name);
$today_date = date('Y-m-d');
$need_update = false;

if ($last_update !== $today_date) {
    $need_update = true;
    set_transient($transient_name, $today_date, DAY_IN_SECONDS);
}

// Get newspaper data from transient or fetch new data
$newspaper_data = get_transient('kanews_newspaper_data');
if ($newspaper_data === false || $need_update) {
    $newspaper_data = [];
    
    // Fetch newspaper data from gazeteoku.com
    $source_url = 'https://www.gazeteoku.com/gazeteler';
    $response = wp_remote_get($source_url);
    
    if (!is_wp_error($response) && wp_remote_retrieve_response_code($response) === 200) {
        $html = wp_remote_retrieve_body($response);
        
        // Use DOMDocument to parse the HTML
        $dom = new DOMDocument();
        @$dom->loadHTML(mb_convert_encoding($html, 'HTML-ENTITIES', 'UTF-8'));
        $xpath = new DOMXPath($dom);
        
        // Find all newspaper items
        $newspaper_items = $xpath->query('//div[contains(@class, "col-12 col-md-6 col-xl-4 col-lg-6")]');
        
        foreach ($newspaper_items as $item) {
            // Extract newspaper name
            $name_element = $xpath->query('.//strong', $item)->item(0);
            $name = $name_element ? trim($name_element->textContent) : '';
            
            // Capitalize only the first letter of the newspaper name
            if (!empty($name)) {
                $name = mb_strtolower($name, 'UTF-8');
                $name = mb_strtoupper(mb_substr($name, 0, 1, 'UTF-8'), 'UTF-8') . mb_substr($name, 1, null, 'UTF-8');
            }
            
            // Extract date
            $date_element = $xpath->query('.//small', $item)->item(0);
            $date = $date_element ? trim($date_element->textContent) : $today;
            
            // Extract image URL
            $img_element = $xpath->query('.//img', $item)->item(0);
            $small_image = $img_element ? $img_element->getAttribute('src') : '';
            $large_image = $img_element ? $img_element->getAttribute('data-srcset') : '';
            
            // Fix blank image issue
            if (empty($small_image) || $small_image === 'https://s.gazeteoku.com/assets/web/files/blank.png') {
                // Try to extract from data-src attribute
                $small_image = $img_element ? $img_element->getAttribute('data-src') : '';
                
                // If still empty, try to extract from data-srcset
                if (empty($small_image) && !empty($large_image)) {
                    // Extract the first URL from data-srcset
                    preg_match('/^(.*?)\s/', $large_image, $matches);
                    if (!empty($matches[1])) {
                        $small_image = $matches[1];
                    }
                }
            }
            
            // Fix large image URL format
            if (!empty($large_image)) {
                // Extract the URL from data-srcset (remove the "2x" suffix)
                preg_match('/^(.*?)\s/', $large_image, $matches);
                if (!empty($matches[1])) {
                    $large_image = $matches[1];
                }
            }
            
            // Get the highest quality image URL
            $highest_quality_image = '';
            if (!empty($large_image)) {
                // Check if the URL contains a size indicator (like /3/460/772/)
                if (preg_match('/\/\d+\/\d+\/\d+\//', $large_image, $matches)) {
                    // Replace with the highest quality path
                    $highest_quality_image = preg_replace('/\/\d+\/\d+\/\d+\//', '/', $large_image);
                } else {
                    $highest_quality_image = $large_image;
                }
                
                // Ensure the URL has the correct directory structure (year/month/day)
                if (strpos($highest_quality_image, '/storage/files/images/') !== false) {
                    // Extract the filename part
                    $filename = basename($highest_quality_image);
                    
                    // Check if the URL already has the year/month/day structure
                    if (!preg_match('/\/\d{4}\/\d{2}\/\d{2}\//', $highest_quality_image)) {
                        // Extract date from the filename if possible (format: newspaper-YYYY-MM-DD-xxxx.jpg)
                        if (preg_match('/(\d{4})-(\d{2})-(\d{2})/', $filename, $date_matches)) {
                            $year = $date_matches[1];
                            $month = $date_matches[2];
                            $day = $date_matches[3];
                            
                            // Reconstruct the URL with the correct directory structure
                            $highest_quality_image = preg_replace('/\/storage\/files\/images\//', "/storage/files/images/{$year}/{$month}/{$day}/", $highest_quality_image);
                        }
                    }
                }
            } else if (!empty($small_image)) {
                $highest_quality_image = $small_image;
                
                // Apply the same directory structure fix to small_image if needed
                if (strpos($highest_quality_image, '/storage/files/images/') !== false) {
                    // Extract the filename part
                    $filename = basename($highest_quality_image);
                    
                    // Check if the URL already has the year/month/day structure
                    if (!preg_match('/\/\d{4}\/\d{2}\/\d{2}\//', $highest_quality_image)) {
                        // Extract date from the filename if possible (format: newspaper-YYYY-MM-DD-xxxx.jpg)
                        if (preg_match('/(\d{4})-(\d{2})-(\d{2})/', $filename, $date_matches)) {
                            $year = $date_matches[1];
                            $month = $date_matches[2];
                            $day = $date_matches[3];
                            
                            // Reconstruct the URL with the correct directory structure
                            $highest_quality_image = preg_replace('/\/storage\/files\/images\//', "/storage/files/images/{$year}/{$month}/{$day}/", $highest_quality_image);
                        }
                    }
                }
            }
            
            // Extract link
            $link_element = $xpath->query('.//a', $item)->item(0);
            $link = $link_element ? $link_element->getAttribute('href') : '';
            
            // Create slug from name
            $slug = sanitize_title($name);
            
            if (!empty($name) && !empty($small_image)) {
                $newspaper_data[$slug] = [
                    'name' => $name,
                    'date' => $date,
                    'small_image' => $small_image,
                    'large_image' => $large_image,
                    'highest_quality_image' => $highest_quality_image,
                    'link' => $link
                ];
            }
        }
    }
    
    
    
    // Store in transient for 24 hours
    set_transient('kanews_newspaper_data', $newspaper_data, DAY_IN_SECONDS);
}

// Add custom newspapers if any
if (!empty($custom_news)) {
  foreach ($custom_news as $key => $value) {
              $slug = strtolower(urlencode($value['title']));
              // Capitalize only the first letter of custom newspaper names
              $newspaper_name = $value['title'];
              if (!empty($newspaper_name)) {
                  $newspaper_name = mb_strtolower($newspaper_name, 'UTF-8');
                  $newspaper_name = mb_strtoupper(mb_substr($newspaper_name, 0, 1, 'UTF-8'), 'UTF-8') . mb_substr($newspaper_name, 1, null, 'UTF-8');
              }
              $newspaper_data[$slug] = [
                  'name' => $newspaper_name,
                  'date' => $today,
                  'small_image' => $value['media'],
                  'large_image' => $value['media'],
                  'highest_quality_image' => $value['media'],
                  'link' => ''
              ];
          }
      }

// Create newspapers array from newspaper_data
$newspapers = [];
foreach ($newspaper_data as $key => $value) {
    $newspapers[$key] = $value['name'];
}

// Check if a specific newspaper is requested
$read = isset($_GET['gazete']) ? strtolower(urlencode(($_GET['gazete']))) : NULL;
if($read != NULL && ( !isset($newspapers[$read]) ) ) {
  wp_redirect( get_the_permalink(), 301);
  die;
}

// Set page title
$title = $new_title = '';
if($read != NULL && $newspapers[$read] != '') {
  $title = wp_sprintf(esc_html__('%1$s Gazetesi %2$s Günü Gazete Manşetleri', 'kanews'), $newspapers[$read], $today);
  $new_title = ucwords($title).' - '.get_bloginfo('name');
}

// Filter for custom title
function generate_custom_title($title) {
  global $new_title;
  if($new_title)
  $title = $new_title;
  return $title;  
}
add_filter( 'pre_get_document_title', 'generate_custom_title', 10 );
add_filter( 'wpseo_title', 'generate_custom_title', 15 );

// Get header
get_header(); 

// Page header
while ( have_posts() ) : the_post();
    $desc = isset($newspapers[$read]) ? wp_sprintf( __('%1$s gazetesinin %2$s tarihli gazete manşetlerine göz atın, en son gelişmeler ve öne çıkan haberlerle Türkiye\'nin gündemini takip edin!', 'kanews'), $newspapers[$read], $today ) : ''; 
    kanews_page_header($post->ID, $title, '', $desc);
endwhile;

// Header ad
do_action('kanews_header_ad');
?>


  <main id="main" class="site-main">
    <div class="container">
      <div class="row">
        <?php $insights = get_post_meta( get_the_ID(), 'post_insight', true ) == 1 ? 1 : 0; if(kanews_insights_control() == true || $insights == 0 ): ?>
          <div class="col-12 col-md-3 col-lg-2 kanews-sticky">
            <div class="kanews-section widget widget_pages kanews-collapse-wrapper">
              <?php echo kanews_widget_title(esc_html__( 'Gazeteler', 'kanews' )); ?>
            <ul>
                            <li class="page_item <?php if($read == NULL) echo 'current_page_item'; ?>">
                                <a href="<?php the_permalink(); ?>"><?php _e('Hepsi', 'kanews'); ?></a>
                            </li>
              <?php 
                            $counter = 0;
                            foreach($newspapers as $key => $newspaper) { 
                                $counter++;
                $collapse = $counter > 3 ? 'kanews-collapse-item hidden-mobile' : '';
                if($key == $read)
                echo '<li class="page_item current_page_item '.$collapse.'"><a href="'.esc_url( add_query_arg( 'gazete', $key, get_the_permalink() ) ).'">'.$newspaper.'</a></li>';
                else
                echo '<li class="page_item '.$collapse.'"><a href="'.esc_url( add_query_arg( 'gazete', $key, get_the_permalink() ) ).'">'.$newspaper.'</a></li>';
              }
              ?>
            </ul>
                        <div class="kanews-collapse-btn hidden-desktop">
                            <i class="icon-arrow icon-3x"></i> 
                            <span><?php esc_html_e( 'Daha Fazla Göster', 'kanews' ); ?></span>
                        </div>
            </div>
          </div>
          
          <div class="col-12 col-md-9 col-lg-10">
                    <div class="post-width newspapers">
          <div class="row">
                            <?php if($read != NULL): ?>
          <?php 
                                // Display single newspaper
                                if(isset($newspaper_data[$read])): 
                                    $newspaper = $newspaper_data[$read];
                                ?>
                                <div class="col-12">
                                    <div class="kanews-section newspaper-item">
                                        <a href="#" class="newspaper-zoom" data-image="<?php echo esc_url($newspaper['highest_quality_image']); ?>" data-title="<?php echo esc_attr($newspaper['name']); ?>">
                                            <?php echo kanews_widget_title(sprintf(esc_html__('%s Gazetesi %s Günü 1. Sayfası', 'kanews'), $newspaper['name'], $today), 'h2'); ?>
                                            <div class="kanews-table-date"><?php echo esc_html($newspaper['date']); ?></div>
                                            <img src="<?php echo esc_url($newspaper['highest_quality_image']); ?>" alt="<?php echo esc_attr($newspaper['name']); ?>" loading="lazy">
                                        </a>
                                        <div class="d-flex flex-wrap align-items-center justify-content-center p-1" style="gap: 1rem">
                                            <a href="https://www.facebook.com/share.php?u=<?php echo urlencode(get_permalink() . '?gazete=' . $read); ?>" class="facebook" data-toggle="tooltip" data-placement="right" title="Facebook' da paylaş">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 32 32">
                                                    <path d="M19 6h5v-6h-5c-3.86 0-7 3.14-7 7v3h-4v6h4v16h6v-16h5l1-6h-6v-3c0-0.542 0.458-1 1-1z"></path>
                                                </svg>
                                            </a>
                                            <a href="https://twitter.com/share?url=<?php echo urlencode(get_permalink() . '?gazete=' . $read); ?>&text=<?php echo urlencode($newspaper['name'] . ' Manşeti'); ?>" class="twitter" data-toggle="tooltip" data-placement="right" title="Twitter' da paylaş">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 32 32">
                                                    <path d="M32 7.075c-1.175 0.525-2.444 0.875-3.769 1.031 1.356-0.813 2.394-2.1 2.887-3.631-1.269 0.75-2.675 1.3-4.169 1.594-1.2-1.275-2.906-2.069-4.794-2.069-3.625 0-6.563 2.938-6.563 6.563 0 0.512 0.056 1.012 0.169 1.494-5.456-0.275-10.294-2.888-13.531-6.862-0.563 0.969-0.887 2.1-0.887 3.3 0 2.275 1.156 4.287 2.919 5.463-1.075-0.031-2.087-0.331-2.975-0.819 0 0.025 0 0.056 0 0.081 0 3.181 2.263 5.838 5.269 6.437-0.55 0.15-1.131 0.231-1.731 0.231-0.425 0-0.831-0.044-1.237-0.119 0.838 2.606 3.263 4.506 6.131 4.563-2.25 1.762-5.075 2.813-8.156 2.813-0.531 0-1.050-0.031-1.569-0.094 2.913 1.869 6.362 2.95 10.069 2.95 12.075 0 18.681-10.006 18.681-18.681 0-0.287-0.006-0.569-0.019-0.85 1.281-0.919 2.394-2.075 3.275-3.394z"></path>
                                                </svg>
                                            </a>
                                            <a href="https://pinterest.com/pin/create/button/?url=<?php echo urlencode(get_permalink() . '?gazete=' . $read); ?>&description=<?php echo urlencode($newspaper['name'] . ' Manşeti'); ?>" class="pinterest" data-toggle="tooltip" data-placement="right" title="Pinterest'e ekle">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 32 32">
                                                    <path d="M16 0c-8.825 0-16 7.175-16 16s7.175 16 16 16 16-7.175 16-16-7.175-16-16-16zM16 29.863c-1.431 0-2.806-0.219-4.106-0.619 0.563-0.919 1.412-2.431 1.725-3.631 0.169-0.65 0.863-3.294 0.863-3.294 0.45 0.863 1.775 1.594 3.175 1.594 4.181 0 7.194-3.844 7.194-8.625 0-4.581-3.738-8.006-8.544-8.006-5.981 0-9.156 4.019-9.156 8.387 0 2.031 1.081 4.563 2.813 5.369 0.262 0.125 0.4 0.069 0.463-0.188 0.044-0.194 0.281-1.131 0.387-1.575 0.031-0.137 0.019-0.262-0.094-0.4-0.575-0.694-1.031-1.975-1.031-3.162 0-3.056 2.313-6.019 6.256-6.019 3.406 0 5.788 2.319 5.788 5.637 0 3.75-1.894 6.35-4.356 6.35-1.363 0-2.381-1.125-2.050-2.506 0.394-1.65 1.15-3.425 1.15-4.613 0-1.063-0.569-1.95-1.756-1.95-1.394 0-2.506 1.438-2.506 3.369 0 1.225 0.412 2.056 0.412 2.056s-1.375 5.806-1.625 6.887c-0.281 1.2-0.169 2.881-0.050 3.975-5.156-2.012-8.813-7.025-8.813-12.9 0-7.656 6.206-13.863 13.862-13.863s13.863 6.206 13.863 13.863c0 7.656-6.206 13.863-13.863 13.863z"></path>
                                                </svg>
                                            </a>
                                            <a href="whatsapp://send?text=<?php echo urlencode($newspaper['name'] . ' Manşeti - ' . get_permalink() . '?gazete=' . $read); ?>" class="whatsapp" data-toggle="tooltip" data-placement="right" title="WHATSAPP' da paylaş">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 32 32">
                                                    <path d="M27.281 4.65c-2.994-3-6.975-4.65-11.219-4.65-8.738 0-15.85 7.112-15.85 15.856 0 2.794 0.731 5.525 2.119 7.925l-2.25 8.219 8.406-2.206c2.319 1.262 4.925 1.931 7.575 1.931h0.006c0 0 0 0 0 0 8.738 0 15.856-7.113 15.856-15.856 0-4.238-1.65-8.219-4.644-11.219zM16.069 29.050v0c-2.369 0-4.688-0.637-6.713-1.837l-0.481-0.288-4.987 1.306 1.331-4.863-0.313-0.5c-1.325-2.094-2.019-4.519-2.019-7.012 0-7.269 5.912-13.181 13.188-13.181 3.519 0 6.831 1.375 9.319 3.862 2.488 2.494 3.856 5.8 3.856 9.325-0.006 7.275-5.919 13.188-13.181 13.188zM23.294 19.175c-0.394-0.2-2.344-1.156-2.706-1.288s-0.625-0.2-0.894 0.2c-0.262 0.394-1.025 1.288-1.256 1.556-0.231 0.262-0.462 0.3-0.856 0.1s-1.675-0.619-3.188-1.969c-1.175-1.050-1.975-2.35-2.206-2.744s-0.025-0.613 0.175-0.806c0.181-0.175 0.394-0.463 0.594-0.694s0.262-0.394 0.394-0.662c0.131-0.262 0.069-0.494-0.031-0.694s-0.894-2.15-1.219-2.944c-0.319-0.775-0.65-0.669-0.894-0.681-0.231-0.012-0.494-0.012-0.756-0.012s-0.694 0.1-1.056 0.494c-0.363 0.394-1.387 1.356-1.387 3.306s1.419 3.831 1.619 4.1c0.2 0.262 2.794 4.269 6.769 5.981 0.944 0.406 1.681 0.65 2.256 0.837 0.95 0.3 1.813 0.256 2.494 0.156 0.762-0.113 2.344-0.956 2.675-1.881s0.331-1.719 0.231-1.881c-0.094-0.175-0.356-0.275-0.756-0.475z"></path>
                                                </svg>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>
                  <?php else: ?>
                                <?php 
                                // Display all newspapers in grid
                                foreach($newspaper_data as $key => $newspaper): 
                                ?>
                                <div class="col-12 col-md-6 col-xl-4 col-lg-6">
                                    <div class="kanews-section newspaper-item">
                                        <a href="<?php echo esc_url(add_query_arg('gazete', $key, get_the_permalink())); ?>" title="<?php echo esc_attr($newspaper['name']); ?>">
                                            <?php echo kanews_widget_title(esc_html($newspaper['name']), 'h2'); ?>
                                            <div class="kanews-table-date"><?php echo esc_html($newspaper['date']); ?></div>
                                            <?php if (!empty($newspaper['small_image']) && $newspaper['small_image'] !== 'https://s.gazeteoku.com/assets/web/files/blank.png'): ?>
                                              <img src="<?php echo esc_url($newspaper['small_image']); ?>" loading="lazy" alt="<?php echo esc_attr($newspaper['name']); ?>">
                                            <?php else: ?>
                                              <img src="<?php echo esc_url($newspaper['highest_quality_image']); ?>" loading="lazy" alt="<?php echo esc_attr($newspaper['name']); ?>">
                  <?php endif; ?>
                </a>
                                        <div class="d-flex flex-wrap align-items-center justify-content-center p-1" style="gap: 1rem">
                                            <a href="https://www.facebook.com/share.php?u=<?php echo urlencode(get_permalink() . '?gazete=' . $key); ?>" class="facebook" data-toggle="tooltip" data-placement="right" title="Facebook' da paylaş">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 32 32">
                                                    <path d="M19 6h5v-6h-5c-3.86 0-7 3.14-7 7v3h-4v6h4v16h6v-16h5l1-6h-6v-3c0-0.542 0.458-1 1-1z"></path>
                                                </svg>
                                            </a>
                                            <a href="https://twitter.com/share?url=<?php echo urlencode(get_permalink() . '?gazete=' . $key); ?>&text=<?php echo urlencode($newspaper['name'] . ' Manşeti'); ?>" class="twitter" data-toggle="tooltip" data-placement="right" title="Twitter' da paylaş">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 32 32">
                                                    <path d="M32 7.075c-1.175 0.525-2.444 0.875-3.769 1.031 1.356-0.813 2.394-2.1 2.887-3.631-1.269 0.75-2.675 1.3-4.169 1.594-1.2-1.275-2.906-2.069-4.794-2.069-3.625 0-6.563 2.938-6.563 6.563 0 0.512 0.056 1.012 0.169 1.494-5.456-0.275-10.294-2.888-13.531-6.862-0.563 0.969-0.887 2.1-0.887 3.3 0 2.275 1.156 4.287 2.919 5.463-1.075-0.031-2.087-0.331-2.975-0.819 0 0.025 0 0.056 0 0.081 0 3.181 2.263 5.838 5.269 6.437-0.55 0.15-1.131 0.231-1.731 0.231-0.425 0-0.831-0.044-1.237-0.119 0.838 2.606 3.263 4.506 6.131 4.563-2.25 1.762-5.075 2.813-8.156 2.813-0.531 0-1.050-0.031-1.569-0.094 2.913 1.869 6.362 2.95 10.069 2.95 12.075 0 18.681-10.006 18.681-18.681 0-0.287-0.006-0.569-0.019-0.85 1.281-0.919 2.394-2.075 3.275-3.394z"></path>
                                                </svg>
                                            </a>
                                            <a href="https://pinterest.com/pin/create/button/?url=<?php echo urlencode(get_permalink() . '?gazete=' . $key); ?>&description=<?php echo urlencode($newspaper['name'] . ' Manşeti'); ?>" class="pinterest" data-toggle="tooltip" data-placement="right" title="Pinterest'e ekle">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 32 32">
                                                    <path d="M16 0c-8.825 0-16 7.175-16 16s7.175 16 16 16 16-7.175 16-16-7.175-16-16-16zM16 29.863c-1.431 0-2.806-0.219-4.106-0.619 0.563-0.919 1.412-2.431 1.725-3.631 0.169-0.65 0.863-3.294 0.863-3.294 0.45 0.863 1.775 1.594 3.175 1.594 4.181 0 7.194-3.844 7.194-8.625 0-4.581-3.738-8.006-8.544-8.006-5.981 0-9.156 4.019-9.156 8.387 0 2.031 1.081 4.563 2.813 5.369 0.262 0.125 0.4 0.069 0.463-0.188 0.044-0.194 0.281-1.131 0.387-1.575 0.031-0.137 0.019-0.262-0.094-0.4-0.575-0.694-1.031-1.975-1.031-3.162 0-3.056 2.313-6.019 6.256-6.019 3.406 0 5.788 2.319 5.788 5.637 0 3.75-1.894 6.35-4.356 6.35-1.363 0-2.381-1.125-2.050-2.506 0.394-1.65 1.15-3.425 1.15-4.613 0-1.063-0.569-1.95-1.756-1.95-1.394 0-2.506 1.438-2.506 3.369 0 1.225 0.412 2.056 0.412 2.056s-1.375 5.806-1.625 6.887c-0.281 1.2-0.169 2.881-0.050 3.975-5.156-2.012-8.813-7.025-8.813-12.9 0-7.656 6.206-13.863 13.862-13.863s13.863 6.206 13.863 13.863c0 7.656-6.206 13.863-13.863 13.863z"></path>
                                                </svg>
                                            </a>
                                            <a href="whatsapp://send?text=<?php echo urlencode($newspaper['name'] . ' Manşeti - ' . get_permalink() . '?gazete=' . $key); ?>" class="whatsapp" data-toggle="tooltip" data-placement="right" title="WHATSAPP' da paylaş">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 32 32">
                                                    <path d="M27.281 4.65c-2.994-3-6.975-4.65-11.219-4.65-8.738 0-15.85 7.112-15.85 15.856 0 2.794 0.731 5.525 2.119 7.925l-2.25 8.219 8.406-2.206c2.319 1.262 4.925 1.931 7.575 1.931h0.006c0 0 0 0 0 0 8.738 0 15.856-7.113 15.856-15.856 0-4.238-1.65-8.219-4.644-11.219zM16.069 29.050v0c-2.369 0-4.688-0.637-6.713-1.837l-0.481-0.288-4.987 1.306 1.331-4.863-0.313-0.5c-1.325-2.094-2.019-4.519-2.019-7.012 0-7.269 5.912-13.181 13.188-13.181 3.519 0 6.831 1.375 9.319 3.862 2.488 2.494 3.856 5.8 3.856 9.325-0.006 7.275-5.919 13.188-13.181 13.188zM23.294 19.175c-0.394-0.2-2.344-1.156-2.706-1.288s-0.625-0.2-0.894 0.2c-0.262 0.394-1.025 1.288-1.256 1.556-0.231 0.262-0.462 0.3-0.856 0.1s-1.675-0.619-3.188-1.969c-1.175-1.050-1.975-2.35-2.206-2.744s-0.025-0.613 0.175-0.806c0.181-0.175 0.394-0.463 0.594-0.694s0.262-0.394 0.394-0.662c0.131-0.262 0.069-0.494-0.031-0.694s-0.894-2.15-1.219-2.944c-0.319-0.775-0.65-0.669-0.894-0.681-0.231-0.012-0.494-0.012-0.756-0.012s-0.694 0.1-1.056 0.494c-0.363 0.394-1.387 1.356-1.387 3.306s1.419 3.831 1.619 4.1c0.2 0.262 2.794 4.269 6.769 5.981 0.944 0.406 1.681 0.65 2.256 0.837 0.95 0.3 1.813 0.256 2.494 0.156 0.762-0.113 2.344-0.956 2.675-1.881s0.331-1.719 0.231-1.881c-0.094-0.175-0.356-0.275-0.756-0.475z"></path>
                                                </svg>
                  </a>
                </div>
              </div>
                                </div>
                                <?php endforeach; ?>
            <?php endif; ?>
                        </div>
                    </div>

          <?php while ( have_posts() ) : the_post(); 
            if ($post->post_content): ?>
              <div class="col-12">
                <div class="kanews-article kanews-section-box kanews-article-1">
                  <div class="kanews-article-content entry-content">
                    <?php the_content(); ?>
                  </div>
                </div>
              </div>
            <?php endif; ?>
            <?php if ( comments_open() || get_comments_number() ) : ?>
              <div class="col-12">
                <?php comments_template(); ?>
              </div>
            <?php endif;?> 
          <?php endwhile; ?>
                </div>
        <?php else: ?>
          <div class="col-12"><?php echo kanews_private_content('a'); ?></div>
        <?php endif; ?>
      </div>
    </div>
  </main>

<!-- Modal for zoomed newspaper -->
<div id="newspaperModal" class="modal">
    <span class="modal-close">&times;</span>
    <img class="modal-content" id="modalImage">
    <div id="modalCaption"></div>
</div>

<!-- Add JavaScript for zoom functionality -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Get the modal
    var modal = document.getElementById("newspaperModal");
    var modalImg = document.getElementById("modalImage");
    var captionText = document.getElementById("modalCaption");
    var closeBtn = document.getElementsByClassName("modal-close")[0];
    
    // Add click event to all newspaper images
    var newspaperLinks = document.querySelectorAll('.newspaper-zoom');
    newspaperLinks.forEach(function(link) {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            var imgSrc = this.getAttribute('data-image');
            var imgTitle = this.getAttribute('data-title');
            
            modal.style.display = "block";
            modalImg.src = imgSrc;
            captionText.innerHTML = imgTitle;
        });
    });
    
    // Close modal when clicking the close button
    closeBtn.onclick = function() {
        modal.style.display = "none";
    }
    
    // Close modal when clicking outside the image
    modal.onclick = function(e) {
        if (e.target === modal) {
            modal.style.display = "none";
        }
    }
    
    // Initialize tooltips if Bootstrap is available
    if (typeof $ !== 'undefined' && $.fn.tooltip) {
        $('[data-toggle="tooltip"]').tooltip();
    }
});
</script>

<?php get_footer(); ?>