<?php 
defined( 'ABSPATH' ) || exit; // Exit if accessed directly

function generate_custom_title($title) {
  return esc_html__( 'Yazarlarımız', 'kanews').' - ' .get_bloginfo("name");
}
add_filter( 'pre_get_document_title', 'generate_custom_title', 10 );
add_filter( 'wpseo_title', 'generate_custom_title', 15 );
get_header(); ?>
<?php kanews_page_header(get_the_ID(), esc_html__( 'Yazarlarımız', 'kanews' ), '', '', false); ?>
<?php do_action('kanews_header_ad'); ?>

  <main id="main" class="site-main mb-3">
    <div class="container">
      <div class="row">

        <?php 
        $lists = kanews_get_option('author-lists');

        if($lists): ?>

          <?php foreach ( $lists as $list ) {
            echo $list['title'] != '' ? '<h2 class="col-12 mt-1">'.$list['title'].'</h2>' : '';
            if($list['authors']) {
              foreach ( $list['authors'] as $author ) {
                $user_data = get_userdata($author);

                if(!is_object($user_data))
                continue;
                ?>
                <div class="col-6 col-md-3 col-lg-2">
                  <div class="kanews-profile-card">
                    <div class="kanews-profile-card-header">
                      <?php echo kanews_user_avatar(get_the_author_meta('ID', $user_data->ID),'72'); ?>
                    </div>
                    <div class="kanews-profile-card-body">
                      <span class="truncate truncate-1"><?php if(get_the_author_meta('first_name', $user_data->ID) && get_the_author_meta('last_name', $user_data->ID)): ?>
                        <?php echo esc_html(get_the_author_meta('first_name', $user_data->ID)); ?> <?php echo esc_html(get_the_author_meta('last_name', $user_data->ID)); ?>
                      <?php else: ?>
                        <?php echo esc_html(get_the_author_meta('display_name', $user_data->ID)); ?>
                      <?php endif; ?></span>
                    </div>
                    <div class="kanews-profile-card-footer">
                      
                    <a class="kanews-btn kanews-btn-o kanews-btn-sm" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID', $user_data->ID ) ); ?>"><?php esc_html_e( 'Tüm Yazıları', 'kanews' ); ?></a>
                    </div>
                  </div>
                </div>
                <?php 
              }
            }
          } ?>

        <?php endif; ?>

          

  </main> 

<?php
get_footer();