<?php
/**
 * The template for displaying all single comp
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Kanews
 */
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
get_header();
kanews_page_header(null, esc_html__( 'Firma Rehberi', 'kanews' )); 
?>
	<?php do_action('kanews_header_ad'); ?>
  <main id="main" class="site-main">
    <div class="container">
      <div class="row">
        <?php if( ! is_paged() ) : ?>
        <div class="col-12">
          <?php 
            $slick_options = [
              'slidesToShow'  => 5,
              'dots'  => true,
              'adaptiveHeight'  => false,
              'arrows'			  => false,
              'autoplay'			=> true,
              'responsive' 			=> [
                [
                  'breakpoint' 	 => 992,
                  'settings'		 => [
                    'slidesToShow' => 3
                  ]
                ],
                [
                  'breakpoint' 	 => 525,
                  'settings'		 => [
                    'slidesToShow' => 1
                  ]
                ],
              ]
            ];
            $all_user_ids = Kanews\Util\Cache::get_users([
              'fields' => 'id',
              'meta_key' => 'kanews_insights_purchase_date',
              'meta_compare' => '!==',
              'meta_value' => ''
            ]);
            $kanews_query = new WP_Query(
              array( 
                'showposts'    => 20,
                'post_type'    => 'firma',
                'author__in'   => $all_user_ids,
              )
            );
            if ($kanews_query->have_posts() && kanews_get_option('comp-insights') != false) : ?>
    
              <div class="kanews-section">
                <?php echo kanews_widget_title(esc_html__( 'Abone Firmalar', 'kanews' )); ?>
                <div class="kanews-slider-c0">

                  <div class="kanews-slider-wrapper" data-slick='<?php echo wp_json_encode( $slick_options ); ?>'>
                    <?php $counter = 0; while($kanews_query->have_posts()): $kanews_query->the_post(); global $post;  ?>
                      <?php if(kanews_insights_control($post->post_author) == true): $counter++; ?>
                        <div class="kanews-post-item kanews-post-comp kanews-post-grid-item">
                          <a href="<?php the_permalink(); ?>" class="kanews-post-href"></a>
                          <?php kanews_post_thumbnail('full', 'kanews-post-comp-thumb'); ?>
                          <div class="kanews-post-content">
                            <?php the_title( sprintf( '<h3 class="kanews-post-headline truncate truncate-1"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
                          </div>
                        </div>
                      <?php endif; ?>
                      
                    <?php endwhile; wp_reset_postdata(); ?>
                  </div>

                  <?php if($counter == 0): ?>
                    <p style="margin: 15px"><?php esc_html_e( 'Abone firma bulunamadı', 'kanews' ); ?></p>
                  <?php endif; ?>
                
                </div>
              </div>
            
            <?php endif;
          ?>
          <?php 
            echo '<div class="row">';
            echo '<div class="kanews-widget-area kanews-widgets-top">';
              dynamic_sidebar( 'firma-top-full' );
            echo '</div>';
            echo '</div>';
          ?>
        </div>
        <?php endif; ?>
        <div class="col-12 col-lg-8">
          <?php
            echo '<div class="row">';
            echo '<div class="kanews-widget-area kanews-widgets-content">';
              dynamic_sidebar( 'firma-content' );
            echo '</div>';
            echo '</div>';

            echo '<div class="kanews-section kanews-posts-style-2">';
              echo kanews_widget_title(esc_html__( 'Yeni Eklenen Firmalar', 'kanews' ), 'h2');
              $style = kanews_get_option('firma-style') ? kanews_get_option('firma-style') : 1; 

              switch($style) {
                case '1':
                  $style = 'comp';
                  break;
                case '2':
                  $style = 'comp-2';
                  break;
                case '3':
                  $style = 'comp-3';
                  break;
              }

              if ( have_posts() ) : 
                echo '<div class="d-flex flex-wrap" kanews-data-load-more>';
                  while ( have_posts() ) : the_post(); 
                    get_template_part('template-parts/archives/article', $style);
                  endwhile;
                echo '</div>';
                kanews_pagination();
              else:
                get_template_part('template-parts/archives/article', 'none');
              endif;
            echo '</div>';
          ?>
        </div>
        <?php get_sidebar('firma'); ?>
      </div>
		</div>
	</main>

<?php
get_footer();
