<?php
/**
 * The template for displaying all single comp
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Kanews
 */
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
wp_enqueue_script('kanews-ilan-search');
get_header();
$q = get_queried_object();

$title = is_tax('ilan-ilce', 'ilan-il') ? esc_html__( 'İlanlar', 'kanews' ) : sprintf(esc_html__('%s İlanları', 'kanews'), $q->name);
kanews_page_header(null, $title); 
?>
	<?php do_action('kanews_header_ad'); ?>
  <main id="main" class="site-main">
    <div class="container">
      <div class="row">
        <?php get_sidebar('ilan'); ?>
        <div class="col-12 col-lg-9">
          <?php

            echo '<div class="kanews-section kanews-section-flat kanews-posts-style-2 column_x_gutter kanews-section-gutter">';
              echo kanews_widget_title(esc_html__( 'Yeni İlanlar', 'kanews' ), 'h2');
              $out = '<div class="kanews-dropdown kanews-dropdown-ilan">'; 
                $out .= '<div data-toggle="kanews-ilan-sort" class="kanews-dropdown-item">'.esc_html__( 'Sıralama Ölçütü', 'kanews' ).'</div>';
                $out .= '<div id="kanews-ilan-sort" class="kanews-dropdown-content">';
                  $out .= '<ul>';
                    $out .= '<li><a href="'.get_post_type_archive_link('ilan').'">'.esc_html__( 'Öne Çıkanlar', 'kanews' ).'</a></li>';
                    $out .= '<li><a href="'.esc_url( add_query_arg( 'sort', 'da', $_SERVER['REQUEST_URI'] ) ).'">'.esc_html__( 'Eklenme Tarihi (En Eski)', 'kanews' ).'</a></li>';
                    $out .= '<li><a href="'.esc_url( add_query_arg( 'sort', 'dd', $_SERVER['REQUEST_URI'] ) ).'">'.esc_html__( 'Eklenme Tarihi (En Yeni)', 'kanews' ).'</a></li>';
                  $out .= '</ul>';
                $out .= '</div>'; 
              $out .= '</div>'; 
              echo $out;
              global $wp_query;
              $args = array_merge( $wp_query->query_vars, array( 'post_type' => 'ilan' ) );

  
// İlk durum
if (isset($_GET['il']) && is_numeric($_GET['il']) && ($_GET['il'] > 0 && $_GET['il'] <= 81)) {
    $sehir_tax_query = array(
        'taxonomy' => 'ilan-il',
        'field'    => 'name',
        'terms'    => kanews_get_sehir($_GET['il']),
    );

    $args['tax_query'][] = $sehir_tax_query;
}

// İkinci durum
if (isset($_GET['ilce']) && $_GET['ilce'] && isset($_GET['il']) && is_numeric($_GET['il']) && ($_GET['il'] > 0 && $_GET['il'] <= 81)) {
    $ilce_tax_query = array(
        'taxonomy' => 'ilan-ilce',
        'field'    => 'name',
        'terms'    => $_GET['ilce'],
    );

    // İlk durumda tanımlanan 'ilan-il' vergi sorgusunu ekleyin
    if (isset($sehir_tax_query)) {
        $ilce_tax_query['relation'] = 'AND';
        $ilce_tax_query[] = $sehir_tax_query;
    }

    $args['tax_query'][] = $ilce_tax_query;
}

// Üçüncü durum
if (isset($_GET['labels']) && !empty($_GET['labels'])) {
    $label_tax_query = array(
        'taxonomy' => 'ilan-etiket',
        'field'    => 'term_id',
        'terms'    => $_GET['labels'],
    );

    $args['tax_query'][] = $label_tax_query;
}


              if( isset($_GET['search']) && !empty( $_GET['search'] )  )
              $args = array_merge($args, array('s' => $_GET['search']) );
						
              if( class_exists('Simple_Review')  )
              $args = array_merge($args, array('orderby' => 'menu_order') );

              // print_r($args);

              query_posts( $args );
              if ( have_posts() ) : 
                echo '<div class="row equal-height" kanews-data-load-more>';
                  while ( have_posts() ) : the_post(); 
                    get_template_part('template-parts/archives/article', 'ilan');
                  endwhile;
                echo '</div>';
                kanews_pagination();
              else:
                get_template_part('template-parts/archives/article', 'none');
              endif;
            echo '</div>';

            wp_reset_query();
          ?>
        </div>
        
      </div>
		</div>
	</main>

<?php
get_footer();
?>